/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Binary;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.modeshape.jcr.value.binary.StoredBinaryValue;

@Immutable
public class BinaryStoreValueFactory
extends AbstractValueFactory<Binary>
implements BinaryFactory {
    private static final String CHAR_SET_NAME = "UTF-8";
    private static final Binary[] EMPTY_BINARY_ARRAY = new Binary[0];
    private final BinaryStore store;

    public BinaryStoreValueFactory(BinaryStore store, TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.BINARY, decoder, stringValueFactory);
        this.store = store;
    }

    public BinaryStoreValueFactory with(BinaryStore store) {
        return new BinaryStoreValueFactory(store, super.getDecoder(), super.getStringValueFactory());
    }

    protected Binary[] createEmptyArray(int length) {
        return EMPTY_BINARY_ARRAY;
    }

    @Override
    public Binary create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.create(value.getBytes(CHAR_SET_NAME));
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Binary.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public Binary create(String value, TextDecoder decoder) {
        if (value == null) {
            return null;
        }
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Binary create(int value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(long value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(boolean value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(float value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(double value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(BigDecimal value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Calendar value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Date value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(DateTime value) throws ValueFormatException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Name value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Path value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Path.Segment value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Reference value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(URI value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(UUID value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(NodeKey value) throws ValueFormatException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Binary create(Binary value) throws ValueFormatException, IoException {
        return value;
    }

    @Override
    public Binary create(byte[] value) throws ValueFormatException {
        if ((long)value.length <= this.store.getMinimumBinarySizeInBytes()) {
            return new InMemoryBinaryValue(this.store, value);
        }
        try {
            return this.store.storeValue(new ByteArrayInputStream(value));
        }
        catch (BinaryStoreException e) {
            throw new ValueFormatException((Object)e, PropertyType.BINARY);
        }
    }

    @Override
    public Binary create(InputStream stream) throws IoException {
        if (stream == null) {
            return null;
        }
        try {
            return this.store.storeValue(stream);
        }
        catch (BinaryStoreException e) {
            throw new ValueFormatException((Object)e, PropertyType.BINARY);
        }
    }

    @Override
    public Binary find(BinaryKey secureHash, long size) throws BinaryStoreException {
        return new StoredBinaryValue(this.store, secureHash, size);
    }
}

