package org.modeshape.jcr.cache.change;

import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Path;

/**
 * A change event which is generated by a {@link javax.jcr.Node#orderBefore(String, String)} operation.
 *
 * @author Horia Chiorean
 */
public class NodeReordered extends AbstractNodeChange {

    private Path oldPath;
    private NodeKey parent;

    public NodeReordered( NodeKey key,
                          NodeKey parent,
                          Path path,
                          Path oldPath ) {
        super(key, path);
        this.oldPath = oldPath;
        this.parent = parent;
    }

    public Path getOldPath() {
        return oldPath;
    }

    public NodeKey getParent() {
        return parent;
    }
}
