/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.value.Path;

public class NodeSequenced
extends AbstractNodeChange {
    private final NodeKey sequencedNodeKey;
    private final Path sequencedNodePath;

    public NodeSequenced(NodeKey sequencedNodeKey, Path sequencedNodePath, NodeKey outputNodeKey, Path outputNodePath) {
        super(outputNodeKey, outputNodePath);
        CheckArg.isNotNull((Object)outputNodeKey, (String)" original node key");
        CheckArg.isNotNull((Object)outputNodePath, (String)" original node path");
        this.sequencedNodeKey = sequencedNodeKey;
        this.sequencedNodePath = sequencedNodePath;
    }

    public NodeKey getSequencedNodeKey() {
        return this.sequencedNodeKey;
    }

    public Path getSequencedNodePath() {
        return this.sequencedNodePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sequenced new node: ").append(this.getSequencedNodeKey()).append(" at path: ").append(this.getSequencedNodePath());
        sb.append(" from the node: ").append(this.getSequencedNodeKey()).append(" at path: ").append(this.sequencedNodePath);
        return sb.toString();
    }
}

