/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.infinispan.schematic.document.NotThreadSafe;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.RepositoryPathCache;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.lucene.LuceneQueryEngine;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@NotThreadSafe
public class BasicTupleCollector
extends LuceneQueryEngine.TupleCollector {
    private final QueryContext queryContext;
    private final RepositoryCache repositoryCache;
    private final QueryResults.Columns columns;
    private final LinkedList<Object[]> tuples = new LinkedList();
    private final RepositoryPathCache repositoryPathCache;
    private final Name[] columnNames;
    private final int numValues;
    private final FieldSelector fieldSelector;
    private final int locationIndex;
    private final PseudoColumnAssignment[] assignments;
    private Scorer scorer;
    private IndexReader currentReader;
    private int docOffset;
    private String lastWorkspaceName;
    private NodeCache lastWorkspaceCache;
    private PathCache lastWorkspacePathCache;

    public BasicTupleCollector(QueryContext queryContext, QueryResults.Columns columns) {
        this.queryContext = queryContext;
        this.repositoryCache = queryContext.getRepositoryCache();
        this.repositoryPathCache = new RepositoryPathCache();
        this.columns = columns;
        this.numValues = this.columns.getTupleSize();
        assert (this.numValues >= 0);
        assert (this.columns.getSelectorNames().size() == 1);
        String selectorName = this.columns.getSelectorNames().get(0);
        this.locationIndex = this.columns.getLocationIndex(selectorName);
        ArrayList<PseudoColumnAssignment> assignments = new ArrayList<PseudoColumnAssignment>();
        if (columns.hasFullTextSearchScores()) {
            int scoreIndex = this.columns.getFullTextSearchScoreIndexFor(selectorName);
            assignments.add(new ScoreColumnAssignment(scoreIndex));
        }
        this.columnNames = new Name[this.numValues];
        List<String> columnNames = this.columns.getColumnNames();
        NameFactory nameFactory = queryContext.getExecutionContext().getValueFactories().getNameFactory();
        for (String columnName : columnNames) {
            Name propName;
            int index = this.columns.getColumnIndexForName(columnName);
            String propertyName = this.columns.getPropertyNameForColumn(index);
            if ("jcr:score".equals(propertyName)) continue;
            if ("jcr:path".equals(propertyName)) {
                assignments.add(new PathColumnAssignment(index));
                continue;
            }
            if ("jcr:name".equals(propertyName)) {
                assignments.add(new NameColumnAssignment(index));
                continue;
            }
            if ("mode:localName".equals(propertyName)) {
                assignments.add(new LocalNameColumnAssignment(index));
                continue;
            }
            if ("mode:depth".equals(propertyName)) {
                assignments.add(new LocalNameColumnAssignment(index));
                continue;
            }
            this.columnNames[index] = propName = (Name)nameFactory.create(propertyName);
        }
        this.assignments = assignments.toArray(new PseudoColumnAssignment[assignments.size()]);
        final HashSet<String> loadedFieldNames = new HashSet<String>();
        loadedFieldNames.add("::id");
        loadedFieldNames.add("::wks");
        this.fieldSelector = new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                return loadedFieldNames.contains(fieldName) ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
            }
        };
    }

    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    public void setNextReader(IndexReader reader, int docBase) {
        this.currentReader = reader;
        this.docOffset = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    @Override
    public float doCollect(int doc) throws IOException {
        Object[] tuple = new Object[this.numValues];
        Document document = this.currentReader.document(doc, this.fieldSelector);
        String id = document.get("::id");
        String workspace = document.get("::wks");
        float score = this.scorer.score();
        NodeKey key = new NodeKey(id);
        if (!workspace.equals(this.lastWorkspaceName)) {
            this.lastWorkspaceName = workspace;
            this.lastWorkspaceCache = this.queryContext.getNodeCache(workspace);
            this.lastWorkspacePathCache = this.repositoryPathCache.getPathCache(workspace, this.lastWorkspaceCache);
        }
        CachedNode node = this.lastWorkspaceCache.getNode(key);
        Path path = this.lastWorkspacePathCache.getPath(node);
        QueryResults.Location location = new QueryResults.Location(path, key);
        tuple[this.locationIndex] = location;
        for (int i = 0; i != this.numValues; ++i) {
            Object firstValue;
            Object[] values;
            Property property;
            Name propName = this.columnNames[i];
            if (propName == null || (property = node.getProperty(propName, this.lastWorkspaceCache)) == null || property.isEmpty()) continue;
            tuple[i] = property.isMultiple() ? (values = property.getValuesAsArray()) : (firstValue = property.getFirstValue());
        }
        for (PseudoColumnAssignment assignment : this.assignments) {
            assignment.setValue(tuple, path, score);
        }
        this.tuples.add(tuple);
        return score;
    }

    @Override
    public List<Object[]> getTuples() {
        return this.tuples;
    }

    protected static final class NodeDepthColumnAssignment
    extends PseudoColumnAssignment {
        protected NodeDepthColumnAssignment(int index) {
            super(index);
        }

        @Override
        protected Object computeValue(Path path, float score) {
            return new Integer(path.size());
        }
    }

    protected static final class ScoreColumnAssignment
    extends PseudoColumnAssignment {
        protected ScoreColumnAssignment(int index) {
            super(index);
        }

        @Override
        protected Object computeValue(Path path, float score) {
            return new Float(score);
        }
    }

    protected static final class LocalNameColumnAssignment
    extends PseudoColumnAssignment {
        protected LocalNameColumnAssignment(int index) {
            super(index);
        }

        @Override
        protected Object computeValue(Path path, float score) {
            if (path.isRoot()) {
                return Path.ROOT_NAME.getLocalName();
            }
            return path.getLastSegment().getName().getLocalName();
        }
    }

    protected static final class NameColumnAssignment
    extends PseudoColumnAssignment {
        protected NameColumnAssignment(int index) {
            super(index);
        }

        @Override
        protected Object computeValue(Path path, float score) {
            if (path.isRoot()) {
                return Path.ROOT_NAME;
            }
            return path.getLastSegment().getName();
        }
    }

    protected static final class PathColumnAssignment
    extends PseudoColumnAssignment {
        protected PathColumnAssignment(int index) {
            super(index);
        }

        @Override
        protected Object computeValue(Path path, float score) {
            return path;
        }
    }

    protected static abstract class PseudoColumnAssignment {
        private final int index;

        protected PseudoColumnAssignment(int index) {
            this.index = index;
        }

        public final void setValue(Object[] tuple, Path path, float score) {
            Object value;
            tuple[this.index] = value = this.computeValue(path, score);
        }

        protected abstract Object computeValue(Path var1, float var2);
    }
}

