/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.SelfClosingInputStream;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;

@NotThreadSafe
final class JcrValue
implements Value {
    static final JcrValue[] EMPTY_ARRAY = new JcrValue[0];
    private final ValueFactories factories;
    private final int type;
    private final Object value;
    private InputStream asStream = null;

    JcrValue(ValueFactories factories, int type, Object value) {
        assert (factories != null);
        this.factories = factories;
        assert (type == 2 || type == 6 || type == 5 || type == 12 || type == 4 || type == 3 || type == 7 || type == 8 || type == 9 || type == 10 || type == 1 || type == 11) : "Unxpected PropertyType: " + PropertyType.nameFromValue((int)type) + " for value " + (value == null ? "null" : "\"" + value + "\"");
        assert (value != null);
        this.type = type;
        this.value = this.convertToType(this.type, value);
    }

    JcrValue(ValueFactories factories, Value value) throws RepositoryException {
        assert (factories != null);
        assert (value != null);
        this.factories = factories;
        this.type = value.getType();
        this.value = this.valueToType(this.type, value);
    }

    private javax.jcr.ValueFormatException createValueFormatException(Class<?> type) {
        return new javax.jcr.ValueFormatException(JcrI18n.cannotConvertValue.text(new Object[]{this.value.getClass().getSimpleName(), type.getSimpleName()}));
    }

    private javax.jcr.ValueFormatException createValueFormatException(ValueFormatException vfe) {
        return new javax.jcr.ValueFormatException((Throwable)vfe);
    }

    final ValueFactories factories() {
        return this.factories;
    }

    final Object value() {
        return this.value;
    }

    public boolean getBoolean() throws javax.jcr.ValueFormatException {
        try {
            boolean convertedValue = this.factories().getBooleanFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Boolean.TYPE);
        }
    }

    public Calendar getDate() throws javax.jcr.ValueFormatException {
        if (this.value == null) {
            return null;
        }
        try {
            Calendar convertedValue = ((DateTime)this.factories().getDateFactory().create(this.value)).toCalendar();
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Calendar.class);
        }
    }

    public BigDecimal getDecimal() throws javax.jcr.ValueFormatException, RepositoryException {
        if (this.value == null) {
            return null;
        }
        try {
            BigDecimal convertedValue = this.factories().getDecimalFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Double.TYPE);
        }
    }

    public double getDouble() throws javax.jcr.ValueFormatException {
        try {
            double convertedValue = this.factories().getDoubleFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Double.TYPE);
        }
    }

    long getLength() throws RepositoryException {
        if (this.value == null) {
            return 0L;
        }
        if (this.type == 2) {
            return ((BinaryValue)this.factories().getBinaryFactory().create(this.value)).getSize();
        }
        return this.getString().length();
    }

    public long getLong() throws javax.jcr.ValueFormatException {
        try {
            long convertedValue = this.factories().getLongFactory().create(this.value);
            return convertedValue;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(Long.TYPE);
        }
    }

    public InputStream getStream() throws javax.jcr.ValueFormatException {
        if (this.value == null) {
            return null;
        }
        try {
            if (this.asStream == null) {
                BinaryValue binary = (BinaryValue)this.factories().getBinaryFactory().create(this.value);
                this.asStream = new SelfClosingInputStream(binary);
            }
            return this.asStream;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(InputStream.class);
        }
    }

    public BinaryValue getBinary() throws RepositoryException {
        if (this.value == null) {
            return null;
        }
        try {
            BinaryValue binary = (BinaryValue)this.factories().getBinaryFactory().create(this.value);
            return binary;
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(InputStream.class);
        }
    }

    public String getString() throws javax.jcr.ValueFormatException {
        try {
            return this.factories().getStringFactory().create(this.value);
        }
        catch (RuntimeException error) {
            throw this.createValueFormatException(String.class);
        }
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JcrValue) {
            JcrValue that = (JcrValue)obj;
            if (this.type != that.type) {
                return false;
            }
            try {
                switch (this.type) {
                    case 1: {
                        return this.getString().equals(that.getString());
                    }
                    case 2: {
                        BinaryFactory binaryFactory = this.factories().getBinaryFactory();
                        BinaryValue thisValue = (BinaryValue)binaryFactory.create(this.value);
                        BinaryValue thatValue = (BinaryValue)binaryFactory.create(that.value);
                        return thisValue.equals(thatValue);
                    }
                    case 6: {
                        return this.getBoolean() == that.getBoolean();
                    }
                    case 4: {
                        return this.getDouble() == that.getDouble();
                    }
                    case 3: {
                        return this.getLong() == that.getLong();
                    }
                    case 12: {
                        return this.getDecimal().equals(that.getDecimal());
                    }
                    case 5: {
                        DateTimeFactory dateFactory = this.factories().getDateFactory();
                        DateTime thisDateValue = (DateTime)dateFactory.create(this.value);
                        DateTime thatDateValue = (DateTime)dateFactory.create(that.value);
                        return thisDateValue.equals(thatDateValue);
                    }
                    case 8: {
                        PathFactory pathFactory = this.factories().getPathFactory();
                        Path thisPathValue = (Path)pathFactory.create(this.value);
                        Path thatPathValue = (Path)pathFactory.create(that.value);
                        return thisPathValue.equals(thatPathValue);
                    }
                    case 7: {
                        NameFactory nameFactory = this.factories().getNameFactory();
                        Name thisNameValue = (Name)nameFactory.create(this.value);
                        Name thatNameValue = (Name)nameFactory.create(that.value);
                        return thisNameValue.equals(thatNameValue);
                    }
                    case 9: 
                    case 10: {
                        return this.getString().equals(that.getString());
                    }
                }
                throw new SystemFailureException(JcrI18n.invalidPropertyType.text(new Object[]{this.type}));
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        if (obj instanceof Value) {
            Value that = (Value)obj;
            if (this.type != that.getType()) {
                return false;
            }
            try {
                switch (this.type) {
                    case 1: {
                        return this.getString().equals(that.getString());
                    }
                    case 2: {
                        return IoUtil.isSame((InputStream)this.getStream(), (InputStream)that.getBinary().getStream());
                    }
                    case 6: {
                        return this.getBoolean() == that.getBoolean();
                    }
                    case 4: {
                        return this.getDouble() == that.getDouble();
                    }
                    case 3: {
                        return this.getLong() == that.getLong();
                    }
                    case 12: {
                        return this.getDecimal().equals(that.getDecimal());
                    }
                    case 5: {
                        return this.getDate().equals(that.getDate());
                    }
                    case 8: {
                        return this.getString().equals(that.getString());
                    }
                    case 7: {
                        return this.getString().equals(that.getString());
                    }
                    case 9: {
                        return this.getString().equals(that.getString());
                    }
                }
                throw new SystemFailureException(JcrI18n.invalidPropertyType.text(new Object[]{this.type}));
            }
            catch (IOException e) {
                return false;
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return false;
    }

    private JcrValue withTypeAndValue(int type, Object value) {
        return new JcrValue(this.factories, type, value);
    }

    final JcrValue asType(int type) throws javax.jcr.ValueFormatException {
        return this.asType(type, false);
    }

    final JcrValue asType(int type, boolean force) throws javax.jcr.ValueFormatException {
        if (!force && type == this.type) {
            return this.withTypeAndValue(this.type, this.value);
        }
        Object value = this.value;
        switch (type) {
            case 6: {
                if (this.type != 1 && this.type != 2) {
                    throw this.createValueFormatException(Boolean.TYPE);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getBooleanFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 5: {
                if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 3) {
                    throw this.createValueFormatException(Calendar.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getDateFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 7: {
                if (this.type != 1 && this.type != 2 && this.type != 8) {
                    throw this.createValueFormatException(Name.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getNameFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 8: {
                if (this.type != 1 && this.type != 2 && this.type != 7) {
                    throw this.createValueFormatException(Path.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getPathFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 9: {
                if (this.type != 1 && this.type != 2 && this.type != 10) {
                    throw this.createValueFormatException(Node.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getReferenceFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 10: {
                if (this.type != 1 && this.type != 2 && this.type != 9) {
                    throw this.createValueFormatException(Node.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getWeakReferenceFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 4: {
                if (this.type != 1 && this.type != 2 && this.type != 3 && this.type != 5) {
                    throw this.createValueFormatException(Double.TYPE);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getDoubleFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 3: {
                if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 5) {
                    throw this.createValueFormatException(Long.TYPE);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getLongFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 12: {
                if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 3 && this.type != 5) {
                    throw this.createValueFormatException(BigDecimal.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getDecimalFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 11: {
                if (this.type != 1 && this.type != 2 && this.type != 11) {
                    throw this.createValueFormatException(URI.class);
                }
                try {
                    return this.withTypeAndValue(type, this.factories().getUriFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 2: {
                try {
                    return this.withTypeAndValue(type, this.factories().getBinaryFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 1: {
                try {
                    return this.withTypeAndValue(type, this.factories().getStringFactory().create(value));
                }
                catch (ValueFormatException vfe) {
                    throw this.createValueFormatException(vfe);
                }
            }
            case 0: {
                return this.withTypeAndValue(this.type, this.value);
            }
        }
        assert (false) : "Unexpected JCR property type " + type;
        throw new IllegalStateException("Invalid property type " + type);
    }

    protected Object valueToType(int type, Value value) throws RepositoryException {
        switch (type) {
            case 6: {
                return this.factories().getBooleanFactory().create(value.getBoolean());
            }
            case 5: {
                return this.factories().getDateFactory().create(value.getDate());
            }
            case 7: {
                return this.factories().getNameFactory().create(value.getString());
            }
            case 8: {
                return this.factories().getPathFactory().create(value.getString());
            }
            case 9: 
            case 10: {
                return this.factories().getReferenceFactory().create(value.getString());
            }
            case 4: {
                return this.factories().getDoubleFactory().create(value.getDouble());
            }
            case 3: {
                return this.factories().getLongFactory().create(value.getLong());
            }
            case 12: {
                return this.factories().getDecimalFactory().create(value.getDecimal());
            }
            case 11: {
                return this.factories().getUriFactory().create(value.getString());
            }
            case 2: {
                return this.factories().getBinaryFactory().create(value.getBinary());
            }
            case 1: {
                return this.factories().getStringFactory().create(value.getString());
            }
            case 0: {
                return value.getString();
            }
        }
        assert (false) : "Unexpected JCR property type " + type;
        throw new IllegalStateException("Invalid property type " + type);
    }

    protected Object convertToType(int type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 6: {
                return this.factories().getBooleanFactory().create(value);
            }
            case 5: {
                return this.factories().getDateFactory().create(value);
            }
            case 7: {
                return this.factories().getNameFactory().create(value);
            }
            case 8: {
                return this.factories().getPathFactory().create(value);
            }
            case 9: 
            case 10: {
                return this.factories().getReferenceFactory().create(value);
            }
            case 4: {
                return this.factories().getDoubleFactory().create(value);
            }
            case 3: {
                return this.factories().getLongFactory().create(value);
            }
            case 12: {
                return this.factories().getDecimalFactory().create(value);
            }
            case 11: {
                return this.factories().getUriFactory().create(value);
            }
            case 2: {
                return this.factories().getBinaryFactory().create(value);
            }
            case 1: {
                return this.factories().getStringFactory().create(value);
            }
            case 0: {
                return value;
            }
        }
        assert (false) : "Unexpected JCR property type " + type;
        throw new IllegalStateException("Invalid property type " + type);
    }

    public String toString() {
        return (this.value == null ? "null" : this.value.toString()) + " (" + PropertyType.nameFromValue((int)this.type) + ")";
    }
}

