/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LazyCachedNode;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;

public class WorkspaceCache
implements DocumentCache,
ChangeSetListener {
    private final DocumentTranslator translator;
    private final ExecutionContext context;
    private final SchematicDb database;
    private final ConcurrentMap<NodeKey, CachedNode> nodesByKey = new ConcurrentHashMap<NodeKey, CachedNode>();
    private final NodeKey rootKey;
    private final ChildReference childReferenceForRoot;
    private final String repositoryKey;
    private final String workspaceName;
    private final String workspaceKey;
    private final String sourceKey;
    private final PathFactory pathFactory;
    private final NameFactory nameFactory;
    private final ChangeSetListener changeSetListener;
    private volatile boolean closed = false;

    public WorkspaceCache(ExecutionContext context, String repositoryKey, String workspaceName, SchematicDb database, long largeValueSize, NodeKey rootKey, ChangeSetListener changeSetListener) {
        this.context = context;
        this.database = database;
        this.changeSetListener = changeSetListener;
        this.translator = new DocumentTranslator(context, database, largeValueSize);
        this.rootKey = rootKey;
        this.childReferenceForRoot = new ChildReference(rootKey, Path.ROOT_NAME, 1);
        this.repositoryKey = repositoryKey;
        this.workspaceName = workspaceName;
        this.workspaceKey = rootKey.getWorkspaceKey();
        this.sourceKey = rootKey.getSourceKey();
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.nameFactory = context.getValueFactories().getNameFactory();
    }

    public void setMinimumBinarySizeInBytes(long largeValueSize) {
        assert (largeValueSize > -1L);
        this.translator.setLargeValueSize(largeValueSize);
    }

    @Override
    public final WorkspaceCache workspaceCache() {
        return this;
    }

    public final String getProcessKey() {
        return this.context.getProcessId();
    }

    public final String getRepositoryKey() {
        return this.repositoryKey;
    }

    public final String getWorkspaceKey() {
        return this.workspaceKey;
    }

    public final String getWorkspaceName() {
        return this.workspaceName;
    }

    final DocumentTranslator translator() {
        return this.translator;
    }

    final ExecutionContext context() {
        return this.context;
    }

    final NameFactory nameFactory() {
        return this.nameFactory;
    }

    final PathFactory pathFactory() {
        return this.pathFactory;
    }

    final Path rootPath() {
        return this.pathFactory().createRootPath();
    }

    final SchematicDb database() {
        return this.database;
    }

    final Document documentFor(String key) {
        SchematicEntry entry = this.database.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getContentAsDocument();
    }

    final Document documentFor(NodeKey key) {
        return this.documentFor(key.toString());
    }

    final ChildReference childReferenceForRoot() {
        return this.childReferenceForRoot;
    }

    final String sourceKey() {
        return this.sourceKey;
    }

    @Override
    public NodeKey getRootKey() {
        this.checkNotClosed();
        return this.rootKey;
    }

    @Override
    public CachedNode getNode(NodeKey key) {
        LazyCachedNode newNode;
        Document doc;
        this.checkNotClosed();
        CachedNode node = (CachedNode)this.nodesByKey.get(key);
        if (node == null && (doc = this.documentFor(key)) != null && (node = this.nodesByKey.putIfAbsent(key, newNode = new LazyCachedNode(key, doc))) == null) {
            node = newNode;
        }
        return node;
    }

    @Override
    public CachedNode getNode(ChildReference reference) {
        this.checkNotClosed();
        return this.getNode(reference.getKey());
    }

    @Override
    public void clear() {
        this.nodesByKey.clear();
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (!this.closed) {
            for (NodeKey key : changeSet.changedNodes()) {
                this.nodesByKey.remove(key);
            }
        }
    }

    protected void changed(ChangeSet changes) {
        this.checkNotClosed();
        for (NodeKey key : changes.changedNodes()) {
            this.nodesByKey.remove(key);
        }
        if (this.changeSetListener != null) {
            this.changeSetListener.notify(changes);
        }
    }

    protected final void checkNotClosed() {
        if (this.closed) {
            throw new WorkspaceNotFoundException(JcrI18n.workspaceHasBeenDeleted.text(new Object[]{this.getWorkspaceName()}));
        }
    }

    public void signalDeleted() {
        this.closed = true;
        this.clear();
    }
}

