/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentAlreadyExistsException;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.ReferentialIntegrityException;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.WrappedException;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.document.AbstractSessionCache;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@ThreadSafe
public class WritableSessionCache
extends AbstractSessionCache {
    private static final NodeKey REMOVED_KEY = new NodeKey("REMOVED_NODE_SHOULD_NEVER_BE_PERSISTED");
    private static final SessionNode REMOVED = new SessionNode(REMOVED_KEY, false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<NodeKey, SessionNode> changedNodes = new HashMap<NodeKey, SessionNode>();
    private Set<NodeKey> replacedNodes;
    private LinkedHashSet<NodeKey> changedNodesInOrder = new LinkedHashSet();
    private final TransactionManager tm;

    public WritableSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, SessionEnvironment sessionContext) {
        super(context, workspaceCache, sessionContext);
        this.tm = sessionContext.getTransactionManager();
    }

    protected final void assertInSession(SessionNode node) {
        assert (this.changedNodes.get(node.getKey()) == node) : "Node " + node.getKey() + " is not in this session";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedNode getNode(NodeKey key) {
        CachedNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == REMOVED) {
            return null;
        }
        return sessionNode != null ? sessionNode : super.getNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionNode mutable(NodeKey key) {
        SessionNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == null || sessionNode == REMOVED) {
            sessionNode = new SessionNode(key, false);
            lock = this.lock.writeLock();
            try {
                lock.lock();
                sessionNode = this.changedNodes.get(key);
                if (sessionNode == null) {
                    sessionNode = new SessionNode(key, false);
                    this.changedNodes.put(key, sessionNode);
                    this.changedNodesInOrder.add(key);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return sessionNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.changedNodes.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(CachedNode node) {
        Path nodePath = node.getPath(this);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            List<SessionNode> nodesToRemoveInOrder = this.getChangedNodesAtOrBelowChildrenFirst(nodePath);
            for (SessionNode nodeToRemove : nodesToRemoveInOrder) {
                this.changedNodes.remove(nodeToRemove.getKey());
            }
        }
        finally {
            lock.unlock();
        }
    }

    private List<SessionNode> getChangedNodesAtOrBelowChildrenFirst(Path nodePath) {
        ArrayList<SessionNode> changedNodesChildrenFirst = new ArrayList<SessionNode>();
        for (NodeKey key : this.changedNodes.keySet()) {
            SessionNode changedNode = this.changedNodes.get(key);
            Path changedNodePath = changedNode.getPath(this);
            if (!changedNodePath.isAtOrBelow(nodePath)) continue;
            int insertIndex = changedNodesChildrenFirst.size();
            for (int i = 0; i < changedNodesChildrenFirst.size(); ++i) {
                if (!((SessionNode)changedNodesChildrenFirst.get(i)).getPath(this).isAncestorOf(changedNodePath)) continue;
                insertIndex = i;
                break;
            }
            changedNodesChildrenFirst.add(insertIndex, changedNode);
        }
        return changedNodesChildrenFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeys() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet<NodeKey> hashSet = new HashSet<NodeKey>(this.changedNodes.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeysAtOrBelow(CachedNode srcNode) {
        CheckArg.isNotNull((Object)srcNode, (String)"srcNode");
        Path sourcePath = srcNode.getPath(this);
        Lock readLock = this.lock.readLock();
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        try {
            readLock.lock();
            for (Map.Entry<NodeKey, SessionNode> entry : this.changedNodes.entrySet()) {
                SessionNode changedNodeThisSession = entry.getValue();
                NodeKey changedNodeKey = entry.getKey();
                Path changedNodePath = null;
                if (changedNodeThisSession == REMOVED) {
                    CachedNode persistentRemovedNode = this.workspaceCache.getNode(changedNodeKey);
                    if (persistentRemovedNode == null) {
                        result.add(changedNodeKey);
                        continue;
                    }
                    changedNodePath = persistentRemovedNode.getPath(this);
                } else {
                    changedNodePath = changedNodeThisSession.getPath(this);
                }
                if (changedNodePath == null || !changedNodePath.isAtOrBelow(sourcePath)) continue;
                result.add(changedNodeKey);
            }
            HashSet<NodeKey> hashSet = result;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanges() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            boolean bl = !this.changedNodes.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void save() {
        this.save(null);
    }

    protected void save(SessionCache.PreSave preSaveOperation) {
        if (!this.hasChanges()) {
            return;
        }
        Logger logger = Logger.getLogger(this.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug("Beginning SessionCache.save() with these changes: \n{0}", new Object[]{this});
        }
        ChangeSet events = null;
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            if (preSaveOperation != null) {
                AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
                for (SessionNode node : this.changedNodes.values()) {
                    if (node == REMOVED) continue;
                    this.checkNodeNotRemovedByAnotherTransaction(node);
                    preSaveOperation.process(node, saveContext);
                }
            }
            try {
                boolean closeTxn = false;
                if (this.tm != null) {
                    this.tm.begin();
                    closeTxn = true;
                }
                SessionEnvironment.Monitor monitor = this.sessionContext().createMonitor();
                try {
                    events = this.persistChanges(this.changedNodesInOrder, monitor);
                }
                catch (RuntimeException e) {
                    if (this.tm != null) {
                        this.tm.rollback();
                    }
                    throw e;
                }
                if (closeTxn) {
                    assert (this.tm != null);
                    this.tm.commit();
                }
                if (events != null && monitor != null) {
                    monitor.recordChanged(events.changedNodes().size());
                }
            }
            catch (NotSupportedException err) {
            }
            catch (SecurityException err) {
                throw new SystemFailureException((Throwable)err);
            }
            catch (IllegalStateException err) {
                throw new SystemFailureException((Throwable)err);
            }
            catch (RollbackException err) {
            }
            catch (HeuristicMixedException err) {
            }
            catch (HeuristicRollbackException err) {
                lock.unlock();
                return;
            }
            catch (SystemException err) {
                throw new SystemFailureException((Throwable)err);
            }
            this.changedNodes = new HashMap<NodeKey, SessionNode>();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            lock.unlock();
        }
        this.changedNodesInOrder.clear();
        this.replacedNodes = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Completing SessionCache.save()", new Object[0]);
        }
        this.fireChanges(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(SessionCache other, SessionCache.PreSave preSaveOperation) {
        WritableSessionCache that = (WritableSessionCache)other;
        Lock thisLock = this.lock.writeLock();
        Lock thatLock = that.lock.writeLock();
        ChangeSet events1 = null;
        ChangeSet events2 = null;
        try {
            thisLock.lock();
            thatLock.lock();
            try {
                if (preSaveOperation != null) {
                    AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
                    for (SessionNode node : this.changedNodes.values()) {
                        if (node == REMOVED) continue;
                        this.checkNodeNotRemovedByAnotherTransaction(node);
                        preSaveOperation.process(node, saveContext);
                    }
                }
                boolean closeTxn = false;
                if (this.tm != null) {
                    this.tm.begin();
                    closeTxn = true;
                }
                SessionEnvironment.Monitor monitor = this.sessionContext().createMonitor();
                try {
                    events1 = this.persistChanges(this.changedNodesInOrder, monitor);
                    events2 = that.persistChanges(that.changedNodesInOrder, monitor);
                }
                catch (RuntimeException e) {
                    if (this.tm != null) {
                        this.tm.rollback();
                    }
                    throw e;
                }
                if (closeTxn) {
                    assert (this.tm != null);
                    this.tm.commit();
                }
                if (monitor != null) {
                    if (events1 != null) {
                        monitor.recordChanged(events1.changedNodes().size());
                    }
                    if (events2 != null) {
                        monitor.recordChanged(events2.changedNodes().size());
                    }
                }
            }
            catch (NotSupportedException err) {
            }
            catch (SecurityException err) {
                throw new SystemFailureException((Throwable)err);
            }
            catch (IllegalStateException err) {
                throw new SystemFailureException((Throwable)err);
            }
            catch (RollbackException err) {
            }
            catch (HeuristicMixedException err) {
            }
            catch (HeuristicRollbackException err) {
                try {
                    thatLock.unlock();
                }
                finally {
                    thisLock.unlock();
                }
                return;
            }
            catch (SystemException err) {
                throw new SystemFailureException((Throwable)err);
            }
            this.changedNodes = new HashMap<NodeKey, SessionNode>();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            try {
                thatLock.unlock();
            }
            finally {
                thisLock.unlock();
            }
        }
        this.changedNodesInOrder.clear();
        this.replacedNodes = null;
        that.changedNodes = new HashMap<NodeKey, SessionNode>();
        that.changedNodesInOrder.clear();
        that.replacedNodes = null;
        this.fireChanges(events1);
        this.fireChanges(events2);
    }

    private void checkNodeNotRemovedByAnotherTransaction(MutableCachedNode node) {
        String keyString = node.getKey().toString();
        if (!node.isNew() && !this.workspaceCache.database().containsKey(keyString)) {
            throw new DocumentNotFoundException(keyString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(CachedNode node, SessionCache other, SessionCache.PreSave preSaveOperation) {
        List<NodeKey> savedNodesInOrder;
        Path topPath = node.getPath(this);
        Logger logger = Logger.getLogger(this.getClass());
        if (logger.isDebugEnabled()) {
            String pathStr = topPath.getString(this.context().getNamespaceRegistry());
            logger.debug("Beginning SessionCache.save(Path) with subset of changes below '{0}': \n{1}", new Object[]{pathStr, this});
        }
        WritableSessionCache that = (WritableSessionCache)other;
        Lock thisLock = this.lock.writeLock();
        Lock thatLock = that.lock.writeLock();
        ChangeSet events1 = null;
        ChangeSet events2 = null;
        try {
            thisLock.lock();
            thatLock.lock();
            savedNodesInOrder = this.filterChangesAtOrBelowPath(topPath, preSaveOperation);
            try {
                boolean closeTxn = false;
                if (this.tm != null) {
                    this.tm.begin();
                    closeTxn = true;
                }
                SessionEnvironment.Monitor monitor = this.sessionContext().createMonitor();
                try {
                    events1 = this.persistChanges(savedNodesInOrder, monitor);
                    events2 = that.persistChanges(that.changedNodesInOrder, monitor);
                }
                catch (RuntimeException e) {
                    if (this.tm != null) {
                        this.tm.rollback();
                    }
                    throw e;
                }
                if (closeTxn) {
                    assert (this.tm != null);
                    this.tm.commit();
                }
                if (monitor != null) {
                    if (events1 != null) {
                        monitor.recordChanged(events1.changedNodes().size());
                    }
                    if (events2 != null) {
                        monitor.recordChanged(events2.changedNodes().size());
                    }
                }
            }
            catch (NotSupportedException err) {
            }
            catch (SecurityException err) {
                throw new SystemFailureException((Throwable)err);
            }
            catch (IllegalStateException err) {
                throw new SystemFailureException((Throwable)err);
            }
            catch (RollbackException err) {
            }
            catch (HeuristicMixedException err) {
            }
            catch (HeuristicRollbackException err) {
                try {
                    thatLock.unlock();
                }
                finally {
                    thisLock.unlock();
                }
                return;
            }
            catch (SystemException err) {
                throw new SystemFailureException((Throwable)err);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            try {
                thatLock.unlock();
            }
            finally {
                thisLock.unlock();
            }
        }
        for (NodeKey savedNode : savedNodesInOrder) {
            this.changedNodes.remove(savedNode);
            this.changedNodesInOrder.remove(savedNode);
            if (this.replacedNodes == null) continue;
            this.replacedNodes.remove(savedNode);
        }
        that.changedNodes = new HashMap<NodeKey, SessionNode>();
        that.changedNodesInOrder.clear();
        that.replacedNodes = null;
        this.fireChanges(events1);
        this.fireChanges(events2);
    }

    private List<NodeKey> filterChangesAtOrBelowPath(Path topPath, SessionCache.PreSave preSaveOperation) throws Exception {
        LinkedList<NodeKey> savedNodesInOrder = new LinkedList<NodeKey>();
        AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
        for (NodeKey key : this.changedNodesInOrder) {
            MutableCachedNode changedNode = this.changedNodes.get(key);
            if (changedNode != REMOVED) {
                Path path = changedNode.getPath(this);
                if (!topPath.isAtOrAbove(path)) continue;
                if (preSaveOperation != null) {
                    this.checkNodeNotRemovedByAnotherTransaction(changedNode);
                    preSaveOperation.process(changedNode, saveContext);
                }
                savedNodesInOrder.add(key);
                continue;
            }
            CachedNode removedNode = this.workspaceCache().getNode(key);
            if (removedNode == null || !topPath.isAtOrAbove(removedNode.getPath(this))) continue;
            savedNodesInOrder.add(key);
        }
        return savedNodesInOrder;
    }

    private void fireChanges(ChangeSet changeSet) {
        if (changeSet != null && changeSet.size() != 0) {
            this.workspaceCache.changed(changeSet);
        }
    }

    protected ChangeSet persistChanges(Iterable<NodeKey> changedNodesInOrder, SessionEnvironment.Monitor monitor) {
        ExecutionContext context = this.context();
        String userId = context.getSecurityContext().getUserName();
        Map<String, String> userData = context.getData();
        DateTime timestamp = context.getValueFactories().getDateFactory().create();
        String workspaceName = this.workspaceCache().getWorkspaceName();
        String repositoryKey = this.workspaceCache().getRepositoryKey();
        String processKey = this.workspaceCache().getProcessKey();
        RecordingChanges changes = new RecordingChanges(processKey, repositoryKey, workspaceName);
        SchematicDb database = this.workspaceCache.database();
        DocumentTranslator translator = this.workspaceCache.translator();
        PathCache sessionPaths = new PathCache(this);
        PathCache workspacePaths = new PathCache(this.workspaceCache);
        HashSet<NodeKey> referrers = null;
        HashSet<NodeKey> removedNodes = null;
        HashSet<BinaryKey> unusedBinaryKeys = new HashSet<BinaryKey>();
        for (NodeKey nodeKey : changedNodesInOrder) {
            Set<Name> removedProperties;
            SessionNode.LockChange lockChange;
            CachedNode persisted;
            SessionNode node = this.changedNodes.get(nodeKey);
            String keyStr = nodeKey.toString();
            if (node == REMOVED) {
                persisted = this.workspaceCache.getNode(nodeKey);
                if (persisted == null) continue;
                if (removedNodes == null) {
                    removedNodes = new HashSet<NodeKey>();
                    referrers = new HashSet<NodeKey>();
                }
                assert (referrers != null);
                referrers.addAll(persisted.getReferrers(this.workspaceCache, CachedNode.ReferenceType.STRONG));
                Path path = workspacePaths.getPath(persisted);
                changes.nodeRemoved(nodeKey, persisted.getParentKey(this.workspaceCache), path);
                removedNodes.add(nodeKey);
                continue;
            }
            persisted = null;
            Path newPath = sessionPaths.getPath(node);
            NodeKey newParent = node.newParent();
            EditableDocument doc = null;
            Document metadata = null;
            SessionNode.ChangedAdditionalParents additionalParents = node.additionalParents();
            if (node.isNew()) {
                doc = Schematic.newDocument();
                translator.setKey(doc, nodeKey);
                translator.setParents(doc, newParent, null, additionalParents);
                changes.nodeCreated(nodeKey, newParent, newPath, node.changedProperties());
                if (monitor != null) {
                    Name primaryType = node.getPrimaryType(this);
                    Set<Name> mixinTypes = node.getMixinTypes(this);
                    monitor.recordAdd(workspaceName, nodeKey, newPath, primaryType, mixinTypes, node.changedProperties().values());
                }
            } else {
                SchematicEntry nodeEntry = database.get(keyStr);
                if (nodeEntry == null) {
                    throw new DocumentNotFoundException(keyStr);
                }
                doc = nodeEntry.editDocumentContent();
                if (newParent != null) {
                    persisted = this.workspaceCache.getNode(nodeKey);
                    Path oldPath = workspacePaths.getPath(persisted);
                    NodeKey oldParentKey = persisted.getParentKey(this.workspaceCache);
                    if (!oldParentKey.equals(newParent) || !additionalParents.isEmpty()) {
                        translator.setParents(doc, node.newParent(), oldParentKey, additionalParents);
                    }
                    changes.nodeMoved(nodeKey, newParent, oldParentKey, newPath, oldPath);
                } else if (additionalParents != null) {
                    translator.setParents(doc, null, null, additionalParents);
                }
                SessionNode.MixinChanges mixinChanges = node.mixinChanges(false);
                if (mixinChanges != null && !mixinChanges.isEmpty()) {
                    Property oldProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    translator.addPropertyValues(doc, JcrLexicon.MIXIN_TYPES, true, mixinChanges.getAdded(), unusedBinaryKeys);
                    translator.removePropertyValues(doc, JcrLexicon.MIXIN_TYPES, mixinChanges.getRemoved(), unusedBinaryKeys);
                    Property property = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, newPath, property);
                    } else if (property == null) {
                        changes.propertyRemoved(nodeKey, newPath, oldProperty);
                    } else {
                        changes.propertyChanged(nodeKey, newPath, property, oldProperty);
                    }
                }
            }
            if ((lockChange = node.getLockChange()) != null) {
                switch (lockChange) {
                    case LOCK_FOR_SESSION: 
                    case LOCK_FOR_NON_SESSION: {
                        if (!translator.isLocked(doc)) break;
                        throw new LockFailureException(nodeKey);
                    }
                }
            }
            if (!(removedProperties = node.removedProperties()).isEmpty()) {
                assert (!node.isNew());
                if (persisted == null) {
                    persisted = this.workspaceCache.getNode(nodeKey);
                }
                for (Name name : removedProperties) {
                    Property oldProperty = translator.removeProperty(doc, name, unusedBinaryKeys);
                    if (oldProperty == null) continue;
                    changes.propertyRemoved(nodeKey, newPath, oldProperty);
                }
            }
            if (!node.changedProperties().isEmpty()) {
                if (!node.isNew() && persisted == null) {
                    persisted = this.workspaceCache.getNode(nodeKey);
                }
                for (Map.Entry entry : node.changedProperties().entrySet()) {
                    Name name = (Name)entry.getKey();
                    Property prop = (Property)entry.getValue();
                    Property oldProperty = persisted != null ? persisted.getProperty(name, this.workspaceCache) : null;
                    translator.setProperty(doc, prop, unusedBinaryKeys);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, newPath, prop);
                        continue;
                    }
                    changes.propertyChanged(nodeKey, newPath, prop, oldProperty);
                }
            }
            SessionNode.ChangedChildren changedChildren = node.changedChildren();
            MutableChildReferences mutableChildReferences = node.appended(false);
            if ((changedChildren == null || changedChildren.isEmpty()) && mutableChildReferences != null && !mutableChildReferences.isEmpty()) {
                translator.changeChildren(nodeKey, doc, changedChildren, mutableChildReferences);
            } else if (changedChildren != null && !changedChildren.isEmpty()) {
                if (!changedChildren.getRemovals().isEmpty()) {
                    for (NodeKey removed : changedChildren.getRemovals()) {
                        CachedNode persistent = this.workspaceCache.getNode(removed);
                        if (persistent == null) continue;
                        Path oldPath = workspacePaths.getPath(persistent);
                        if (mutableChildReferences == null || !mutableChildReferences.hasChild(persistent.getKey())) continue;
                        ChildReference appendedChildRef = node.getChildReferences(this).getChild(persistent.getKey());
                        newPath = this.pathFactory().create(sessionPaths.getPath(node), appendedChildRef.getSegment());
                        changes.nodeReordered(persistent.getKey(), node.getKey(), newPath, oldPath, null);
                    }
                }
                translator.changeChildren(nodeKey, doc, changedChildren, mutableChildReferences);
                Map<NodeKey, Name> newNames = changedChildren.getNewNames();
                if (!newNames.isEmpty()) {
                    for (Map.Entry<NodeKey, Name> renameEntry : newNames.entrySet()) {
                        NodeKey renamedKey = renameEntry.getKey();
                        CachedNode oldRenamedNode = this.workspaceCache.getNode(renamedKey);
                        if (oldRenamedNode == null) continue;
                        CachedNode renamedNode = this.getNode(renamedKey);
                        Path renamedFromPath = workspacePaths.getPath(oldRenamedNode);
                        Path renamedToPath = sessionPaths.getPath(renamedNode);
                        changes.nodeRenamed(renamedKey, renamedToPath, renamedFromPath.getLastSegment());
                    }
                }
                Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
                for (SessionNode.Insertions insertion : insertionsByBeforeKey.values()) {
                    for (ChildReference insertedRef : insertion.inserted()) {
                        CachedNode insertedNodePersistent = this.workspaceCache.getNode(insertedRef);
                        Path nodeOldPath = insertedNodePersistent != null ? workspacePaths.getPath(insertedNodePersistent) : null;
                        CachedNode insertedBeforeNode = this.workspaceCache.getNode(insertion.insertedBefore());
                        Path insertedBeforePath = workspacePaths.getPath(insertedBeforeNode);
                        Path nodeNewPath = null;
                        if (nodeOldPath != null) {
                            boolean isSnsReordering = nodeOldPath != null && nodeOldPath.getLastSegment().getName().equals(insertedBeforePath.getLastSegment().getName());
                            nodeNewPath = isSnsReordering ? insertedBeforePath : nodeOldPath;
                        } else {
                            nodeNewPath = sessionPaths.getPath(this.changedNodes.get(insertedRef.getKey()));
                        }
                        changes.nodeReordered(insertedRef.getKey(), node.getKey(), nodeNewPath, nodeOldPath, insertedBeforePath);
                    }
                }
            }
            SessionNode.ReferrerChanges referrerChanges = node.getReferrerChanges();
            if (referrerChanges != null && !referrerChanges.isEmpty()) {
                translator.changeReferrers(doc, referrerChanges);
                changes.nodeChanged(nodeKey, newPath);
            }
            if (node.isNew()) {
                if (database.putIfAbsent(keyStr, (Document)doc, metadata) == null) continue;
                if (this.replacedNodes != null && this.replacedNodes.contains(nodeKey)) {
                    database.put(keyStr, (Document)doc, metadata);
                    continue;
                }
                if (removedNodes != null && removedNodes.contains(nodeKey)) {
                    database.put(keyStr, (Document)doc, metadata);
                    removedNodes.remove(nodeKey);
                    continue;
                }
                throw new DocumentAlreadyExistsException(keyStr);
            }
            if (monitor == null) continue;
            Name primaryType = node.getPrimaryType(this);
            Set<Name> mixinTypes = node.getMixinTypes(this);
            monitor.recordUpdate(workspaceName, nodeKey, newPath, primaryType, mixinTypes, node.getProperties(this));
        }
        if (removedNodes != null) {
            assert (!removedNodes.isEmpty());
            assert (referrers != null);
            referrers.removeAll(removedNodes);
            if (!referrers.isEmpty()) {
                throw new ReferentialIntegrityException((Set<NodeKey>)removedNodes, (Set<NodeKey>)referrers);
            }
            for (NodeKey nodeKey : removedNodes) {
                database.remove(nodeKey.toString());
            }
            if (monitor != null) {
                monitor.recordRemove(workspaceName, (Iterable<NodeKey>)removedNodes);
            }
        }
        if (!unusedBinaryKeys.isEmpty()) {
            for (BinaryKey binaryKey : unusedBinaryKeys) {
                changes.binaryValueNoLongerUsed(binaryKey);
            }
        }
        changes.setChangedNodes(this.changedNodes.keySet());
        changes.freeze(userId, userData, timestamp);
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionNode add(SessionNode newNode) {
        assert (newNode != REMOVED);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            NodeKey key = newNode.getKey();
            SessionNode node = this.changedNodes.put(key, newNode);
            if (node != null) {
                if (node != REMOVED) {
                    this.changedNodes.put(key, node);
                    SessionNode sessionNode = node;
                    return sessionNode;
                }
                if (this.replacedNodes == null) {
                    this.replacedNodes = new HashSet<NodeKey>();
                }
                this.replacedNodes.add(key);
            }
            this.changedNodesInOrder.add(key);
            SessionNode sessionNode = newNode;
            return sessionNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(NodeKey key) {
        assert (key != null);
        WorkspaceCache workspace = this.workspaceCache();
        CachedNode topNode = this.getNode(key);
        if (topNode == null) {
            throw new NodeNotFoundException(key);
        }
        HashMap<NodeKey, SessionNode> removed = new HashMap<NodeKey, SessionNode>();
        LinkedHashSet<NodeKey> addToChangedNodes = new LinkedHashSet<NodeKey>();
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            LinkedList<NodeKey> keys = new LinkedList<NodeKey>();
            keys.add(key);
            while (!keys.isEmpty()) {
                NodeKey nodeKey = (NodeKey)keys.remove();
                SessionNode node = this.changedNodes.put(nodeKey, REMOVED);
                ChildReferences children = null;
                if (node != null) {
                    if (node == REMOVED) continue;
                    children = node.getChildReferences(this);
                    removed.put(nodeKey, node);
                } else {
                    addToChangedNodes.add(nodeKey);
                    CachedNode persisted = workspace.getNode(nodeKey);
                    if (persisted == null) continue;
                    children = persisted.getChildReferences(workspace);
                }
                assert (children != null);
                for (ChildReference child : children) {
                    NodeKey childKey = child.getKey();
                    keys.add(childKey);
                }
            }
            this.changedNodesInOrder.addAll(addToChangedNodes);
        }
        catch (RuntimeException e) {
            try {
                this.changedNodes.putAll(removed);
            }
            catch (RuntimeException e2) {
                I18n msg = JcrI18n.failedWhileRollingBackDestroyToRuntimeError;
                Logger.getLogger(this.getClass()).error((Throwable)e2, msg, new Object[]{e2.getMessage(), e.getMessage()});
            }
            finally {
                throw e;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isDestroyed(NodeKey key) {
        return this.changedNodes.get(key) == REMOVED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NamespaceRegistry reg = this.context().getNamespaceRegistry();
        sb.append("Session ").append(this.context().getId()).append(" to workspace '").append(this.workspaceCache.getWorkspaceName());
        for (NodeKey key : this.changedNodesInOrder) {
            SessionNode changes = this.changedNodes.get(key);
            if (changes == null) continue;
            sb.append("\n ");
            sb.append(changes.getString(reg));
        }
        return sb.toString();
    }
}

