/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;

@Immutable
public class UriValueFactory
extends AbstractValueFactory<URI> {
    private final NamespaceRegistry namespaceRegistry;

    public UriValueFactory(NamespaceRegistry namespaceRegistry, TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.URI, decoder, stringValueFactory);
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        this.namespaceRegistry = namespaceRegistry;
    }

    @Override
    public URI create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), URI.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public URI create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public URI create(int value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public URI create(long value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public URI create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public URI create(float value) {
        throw new ValueFormatException((Object)Float.valueOf(value), this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public URI create(double value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public URI create(BigDecimal value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public URI create(Calendar value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public URI create(Date value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public URI create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public URI create(Name value) {
        if (value == null) {
            return null;
        }
        return this.create("./" + value.getString(this.namespaceRegistry));
    }

    @Override
    public URI create(Path value) {
        if (value == null) {
            return null;
        }
        if (value.isAbsolute()) {
            return this.create("/" + value.getString(this.namespaceRegistry));
        }
        return this.create("./" + value.getString(this.namespaceRegistry));
    }

    @Override
    public URI create(Path.Segment value) {
        if (value == null) {
            return null;
        }
        return this.create("./" + value.getString(this.namespaceRegistry));
    }

    @Override
    public URI create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public URI create(UUID value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public URI create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public URI create(URI value) {
        return value;
    }

    @Override
    public URI create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public URI create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public URI create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    protected URI[] createEmptyArray(int length) {
        return new URI[length];
    }
}

