/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.sandbox.standalone;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.sandbox.standalone.FullTextManager;
import org.hibernate.search.sandbox.standalone.FullTextQuery;
import org.hibernate.search.sandbox.standalone.InstanceTransactionContext;

public class LuceneFullTextManager
implements FullTextManager {
    private final SearchFactoryImplementor searchFactory;
    private final InstanceTransactionContext transactionContext;

    LuceneFullTextManager(SearchFactoryImplementor sfi) {
        this.searchFactory = sfi;
        this.transactionContext = new InstanceTransactionContext();
        this.transactionContext.beginTransaction();
    }

    @Override
    public <T> T get(Class<T> entityType, Serializable id) {
        EntityIndexBinder entityIndexBinding = this.searchFactory.getIndexBindingForEntity(entityType);
        if (entityIndexBinding == null) {
            String msg = "Entity to retrueve is not an @Indexed entity: " + entityType.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        if (id == null) {
            throw new IllegalArgumentException("Identifier cannot be null");
        }
        DocumentBuilderIndexedEntity<?> docBuilder = entityIndexBinding.getDocumentBuilder();
        TermQuery luceneQuery = new TermQuery(docBuilder.getTerm(id));
        FullTextQuery searchQuery = this.createFullTextQuery((Query)luceneQuery, entityType);
        List<?> results = searchQuery.list();
        if (results.size() > 1) {
            throw new SearchException("Several entities with he same id found: " + entityType + "#" + id);
        }
        T result = results.size() == 0 ? null : (T)results.get(0);
        return result;
    }

    @Override
    public FullTextQuery createFullTextQuery(Query luceneQuery, Class<?> ... entities) {
        return null;
    }

    @Override
    public <T> void index(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity to index should not be null");
        }
        Class<?> clazz = this.getClass(entity);
        EntityIndexBinder entityIndexBinding = this.searchFactory.getIndexBindingForEntity(clazz);
        if (entityIndexBinding == null) {
            String msg = "Entity to index is not an @Indexed entity: " + entity.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        Serializable id = entityIndexBinding.getDocumentBuilder().getId(entity);
        Work<T> work = new Work<T>(entity, id, WorkType.INDEX);
        this.searchFactory.getWorker().performWork(work, this.transactionContext);
    }

    private Class<?> getClass(Object entity) {
        return entity.getClass();
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        if (entityType == null) {
            return;
        }
        Set<Class<?>> targetedClasses = this.searchFactory.getIndexedTypesPolymorphic(new Class[]{entityType});
        if (targetedClasses.isEmpty()) {
            String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
            throw new IllegalArgumentException(msg);
        }
        for (Class<?> clazz : targetedClasses) {
            if (id == null) {
                this.createAndPerformWork(clazz, null, WorkType.PURGE_ALL);
                continue;
            }
            this.createAndPerformWork(clazz, id, WorkType.PURGE);
        }
    }

    private <T> void createAndPerformWork(Class<T> clazz, Serializable id, WorkType workType) {
        Work<T> work = new Work<T>(clazz, id, workType);
        this.searchFactory.getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.purge(entityType, null);
    }

    @Override
    public void flushToIndexes() {
        this.searchFactory.getWorker().flushWorks(this.transactionContext);
    }
}

