/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.query.InvalidQueryException;
import javax.transaction.Synchronization;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.QueryIndexing;
import org.modeshape.jcr.query.lucene.LuceneQueryEngine;
import org.modeshape.jcr.query.lucene.LuceneSearchConfiguration;
import org.modeshape.jcr.query.lucene.basic.BasicLuceneConfiguration;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.optimize.RuleBasedOptimizer;
import org.modeshape.jcr.query.plan.CanonicalPlanner;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Path;

class RepositoryQueryManager {
    private final JcrRepository.RunningState runningState;
    private final ExecutorService indexingExecutorService;
    private final LuceneSearchConfiguration config;
    private final Lock engineInitLock = new ReentrantLock();
    private volatile LuceneQueryEngine queryEngine;
    protected static final TransactionContext NO_TRANSACTION = new TransactionContext(){

        public boolean isTransactionInProgress() {
            return false;
        }

        public Object getTransactionIdentifier() {
            throw new UnsupportedOperationException("Should not be called since we're just reading content");
        }

        public void registerSynchronization(Synchronization synchronization) {
            throw new UnsupportedOperationException("Should not be called since we're just reading content");
        }
    };

    RepositoryQueryManager(JcrRepository.RunningState runningState, RepositoryConfiguration.QuerySystem querySystem, ExecutorService indexingExecutorService, Properties backendProps, Properties indexingProps, Properties indexStorageProps) {
        this.runningState = runningState;
        this.indexingExecutorService = indexingExecutorService;
        String repoName = runningState.name();
        this.config = new BasicLuceneConfiguration(repoName, backendProps, indexingProps, indexStorageProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        block7: {
            this.indexingExecutorService.shutdown();
            if (this.queryEngine != null) {
                try {
                    this.engineInitLock.lock();
                    if (this.queryEngine == null) break block7;
                    try {
                        this.queryEngine.shutdown();
                    }
                    finally {
                        this.queryEngine = null;
                    }
                }
                finally {
                    this.engineInitLock.unlock();
                }
            }
        }
    }

    public CancellableQuery query(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, org.modeshape.jcr.api.query.qom.QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) throws InvalidQueryException {
        return this.queryEngine().query(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, (QueryCommand)query, schemata, hints, variables);
    }

    public QueryIndexing getIndexes() {
        return this.queryEngine().getQueryIndexing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final LuceneQueryEngine queryEngine() {
        if (this.queryEngine == null) {
            try {
                this.engineInitLock.lock();
                if (this.queryEngine == null) {
                    Logger.getLogger(this.getClass()).debug("Hibernate Search configuration for repository '{0}': {1}", new Object[]{this.runningState.name(), this.config});
                    boolean enableFullTextSearch = this.runningState.isFullTextSearchEnabled();
                    CanonicalPlanner planner = new CanonicalPlanner();
                    RuleBasedOptimizer optimizer = new RuleBasedOptimizer();
                    SearchFactoryImplementor searchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)this.config).buildSearchFactory();
                    this.queryEngine = new LuceneQueryEngine(this.runningState.context(), this.runningState.name(), planner, optimizer, searchFactory, this.config.getVersion(), enableFullTextSearch);
                }
            }
            finally {
                this.engineInitLock.unlock();
            }
        }
        return this.queryEngine;
    }

    public void reindexContent(JcrWorkspace workspace) {
        this.reindexContent(workspace, Path.ROOT_PATH, Integer.MAX_VALUE);
    }

    public void reindexContent(JcrWorkspace workspace, Path path, int depth) {
        CheckArg.isPositive((int)depth, (String)"depth");
        JcrSession session = workspace.getSession();
        NodeCache cache = session.cache().getWorkspace();
        String workspaceName = workspace.getName();
        CachedNode node = cache.getNode(cache.getRootKey());
        for (Path.Segment segment : path) {
            ChildReference ref = node.getChildReferences(cache).getChild(segment);
            if (ref == null) {
                return;
            }
            node = cache.getNode(ref);
        }
        NodeTypeSchemata schemata = this.runningState.nodeTypeManager().getRepositorySchemata();
        String systemWorkspaceKey = this.runningState.repositoryCache().getSystemWorkspaceKey();
        if (node.getKey().getWorkspaceKey().equals(systemWorkspaceKey)) {
            this.reindexSystemContent(node, depth, schemata);
        } else {
            this.reindexContent(workspaceName, schemata, cache, node, depth, path.isRoot());
        }
    }

    protected void reindexContent(String workspaceName, NodeTypeSchemata schemata, NodeCache cache, CachedNode node, int depth, boolean lookForSystemNode) {
        NodeKey key;
        PathCache paths = new PathCache(cache);
        Path nodePath = paths.getPath(node);
        QueryIndexing indexes = this.getIndexes();
        TransactionContext txnCtx = NO_TRANSACTION;
        indexes.updateIndex(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getProperties(cache), schemata, txnCtx);
        if (depth == 1) {
            return;
        }
        LinkedList<NodeKey> queue = new LinkedList<NodeKey>();
        if (lookForSystemNode) {
            ChildReferences childRefs = node.getChildReferences(cache);
            ChildReference systemRef = childRefs.getChild(JcrLexicon.SYSTEM);
            NodeKey systemKey = systemRef != null ? systemRef.getKey() : null;
            for (ChildReference childRef : node.getChildReferences(cache)) {
                NodeKey childKey = childRef.getKey();
                if (childKey.equals(systemKey)) {
                    node = cache.getNode(childKey);
                    this.reindexSystemContent(node, depth - 1, schemata);
                    continue;
                }
                queue.add(childKey);
            }
        } else {
            for (ChildReference childRef : node.getChildReferences(cache)) {
                queue.add(childRef.getKey());
            }
        }
        while ((key = (NodeKey)queue.poll()) != null) {
            node = cache.getNode(key);
            nodePath = paths.getPath(node);
            indexes.updateIndex(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getProperties(cache), schemata, txnCtx);
            if (nodePath.size() > depth) continue;
            for (ChildReference childRef : node.getChildReferences(cache)) {
                queue.add(childRef.getKey());
            }
        }
    }

    protected void reindexSystemContent(CachedNode nodeInSystemBranch, int depth, NodeTypeSchemata schemata) {
        RepositoryCache repoCache = this.runningState.repositoryCache();
        String workspaceName = repoCache.getSystemWorkspaceName();
        NodeCache systemWorkspaceCache = repoCache.getWorkspaceCache(workspaceName);
        this.reindexContent(workspaceName, schemata, systemWorkspaceCache, nodeInSystemBranch, depth, false);
    }

    protected void reindexSystemContent(boolean async) {
        RepositoryCache repositoryCache = this.runningState.repositoryCache();
        final NodeCache systemWorkspaceCache = repositoryCache.getWorkspaceCache(repositoryCache.getSystemWorkspaceName());
        final CachedNode systemRoot = systemWorkspaceCache.getNode(repositoryCache.getSystemKey());
        if (async) {
            this.indexingExecutorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RepositoryQueryManager.this.reindexSystemContent(systemRoot, systemWorkspaceCache);
                    return null;
                }
            });
        } else {
            this.reindexSystemContent(systemRoot, systemWorkspaceCache);
        }
    }

    private void reindexSystemContent(CachedNode systemRoot, NodeCache systemWorkspaceCache) {
        NodeTypeSchemata schemata = this.runningState.nodeTypeManager().getRepositorySchemata();
        this.reindexSystemContent(systemRoot, 1, schemata);
        for (ChildReference childReference : systemRoot.getChildReferences(systemWorkspaceCache)) {
            CachedNode systemNode = systemWorkspaceCache.getNode(childReference.getKey());
            String systemNodeName = systemNode.getName(systemWorkspaceCache).toString();
            if (systemNodeName.contains("versionStorage") || systemNodeName.contains("locks")) continue;
            this.reindexSystemContent(systemNode, Integer.MAX_VALUE, schemata);
        }
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace);
                return Boolean.TRUE;
            }
        });
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace, final Path path, final int depth) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace, path, depth);
                return Boolean.TRUE;
            }
        });
    }
}

