/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrDocumentViewExporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSvLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
class JcrContentHandler
extends DefaultHandler {
    protected static final TextDecoder SYSTEM_VIEW_NAME_DECODER = new XmlNameEncoder();
    protected static final TextDecoder DOCUMENT_VIEW_NAME_DECODER = JcrDocumentViewExporter.NAME_DECODER;
    protected static final TextDecoder DOCUMENT_VIEW_VALUE_DECODER = JcrDocumentViewExporter.VALUE_DECODER;
    private static final String ALT_XML_SCHEMA_NAMESPACE_PREFIX = "xsd";
    private final JcrSession session;
    private final ExecutionContext context;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ValueFactory<String> stringFactory;
    private final NamespaceRegistry namespaces;
    private final javax.jcr.ValueFactory jcrValueFactory;
    private final JcrNodeTypeManager nodeTypes;
    private final javax.jcr.NamespaceRegistry jcrNamespaceRegistry;
    protected final int uuidBehavior;
    protected final boolean retentionInfoRetained;
    protected final boolean lifecycleInfoRetained;
    protected final String primaryTypeName;
    protected final String mixinTypesName;
    protected final String uuidName;
    private AbstractJcrNode currentNode;
    private ContentHandler delegate;
    protected final List<AbstractJcrProperty> refPropsRequiringConstraintValidation = new LinkedList<AbstractJcrProperty>();
    protected final List<AbstractJcrNode> nodesForPostProcessing = new LinkedList<AbstractJcrNode>();
    protected SessionCache cache;
    private final boolean saveWhenCompleted;
    protected static final Set<Name> PROPERTIES_FOR_POST_PROCESSING = Collections.unmodifiableSet((Object[])new Name[]{JcrLexicon.LOCK_IS_DEEP, JcrLexicon.LOCK_OWNER, JcrLexicon.BASE_VERSION, JcrLexicon.LIFECYCLE_POLICY, JcrLexicon.CURRENT_LIFECYCLE_STATE, JcrLexicon.HOLD, JcrLexicon.IS_DEEP, JcrLexicon.RETENTION_POLICY});

    JcrContentHandler(JcrSession session, AbstractJcrNode parent, int uuidBehavior, boolean saveWhenCompleted, boolean retentionInfoRetained, boolean lifecycleInfoRetained) throws PathNotFoundException, RepositoryException {
        assert (session != null);
        assert (uuidBehavior == 0 || uuidBehavior == 1 || uuidBehavior == 2 || uuidBehavior == 3);
        this.session = session;
        this.session.initBaseVersionKeys();
        this.context = this.session.context();
        this.namespaces = this.context.getNamespaceRegistry();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.stringFactory = this.context.getValueFactories().getStringFactory();
        this.uuidBehavior = uuidBehavior;
        this.retentionInfoRetained = retentionInfoRetained;
        this.lifecycleInfoRetained = lifecycleInfoRetained;
        this.saveWhenCompleted = saveWhenCompleted;
        this.cache = session.cache();
        this.currentNode = parent;
        this.jcrValueFactory = session.getValueFactory();
        this.nodeTypes = session.nodeTypeManager();
        this.jcrNamespaceRegistry = session.workspace().getNamespaceRegistry();
        this.primaryTypeName = JcrLexicon.PRIMARY_TYPE.getString(this.namespaces);
        this.mixinTypesName = JcrLexicon.MIXIN_TYPES.getString(this.namespaces);
        this.uuidName = JcrLexicon.UUID.getString(this.namespaces);
    }

    protected final JcrSession session() {
        return this.session;
    }

    protected final NamespaceRegistry namespaces() {
        return this.namespaces;
    }

    protected final JcrNodeTypeManager nodeTypes() {
        return this.nodeTypes;
    }

    protected final JcrNodeType nodeTypeFor(String name) {
        return this.nodeTypes.getNodeType(this.nameFor(name));
    }

    protected final String stringFor(Object name) {
        return this.stringFactory.create(name);
    }

    protected final Name nameFor(String name) {
        return (Name)this.nameFactory.create(name);
    }

    protected final Path pathFor(Name ... names) {
        return this.pathFor(this.pathFactory.createRootPath(), names);
    }

    protected final Path pathFor(Path parentPath, Name ... names) {
        return this.pathFactory.create(parentPath, names);
    }

    protected final Value valueFor(String value, int type) throws ValueFormatException {
        return this.jcrValueFactory.createValue(value, type);
    }

    protected final Value valueFor(InputStream stream) throws RepositoryException {
        return this.jcrValueFactory.createValue(this.jcrValueFactory.createBinary(stream));
    }

    protected final SessionCache cache() {
        return this.cache;
    }

    protected void postProcessNodes() throws SAXException {
        try {
            for (AbstractJcrNode node : this.nodesForPostProcessing) {
                AbstractJcrProperty baseVersionProp;
                MutableCachedNode mutable = node.mutable();
                if (node.isNodeType(JcrMixLexicon.VERSIONABLE) && (baseVersionProp = node.getProperty(JcrLexicon.BASE_VERSION)) != null) {
                    NodeKeyReference baseVersionRef = (NodeKeyReference)baseVersionProp.getValue().value();
                    this.session.setDesiredBaseVersionKey(node.key(), baseVersionRef.getNodeKey());
                }
                if (node.isNodeType(JcrMixLexicon.LOCKABLE) && node.isLocked()) {
                    node.unlock();
                }
                if (node.isNodeType(JcrMixLexicon.LIFECYCLE) && this.lifecycleInfoRetained && !this.isValidReference(node, JcrLexicon.LIFECYCLE_POLICY, false)) {
                    mutable.removeProperty(this.cache, JcrLexicon.LIFECYCLE_POLICY);
                    mutable.removeProperty(this.cache, JcrLexicon.CURRENT_LIFECYCLE_STATE);
                }
                if (!node.isNodeType(JcrMixLexicon.MANAGED_RETENTION) || !this.retentionInfoRetained || this.isValidReference(node, JcrLexicon.RETENTION_POLICY, false)) continue;
                mutable.removeProperty(this.cache, JcrLexicon.HOLD);
                mutable.removeProperty(this.cache, JcrLexicon.IS_DEEP);
                mutable.removeProperty(this.cache, JcrLexicon.RETENTION_POLICY);
            }
        }
        catch (RepositoryException e) {
            throw new EnclosingSAXException((Exception)((Object)e));
        }
    }

    protected boolean isValidReference(AbstractJcrNode node, Name propertyName, boolean returnValueIfNoProperty) throws RepositoryException {
        AbstractJcrProperty property = node.getProperty(propertyName);
        return property == null ? returnValueIfNoProperty : this.isValidReference(property);
    }

    protected boolean isValidReference(AbstractJcrProperty property) throws RepositoryException {
        JcrPropertyDefinition defn = property.getDefinition();
        if (defn == null) {
            return false;
        }
        if (property.isMultiple()) {
            for (JcrValue value : property.getValues()) {
                if (defn.canCastToTypeAndSatisfyConstraints(value, this.session)) continue;
                return false;
            }
            return true;
        }
        return defn.canCastToTypeAndSatisfyConstraints(property.getValue(), this.session);
    }

    protected void validateReferenceConstraints() throws SAXException {
        if (this.refPropsRequiringConstraintValidation.isEmpty()) {
            return;
        }
        try {
            for (AbstractJcrProperty refProp : this.refPropsRequiringConstraintValidation) {
                if (refProp.property() == null || this.isValidReference(refProp)) continue;
                JcrPropertyDefinition defn = refProp.getDefinition();
                String name = this.stringFor(refProp.name());
                String path = refProp.getParent().getPath();
                throw new ConstraintViolationException(JcrI18n.constraintViolatedOnReference.text(new Object[]{name, path, defn}));
            }
        }
        catch (RepositoryException e) {
            throw new EnclosingSAXException((Exception)((Object)e));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        assert (this.delegate != null);
        this.delegate.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.postProcessNodes();
        this.validateReferenceConstraints();
        if (this.saveWhenCompleted) {
            try {
                this.session.save();
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        super.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        assert (this.delegate != null);
        this.delegate.endElement(uri, localName, name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.checkDelegate(uri);
        assert (this.delegate != null);
        this.delegate.startElement(uri, localName, name, atts);
    }

    private void checkDelegate(String namespaceUri) {
        if (this.delegate != null) {
            return;
        }
        this.delegate = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceUri) ? new SystemViewContentHandler(this.currentNode) : new DocumentViewContentHandler(this.currentNode);
    }

    protected static byte[] decodeBase64(String value) throws IOException {
        try {
            return Base64.decode((byte[])value.getBytes("UTF-8"));
        }
        catch (IOException e) {
            return Base64.decode((String)value, (int)16);
        }
    }

    protected static String decodeBase64AsString(String value) throws IOException {
        byte[] decoded = JcrContentHandler.decodeBase64(value);
        return new String(decoded, "UTF-8");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            String existingUri;
            if (ALT_XML_SCHEMA_NAMESPACE_PREFIX.equals(prefix) && uri.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = "xs";
            }
            if ((existingUri = this.namespaces.getNamespaceForPrefix(prefix)) != null) {
                if (existingUri.equals(uri)) {
                    return;
                }
                throw new RepositoryException("Prefix " + prefix + " is already permanently mapped");
            }
            this.jcrNamespaceRegistry.registerNamespace(prefix, uri);
        }
        catch (RepositoryException re) {
            throw new EnclosingSAXException((Exception)((Object)re));
        }
    }

    private class DocumentViewContentHandler
    extends DefaultHandler {
        private NodeHandler current;
        private final NodeHandlerFactory nodeHandlerFactory;

        DocumentViewContentHandler(AbstractJcrNode currentNode) {
            this.current = new ExistingNodeHandler(currentNode, null);
            this.nodeHandlerFactory = new StandardNodeHandlerFactory();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            String nodeName = DOCUMENT_VIEW_NAME_DECODER.decode(name);
            this.current = this.nodeHandlerFactory.createFor(JcrContentHandler.this.nameFor(nodeName), this.current, JcrContentHandler.this.uuidBehavior);
            for (int i = 0; i < atts.getLength(); ++i) {
                String value = atts.getValue(i);
                if (value == null) continue;
                value = DOCUMENT_VIEW_VALUE_DECODER.decode(value);
                String propertyName = DOCUMENT_VIEW_NAME_DECODER.decode(atts.getQName(i));
                this.current.addPropertyValue(JcrContentHandler.this.nameFor(propertyName), value, false, 1, null);
            }
            this.current.finish();
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.current.finish();
            this.current = this.current.parentHandler();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length);
            if ((value = value.trim()).length() == 0) {
                return;
            }
            this.current = this.nodeHandlerFactory.createFor(JcrLexicon.XMLTEXT, this.current, JcrContentHandler.this.uuidBehavior);
            this.current.addPropertyValue(JcrLexicon.PRIMARY_TYPE, JcrContentHandler.this.stringFor(JcrNtLexicon.UNSTRUCTURED), false, 7, DOCUMENT_VIEW_NAME_DECODER);
            this.current.addPropertyValue(JcrLexicon.XMLCHARACTERS, value, false, 1, null);
            this.current.finish();
            this.current = this.current.parentHandler();
        }
    }

    private class SystemViewContentHandler
    extends DefaultHandler {
        private final String svNameName;
        private final String svTypeName;
        private final String svMultipleName;
        private NodeHandler current;
        private final NodeHandlerFactory nodeHandlerFactory;
        private String currentPropertyName;
        private int currentPropertyType;
        private boolean currentPropertyValueIsBinary;
        private boolean currentPropertyIsMultiValued;
        private StringBuilder currentPropertyValue;

        SystemViewContentHandler(AbstractJcrNode parent) {
            this.svNameName = JcrSvLexicon.NAME.getString(JcrContentHandler.this.namespaces());
            this.svTypeName = JcrSvLexicon.TYPE.getString(JcrContentHandler.this.namespaces());
            this.svMultipleName = JcrSvLexicon.MULTIPLE.getString(JcrContentHandler.this.namespaces());
            this.current = new ExistingNodeHandler(parent, null);
            this.nodeHandlerFactory = new StandardNodeHandlerFactory();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.currentPropertyValue = new StringBuilder();
            if ("node".equals(localName)) {
                this.current.finish();
                String nodeName = atts.getValue(SYSTEM_VIEW_NAME_DECODER.decode(this.svNameName));
                this.current = this.nodeHandlerFactory.createFor(JcrContentHandler.this.nameFor(nodeName), this.current, JcrContentHandler.this.uuidBehavior);
            } else if ("property".equals(localName)) {
                this.currentPropertyName = atts.getValue(SYSTEM_VIEW_NAME_DECODER.decode(this.svNameName));
                this.currentPropertyType = PropertyType.valueFromName((String)atts.getValue(this.svTypeName));
                String svMultiple = atts.getValue(this.svMultipleName);
                this.currentPropertyIsMultiValued = Boolean.TRUE.equals(Boolean.valueOf(svMultiple));
            } else if ("value".equals(localName)) {
                String xsiType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                this.currentPropertyValueIsBinary = "xs:base64Binary".equals(xsiType);
            } else if (!"value".equals(localName)) {
                throw new IllegalStateException("Unexpected element '" + name + "' in system view");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currentPropertyValue.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("node".equals(localName)) {
                this.current.finish();
                this.current = this.current.parentHandler();
            } else if ("value".equals(localName)) {
                String currentPropertyString = this.currentPropertyValue.toString();
                if (this.currentPropertyValueIsBinary) {
                    try {
                        currentPropertyString = JcrContentHandler.decodeBase64AsString(currentPropertyString);
                    }
                    catch (IOException ioe) {
                        throw new EnclosingSAXException((Exception)ioe);
                    }
                }
                this.current.addPropertyValue(JcrContentHandler.this.nameFor(this.currentPropertyName), currentPropertyString, this.currentPropertyIsMultiValued, this.currentPropertyType, SYSTEM_VIEW_NAME_DECODER);
            } else if (!"property".equals(localName)) {
                throw new IllegalStateException("Unexpected element '" + name + "' in system view");
            }
            this.currentPropertyValue = new StringBuilder();
        }
    }

    protected class StandardNodeHandlerFactory
    implements NodeHandlerFactory {
        protected StandardNodeHandlerFactory() {
        }

        @Override
        public NodeHandler createFor(Name name, NodeHandler parentHandler, int uuidBehavior) throws SAXException {
            if (parentHandler instanceof IgnoreBranchHandler || parentHandler.ignoreAllChildren()) {
                return new IgnoreBranchHandler(parentHandler);
            }
            if (JcrLexicon.ROOT.equals(name)) {
                try {
                    JcrRootNode rootNode = JcrContentHandler.this.session().getRootNode();
                    return new JcrRootHandler(rootNode);
                }
                catch (RepositoryException re) {
                    throw new EnclosingSAXException((Exception)((Object)re));
                }
            }
            if (JcrLexicon.SYSTEM.equals(name)) {
                return new JcrSystemHandler(parentHandler);
            }
            return new BasicNodeHandler(name, parentHandler, uuidBehavior);
        }
    }

    protected static interface NodeHandlerFactory {
        public NodeHandler createFor(Name var1, NodeHandler var2, int var3) throws SAXException;
    }

    protected class JcrSystemHandler
    extends IgnoreBranchHandler {
        protected JcrSystemHandler(NodeHandler parentHandler) {
            super(parentHandler);
        }
    }

    protected class IgnoreBranchHandler
    extends NodeHandler {
        private NodeHandler parentHandler;

        protected IgnoreBranchHandler(NodeHandler parentHandler) {
            this.parentHandler = parentHandler;
        }

        @Override
        public NodeHandler parentHandler() {
            return this.parentHandler;
        }
    }

    protected class JcrRootHandler
    extends ExistingNodeHandler {
        protected JcrRootHandler(AbstractJcrNode root) {
            super(root, null);
        }

        @Override
        public void addPropertyValue(Name propertyName, String value, boolean forceMultiValued, int propertyType, TextDecoder decoder) {
        }
    }

    protected class ExistingNodeHandler
    extends NodeHandler {
        private final AbstractJcrNode node;
        private final NodeHandler parentHandler;

        protected ExistingNodeHandler(AbstractJcrNode node, NodeHandler parentHandler) {
            this.node = node;
            this.parentHandler = parentHandler;
        }

        @Override
        public AbstractJcrNode node() {
            return this.node;
        }

        @Override
        public NodeHandler parentHandler() {
            return this.parentHandler;
        }

        @Override
        public void addPropertyValue(Name propertyName, String value, boolean forceMultiValued, int propertyType, TextDecoder decoder) {
            throw new UnsupportedOperationException();
        }
    }

    protected class BasicNodeHandler
    extends NodeHandler {
        private final Map<Name, List<Value>> properties;
        private final Set<Name> multiValuedPropertyNames;
        private final Name nodeName;
        private NodeHandler parentHandler;
        private AbstractJcrNode node;
        private final int uuidBehavior;
        private boolean postProcessed;
        private boolean ignoreAllChildren;

        protected BasicNodeHandler(Name name, NodeHandler parentHandler, int uuidBehavior) {
            this.postProcessed = false;
            this.ignoreAllChildren = false;
            this.nodeName = name;
            this.parentHandler = parentHandler;
            this.properties = new HashMap<Name, List<Value>>();
            this.multiValuedPropertyNames = new HashSet<Name>();
            this.uuidBehavior = uuidBehavior;
        }

        @Override
        public void finish() throws SAXException {
            this.node();
        }

        @Override
        public boolean ignoreAllChildren() {
            return this.ignoreAllChildren;
        }

        @Override
        protected String name() {
            return JcrContentHandler.this.stringFor(this.nodeName);
        }

        @Override
        public AbstractJcrNode node() throws SAXException {
            if (this.node == null) {
                this.create();
            }
            assert (this.node != null);
            return this.node;
        }

        @Override
        public NodeHandler parentHandler() {
            return this.parentHandler;
        }

        @Override
        public void addPropertyValue(Name name, String value, boolean forceMultiValued, int propertyType, TextDecoder decoder) throws EnclosingSAXException {
            if (forceMultiValued) {
                this.multiValuedPropertyNames.add(name);
            }
            try {
                if (this.node != null) {
                    if (JcrLexicon.PRIMARY_TYPE.equals(name)) {
                        return;
                    }
                    if (JcrLexicon.MIXIN_TYPES.equals(name)) {
                        return;
                    }
                    if (JcrLexicon.UUID.equals(name)) {
                        return;
                    }
                    this.node.setProperty(name, (JcrValue)JcrContentHandler.this.valueFor(value, propertyType), true, true);
                } else {
                    List<Value> values = this.properties.get(name);
                    if (values == null) {
                        values = new ArrayList<Value>();
                        this.properties.put(name, values);
                    }
                    if (propertyType == 2) {
                        byte[] binary = JcrContentHandler.decodeBase64(value);
                        ByteArrayInputStream is = new ByteArrayInputStream(binary);
                        values.add(JcrContentHandler.this.valueFor(is));
                    } else {
                        if (decoder != null) {
                            value = decoder.decode(value);
                        }
                        if (value != null && propertyType == 1) {
                            values.add(JcrContentHandler.this.valueFor(value, propertyType));
                        } else if (value != null && (propertyType == 9 || propertyType == 10)) {
                            try {
                                boolean isSystemReference;
                                boolean bl = isSystemReference = name.getNamespaceUri().equals("http://www.jcp.org/jcr/1.0") || name.getNamespaceUri().equals(ModeShapeLexicon.NAMESPACE.getNamespaceUri());
                                if (!isSystemReference) {
                                    value = this.parentHandler().node().key().withId(value).toString();
                                }
                                values.add(JcrContentHandler.this.valueFor(value, propertyType));
                            }
                            catch (SAXException e) {
                                throw new EnclosingSAXException((Exception)e);
                            }
                        } else if (value != null && value.length() > 0) {
                            values.add(JcrContentHandler.this.valueFor(value, propertyType));
                        }
                    }
                }
                if (!this.postProcessed && PROPERTIES_FOR_POST_PROCESSING.contains(name)) {
                    this.postProcessed = true;
                }
            }
            catch (IOException ioe) {
                throw new EnclosingSAXException((Exception)ioe);
            }
            catch (RepositoryException re) {
                throw new EnclosingSAXException((Exception)((Object)re));
            }
        }

        protected void create() throws SAXException {
            try {
                AbstractJcrNode child;
                boolean nodeAlreadyExists;
                AbstractJcrNode existingNode;
                AbstractJcrNode parent = this.parentHandler.node();
                NodeKey parentKey = parent.key();
                assert (parent != null);
                NodeKey key = null;
                List<Value> rawUuid = this.properties.get(JcrLexicon.UUID);
                boolean makeShareable = false;
                if (rawUuid != null) {
                    assert (rawUuid.size() == 1);
                    key = parentKey.withId(rawUuid.get(0).getString());
                    try {
                        existingNode = JcrContentHandler.this.session().node(key, null, parentKey);
                        switch (this.uuidBehavior) {
                            case 2: {
                                parent = existingNode.getParent();
                                existingNode.remove();
                                break;
                            }
                            case 0: {
                                key = JcrContentHandler.this.cache().getRootKey().withRandomId();
                                break;
                            }
                            case 1: {
                                if (existingNode.path().isAtOrAbove(parent.path())) {
                                    throw new ConstraintViolationException(JcrI18n.cannotRemoveParentNodeOfTarget.text(new Object[]{existingNode.getPath(), key, parent.getPath()}));
                                }
                                existingNode.remove();
                                break;
                            }
                            case 3: {
                                if (existingNode.isShareable()) {
                                    makeShareable = true;
                                    break;
                                }
                                throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{key, JcrContentHandler.this.session().workspace().getName(), existingNode.getPath()}));
                            }
                        }
                    }
                    catch (ItemNotFoundException e) {
                        // empty catch block
                    }
                }
                boolean bl = nodeAlreadyExists = (existingNode = parent.getNodeIfExists(this.nodeName)) != null && existingNode.getDefinition().isAutoCreated();
                if (!nodeAlreadyExists) {
                    List<Value> primaryTypeValueList = this.properties.get(JcrLexicon.PRIMARY_TYPE);
                    String typeName = primaryTypeValueList != null ? primaryTypeValueList.get(0).getString() : null;
                    Name name = JcrContentHandler.this.nameFor(typeName);
                    if ((makeShareable || JcrNtLexicon.SHARE.equals(name)) && key != null) {
                        parent.mutable().linkChild(JcrContentHandler.this.cache, key, this.nodeName);
                        this.node = JcrContentHandler.this.session().node(key, null, parentKey);
                        this.ignoreAllChildren = true;
                        return;
                    }
                    child = parent.addChildNode(this.nodeName, name, key);
                } else {
                    child = existingNode;
                }
                List<Value> mixinTypeValueList = this.properties.get(JcrLexicon.MIXIN_TYPES);
                if (mixinTypeValueList != null) {
                    for (Value value : mixinTypeValueList) {
                        child.addMixin(value.getString());
                    }
                }
                for (Map.Entry entry : this.properties.entrySet()) {
                    List values;
                    AbstractJcrProperty prop;
                    Name propertyName = (Name)entry.getKey();
                    if (JcrLexicon.PRIMARY_TYPE.equals(propertyName) || JcrLexicon.MIXIN_TYPES.equals(propertyName) || JcrLexicon.UUID.equals(propertyName) || (prop = (values = (List)entry.getValue()).size() == 1 && !this.multiValuedPropertyNames.contains(propertyName) ? child.setProperty(propertyName, (JcrValue)values.get(0), true, true) : child.setProperty(propertyName, values.toArray(new JcrValue[values.size()]), 0, true, true)).getType() != 9 || prop.getDefinition().getValueConstraints().length == 0 || prop.getDefinition().isProtected()) continue;
                    JcrContentHandler.this.refPropsRequiringConstraintValidation.add(prop);
                }
                this.node = child;
                if (this.postProcessed) {
                    JcrContentHandler.this.nodesForPostProcessing.add(this.node);
                }
            }
            catch (RepositoryException re) {
                throw new EnclosingSAXException((Exception)((Object)re));
            }
        }
    }

    protected abstract class NodeHandler {
        protected NodeHandler() {
        }

        public void finish() throws SAXException {
        }

        public AbstractJcrNode node() throws SAXException {
            return null;
        }

        public NodeHandler parentHandler() {
            return null;
        }

        public boolean ignoreAllChildren() {
            return false;
        }

        public void addPropertyValue(Name name, String value, boolean forceMultiValued, int propertyType, TextDecoder decoder) throws EnclosingSAXException {
        }

        protected String name() {
            try {
                Path path = this.node().path();
                return path.isRoot() ? "" : JcrContentHandler.this.stringFor(path.getLastSegment());
            }
            catch (Exception e) {
                throw new SystemFailureException((Throwable)e);
            }
        }

        public String toString() {
            NodeHandler parent = this.parentHandler();
            if (parent != null) {
                return parent.toString() + "/" + this.name();
            }
            try {
                return this.node().getPath();
            }
            catch (Throwable e) {
                try {
                    return this.node().toString();
                }
                catch (SAXException e2) {
                    throw new SystemFailureException((Throwable)e2);
                }
            }
        }
    }

    class EnclosingSAXException
    extends SAXException {
        private static final long serialVersionUID = -1044992767566435542L;

        EnclosingSAXException(Exception e) {
            super(e);
        }
    }
}

