/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.text.TextExtractor;
import org.modeshape.jcr.text.TextExtractorOutput;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;

@Immutable
public final class TextExtractors {
    private static final Logger LOGGER = Logger.getLogger(TextExtractors.class);
    private final List<TextExtractor> extractors = new ArrayList<TextExtractor>();
    private final Executor extractingQueue;
    private final ConcurrentHashMap<BinaryKey, CountDownLatch> workerLatches;
    private final boolean enabledFullTextSearch;

    public TextExtractors(JcrRepository.RunningState repository, RepositoryConfiguration.TextExtracting extracting) {
        this.extractingQueue = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(extracting.getThreadPoolName()));
        this.workerLatches = new ConcurrentHashMap();
        this.enabledFullTextSearch = repository.isFullTextSearchEnabled();
        this.initExtractors(repository, extracting);
    }

    private void initExtractors(JcrRepository.RunningState repository, RepositoryConfiguration.TextExtracting extracting) {
        List<RepositoryConfiguration.Component> extractors = extracting.getTextExtractors();
        for (RepositoryConfiguration.Component component : extractors) {
            try {
                TextExtractor extractor = (TextExtractor)component.createInstance(this.getClass().getClassLoader());
                extractor.setLogger(ExtensionLogger.getLogger(extractor.getClass()));
                this.extractors.add(extractor);
            }
            catch (Throwable t) {
                String desc = component.getName();
                String repoName = repository.name();
                LOGGER.error(t, (I18nResource)JcrI18n.unableToInitializeTextExtractor, new Object[]{desc, repoName, t.getMessage()});
            }
        }
    }

    public boolean extractionEnabled() {
        return this.enabledFullTextSearch && !this.extractors.isEmpty();
    }

    public String extract(InMemoryBinaryValue inMemoryBinaryValue, TextExtractor.Context context) {
        try {
            String mimeType = inMemoryBinaryValue.getMimeType();
            TextExtractorOutput output = new TextExtractorOutput();
            for (TextExtractor extractor : this.extractors) {
                if (!extractor.supportsMimeType(mimeType)) continue;
                extractor.extractFrom((Binary)inMemoryBinaryValue, (TextExtractor.Output)output, context);
                break;
            }
            String extractedText = output.getText();
            return extractedText;
        }
        catch (Exception e) {
            LOGGER.error((I18nResource)JcrI18n.errorExtractingTextFromBinary, new Object[]{inMemoryBinaryValue.getHexHash(), e.getLocalizedMessage()});
            return null;
        }
    }

    public void extract(BinaryStore store, BinaryValue binaryValue, TextExtractor.Context context) {
        if (!this.extractionEnabled()) {
            return;
        }
        if (binaryValue instanceof InMemoryBinaryValue) {
            return;
        }
        CheckArg.isNotNull((Object)binaryValue, (String)"binaryValue");
        CountDownLatch latch = this.getWorkerLatch(binaryValue.getKey(), true);
        this.extractingQueue.execute(new Worker(store, binaryValue, context, latch));
    }

    public CountDownLatch getWorkerLatch(BinaryKey binaryKey, boolean createIfMissing) {
        if (createIfMissing) {
            CountDownLatch latch = new CountDownLatch(1);
            CountDownLatch existingLatch = this.workerLatches.putIfAbsent(binaryKey, latch);
            return existingLatch != null ? existingLatch : latch;
        }
        return this.workerLatches.get(binaryKey);
    }

    protected final class Worker
    implements Runnable {
        private final BinaryValue binaryValue;
        private final TextExtractor.Context context;
        private final BinaryStore store;
        private final CountDownLatch latch;

        protected Worker(BinaryStore store, BinaryValue binaryValue, TextExtractor.Context context, CountDownLatch latch) {
            this.store = store;
            this.binaryValue = binaryValue;
            this.context = context;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String extractedText;
                if (this.store.getExtractedText(this.binaryValue) != null) {
                    return;
                }
                String mimeType = this.binaryValue.getMimeType();
                TextExtractorOutput output = new TextExtractorOutput();
                for (TextExtractor extractor : TextExtractors.this.extractors) {
                    if (!extractor.supportsMimeType(mimeType)) continue;
                    extractor.extractFrom((Binary)this.binaryValue, (TextExtractor.Output)output, this.context);
                    break;
                }
                if ((extractedText = output.getText()) != null && !StringUtil.isBlank((String)extractedText)) {
                    this.store.storeExtractedText(this.binaryValue, extractedText);
                }
            }
            catch (Exception e) {
                LOGGER.error((I18nResource)JcrI18n.errorExtractingTextFromBinary, new Object[]{this.binaryValue.getHexHash(), e.getLocalizedMessage()});
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

