/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.NodeNotFoundInParentException;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.PatternIterator;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@Immutable
public class LazyCachedNode
implements CachedNode {
    private final NodeKey key;
    private Document document;
    private Map<Name, Property> properties;
    private NodeKey parent;
    private Set<NodeKey> additionalParents;
    private ChildReference parentReferenceToSelf;
    private boolean propertiesFullyLoaded = false;
    private ChildReferences childReferences;

    public LazyCachedNode(NodeKey key) {
        this.key = key;
    }

    public LazyCachedNode(NodeKey key, Document document) {
        this.key = key;
        this.document = document;
    }

    protected final WorkspaceCache workspaceCache(NodeCache cache) {
        return ((DocumentCache)cache).workspaceCache();
    }

    protected Document document(WorkspaceCache cache) {
        if (this.document == null) {
            this.document = cache.documentFor(this.key);
            if (this.document == null) {
                throw new NodeNotFoundException(this.key);
            }
        }
        return this.document;
    }

    @Override
    public NodeKey getParentKey(NodeCache cache) {
        if (this.parent == null) {
            WorkspaceCache wsCache = this.workspaceCache(cache);
            this.parent = wsCache.translator().getParentKey(this.document(wsCache), wsCache.getWorkspaceKey(), this.key.getWorkspaceKey());
        }
        return this.parent;
    }

    @Override
    public NodeKey getParentKeyInAnyWorkspace(NodeCache cache) {
        WorkspaceCache wsCache = this.workspaceCache(cache);
        return wsCache.translator().getParentKey(this.document(wsCache), this.key.getWorkspaceKey(), this.key.getWorkspaceKey());
    }

    @Override
    public Set<NodeKey> getAdditionalParentKeys(NodeCache cache) {
        if (this.additionalParents == null) {
            WorkspaceCache wsCache = this.workspaceCache(cache);
            Set<NodeKey> additionalParents = wsCache.translator().getParentKeys(this.document(wsCache), wsCache.getWorkspaceKey(), this.key.getWorkspaceKey());
            this.additionalParents = additionalParents.isEmpty() ? additionalParents : Collections.unmodifiableSet(additionalParents);
        }
        return this.additionalParents;
    }

    @Override
    public boolean isAtOrBelow(NodeCache cache, Path path) {
        Path aPath = this.getPath(cache);
        if (path.isAtOrAbove(aPath)) {
            return true;
        }
        Set<NodeKey> additionalParents = this.getAdditionalParentKeys(cache);
        if (!additionalParents.isEmpty()) {
            Path parentOfPath = path.getParent();
            for (NodeKey parentKey : additionalParents) {
                ChildReference ref;
                CachedNode parent = cache.getNode(parentKey);
                if (!parent.getPath(cache).isAtOrBelow(parentOfPath) || (ref = parent.getChildReferences(cache).getChild(this.key)) == null || !ref.getSegment().equals(path.getLastSegment())) continue;
                return true;
            }
        }
        return false;
    }

    protected CachedNode parent(WorkspaceCache cache) {
        NodeKey parentKey = this.getParentKey(cache);
        if (parentKey == null) {
            return null;
        }
        CachedNode parent = cache.getNode(parentKey);
        if (parent == null) {
            throw new NodeNotFoundException(parentKey);
        }
        return parent;
    }

    protected ChildReference parentReferenceToSelf(WorkspaceCache cache) {
        if (this.parentReferenceToSelf == null) {
            CachedNode parent = this.parent(cache);
            this.parentReferenceToSelf = parent == null ? cache.childReferenceForRoot() : parent.getChildReferences(cache).getChild(this.key);
        }
        if (this.parentReferenceToSelf == null) {
            throw new NodeNotFoundInParentException(this.key, this.getParentKey(cache));
        }
        return this.parentReferenceToSelf;
    }

    protected Map<Name, Property> properties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<Name, Property>();
        }
        return this.properties;
    }

    @Override
    public NodeKey getKey() {
        return this.key;
    }

    @Override
    public Name getName(NodeCache cache) {
        return this.parentReferenceToSelf(this.workspaceCache(cache)).getName();
    }

    @Override
    public Path.Segment getSegment(NodeCache cache) {
        return this.parentReferenceToSelf(this.workspaceCache(cache)).getSegment();
    }

    protected Path.Segment getSegment(WorkspaceCache cache) {
        return this.parentReferenceToSelf(cache).getSegment();
    }

    @Override
    public Path getPath(NodeCache cache) {
        WorkspaceCache wsCache = this.workspaceCache(cache);
        CachedNode parent = this.parent(wsCache);
        if (parent != null) {
            Path parentPath = parent.getPath(wsCache);
            return wsCache.pathFactory().create(parentPath, this.getSegment(wsCache));
        }
        if (wsCache.getNode(this.key) == null) {
            throw new NodeNotFoundException(this.key);
        }
        return wsCache.rootPath();
    }

    @Override
    public Name getPrimaryType(NodeCache cache) {
        Property prop = this.getProperty(JcrLexicon.PRIMARY_TYPE, cache);
        WorkspaceCache wsCache = this.workspaceCache(cache);
        return (Name)wsCache.nameFactory().create(prop.getFirstValue());
    }

    @Override
    public Set<Name> getMixinTypes(NodeCache cache) {
        Property prop = this.getProperty(JcrLexicon.MIXIN_TYPES, cache);
        if (prop == null || prop.size() == 0) {
            return Collections.emptySet();
        }
        NameFactory nameFactory = this.workspaceCache(cache).nameFactory();
        if (prop.size() == 1) {
            Name name = (Name)nameFactory.create(prop.getFirstValue());
            return Collections.singleton(name);
        }
        HashSet<Name> names = new HashSet<Name>();
        for (Object value : prop) {
            Name name = (Name)nameFactory.create(value);
            names.add(name);
        }
        return names;
    }

    @Override
    public int getPropertyCount(NodeCache cache) {
        if (this.propertiesFullyLoaded) {
            return this.properties().size();
        }
        WorkspaceCache wsCache = this.workspaceCache(cache);
        return wsCache.translator().countProperties(this.document(wsCache));
    }

    @Override
    public boolean hasProperties(NodeCache cache) {
        Map<Name, Property> props = this.properties();
        if (!props.isEmpty()) {
            return true;
        }
        if (this.propertiesFullyLoaded) {
            return false;
        }
        WorkspaceCache wsCache = this.workspaceCache(cache);
        return wsCache.translator().hasProperties(this.document(wsCache));
    }

    @Override
    public boolean hasProperty(Name name, NodeCache cache) {
        Map<Name, Property> props = this.properties();
        if (props.containsKey(name)) {
            return true;
        }
        if (this.propertiesFullyLoaded) {
            return false;
        }
        WorkspaceCache wsCache = this.workspaceCache(cache);
        return wsCache.translator().hasProperty(this.document(wsCache), name);
    }

    @Override
    public Property getProperty(Name name, NodeCache cache) {
        WorkspaceCache wsCache;
        Map<Name, Property> props = this.properties();
        Property property = props.get(name);
        if (property == null && !this.propertiesFullyLoaded && (property = (wsCache = this.workspaceCache(cache)).translator().getProperty(this.document(wsCache), name)) != null) {
            props.put(name, property);
        }
        return property;
    }

    @Override
    public Iterator<Property> getProperties(NodeCache cache) {
        if (!this.propertiesFullyLoaded) {
            WorkspaceCache wsCache = this.workspaceCache(cache);
            wsCache.translator().getProperties(this.document(wsCache), this.properties());
            this.propertiesFullyLoaded = true;
        }
        return this.properties().values().iterator();
    }

    @Override
    public Iterator<Property> getProperties(Collection<?> namePatterns, NodeCache cache) {
        WorkspaceCache wsCache = this.workspaceCache(cache);
        final NamespaceRegistry registry = wsCache.context().getNamespaceRegistry();
        return new PatternIterator<Property>(this.getProperties(wsCache), namePatterns){

            @Override
            protected String matchable(Property value) {
                return value.getName().getString(registry);
            }
        };
    }

    @Override
    public ChildReferences getChildReferences(NodeCache cache) {
        if (this.childReferences == null) {
            WorkspaceCache wsCache = this.workspaceCache(cache);
            this.childReferences = wsCache.translator().getChildReferences(wsCache, this.document(wsCache));
        }
        return this.childReferences;
    }

    @Override
    public Set<NodeKey> getReferrers(NodeCache cache, CachedNode.ReferenceType type) {
        WorkspaceCache wsCache = this.workspaceCache(cache);
        return wsCache.translator().getReferrers(this.document(wsCache), type);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedNode) {
            CachedNode that = (CachedNode)obj;
            return this.getKey().equals(that.getKey());
        }
        return false;
    }

    public String toString() {
        return this.getString(null);
    }

    public String getString(NamespaceRegistry registry) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node ").append(this.key).append(": ");
        if (this.document != null) {
            sb.append(this.document);
        } else {
            sb.append(" <unloaded>");
        }
        return sb.toString();
    }
}

