/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class HasValueQuery
extends Query {
    private static final long serialVersionUID = 1L;
    protected final String fieldName;
    protected final FieldSelector fieldSelector;

    public HasValueQuery(String fieldName) {
        this.fieldName = fieldName;
        this.fieldSelector = new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                return HasValueQuery.this.fieldName.equals(fieldName) ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };
    }

    public Object clone() {
        return new HasValueQuery(this.fieldName);
    }

    public Weight createWeight(Searcher searcher) {
        return new ExistsWeight();
    }

    public String toString(String field) {
        return this.fieldName + " exists";
    }

    protected boolean hasValue(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String valueString = doc.get(this.fieldName);
        return valueString != null;
    }

    protected class ExistsScorer
    extends Scorer {
        private int docId;
        private final int pastMaxDocId;
        private final IndexReader reader;

        protected ExistsScorer(IndexReader reader, Weight weight) {
            super(weight);
            this.docId = -1;
            this.reader = reader;
            assert (this.reader != null);
            this.pastMaxDocId = this.reader.maxDoc();
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            do {
                ++this.docId;
                if (this.docId != this.pastMaxDocId) continue;
                return Integer.MAX_VALUE;
            } while (this.reader.isDeleted(this.docId) || !HasValueQuery.this.hasValue(this.reader, this.docId));
            return this.docId;
        }

        public int advance(int target) throws IOException {
            int doc;
            if (target == Integer.MAX_VALUE) {
                return target;
            }
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public float score() {
            return 1.0f;
        }
    }

    protected class ExistsWeight
    extends Weight {
        private static final long serialVersionUID = 1L;

        protected ExistsWeight() {
        }

        public Query getQuery() {
            return HasValueQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            return new ExistsScorer(reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) {
            return new Explanation(this.getValue(), this.getQuery().toString());
        }
    }
}

