/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Metadata
implements Externalizable {
    protected long length;
    protected int numberChunks;
    protected long modificationTime;
    protected long unusedSince;
    protected String mimeType;
    protected int numberTextChunks;

    public Metadata() {
    }

    public Metadata(Metadata metadata) {
        this.length = metadata.length;
        this.numberChunks = metadata.numberChunks;
        this.modificationTime = metadata.modificationTime;
        this.unusedSince = metadata.unusedSince;
        this.mimeType = metadata.mimeType;
        this.numberTextChunks = metadata.numberTextChunks;
    }

    public Metadata copy() {
        return new Metadata(this);
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getNumberTextChunks() {
        return this.numberTextChunks;
    }

    public void setNumberTextChunks(int numberTextChunks) {
        this.numberTextChunks = numberTextChunks;
    }

    public int getNumberChunks() {
        return this.numberChunks;
    }

    public void setNumberChunks(int numberChunks) {
        this.numberChunks = numberChunks;
    }

    public boolean isUnused() {
        return this.unusedSince > 0L;
    }

    public long unusedSince() {
        return this.unusedSince;
    }

    public void setUnused() {
        this.unusedSince = System.currentTimeMillis();
    }

    public void setUsed() {
        this.unusedSince = 0L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeLong(this.length);
        out.writeInt(this.numberChunks);
        out.writeLong(this.modificationTime);
        out.writeLong(this.unusedSince);
        out.writeInt(this.numberTextChunks);
        if (this.mimeType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.mimeType);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        in.readShort();
        this.length = in.readLong();
        this.numberChunks = in.readInt();
        this.modificationTime = in.readLong();
        this.unusedSince = in.readLong();
        this.numberTextChunks = in.readInt();
        if (in.readBoolean()) {
            this.mimeType = in.readUTF();
        }
    }
}

