/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryWrappingInterceptor
extends CommandInterceptor {
    private EntryFactory entryFactory;
    protected DataContainer dataContainer;
    protected ClusteringDependentLogic cll;
    protected final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(EntryFactory entryFactory, DataContainer dataContainer, ClusteringDependentLogic cll) {
        this.entryFactory = entryFactory;
        this.dataContainer = dataContainer;
        this.cll = cll;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            for (WriteCommand c : command.getModifications()) {
                c.acceptVisitor(ctx, this.entryWrappingVisitor);
            }
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.commitContextEntries(ctx);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.commitContextEntries(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.commitContextEntries(ctx);
            }
        }
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForReplace(ctx, key);
            }
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        for (InternalCacheEntry entry : this.dataContainer.entrySet()) {
            this.entryFactory.wrapEntryForClear(ctx, entry.getKey());
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForReplace(ctx, key);
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public final Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, !command.isPutIfAbsent());
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        this.entryFactory.wrapEntryForDelta(ctx, command.getDeltaAwareKey(), command.getDelta());
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public final Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.entryFactory.wrapEntryForRemove(ctx, command.getKey());
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public final Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.entryFactory.wrapEntryForReplace(ctx, command.getKey());
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object key : command.getMap().keySet()) {
            this.entryFactory.wrapEntryForPut(ctx, key, null, true);
        }
        return this.invokeNextAndApplyChanges(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.visitRemoveCommand(ctx, command);
    }

    protected void commitContextEntries(InvocationContext ctx) {
        boolean trace = log.isTraceEnabled();
        boolean skipOwnershipCheck = ctx.hasFlag(Flag.SKIP_OWNERSHIP_CHECK);
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            CacheEntry entry = ((SingleKeyNonTxInvocationContext)ctx).getCacheEntry();
            this.commitEntryIfNeeded(ctx, skipOwnershipCheck, entry);
        } else {
            Set<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.iterator();
            Log log = this.getLog();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (this.commitEntryIfNeeded(ctx, skipOwnershipCheck, entry) || !trace) continue;
                if (entry == null) {
                    log.tracef("Entry for key %s is null : not calling commitUpdate", e.getKey());
                    continue;
                }
                log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", e.getKey(), entry);
            }
        }
    }

    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, boolean skipOwnershipCheck) {
        this.cll.commitEntry(entry, null, skipOwnershipCheck);
    }

    private Object invokeNextAndApplyChanges(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isInTxScope()) {
            this.commitContextEntries(ctx);
        }
        return result;
    }

    private boolean commitEntryIfNeeded(InvocationContext ctx, boolean skipOwnershipCheck, CacheEntry entry) {
        if (entry != null && entry.isChanged()) {
            this.commitContextEntry(entry, ctx, skipOwnershipCheck);
            log.tracef("Committed entry %s", entry);
            return true;
        }
        return false;
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            boolean notWrapped = false;
            for (Object key : EntryWrappingInterceptor.this.dataContainer.keySet()) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForClear(ctx, key);
                notWrapped = true;
            }
            if (notWrapped) {
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            boolean notWrapped = false;
            for (Object key : command.getMap().keySet()) {
                if (!EntryWrappingInterceptor.this.cll.localNodeIsOwner(key)) continue;
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, key, null, true);
                notWrapped = true;
            }
            if (notWrapped) {
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cll.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForRemove(ctx, command.getKey());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cll.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, !command.isPutIfAbsent());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cll.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForDelta(ctx, command.getDeltaAwareKey(), command.getDelta());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cll.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForReplace(ctx, command.getKey());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }
    }
}

