/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.cache.NodeKey;

class JcrNodeIterator
implements NodeIterator {
    private final long size;
    private final Iterator<NodeKey> keyIter;
    private final JcrSession session;
    private final AbstractJcrNode.Type expectedType;
    private Node nextNode;
    private long position = 0L;

    protected JcrNodeIterator(JcrSession session, Iterator<NodeKey> iter, long size, AbstractJcrNode.Type expectedType) {
        this.session = session;
        this.keyIter = iter;
        this.size = size;
        this.expectedType = expectedType;
        assert (session != null);
        assert (session != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node nextNode() {
        if (this.hasNext()) {
            assert (this.nextNode != null);
            try {
                ++this.position;
                Node node = this.nextNode;
                return node;
            }
            finally {
                this.nextNode = null;
            }
        }
        throw new NoSuchElementException();
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long skipNum) {
        CheckArg.isNonNegative((long)skipNum, (String)"skipNum");
        if (skipNum == 0L) {
            return;
        }
        for (long i = 0L; i != skipNum; ++i) {
            if (!this.hasNext()) {
                return;
            }
            this.next();
        }
    }

    public boolean hasNext() {
        while (this.nextNode == null && this.keyIter.hasNext()) {
            NodeKey key = this.keyIter.next();
            try {
                this.nextNode = this.session.node(key, this.expectedType);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        return this.nextNode != null;
    }

    public Object next() {
        return this.nextNode();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

