/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
class JcrNodeDefinition
extends JcrItemDefinition
implements NodeDefinition {
    private final boolean allowsSameNameSiblings;
    private final Name defaultPrimaryTypeName;
    private final Name[] requiredPrimaryTypeNames;
    private final Set<Name> requiredPrimaryTypeNameSet;
    private final NodeDefinitionId id;
    private final NodeKey key;
    private final RepositoryNodeTypeManager nodeTypeManager;

    JcrNodeDefinition(ExecutionContext context, JcrNodeType declaringNodeType, NodeKey prototypeKey, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, boolean allowsSameNameSiblings, Name defaultPrimaryTypeName, Name[] requiredPrimaryTypeNames) {
        this(context, null, declaringNodeType, prototypeKey, name, onParentVersion, autoCreated, mandatory, protectedItem, allowsSameNameSiblings, defaultPrimaryTypeName, requiredPrimaryTypeNames);
    }

    JcrNodeDefinition(ExecutionContext context, RepositoryNodeTypeManager nodeTypeManager, JcrNodeType declaringNodeType, NodeKey prototypeKey, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, boolean allowsSameNameSiblings, Name defaultPrimaryTypeName, Name[] requiredPrimaryTypeNames) {
        super(context, declaringNodeType, name, onParentVersion, autoCreated, mandatory, protectedItem);
        this.nodeTypeManager = nodeTypeManager;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
        this.defaultPrimaryTypeName = defaultPrimaryTypeName;
        this.requiredPrimaryTypeNames = requiredPrimaryTypeNames;
        this.id = this.declaringNodeType == null ? null : new NodeDefinitionId(this.declaringNodeType.getInternalName(), this.name, this.requiredPrimaryTypeNames);
        this.key = this.id == null ? prototypeKey : prototypeKey.withId("/jcr:system/jcr:nodeTypes/" + this.id.getString());
        HashSet<Name> requiredPrimaryTypeNameSet = new HashSet<Name>();
        for (Name requiredTypeName : this.requiredPrimaryTypeNames) {
            requiredPrimaryTypeNameSet.add(requiredTypeName);
        }
        this.requiredPrimaryTypeNameSet = Collections.unmodifiableSet(requiredPrimaryTypeNameSet);
    }

    private final String string(Name name) {
        if (name == null) {
            return null;
        }
        if (this.context == null) {
            return name.getString();
        }
        return name.getString(this.context.getNamespaceRegistry());
    }

    @Override
    final NodeKey key() {
        return this.key;
    }

    public NodeDefinitionId getId() {
        return this.id;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    final Name defaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }

    public JcrNodeType getDefaultPrimaryType() {
        if (this.defaultPrimaryTypeName == null) {
            return null;
        }
        return this.nodeTypeManager.getNodeTypes().getNodeType(this.defaultPrimaryTypeName);
    }

    public NodeType[] getRequiredPrimaryTypes() {
        if (this.requiredPrimaryTypeNames.length == 0) {
            NodeType[] result = new NodeType[]{this.nodeTypeManager.getNodeTypes().getNodeType(JcrNtLexicon.BASE)};
            return result;
        }
        NodeType[] result = new NodeType[this.requiredPrimaryTypeNames.length];
        int i = 0;
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.nodeTypeManager.getNodeTypes();
        for (Name name : this.requiredPrimaryTypeNames) {
            result[i++] = nodeTypes.getNodeType(name);
        }
        return result;
    }

    Name[] requiredPrimaryTypeNames() {
        return this.requiredPrimaryTypeNames;
    }

    Set<Name> requiredPrimaryTypeNameSet() {
        return this.requiredPrimaryTypeNameSet;
    }

    public String[] getRequiredPrimaryTypeNames() {
        if (this.requiredPrimaryTypeNames == null) {
            return new String[0];
        }
        String[] rptNames = new String[this.requiredPrimaryTypeNames.length];
        for (int i = 0; i < this.requiredPrimaryTypeNames.length; ++i) {
            rptNames[i] = this.string(this.requiredPrimaryTypeNames[i]);
        }
        return rptNames;
    }

    public String getDefaultPrimaryTypeName() {
        return this.string(this.defaultPrimaryTypeName);
    }

    final boolean allowsChildWithType(JcrNodeType childPrimaryType) {
        if (childPrimaryType == null) {
            return this.defaultPrimaryTypeName != null;
        }
        for (Name requiredPrimaryTypeName : this.requiredPrimaryTypeNameSet) {
            if (childPrimaryType.isNodeType(requiredPrimaryTypeName)) continue;
            return false;
        }
        return true;
    }

    JcrNodeDefinition with(JcrNodeType declaringNodeType) {
        return new JcrNodeDefinition(this.context, declaringNodeType.nodeTypeManager(), declaringNodeType, this.key(), this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    JcrNodeDefinition with(ExecutionContext context) {
        return new JcrNodeDefinition(context, this.nodeTypeManager, this.declaringNodeType, this.key(), this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    JcrNodeDefinition with(RepositoryNodeTypeManager nodeTypeManager) {
        return new JcrNodeDefinition(this.context, nodeTypeManager, this.declaringNodeType, this.key(), this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    public int hashCode() {
        return this.getId().toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JcrNodeDefinition other = (JcrNodeDefinition)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        ValueFactory<String> strings = this.context.getValueFactories().getStringFactory();
        StringBuilder sb = new StringBuilder();
        NodeDefinitionId id = this.getId();
        sb.append(strings.create(id.getNodeTypeName()));
        sb.append('/');
        sb.append(strings.create(id.getChildDefinitionName()));
        if (id.hasRequiredPrimaryTypes()) {
            sb.append(" (required primary types = [");
            boolean first = true;
            for (Name requiredPrimaryType : id.getRequiredPrimaryTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(requiredPrimaryType.getString());
            }
            sb.append("])");
        }
        return sb.toString();
    }
}

