/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.JodaDateTime;

@Immutable
class JcrPropertyDefinition
extends JcrItemDefinition
implements PropertyDefinition {
    protected static final Map<String, Operator> OPERATORS_BY_JCR_NAME;
    private final Object[] rawDefaultValues;
    private final JcrValue[] defaultValues;
    private final int requiredType;
    private final String[] valueConstraints;
    private final boolean multiple;
    private final boolean fullTextSearchable;
    private final boolean queryOrderable;
    private final String[] queryOperators;
    private final NodeKey key;
    private final PropertyDefinitionId id;
    private ConstraintChecker checker = null;

    static Operator operatorFromSymbol(String jcrConstantValue) {
        Operator op = OPERATORS_BY_JCR_NAME.get(jcrConstantValue);
        if (op == null) {
            op = Operator.forSymbol((String)jcrConstantValue);
        }
        assert (op != null);
        return op;
    }

    JcrPropertyDefinition(ExecutionContext context, JcrNodeType declaringNodeType, NodeKey prototypeKey, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, JcrValue[] defaultValues, int requiredType, String[] valueConstraints, boolean multiple, boolean fullTextSearchable, boolean queryOrderable, String[] queryOperators) {
        super(context, declaringNodeType, name, onParentVersion, autoCreated, mandatory, protectedItem);
        String[] stringArray;
        this.defaultValues = defaultValues;
        this.requiredType = requiredType;
        this.valueConstraints = valueConstraints;
        this.multiple = multiple;
        this.fullTextSearchable = fullTextSearchable;
        this.queryOrderable = queryOrderable;
        if (queryOperators != null) {
            stringArray = queryOperators;
        } else {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "jcr.operator.equal.to";
            stringArray2[1] = "jcr.operator.greater.than";
            stringArray2[2] = "jcr.operator.greater.than.or.equal.to";
            stringArray2[3] = "jcr.operator.less.than";
            stringArray2[4] = "jcr.operator.less.than.or.equal.to";
            stringArray2[5] = "jcr.operator.like";
            stringArray = stringArray2;
            stringArray2[6] = "jcr.operator.not.equal.to";
        }
        this.queryOperators = stringArray;
        assert (this.valueConstraints != null);
        this.id = this.declaringNodeType == null ? null : new PropertyDefinitionId(this.declaringNodeType.getInternalName(), this.name, this.requiredType, this.multiple);
        NodeKey nodeKey = this.key = this.id == null ? prototypeKey : prototypeKey.withId("/jcr:system/jcr:nodeTypes/" + this.id.getString());
        if (this.defaultValues != null) {
            this.rawDefaultValues = new Object[this.defaultValues.length];
            int i = 0;
            for (JcrValue defaultValue : this.defaultValues) {
                this.rawDefaultValues[i++] = defaultValue.value();
            }
        } else {
            this.rawDefaultValues = null;
        }
    }

    public PropertyDefinitionId getId() {
        return this.id;
    }

    @Override
    final NodeKey key() {
        return this.key;
    }

    public JcrValue[] getDefaultValues() {
        return this.defaultValues;
    }

    Object[] getRawDefaultValues() {
        return this.rawDefaultValues;
    }

    public boolean hasDefaultValues() {
        return this.defaultValues != null;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    public String[] getAvailableQueryOperators() {
        return this.queryOperators;
    }

    JcrPropertyDefinition with(JcrNodeType declaringNodeType) {
        return new JcrPropertyDefinition(this.context, declaringNodeType, this.key(), this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.getDefaultValues(), this.getRequiredType(), this.getValueConstraints(), this.isMultiple(), this.isFullTextSearchable(), this.isQueryOrderable(), this.getAvailableQueryOperators());
    }

    JcrPropertyDefinition with(ExecutionContext context) {
        return new JcrPropertyDefinition(context, this.declaringNodeType, this.key(), this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.getDefaultValues(), this.getRequiredType(), this.getValueConstraints(), this.isMultiple(), this.isFullTextSearchable(), this.isQueryOrderable(), this.getAvailableQueryOperators());
    }

    public String toString() {
        ValueFactory<String> strings = this.context.getValueFactories().getStringFactory();
        StringBuilder sb = new StringBuilder();
        PropertyDefinitionId id = this.getId();
        sb.append(strings.create(id.getNodeTypeName()));
        sb.append('/');
        sb.append(strings.create(id.getPropertyDefinitionName()));
        sb.append('/');
        sb.append(PropertyType.nameFromValue((int)id.getPropertyType()));
        sb.append(id.allowsMultiple() ? (char)'*' : '1');
        return sb.toString();
    }

    boolean satisfiesConstraints(Value value, JcrSession session) {
        if (value == null) {
            return false;
        }
        if (this.valueConstraints == null || this.valueConstraints.length == 0) {
            return true;
        }
        int type = this.requiredType == 0 ? value.getType() : this.requiredType;
        ConstraintChecker checker = this.checker;
        if (checker == null || checker.getType() != type) {
            this.checker = checker = this.createChecker(this.context, type, this.valueConstraints);
        }
        try {
            return checker.matches(value, session);
        }
        catch (ValueFormatException vfe) {
            return false;
        }
    }

    boolean satisfiesConstraints(Value[] values, JcrSession session) {
        if (this.valueConstraints == null || this.valueConstraints.length == 0) {
            if (this.requiredType != 0) {
                for (Value value : values) {
                    if (value.getType() == this.requiredType) continue;
                    return false;
                }
            }
            return true;
        }
        if (values == null || values.length == 0) {
            return this.isMultiple();
        }
        int type = this.requiredType == 0 ? values[0].getType() : this.requiredType;
        ConstraintChecker checker = this.checker;
        if (checker == null || checker.getType() != type) {
            this.checker = checker = this.createChecker(this.context, type, this.valueConstraints);
        }
        try {
            for (Value value : values) {
                if (this.requiredType != 0 && value.getType() != this.requiredType) {
                    return false;
                }
                if (checker.matches(value, session)) continue;
                return false;
            }
            return true;
        }
        catch (ValueFormatException vfe) {
            return false;
        }
    }

    Object getMinimumValue() {
        if (this.requiredType == 5 || this.requiredType == 4 || this.requiredType == 3 || this.requiredType == 12) {
            ConstraintChecker checker = this.checker;
            if (checker == null || checker.getType() != this.requiredType) {
                this.checker = checker = this.createChecker(this.context, this.requiredType, this.valueConstraints);
            }
            assert (checker instanceof RangeConstraintChecker);
            RangeConstraintChecker rangeChecker = (RangeConstraintChecker)checker;
            return rangeChecker.getMinimum();
        }
        return null;
    }

    Object getMaximumValue() {
        if (this.requiredType == 5 || this.requiredType == 4 || this.requiredType == 3 || this.requiredType == 12) {
            ConstraintChecker checker = this.checker;
            if (checker == null || checker.getType() != this.requiredType) {
                this.checker = checker = this.createChecker(this.context, this.requiredType, this.valueConstraints);
            }
            assert (checker instanceof RangeConstraintChecker);
            RangeConstraintChecker rangeChecker = (RangeConstraintChecker)checker;
            return rangeChecker.getMaximum();
        }
        return null;
    }

    boolean canCastToType(Value value) {
        try {
            assert (value instanceof JcrValue) : "Illegal implementation of Value interface";
            ((JcrValue)value).asType(this.getRequiredType());
            return true;
        }
        catch (javax.jcr.ValueFormatException vfe) {
            return false;
        }
    }

    boolean canCastToType(Value[] values) {
        for (Value value : values) {
            if (this.canCastToType(value)) continue;
            return false;
        }
        return true;
    }

    boolean canCastToTypeAndSatisfyConstraints(Value value, JcrSession session) {
        try {
            assert (value instanceof JcrValue) : "Illegal implementation of Value interface";
            ((JcrValue)value).asType(this.getRequiredType());
            return this.satisfiesConstraints(value, session);
        }
        catch (javax.jcr.ValueFormatException vfe) {
            return false;
        }
    }

    boolean canCastToTypeAndSatisfyConstraints(Value[] values, JcrSession session) {
        for (Value value : values) {
            if (this.canCastToTypeAndSatisfyConstraints(value, session)) continue;
            return false;
        }
        return true;
    }

    private ConstraintChecker createChecker(ExecutionContext context, int type, String[] valueConstraints) {
        switch (type) {
            case 2: {
                return new BinaryConstraintChecker(valueConstraints, context);
            }
            case 5: {
                return new DateTimeConstraintChecker(valueConstraints, context);
            }
            case 4: {
                return new DoubleConstraintChecker(valueConstraints, context);
            }
            case 3: {
                return new LongConstraintChecker(valueConstraints, context);
            }
            case 7: {
                return new NameConstraintChecker(valueConstraints, context);
            }
            case 8: {
                return new PathConstraintChecker(valueConstraints, context);
            }
            case 9: 
            case 10: {
                return new ReferenceConstraintChecker(valueConstraints, context);
            }
            case 1: {
                return new StringConstraintChecker(valueConstraints, context);
            }
            case 12: {
                return new DecimalConstraintChecker(valueConstraints, context);
            }
        }
        throw new IllegalStateException("Invalid property type: " + type);
    }

    public int hashCode() {
        return this.getId().toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JcrPropertyDefinition other = (JcrPropertyDefinition)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    static {
        HashMap<String, Operator> map = new HashMap<String, Operator>();
        map.put("jcr.operator.equal.to", Operator.EQUAL_TO);
        map.put("jcr.operator.greater.than", Operator.GREATER_THAN);
        map.put("jcr.operator.greater.than.or.equal.to", Operator.GREATER_THAN_OR_EQUAL_TO);
        map.put("jcr.operator.less.than", Operator.LESS_THAN);
        map.put("jcr.operator.less.than.or.equal.to", Operator.LESS_THAN_OR_EQUAL_TO);
        map.put("jcr.operator.like", Operator.LIKE);
        map.put("jcr.operator.not.equal.to", Operator.NOT_EQUAL_TO);
        OPERATORS_BY_JCR_NAME = Collections.unmodifiableMap(map);
    }

    @Immutable
    private static class PathConstraintChecker
    implements ConstraintChecker {
        private final ExecutionContext context;
        private final String[] constraints;

        protected PathConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            this.constraints = valueConstraints;
            this.context = context;
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public boolean matches(Value valueToMatch, JcrSession session) {
            assert (valueToMatch instanceof JcrValue);
            if (session == null) {
                return false;
            }
            PathFactory repoPathFactory = this.context.getValueFactories().getPathFactory();
            PathFactory sessionPathFactory = session.pathFactory();
            Path value = (Path)sessionPathFactory.create(((JcrValue)valueToMatch).value());
            value = value.getNormalizedPath();
            for (int i = 0; i < this.constraints.length; ++i) {
                boolean matchesDescendants = this.constraints[i].endsWith("*");
                String pathStr = this.constraints[i];
                if (matchesDescendants) {
                    pathStr = pathStr.substring(0, pathStr.length() - 2);
                }
                Path constraintPath = (Path)repoPathFactory.create(pathStr);
                if (matchesDescendants && value.isDescendantOf(constraintPath)) {
                    return true;
                }
                if (matchesDescendants || !value.equals(constraintPath)) continue;
                return true;
            }
            return false;
        }
    }

    @Immutable
    private static class StringConstraintChecker
    implements ConstraintChecker {
        private final Pattern[] constraints;
        private ValueFactory<String> valueFactory;

        protected StringConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            this.constraints = new Pattern[valueConstraints.length];
            this.valueFactory = context.getValueFactories().getStringFactory();
            for (int i = 0; i < valueConstraints.length; ++i) {
                this.constraints[i] = Pattern.compile(valueConstraints[i]);
            }
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean matches(Value value, JcrSession session) {
            assert (value != null);
            String convertedValue = this.valueFactory.create(((JcrValue)value).value());
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].matcher(convertedValue).matches()) continue;
                return true;
            }
            return false;
        }
    }

    @Immutable
    private static class NameConstraintChecker
    implements ConstraintChecker {
        private final Name[] constraints;
        private final ValueFactory<Name> valueFactory;

        protected NameConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            this.valueFactory = context.getValueFactories().getNameFactory();
            this.constraints = new Name[valueConstraints.length];
            for (int i = 0; i < valueConstraints.length; ++i) {
                this.constraints[i] = this.valueFactory.create(valueConstraints[i]);
            }
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public boolean matches(Value value, JcrSession session) {
            assert (value instanceof JcrValue);
            JcrValue jcrValue = (JcrValue)value;
            Name name = this.valueFactory.create(jcrValue.value());
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    @Immutable
    private static class ReferenceConstraintChecker
    implements ConstraintChecker {
        private final Name[] constraints;

        protected ReferenceConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            NameFactory factory = context.getValueFactories().getNameFactory();
            this.constraints = new Name[valueConstraints.length];
            for (int i = 0; i < valueConstraints.length; ++i) {
                this.constraints[i] = (Name)factory.create(valueConstraints[i]);
            }
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public boolean matches(Value value, JcrSession session) {
            assert (value instanceof JcrValue);
            if (session == null) {
                return false;
            }
            JcrValue jcrValue = (JcrValue)value;
            AbstractJcrNode node = null;
            try {
                node = session.getNodeByIdentifier(jcrValue.getString());
            }
            catch (RepositoryException re) {
                return false;
            }
            NamespaceRegistry namespaces = session.namespaces();
            for (int i = 0; i < this.constraints.length; ++i) {
                try {
                    if (!node.isNodeType(this.constraints[i].getString(namespaces))) continue;
                    return true;
                }
                catch (RepositoryException re) {
                    throw new IllegalStateException(re);
                }
            }
            return false;
        }
    }

    @Immutable
    private static class DecimalConstraintChecker
    extends RangeConstraintChecker<BigDecimal> {
        protected DecimalConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            super(valueConstraints, context);
        }

        @Override
        public int getType() {
            return 12;
        }

        @Override
        protected ValueFactory<BigDecimal> getValueFactory(ValueFactories valueFactories) {
            return valueFactories.getDecimalFactory();
        }

        @Override
        protected Comparable<BigDecimal> parseValue(String s) {
            return new BigDecimal(s);
        }
    }

    @Immutable
    private static class DoubleConstraintChecker
    extends RangeConstraintChecker<Double> {
        protected DoubleConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            super(valueConstraints, context);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        protected ValueFactory<Double> getValueFactory(ValueFactories valueFactories) {
            return valueFactories.getDoubleFactory();
        }

        @Override
        protected Comparable<Double> parseValue(String s) {
            return Double.parseDouble(s);
        }
    }

    @Immutable
    private static class DateTimeConstraintChecker
    extends RangeConstraintChecker<DateTime> {
        protected DateTimeConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            super(valueConstraints, context);
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        protected ValueFactory<DateTime> getValueFactory(ValueFactories valueFactories) {
            return valueFactories.getDateFactory();
        }

        @Override
        protected Comparable<DateTime> parseValue(String s) {
            return new JodaDateTime(s.trim());
        }
    }

    @Immutable
    private static class LongConstraintChecker
    extends RangeConstraintChecker<Long> {
        protected LongConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            super(valueConstraints, context);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        protected ValueFactory<Long> getValueFactory(ValueFactories valueFactories) {
            return valueFactories.getLongFactory();
        }

        @Override
        protected Comparable<Long> parseValue(String s) {
            return Long.parseLong(s);
        }
    }

    @Immutable
    private static class BinaryConstraintChecker
    extends LongConstraintChecker {
        protected BinaryConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            super(valueConstraints, context);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean matches(Value value, JcrSession session) {
            try {
                JcrValue jcrValue = (JcrValue)value;
                long thatSize = value.getBinary().getSize();
                JcrValue sizeValue = new JcrValue(jcrValue.factories(), 3, thatSize);
                return super.matches(sizeValue, session);
            }
            catch (RepositoryException e) {
                assert (false) : "Unexpected condition";
                return false;
            }
        }
    }

    private static abstract class RangeConstraintChecker<T extends Comparable<T>>
    implements ConstraintChecker {
        private final Range<T>[] constraints;
        private final ValueFactory<T> valueFactory;
        private T minimumValue;
        private T maximumValue;

        protected RangeConstraintChecker(String[] valueConstraints, ExecutionContext context) {
            this.constraints = new Range[valueConstraints.length];
            this.valueFactory = this.getValueFactory(context.getValueFactories());
            for (int i = 0; i < valueConstraints.length; ++i) {
                this.constraints[i] = this.parseValueConstraint(valueConstraints[i]);
            }
        }

        protected abstract ValueFactory<T> getValueFactory(ValueFactories var1);

        protected abstract Comparable<T> parseValue(String var1);

        protected T getMinimum() {
            if (this.minimumValue == null) {
                Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<T>>>>>>>>> minimum = null;
                for (Range<T> range : this.constraints) {
                    Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<T>>>>>>>>> rangeMin = range.getMinimum();
                    if (rangeMin == null) continue;
                    minimum = minimum == null ? rangeMin : (minimum.compareTo(rangeMin) > 0 ? rangeMin : minimum);
                }
                this.minimumValue = minimum;
            }
            return this.minimumValue;
        }

        protected T getMaximum() {
            if (this.maximumValue == null) {
                Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<T>>>>>>>>> maximum = null;
                for (Range<T> range : this.constraints) {
                    Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<Comparable<T>>>>>>>>> rangeMax = range.getMaximum();
                    if (rangeMax == null) continue;
                    maximum = maximum == null ? rangeMax : (maximum.compareTo(rangeMax) > 0 ? rangeMax : maximum);
                }
                this.maximumValue = maximum;
            }
            return this.maximumValue;
        }

        private Range<T> parseValueConstraint(String valueConstraint) {
            assert (valueConstraint != null);
            final boolean includeLower = valueConstraint.charAt(0) == '[';
            final boolean includeUpper = valueConstraint.charAt(valueConstraint.length() - 1) == ']';
            int commaInd = valueConstraint.indexOf(44);
            String lval = commaInd > 1 ? valueConstraint.substring(1, commaInd) : null;
            String rval = commaInd < valueConstraint.length() - 2 ? valueConstraint.substring(commaInd + 1, valueConstraint.length() - 1) : null;
            final Comparable<T> lower = lval == null ? null : this.parseValue(lval.trim());
            final Comparable<T> upper = rval == null ? null : this.parseValue(rval.trim());
            return new Range<T>(){

                @Override
                public boolean accepts(T value) {
                    if (lower != null && (includeLower ? lower.compareTo(value) > 0 : lower.compareTo(value) >= 0)) {
                        return false;
                    }
                    return upper == null || !(includeUpper ? upper.compareTo(value) < 0 : upper.compareTo(value) <= 0);
                }

                @Override
                public Comparable<T> getMaximum() {
                    return upper;
                }

                @Override
                public Comparable<T> getMinimum() {
                    return lower;
                }
            };
        }

        @Override
        public boolean matches(Value value, JcrSession session) {
            assert (value != null);
            Comparable convertedValue = (Comparable)this.valueFactory.create(((JcrValue)value).value());
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].accepts(convertedValue)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface Range<T> {
        public boolean accepts(T var1);

        public Comparable<T> getMinimum();

        public Comparable<T> getMaximum();
    }

    public static interface ConstraintChecker {
        public int getType();

        public boolean matches(Value var1, JcrSession var2);
    }
}

