/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Metadata
implements Externalizable {
    private long length;
    private int numberChunks;
    private long modificationTime;
    private long unusedSince;
    private String mimeType;
    private int numberTextChunks;

    public Metadata(long modificationTime, long length, int numberOfChunks) {
        this.length = length;
        this.modificationTime = modificationTime;
        this.numberChunks = numberOfChunks;
        this.unusedSince = 0L;
        this.mimeType = null;
        this.numberTextChunks = 0;
    }

    protected Metadata(long modificationTime, long length, int numberOfChunks, long unusedSince, String mimeType, int numberTextChunks) {
        this.length = length;
        this.modificationTime = modificationTime;
        this.numberChunks = numberOfChunks;
        this.unusedSince = unusedSince;
        this.mimeType = mimeType;
        this.numberTextChunks = numberTextChunks;
    }

    protected Metadata(Metadata metadata) {
        this.length = metadata.length;
        this.numberChunks = metadata.numberChunks;
        this.modificationTime = metadata.modificationTime;
        this.unusedSince = metadata.unusedSince;
        this.mimeType = metadata.mimeType;
        this.numberTextChunks = metadata.numberTextChunks;
    }

    public Metadata copy() {
        return new Metadata(this);
    }

    public long getLength() {
        return this.length;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Metadata withMimeType(String mimeType) {
        return new Metadata(this.modificationTime, this.length, this.numberChunks, this.unusedSince, mimeType, this.numberTextChunks);
    }

    public int getNumberTextChunks() {
        return this.numberTextChunks;
    }

    public Metadata withNumberOfTextChunks(int numberTextChunks) {
        return new Metadata(this.modificationTime, this.length, this.numberChunks, this.unusedSince, this.mimeType, numberTextChunks);
    }

    public int getNumberChunks() {
        return this.numberChunks;
    }

    public boolean isUnused() {
        return this.unusedSince > 0L;
    }

    public void markAsUnusedSince(long unusedSince) {
        this.unusedSince = unusedSince;
    }

    public void markAsUsed() {
        this.unusedSince = 0L;
    }

    public long unusedSince() {
        return this.unusedSince;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeLong(this.length);
        out.writeInt(this.numberChunks);
        out.writeLong(this.modificationTime);
        out.writeLong(this.unusedSince);
        out.writeInt(this.numberTextChunks);
        if (this.mimeType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.mimeType);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        in.readShort();
        this.length = in.readLong();
        this.numberChunks = in.readInt();
        this.modificationTime = in.readLong();
        this.unusedSince = in.readLong();
        this.numberTextChunks = in.readInt();
        if (in.readBoolean()) {
            this.mimeType = in.readUTF();
        }
    }
}

