/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.lang.reflect.Method;
import java.util.Locale;

public class BeanUtils {
    public static String setterName(String fieldName) {
        StringBuilder sb = new StringBuilder("set");
        if (fieldName != null && fieldName.length() > 0) {
            sb.append(fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH));
            if (fieldName.length() > 1) {
                sb.append(fieldName.substring(1));
            }
        }
        return sb.toString();
    }

    public static String getterName(Class componentClass) {
        if (componentClass == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("get");
        sb.append(componentClass.getSimpleName());
        return sb.toString();
    }

    public static String setterName(Class componentClass) {
        if (componentClass == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("set");
        sb.append(componentClass.getSimpleName());
        return sb.toString();
    }

    public static Method getterMethod(Class target, Class componentClass) {
        try {
            return target.getMethod(BeanUtils.getterName(componentClass), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static Method setterMethod(Class target, Class componentClass) {
        try {
            return target.getMethod(BeanUtils.setterName(componentClass), componentClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

