/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;

@NotThreadSafe
final class JcrChildNodeIterator
implements NodeIterator {
    private final NodeResolver resolver;
    private final Iterator<ChildReference> iterator;
    private Iterator<Node> nodeIterator;
    private int ndx;
    private long size;

    JcrChildNodeIterator(NodeResolver resolver, Iterator<ChildReference> iterator) {
        this.resolver = resolver;
        this.iterator = iterator;
        this.size = -1L;
    }

    JcrChildNodeIterator(NodeResolver resolver, ChildReferences childReferences) {
        assert (this.size >= 0L);
        this.resolver = resolver;
        this.iterator = childReferences.iterator();
        this.size = childReferences.size();
    }

    public long getPosition() {
        return this.ndx;
    }

    public long getSize() {
        if (this.size > -1L) {
            return this.size;
        }
        if (!this.hasNext()) {
            this.size = this.ndx;
            return this.size;
        }
        LinkedList<Node> remainingNodes = new LinkedList<Node>();
        this.size = this.ndx;
        while (this.iterator.hasNext()) {
            Node node = this.resolver.nodeFrom(this.iterator.next());
            if (node == null) continue;
            remainingNodes.add(node);
            ++this.size;
        }
        this.nodeIterator = remainingNodes.iterator();
        return this.size;
    }

    public boolean hasNext() {
        return this.nodeIterator != null ? this.nodeIterator.hasNext() : this.iterator.hasNext();
    }

    public Object next() {
        return this.nextNode();
    }

    public Node nextNode() {
        if (this.nodeIterator != null) {
            return this.nodeIterator.next();
        }
        Node child = null;
        while ((child = this.resolver.nodeFrom(this.iterator.next())) == null) {
        }
        ++this.ndx;
        return child;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        CheckArg.isNonNegative((long)count, (String)"count");
        while (--count >= 0L) {
            this.nextNode();
        }
    }

    protected static interface NodeResolver {
        public Node nodeFrom(ChildReference var1);
    }
}

