/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.math.BigDecimal;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.UuidFactory;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueTypeSystem;
import org.modeshape.jcr.value.basic.AbstractValueFactories;
import org.modeshape.jcr.value.basic.BooleanValueFactory;
import org.modeshape.jcr.value.basic.DecimalValueFactory;
import org.modeshape.jcr.value.basic.DoubleValueFactory;
import org.modeshape.jcr.value.basic.JodaDateTimeValueFactory;
import org.modeshape.jcr.value.basic.LongValueFactory;
import org.modeshape.jcr.value.basic.NameValueFactory;
import org.modeshape.jcr.value.basic.ObjectValueFactory;
import org.modeshape.jcr.value.basic.PathValueFactory;
import org.modeshape.jcr.value.basic.ReferenceValueFactory;
import org.modeshape.jcr.value.basic.StringValueFactory;
import org.modeshape.jcr.value.basic.UriValueFactory;
import org.modeshape.jcr.value.basic.UuidValueFactory;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreValueFactory;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

@Immutable
public class StandardValueFactories
extends AbstractValueFactories {
    private final ValueFactory<String> stringFactory;
    private final BinaryFactory binaryFactory;
    private final ValueFactory<Boolean> booleanFactory;
    private final DateTimeFactory dateFactory;
    private final ValueFactory<BigDecimal> decimalFactory;
    private final ValueFactory<Double> doubleFactory;
    private final ValueFactory<Long> longFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ReferenceFactory referenceFactory;
    private final ReferenceFactory weakReferenceFactory;
    private final ValueFactory<URI> uriFactory;
    private final UuidFactory uuidFactory;
    private final ValueFactory<Object> objectFactory;
    private final NamespaceRegistry namespaceRegistry;
    private final TypeSystem typeSystem;

    public StandardValueFactories(NamespaceRegistry namespaceRegistry, BinaryStore binaryStore) {
        this(namespaceRegistry, binaryStore, null, null, new ValueFactory[0]);
    }

    public StandardValueFactories(NamespaceRegistry namespaceRegistry, BinaryStore binaryStore, TextDecoder decoder, TextEncoder encoder, ValueFactory<?> ... extraFactories) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        CheckArg.isNotNull((Object)binaryStore, (String)"binaryStore");
        this.namespaceRegistry = namespaceRegistry;
        decoder = decoder != null ? decoder : ValueFactory.DEFAULT_DECODER;
        encoder = encoder != null ? encoder : ValueFactory.DEFAULT_ENCODER;
        HashMap factories = new HashMap();
        for (ValueFactory<?> factory : extraFactories) {
            if (factory == null) continue;
            factories.put(factory.getPropertyType(), factory);
        }
        this.stringFactory = StandardValueFactories.getFactory(factories, new StringValueFactory(this.namespaceRegistry, decoder, encoder));
        StringValueFactory stringFactoryWithoutNamespaces = new StringValueFactory(decoder, encoder);
        this.binaryFactory = (BinaryFactory)StandardValueFactories.getFactory(factories, new BinaryStoreValueFactory(binaryStore, decoder, (ValueFactory<String>)stringFactoryWithoutNamespaces));
        this.booleanFactory = StandardValueFactories.getFactory(factories, new BooleanValueFactory(decoder, this.stringFactory));
        this.dateFactory = (DateTimeFactory)StandardValueFactories.getFactory(factories, new JodaDateTimeValueFactory(decoder, this.stringFactory));
        this.decimalFactory = StandardValueFactories.getFactory(factories, new DecimalValueFactory(decoder, this.stringFactory));
        this.doubleFactory = StandardValueFactories.getFactory(factories, new DoubleValueFactory(decoder, this.stringFactory));
        this.longFactory = StandardValueFactories.getFactory(factories, new LongValueFactory(decoder, this.stringFactory));
        this.nameFactory = (NameFactory)StandardValueFactories.getFactory(factories, new NameValueFactory(this.namespaceRegistry, decoder, this.stringFactory));
        this.pathFactory = (PathFactory)StandardValueFactories.getFactory(factories, new PathValueFactory(decoder, this.stringFactory, this.nameFactory));
        this.referenceFactory = (ReferenceFactory)StandardValueFactories.getFactory(factories, new ReferenceValueFactory(decoder, this.stringFactory, false));
        this.weakReferenceFactory = (ReferenceFactory)StandardValueFactories.getFactory(factories, new ReferenceValueFactory(decoder, this.stringFactory, true));
        this.uuidFactory = (UuidFactory)StandardValueFactories.getFactory(factories, new UuidValueFactory(decoder, this.stringFactory));
        this.uriFactory = StandardValueFactories.getFactory(factories, new UriValueFactory(this.namespaceRegistry, decoder, this.stringFactory));
        this.objectFactory = StandardValueFactories.getFactory(factories, new ObjectValueFactory(decoder, this.stringFactory, this.binaryFactory));
        this.typeSystem = new ValueTypeSystem(this);
    }

    public StandardValueFactories(StandardValueFactories factories, BinaryStore store) {
        this.namespaceRegistry = factories.namespaceRegistry;
        this.stringFactory = factories.stringFactory;
        this.booleanFactory = factories.booleanFactory;
        this.dateFactory = factories.getDateFactory();
        this.decimalFactory = factories.getDecimalFactory();
        this.doubleFactory = factories.getDoubleFactory();
        this.longFactory = factories.longFactory;
        this.nameFactory = factories.getNameFactory();
        this.pathFactory = factories.getPathFactory();
        this.referenceFactory = factories.getReferenceFactory();
        this.weakReferenceFactory = factories.getWeakReferenceFactory();
        this.uuidFactory = factories.getUuidFactory();
        this.uriFactory = factories.getUriFactory();
        TextDecoder decoder = ((StringValueFactory)this.stringFactory).getDecoder();
        TextEncoder encoder = ((StringValueFactory)this.stringFactory).getEncoder();
        if (store == null) {
            store = TransientBinaryStore.get();
        }
        StringValueFactory stringFactoryWithoutNamespaces = new StringValueFactory(decoder, encoder);
        this.binaryFactory = new BinaryStoreValueFactory(store, decoder, (ValueFactory<String>)stringFactoryWithoutNamespaces);
        this.objectFactory = new ObjectValueFactory(decoder, this.stringFactory, this.binaryFactory);
        this.typeSystem = new ValueTypeSystem(this);
    }

    private static <T> ValueFactory<T> getFactory(Map<PropertyType, ValueFactory<?>> factories, ValueFactory<T> defaultFactory) {
        PropertyType type = defaultFactory.getPropertyType();
        ValueFactory<Object> factory = factories.get((Object)type);
        if (factory == null) {
            factory = defaultFactory;
            factories.put(type, factory);
        }
        return factory;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    @Override
    public BinaryFactory getBinaryFactory() {
        return this.binaryFactory;
    }

    @Override
    public ValueFactory<Boolean> getBooleanFactory() {
        return this.booleanFactory;
    }

    @Override
    public DateTimeFactory getDateFactory() {
        return this.dateFactory;
    }

    @Override
    public ValueFactory<BigDecimal> getDecimalFactory() {
        return this.decimalFactory;
    }

    @Override
    public ValueFactory<Double> getDoubleFactory() {
        return this.doubleFactory;
    }

    @Override
    public ValueFactory<Long> getLongFactory() {
        return this.longFactory;
    }

    @Override
    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    @Override
    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    @Override
    public ReferenceFactory getReferenceFactory() {
        return this.referenceFactory;
    }

    @Override
    public ReferenceFactory getWeakReferenceFactory() {
        return this.weakReferenceFactory;
    }

    @Override
    public ValueFactory<String> getStringFactory() {
        return this.stringFactory;
    }

    @Override
    public ValueFactory<URI> getUriFactory() {
        return this.uriFactory;
    }

    @Override
    public UuidFactory getUuidFactory() {
        return this.uuidFactory;
    }

    @Override
    public ValueFactory<Object> getObjectFactory() {
        return this.objectFactory;
    }
}

