/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.SecureHash;
import org.modeshape.connector.filesystem.InclusionExclusionFilenameFilter;
import org.modeshape.connector.filesystem.JsonSidecarExtraPropertyStore;
import org.modeshape.connector.filesystem.LegacySidecarExtraPropertyStore;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.cache.DocumentStoreException;
import org.modeshape.jcr.federation.NoExtraPropertiesStorage;
import org.modeshape.jcr.federation.spi.Connector;
import org.modeshape.jcr.federation.spi.DocumentChanges;
import org.modeshape.jcr.federation.spi.DocumentReader;
import org.modeshape.jcr.federation.spi.DocumentWriter;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.binary.UrlBinaryValue;

public class FileSystemConnector
extends Connector {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String DELIMITER = "/";
    private static final String NT_FOLDER = "nt:folder";
    private static final String NT_FILE = "nt:file";
    private static final String NT_RESOURCE = "nt:resource";
    private static final String MIX_MIME_TYPE = "mix:mimeType";
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private static final String JCR_DATA = "jcr:data";
    private static final String JCR_MIME_TYPE = "jcr:mimeType";
    private static final String JCR_ENCODING = "jcr:encoding";
    private static final String JCR_CREATED = "jcr:created";
    private static final String JCR_CREATED_BY = "jcr:createdBy";
    private static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    private static final String JCR_LAST_MODIFIED_BY = "jcr:lastModified";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final int JCR_CONTENT_SUFFIX_LENGTH = "/jcr:content".length();
    private static final String EXTRA_PROPERTIES_JSON = "json";
    private static final String EXTRA_PROPERTIES_LEGACY = "legacy";
    private static final String EXTRA_PROPERTIES_NONE = "none";
    private String directoryPath;
    private File directory;
    private String directoryAbsolutePath;
    private int directoryAbsolutePathLength;
    private boolean readonly = false;
    private boolean addMimeTypeMixin = false;
    private String inclusionPattern;
    private String exclusionPattern;
    private InclusionExclusionFilenameFilter filenameFilter;
    private String extraPropertiesStorage;
    private NamespaceRegistry registry;

    @Override
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.initialize(registry, nodeTypeManager);
        this.registry = registry;
        this.checkFieldNotNull(this.directoryPath, "directoryPath");
        this.directory = new File(this.directoryPath);
        if (!this.directory.exists() || !this.directory.isDirectory()) {
            String msg = JcrI18n.fileConnectorTopLevelDirectoryMissingOrCannotBeRead.text(new Object[]{this.getSourceName(), "directoryPath"});
            throw new RepositoryException(msg);
        }
        if (!this.directory.canRead() && !this.directory.setReadable(true)) {
            String msg = JcrI18n.fileConnectorTopLevelDirectoryMissingOrCannotBeRead.text(new Object[]{this.getSourceName(), "directoryPath"});
            throw new RepositoryException(msg);
        }
        this.directoryAbsolutePath = this.directory.getAbsolutePath();
        if (!this.directoryAbsolutePath.endsWith(FILE_SEPARATOR)) {
            this.directoryAbsolutePath = this.directoryAbsolutePath + FILE_SEPARATOR;
        }
        this.directoryAbsolutePathLength = this.directoryAbsolutePath.length() - FILE_SEPARATOR.length();
        this.filenameFilter = new InclusionExclusionFilenameFilter();
        if (this.exclusionPattern != null) {
            this.filenameFilter.setExclusionPattern(this.exclusionPattern);
        }
        if (this.inclusionPattern != null) {
            this.filenameFilter.setInclusionPattern(this.exclusionPattern);
        }
        if (EXTRA_PROPERTIES_JSON.equalsIgnoreCase(this.extraPropertiesStorage)) {
            JsonSidecarExtraPropertyStore store = new JsonSidecarExtraPropertyStore(this, this.translator());
            this.setExtraPropertiesStore(store);
            this.filenameFilter.setExtraPropertiesExclusionPattern(store.getExclusionPattern());
        } else if (EXTRA_PROPERTIES_LEGACY.equalsIgnoreCase(this.extraPropertiesStorage)) {
            LegacySidecarExtraPropertyStore store = new LegacySidecarExtraPropertyStore(this);
            this.setExtraPropertiesStore(store);
            this.filenameFilter.setExtraPropertiesExclusionPattern(store.getExclusionPattern());
        } else if (EXTRA_PROPERTIES_NONE.equalsIgnoreCase(this.extraPropertiesStorage)) {
            this.setExtraPropertiesStore(new NoExtraPropertiesStorage(this));
        }
    }

    NamespaceRegistry registry() {
        return this.registry;
    }

    protected boolean isContentNode(String id) {
        return id.endsWith(JCR_CONTENT_SUFFIX);
    }

    protected File fileFor(String id) {
        assert (id.startsWith(DELIMITER));
        if (this.isContentNode(id)) {
            id = id.substring(0, id.length() - JCR_CONTENT_SUFFIX_LENGTH);
        }
        return new File(this.directory, id);
    }

    protected boolean isRoot(String id) {
        return DELIMITER.equals(id);
    }

    protected String idFor(File file) {
        String path = file.getAbsolutePath();
        if (!path.startsWith(this.directoryAbsolutePath)) {
            if (this.directory.getAbsolutePath().equals(path)) {
                return DELIMITER;
            }
            String msg = JcrI18n.fileConnectorNodeIdentifierIsNotWithinScopeOfConnector.text(new Object[]{this.getSourceName(), this.directoryPath, path});
            throw new DocumentStoreException(path, msg);
        }
        String id = path.substring(this.directoryAbsolutePathLength);
        id = id.replaceAll(Pattern.quote(FILE_SEPARATOR), DELIMITER);
        assert (id.startsWith(DELIMITER));
        return id;
    }

    protected BinaryValue binaryFor(File file) {
        try {
            byte[] sha1 = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (File)file);
            BinaryKey key = new BinaryKey(sha1);
            return this.createBinaryValue(key, file);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected BinaryValue createBinaryValue(BinaryKey key, File file) throws IOException {
        URL content = this.createUrlForFile(file);
        return new UrlBinaryValue(key, content, file.getTotalSpace(), file.getName(), this.getMimeTypeDetector());
    }

    protected URL createUrlForFile(File file) throws IOException {
        return file.toURI().toURL();
    }

    protected boolean isExcluded(File file) {
        return !this.filenameFilter.accept(file.getParentFile(), file.getName());
    }

    protected void checkWritable(String id, File file) {
        if (this.readonly) {
            String msg = JcrI18n.fileConnectorIsReadOnly.text(new Object[]{this.getSourceName(), id, file.getAbsolutePath()});
            throw new DocumentStoreException(id, msg);
        }
        if (this.isExcluded(file)) {
            String msg = JcrI18n.fileConnectorCannotStoreFileThatIsExcluded.text(new Object[]{this.getSourceName(), id, file.getAbsolutePath()});
            throw new DocumentStoreException(id, msg);
        }
    }

    @Override
    public boolean hasDocument(String id) {
        return this.fileFor(id).exists();
    }

    @Override
    public Document getDocumentById(String id) {
        File file = this.fileFor(id);
        if (this.isExcluded(file) || !file.exists()) {
            return null;
        }
        boolean isRoot = this.isRoot(id);
        boolean isResource = this.isContentNode(id);
        DocumentWriter writer = this.newDocument(id);
        File parentFile = file.getParentFile();
        if (isResource) {
            BinaryValue binaryValue = this.binaryFor(file);
            writer.setPrimaryType(NT_RESOURCE);
            writer.addProperty(JCR_DATA, (Object)binaryValue);
            if (this.addMimeTypeMixin) {
                String mimeType = null;
                Object encoding = null;
                try {
                    mimeType = binaryValue.getMimeType();
                }
                catch (Throwable e) {
                    this.getLogger().error(e, (I18nResource)JcrI18n.couldNotGetMimeType, new Object[]{this.getSourceName(), id, e.getMessage()});
                }
                writer.addProperty(JCR_ENCODING, (Object)encoding);
                writer.addProperty(JCR_MIME_TYPE, (Object)mimeType);
            }
            writer.addProperty("jcr:lastModified", this.factories().getDateFactory().create(file.lastModified()));
            writer.addProperty("jcr:lastModified", null);
            parentFile = file;
        } else if (file.isFile()) {
            writer.setPrimaryType(NT_FILE);
            writer.addProperty(JCR_CREATED, this.factories().getDateFactory().create(file.lastModified()));
            writer.addProperty(JCR_CREATED_BY, null);
            String childId = isRoot ? JCR_CONTENT_SUFFIX : id + JCR_CONTENT_SUFFIX;
            writer.addChild(childId, JCR_CONTENT);
        } else {
            writer.setPrimaryType(NT_FOLDER);
            writer.addProperty(JCR_CREATED, this.factories().getDateFactory().create(file.lastModified()));
            writer.addProperty(JCR_CREATED_BY, null);
            for (File child : file.listFiles(this.filenameFilter)) {
                if (!child.exists() || !child.canRead() || !child.isFile() && !child.isDirectory()) continue;
                String childName = child.getName();
                String childId = isRoot ? DELIMITER + childName : id + DELIMITER + childName;
                writer.addChild(childId, childName);
            }
        }
        String parentId = this.idFor(parentFile);
        writer.setParents(parentId);
        writer.addProperties(this.extraPropertiesStore().getProperties(id));
        if (this.addMimeTypeMixin) {
            writer.addMixinType(MIX_MIME_TYPE);
        }
        return writer.document();
    }

    @Override
    public String getDocumentId(String path) {
        String id = path;
        File file = this.fileFor(id);
        return file.exists() ? id : null;
    }

    @Override
    public boolean removeDocument(String id) {
        File file = this.fileFor(id);
        this.checkWritable(id, file);
        this.extraPropertiesStore().removeProperties(id);
        if (!file.exists()) {
            return false;
        }
        FileUtil.delete((File)file);
        return true;
    }

    @Override
    public void storeDocument(Document document) {
        DocumentReader reader = this.readDocument(document);
        String id = reader.getDocumentId();
        File file = this.fileFor(id);
        this.checkWritable(id, file);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!parent.canWrite()) {
            String parentPath = parent.getAbsolutePath();
            String msg = JcrI18n.fileConnectorCannotWriteToDirectory.text(new Object[]{this.getSourceName(), this.getClass(), parentPath});
            throw new DocumentStoreException(id, msg);
        }
        String primaryType = reader.getPrimaryTypeName();
        Map<Name, Property> properties = reader.getProperties();
        Connector.ExtraProperties extraProperties = this.extraPropertiesFor(id, false);
        extraProperties.addAll(properties).except(JCR_PRIMARY_TYPE, JCR_CREATED, "jcr:lastModified", JCR_DATA);
        try {
            if (NT_FILE.equals(primaryType)) {
                file.createNewFile();
            } else if (NT_FOLDER.equals(primaryType)) {
                file.mkdirs();
            } else if (this.isContentNode(id)) {
                Property content = properties.get(JcrLexicon.DATA);
                BinaryValue binary = (BinaryValue)this.factories().getBinaryFactory().create(content.getFirstValue());
                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(file));
                IoUtil.write((InputStream)binary.getStream(), (OutputStream)ostream);
                if (!NT_RESOURCE.equals(primaryType)) {
                    extraProperties.add(properties.get(JcrLexicon.PRIMARY_TYPE));
                }
            }
            extraProperties.save();
        }
        catch (RepositoryException e) {
            throw new DocumentStoreException(id, e);
        }
        catch (IOException e) {
            throw new DocumentStoreException(id, e);
        }
    }

    @Override
    public String newDocumentId(String parentId, Name newDocumentName) {
        return parentId + DELIMITER + newDocumentName.getString();
    }

    @Override
    public void updateDocument(DocumentChanges documentChanges) {
        String id = documentChanges.getDocumentId();
        Document document = documentChanges.getDocument();
        DocumentReader reader = this.readDocument(document);
        String parentId = reader.getParentIds().get(0);
        File file = this.fileFor(id);
        this.checkWritable(id, file);
        File parent = file.getParentFile();
        String newParentId = this.idFor(parent);
        if (!parentId.equals(newParentId)) {
            File newParent = this.fileFor(newParentId);
            File newFile = new File(newParent, file.getName());
            file.renameTo(newFile);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!parent.canWrite()) {
                String parentPath = newParent.getAbsolutePath();
                String msg = JcrI18n.fileConnectorCannotWriteToDirectory.text(new Object[]{this.getSourceName(), this.getClass(), parentPath});
                throw new DocumentStoreException(id, msg);
            }
            parent = newParent;
            this.extraPropertiesStore().removeProperties(id);
            id = this.idFor(newFile);
        } else {
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!parent.canWrite()) {
                String parentPath = parent.getAbsolutePath();
                String msg = JcrI18n.fileConnectorCannotWriteToDirectory.text(new Object[]{this.getSourceName(), this.getClass(), parentPath});
                throw new DocumentStoreException(id, msg);
            }
        }
        String primaryType = reader.getPrimaryTypeName();
        Map<Name, Property> properties = reader.getProperties();
        Connector.ExtraProperties extraProperties = this.extraPropertiesFor(id, true);
        extraProperties.addAll(properties).except(JCR_PRIMARY_TYPE, JCR_CREATED, "jcr:lastModified", JCR_DATA);
        try {
            if (NT_FILE.equals(primaryType)) {
                file.createNewFile();
            } else if (NT_FOLDER.equals(primaryType)) {
                file.mkdir();
            } else if (this.isContentNode(id)) {
                Property content = reader.getProperty(JCR_DATA);
                BinaryValue binary = (BinaryValue)this.factories().getBinaryFactory().create(content.getFirstValue());
                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(file));
                IoUtil.write((InputStream)binary.getStream(), (OutputStream)ostream);
                if (!NT_RESOURCE.equals(primaryType)) {
                    extraProperties.add(properties.get(JcrLexicon.PRIMARY_TYPE));
                }
            }
            extraProperties.save();
        }
        catch (RepositoryException e) {
            throw new DocumentStoreException(id, e);
        }
        catch (IOException e) {
            throw new DocumentStoreException(id, e);
        }
    }
}

