/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.SecureHash;
import org.modeshape.common.util.ThreadPoolFactory;
import org.modeshape.common.util.ThreadPools;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.UriFactory;
import org.modeshape.jcr.value.UuidFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueTypeSystem;
import org.modeshape.jcr.value.basic.BasicPropertyFactory;
import org.modeshape.jcr.value.basic.BooleanValueFactory;
import org.modeshape.jcr.value.basic.DecimalValueFactory;
import org.modeshape.jcr.value.basic.DoubleValueFactory;
import org.modeshape.jcr.value.basic.JodaDateTimeValueFactory;
import org.modeshape.jcr.value.basic.LongValueFactory;
import org.modeshape.jcr.value.basic.NameValueFactory;
import org.modeshape.jcr.value.basic.ObjectValueFactory;
import org.modeshape.jcr.value.basic.PathValueFactory;
import org.modeshape.jcr.value.basic.ReferenceValueFactory;
import org.modeshape.jcr.value.basic.SimpleNamespaceRegistry;
import org.modeshape.jcr.value.basic.StringValueFactory;
import org.modeshape.jcr.value.basic.ThreadSafeNamespaceRegistry;
import org.modeshape.jcr.value.basic.UriValueFactory;
import org.modeshape.jcr.value.basic.UuidValueFactory;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreValueFactory;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

@Immutable
public final class ExecutionContext
implements ThreadPoolFactory,
Cloneable,
NamespaceRegistry.Holder {
    public static final ExecutionContext DEFAULT_CONTEXT = new ExecutionContext();
    private final ThreadPoolFactory threadPools;
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;
    private final SecurityContext securityContext;
    private final BinaryStore binaryStore;
    private final String id = ExecutionContext.sha1(UUID.randomUUID().toString()).substring(0, 9);
    private final String processId;
    private final Map<String, String> data;
    private final TextDecoder decoder;
    private final TextEncoder encoder;
    private final StringFactory stringFactory;
    private final BinaryFactory binaryFactory;
    private final ValueFactory<Boolean> booleanFactory;
    private final DateTimeFactory dateFactory;
    private final ValueFactory<BigDecimal> decimalFactory;
    private final ValueFactory<Double> doubleFactory;
    private final ValueFactory<Long> longFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ReferenceFactory referenceFactory;
    private final ReferenceFactory weakReferenceFactory;
    private final UriFactory uriFactory;
    private final UuidFactory uuidFactory;
    private final ValueFactory<Object> objectFactory;
    private final TypeSystem typeSystem;

    private static String sha1(String name) {
        try {
            byte[] sha1 = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])name.getBytes());
            return SecureHash.asHexString((byte[])sha1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    public ExecutionContext() {
        this(new NullSecurityContext(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.initializeDefaultNamespaces(this.getNamespaceRegistry());
        assert (this.securityContext != null);
    }

    protected ExecutionContext(ExecutionContext context) {
        this(context.securityContext, context.namespaceRegistry, context.propertyFactory, context.threadPools, context.binaryStore, context.data, context.processId, context.decoder, context.encoder, context.stringFactory, context.binaryFactory, context.booleanFactory, context.dateFactory, context.decimalFactory, context.doubleFactory, context.longFactory, context.nameFactory, context.pathFactory, context.referenceFactory, context.weakReferenceFactory, context.uriFactory, context.uuidFactory, context.objectFactory);
    }

    protected ExecutionContext(SecurityContext securityContext, NamespaceRegistry namespaceRegistry, PropertyFactory propertyFactory, ThreadPoolFactory threadPoolFactory, BinaryStore binaryStore, Map<String, String> data, String processId, TextDecoder decoder, TextEncoder encoder, StringFactory stringFactory, BinaryFactory binaryFactory, ValueFactory<Boolean> booleanFactory, DateTimeFactory dateFactory, ValueFactory<BigDecimal> decimalFactory, ValueFactory<Double> doubleFactory, ValueFactory<Long> longFactory, NameFactory nameFactory, PathFactory pathFactory, ReferenceFactory referenceFactory, ReferenceFactory weakReferenceFactory, UriFactory uriFactory, UuidFactory uuidFactory, ValueFactory<Object> objectFactory) {
        assert (securityContext != null);
        this.securityContext = securityContext;
        if (binaryStore == null) {
            binaryStore = TransientBinaryStore.get();
        }
        if (namespaceRegistry == null) {
            namespaceRegistry = new ThreadSafeNamespaceRegistry(new SimpleNamespaceRegistry());
        }
        if (threadPoolFactory == null) {
            threadPoolFactory = new ThreadPools();
        }
        if (data == null) {
            data = Collections.emptyMap();
        }
        if (processId == null) {
            processId = UUID.randomUUID().toString();
        }
        if (decoder == null) {
            decoder = ValueFactory.DEFAULT_DECODER;
        }
        if (encoder == null) {
            encoder = ValueFactory.DEFAULT_ENCODER;
        }
        this.binaryStore = binaryStore;
        this.namespaceRegistry = namespaceRegistry;
        this.threadPools = threadPoolFactory;
        this.data = data;
        this.processId = processId;
        this.decoder = decoder;
        this.encoder = encoder;
        this.valueFactories = new ContextFactories();
        stringFactory = stringFactory == null ? new StringValueFactory(this, decoder, encoder) : stringFactory.with(this.valueFactories).with(this);
        if (binaryFactory == null) {
            StringValueFactory stringFactoryWithoutNamespaces = new StringValueFactory(decoder, encoder);
            binaryFactory = new BinaryStoreValueFactory(this.binaryStore, decoder, this.valueFactories, stringFactoryWithoutNamespaces);
        } else {
            binaryFactory = binaryFactory.with(binaryStore).with(this.valueFactories);
        }
        booleanFactory = booleanFactory == null ? new BooleanValueFactory(decoder, this.valueFactories) : booleanFactory.with(this.valueFactories);
        dateFactory = dateFactory == null ? new JodaDateTimeValueFactory(decoder, this.valueFactories) : dateFactory.with(this.valueFactories);
        decimalFactory = decimalFactory == null ? new DecimalValueFactory(decoder, this.valueFactories) : decimalFactory.with(this.valueFactories);
        doubleFactory = doubleFactory == null ? new DoubleValueFactory(decoder, this.valueFactories) : doubleFactory.with(this.valueFactories);
        longFactory = longFactory == null ? new LongValueFactory(decoder, this.valueFactories) : longFactory.with(this.valueFactories);
        nameFactory = nameFactory == null ? new NameValueFactory(this, decoder, this.valueFactories) : nameFactory.with(this.valueFactories).with(this);
        pathFactory = pathFactory == null ? new PathValueFactory(decoder, this.valueFactories) : pathFactory.with(this.valueFactories);
        referenceFactory = referenceFactory == null ? new ReferenceValueFactory(decoder, this.valueFactories, false) : referenceFactory.with(this.valueFactories);
        weakReferenceFactory = weakReferenceFactory == null ? new ReferenceValueFactory(decoder, this.valueFactories, true) : weakReferenceFactory.with(this.valueFactories);
        uuidFactory = uuidFactory == null ? new UuidValueFactory(decoder, this.valueFactories) : uuidFactory.with(this.valueFactories);
        uriFactory = uriFactory == null ? new UriValueFactory(this, decoder, this.valueFactories) : uriFactory.with(this.valueFactories).with(this);
        objectFactory = objectFactory == null ? new ObjectValueFactory(decoder, this.valueFactories) : objectFactory.with(this.valueFactories);
        this.stringFactory = stringFactory;
        this.binaryFactory = binaryFactory;
        this.booleanFactory = booleanFactory;
        this.dateFactory = dateFactory;
        this.decimalFactory = decimalFactory;
        this.doubleFactory = doubleFactory;
        this.longFactory = longFactory;
        this.nameFactory = nameFactory;
        this.pathFactory = pathFactory;
        this.referenceFactory = referenceFactory;
        this.weakReferenceFactory = weakReferenceFactory;
        this.uuidFactory = uuidFactory;
        this.uriFactory = uriFactory;
        this.objectFactory = objectFactory;
        this.typeSystem = new ValueTypeSystem(this.valueFactories);
        this.propertyFactory = propertyFactory == null ? new BasicPropertyFactory(this.valueFactories) : propertyFactory;
    }

    protected ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPools;
    }

    public Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz);
    }

    public Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public final PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    public BinaryStore getBinaryStore() {
        return this.binaryStore;
    }

    public ExecutorService getThreadPool(String name) {
        return this.threadPools.getThreadPool(name);
    }

    public void releaseThreadPool(ExecutorService pool) {
        this.threadPools.releaseThreadPool(pool);
    }

    public ExecutorService getCachedTreadPool(String name) {
        return this.threadPools.getCachedTreadPool(name);
    }

    public ExecutorService getScheduledThreadPool(String name) {
        return this.threadPools.getScheduledThreadPool(name);
    }

    public void terminateAllPools(long maxWaitTime, TimeUnit timeUnit) {
        this.threadPools.terminateAllPools(maxWaitTime, timeUnit);
    }

    public String getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Map<String, String> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public TextDecoder getDecoder() {
        return this.decoder;
    }

    public ExecutionContext with(BinaryStore binaryStore) {
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, this.propertyFactory, this.threadPools, binaryStore, this.data, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(NamespaceRegistry namespaceRegistry) {
        return new ExecutionContext(this.securityContext, namespaceRegistry, this.propertyFactory, this.threadPools, this.binaryStore, this.data, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(ThreadPoolFactory threadPoolFactory) {
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, this.propertyFactory, threadPoolFactory, this.binaryStore, this.data, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(PropertyFactory propertyFactory) {
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, propertyFactory, this.threadPools, this.binaryStore, this.data, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(SecurityContext securityContext) {
        return new ExecutionContext(securityContext, this.namespaceRegistry, this.propertyFactory, this.threadPools, this.binaryStore, this.data, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(Map<String, String> data) {
        Map<String, String> newData = data;
        if (newData == null) {
            if (this.data.isEmpty()) {
                return this;
            }
        } else {
            newData = Collections.unmodifiableMap(new HashMap<String, String>(data));
        }
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, this.propertyFactory, this.threadPools, this.binaryStore, newData, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(ReferenceFactory referenceFactory) {
        ReferenceFactory strongFactory = this.referenceFactory;
        ReferenceFactory weakFactory = this.weakReferenceFactory;
        if (referenceFactory.getPropertyType() == PropertyType.REFERENCE) {
            strongFactory = referenceFactory;
        } else {
            weakFactory = referenceFactory;
        }
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, this.propertyFactory, this.threadPools, this.binaryStore, this.data, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, strongFactory, weakFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(String key, String value) {
        Map<String, String> newData = this.data;
        if (value == null) {
            if (this.data.isEmpty() || !this.data.containsKey(key)) {
                return this;
            }
            newData = new HashMap<String, String>(this.data);
            newData.remove(key);
            newData = Collections.unmodifiableMap(newData);
        } else {
            newData = new HashMap<String, String>(this.data);
            newData.put(key, value);
            newData = Collections.unmodifiableMap(newData);
        }
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, this.propertyFactory, this.threadPools, this.binaryStore, newData, this.processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext with(String processId) {
        return new ExecutionContext(this.securityContext, this.namespaceRegistry, this.propertyFactory, this.threadPools, this.binaryStore, this.data, processId, this.decoder, this.encoder, this.stringFactory, this.binaryFactory, this.booleanFactory, this.dateFactory, this.decimalFactory, this.doubleFactory, this.longFactory, this.nameFactory, this.pathFactory, this.referenceFactory, this.weakReferenceFactory, this.uriFactory, this.uuidFactory, this.objectFactory);
    }

    public ExecutionContext clone() {
        return new ExecutionContext(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Execution context for ");
        if (this.getSecurityContext() == null) {
            sb.append("null");
        } else {
            sb.append(this.getSecurityContext().getUserName());
        }
        sb.append(" (").append(this.id).append(')');
        return sb.toString();
    }

    protected void initializeDefaultNamespaces(NamespaceRegistry namespaceRegistry) {
        if (namespaceRegistry == null) {
            return;
        }
        namespaceRegistry.register("jcr", "http://www.jcp.org/jcr/1.0");
        namespaceRegistry.register("mix", "http://www.jcp.org/jcr/mix/1.0");
        namespaceRegistry.register("nt", "http://www.jcp.org/jcr/nt/1.0");
        namespaceRegistry.register("mode", "http://www.modeshape.org/1.0");
    }

    protected final class ContextFactories
    implements ValueFactories {
        protected ContextFactories() {
        }

        @Override
        public TypeSystem getTypeSystem() {
            return ExecutionContext.this.typeSystem;
        }

        public NamespaceRegistry getNamespaceRegistry() {
            return ExecutionContext.this.namespaceRegistry;
        }

        @Override
        public BinaryFactory getBinaryFactory() {
            return ExecutionContext.this.binaryFactory;
        }

        @Override
        public ValueFactory<Boolean> getBooleanFactory() {
            return ExecutionContext.this.booleanFactory;
        }

        @Override
        public DateTimeFactory getDateFactory() {
            return ExecutionContext.this.dateFactory;
        }

        @Override
        public ValueFactory<BigDecimal> getDecimalFactory() {
            return ExecutionContext.this.decimalFactory;
        }

        @Override
        public ValueFactory<Double> getDoubleFactory() {
            return ExecutionContext.this.doubleFactory;
        }

        @Override
        public ValueFactory<Long> getLongFactory() {
            return ExecutionContext.this.longFactory;
        }

        @Override
        public NameFactory getNameFactory() {
            return ExecutionContext.this.nameFactory;
        }

        @Override
        public PathFactory getPathFactory() {
            return ExecutionContext.this.pathFactory;
        }

        @Override
        public ReferenceFactory getReferenceFactory() {
            return ExecutionContext.this.referenceFactory;
        }

        @Override
        public ReferenceFactory getWeakReferenceFactory() {
            return ExecutionContext.this.weakReferenceFactory;
        }

        @Override
        public StringFactory getStringFactory() {
            return ExecutionContext.this.stringFactory;
        }

        @Override
        public UriFactory getUriFactory() {
            return ExecutionContext.this.uriFactory;
        }

        @Override
        public UuidFactory getUuidFactory() {
            return ExecutionContext.this.uuidFactory;
        }

        @Override
        public ValueFactory<Object> getObjectFactory() {
            return ExecutionContext.this.objectFactory;
        }

        @Override
        public Iterator<ValueFactory<?>> iterator() {
            return new ValueFactoryIterator();
        }

        @Override
        public ValueFactory<?> getValueFactory(PropertyType type) {
            CheckArg.isNotNull((Object)((Object)type), (String)"type");
            switch (type) {
                case BINARY: {
                    return this.getBinaryFactory();
                }
                case BOOLEAN: {
                    return this.getBooleanFactory();
                }
                case DATE: {
                    return this.getDateFactory();
                }
                case DECIMAL: {
                    return this.getDecimalFactory();
                }
                case DOUBLE: {
                    return this.getDoubleFactory();
                }
                case LONG: {
                    return this.getLongFactory();
                }
                case NAME: {
                    return this.getNameFactory();
                }
                case PATH: {
                    return this.getPathFactory();
                }
                case REFERENCE: {
                    return this.getReferenceFactory();
                }
                case WEAKREFERENCE: {
                    return this.getWeakReferenceFactory();
                }
                case STRING: {
                    return this.getStringFactory();
                }
                case URI: {
                    return this.getUriFactory();
                }
                case UUID: {
                    return this.getUuidFactory();
                }
                case OBJECT: {
                    return this.getObjectFactory();
                }
            }
            return this.getObjectFactory();
        }

        @Override
        public ValueFactory<?> getValueFactory(Object prototype) {
            CheckArg.isNotNull((Object)prototype, (String)"prototype");
            PropertyType inferredType = PropertyType.discoverType(prototype);
            assert (inferredType != null);
            return this.getValueFactory(inferredType);
        }

        protected class ValueFactoryIterator
        implements Iterator<ValueFactory<?>> {
            private final Iterator<PropertyType> propertyTypeIter = PropertyType.iterator();

            protected ValueFactoryIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.propertyTypeIter.hasNext();
            }

            @Override
            public ValueFactory<?> next() {
                PropertyType nextType = this.propertyTypeIter.next();
                return ContextFactories.this.getValueFactory(nextType);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class NullSecurityContext
    implements SecurityContext {
        private NullSecurityContext() {
        }

        @Override
        public boolean isAnonymous() {
            return true;
        }

        @Override
        public String getUserName() {
            return null;
        }

        @Override
        public boolean hasRole(String roleName) {
            return false;
        }

        @Override
        public void logout() {
        }
    }
}

