/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

public class AddOrderingColumnsToSources
implements OptimizerRule {
    public static final AddOrderingColumnsToSources INSTANCE = new AddOrderingColumnsToSources();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        final boolean includeSourceName = context.getHints().qualifyExpandedColumnNames;
        for (PlanNode sortNode : plan.findAllAtOrBelow(PlanNode.Type.SORT)) {
            final HashSet sortColumns = new HashSet();
            Visitors.AbstractVisitor columnVisitor = new Visitors.AbstractVisitor(){

                @Override
                public void visit(PropertyValue prop) {
                    sortColumns.add(AddOrderingColumnsToSources.this.columnFor(prop.selectorName(), prop.getPropertyName(), includeSourceName));
                }

                @Override
                public void visit(ReferenceValue ref) {
                    sortColumns.add(AddOrderingColumnsToSources.this.columnFor(ref.selectorName(), ref.getPropertyName(), includeSourceName));
                }
            };
            List<Object> orderBys = sortNode.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Object.class);
            if (orderBys != null && !orderBys.isEmpty()) {
                for (Object ordering : orderBys) {
                    if (!(ordering instanceof Ordering)) continue;
                    Visitors.visitAll((Ordering)ordering, columnVisitor);
                }
            }
            for (Column sortColumn : sortColumns) {
                this.addSortColumn(context, sortNode, sortColumn);
            }
        }
        return plan;
    }

    protected void addSortColumn(QueryContext context, PlanNode node, Column sortColumn) {
        if (node.getSelectors().contains(sortColumn.selectorName())) {
            List<Column> columns = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            List<String> types = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
            if (columns != null && this.addIfMissing(context, sortColumn, columns, types)) {
                node.setProperty(PlanNode.Property.PROJECT_COLUMNS, columns);
                node.setProperty(PlanNode.Property.PROJECT_COLUMN_TYPES, types);
            }
        }
        for (PlanNode child : node) {
            this.addSortColumn(context, child, sortColumn);
        }
    }

    protected boolean addIfMissing(QueryContext context, Column column, List<Column> columns, List<String> columnTypes) {
        for (Column c : columns) {
            if (!c.selectorName().equals(column.selectorName())) continue;
            String cName = c.getPropertyName();
            if (cName.equals(column.getPropertyName()) || cName.equals(column.getColumnName())) {
                return false;
            }
            cName = c.getColumnName();
            if (!cName.equals(column.getPropertyName()) && !cName.equals(column.getColumnName())) continue;
            return false;
        }
        columns.add(column);
        columnTypes.add(context.getTypeSystem().getDefaultType());
        return true;
    }

    protected Column columnFor(SelectorName selector, String property, boolean includeSourceName) {
        String columnName = includeSourceName ? selector.getString() + "." + property : property;
        return new Column(selector, property, columnName);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

