/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

@Immutable
public class RaiseVariableName
implements OptimizerRule {
    public static final RaiseVariableName INSTANCE = new RaiseVariableName();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode depQuery : plan.findAllAtOrBelow(PlanNode.Traversal.PRE_ORDER, PlanNode.Type.DEPENDENT_QUERY)) {
            PlanNode left = depQuery.getFirstChild();
            this.raiseVariableName(left);
            PlanNode right = depQuery.getLastChild();
            this.raiseVariableName(right);
        }
        return plan;
    }

    protected void raiseVariableName(PlanNode node) {
        String variableName;
        if (node.getType() != PlanNode.Type.DEPENDENT_QUERY && (variableName = this.removeVariableName(node)) != null) {
            node.setProperty(PlanNode.Property.VARIABLE_NAME, variableName);
        }
    }

    protected String removeVariableName(PlanNode node) {
        if (node == null) {
            return null;
        }
        String variableName = node.getProperty(PlanNode.Property.VARIABLE_NAME, String.class);
        if (variableName != null) {
            node.removeProperty((Object)PlanNode.Property.VARIABLE_NAME);
            return variableName;
        }
        return this.removeVariableName(node.getFirstChild());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

