/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation;

import java.util.Collections;
import java.util.Map;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.DocumentStoreException;
import org.modeshape.jcr.federation.spi.Connector;
import org.modeshape.jcr.federation.spi.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ValueFactory;

public class NoExtraPropertiesStorage
implements ExtraPropertiesStore {
    protected static final Map<Name, Property> NO_PROPERTIES_MAP = Collections.emptyMap();
    private final ValueFactory<String> strings;
    private final String sourceName;

    public NoExtraPropertiesStorage(Connector connector) {
        this.strings = connector.getContext().getValueFactories().getStringFactory();
        this.sourceName = connector.getSourceName();
    }

    @Override
    public Map<Name, Property> getProperties(String id) {
        return NO_PROPERTIES_MAP;
    }

    @Override
    public boolean removeProperties(String id) {
        return false;
    }

    @Override
    public void storeProperties(String id, Map<Name, Property> properties) {
        String names = null;
        int count = 0;
        for (Map.Entry<Name, Property> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            String name = this.strings.create(entry.getKey());
            names = names == null ? name : ", " + name;
            ++count;
        }
        if (count == 0) {
            return;
        }
        String msg = null;
        msg = count == 1 ? JcrI18n.couldNotStoreProperty.text(new Object[]{this.sourceName, id, names}) : JcrI18n.couldNotStoreProperties.text(new Object[]{this.sourceName, id, names});
        throw new DocumentStoreException(id, msg);
    }

    @Override
    public void updateProperties(String id, Map<Name, Property> properties) {
        this.storeProperties(id, properties);
    }
}

