/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.transport.AggregateBackupResponse;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupFailureException;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.CustomFailurePolicy;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.XSiteBackup;

public class BackupSenderImpl
implements BackupSender {
    private static Log log = LogFactory.getLog(BackupSenderImpl.class);
    private Cache cache;
    private Transport transport;
    private Configuration config;
    private TransactionTable txTable;
    private final Map<String, CustomFailurePolicy> siteFailurePolicy = new HashMap<String, CustomFailurePolicy>();
    private final ConcurrentMap<String, OfflineStatus> offlineStatus = ConcurrentMapFactory.makeConcurrentMap();
    private final String localSiteName;
    private String cacheName;
    private GlobalConfiguration globalConfig;

    public BackupSenderImpl(String localSiteName) {
        this.localSiteName = localSiteName;
    }

    @Inject
    public void init(Cache cache, Transport transport, TransactionTable txTable, GlobalConfiguration gc) {
        this.cache = cache;
        this.transport = transport;
        this.txTable = txTable;
        this.globalConfig = gc;
    }

    @Start
    public void start() {
        this.config = this.cache.getCacheConfiguration();
        this.cacheName = this.cache.getName();
        for (BackupConfiguration bc : this.config.sites().enabledBackups()) {
            if (bc.backupFailurePolicy() == BackupFailurePolicy.CUSTOM) {
                String backupPolicy = bc.failurePolicyClass();
                if (backupPolicy == null) {
                    throw new IllegalStateException("Backup policy class missing for custom failure policy!");
                }
                CustomFailurePolicy instance = (CustomFailurePolicy)Util.getInstance(backupPolicy, this.globalConfig.classLoader());
                this.siteFailurePolicy.put(bc.site(), instance);
            }
            OfflineStatus offline = new OfflineStatus(bc.takeOffline());
            this.offlineStatus.put(bc.site(), offline);
        }
    }

    @Override
    public BackupResponse backupPrepare(PrepareCommand command) throws Exception {
        BackupFilter filter = !command.isOnePhaseCommit() ? BackupFilter.KEEP_2PC_ONLY : BackupFilter.KEEP_ALL;
        List<XSiteBackup> backups = this.calculateBackupInfo(filter);
        return this.backupCommand(command, backups);
    }

    @Override
    public void processResponses(BackupResponse backupResponse, VisitableCommand command) throws Throwable {
        this.processResponses(backupResponse, command, null);
    }

    @Override
    public void processResponses(BackupResponse backupResponse, VisitableCommand command, Transaction transaction) throws Throwable {
        log.tracef("Processing backup response %s for command %s", backupResponse, command);
        backupResponse.waitForBackupToFinish();
        this.updateOfflineSites(backupResponse);
        this.processFailedResponses(backupResponse, command, transaction);
    }

    private void updateOfflineSites(BackupResponse backupResponse) {
        if (this.offlineStatus.isEmpty()) {
            return;
        }
        Set<String> communicationErrors = backupResponse.getCommunicationErrors();
        for (Map.Entry statusEntry : this.offlineStatus.entrySet()) {
            OfflineStatus status = (OfflineStatus)statusEntry.getValue();
            if (!status.isEnabled()) continue;
            if (communicationErrors.contains(statusEntry.getKey())) {
                status.updateOnCommunicationFailure(backupResponse.getSendTimeMillis());
                log.tracef("OfflineStatus updated %s", status);
                continue;
            }
            if (status.isOffline()) continue;
            status.reset();
        }
    }

    @Override
    public BackupResponse backupWrite(WriteCommand command) throws Exception {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_ALL);
        return this.backupCommand(command, xSiteBackups);
    }

    @Override
    public BackupResponse backupCommit(CommitCommand command) throws Exception {
        BackupResponse onePcResponse = this.sendTo1PCBackups(command);
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_2PC_ONLY);
        BackupResponse twoPcResponse = this.backupCommand(command, xSiteBackups);
        return new AggregateBackupResponse(onePcResponse, twoPcResponse);
    }

    @Override
    public BackupResponse backupRollback(RollbackCommand command) throws Exception {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_2PC_ONLY);
        log.tracef("Backing up rollback command to: %s", xSiteBackups);
        return this.backupCommand(command, xSiteBackups);
    }

    @Override
    public BackupSender.BringSiteOnlineResponse bringSiteOnline(String siteName) {
        if (!this.config.sites().hasInUseBackup(siteName)) {
            log.tryingToBringOnlineNonexistentSite(siteName);
            return BackupSender.BringSiteOnlineResponse.NO_SUCH_SITE;
        }
        OfflineStatus offline = (OfflineStatus)this.offlineStatus.get(siteName);
        boolean broughtOnline = offline.bringOnline();
        return broughtOnline ? BackupSender.BringSiteOnlineResponse.BROUGHT_ONLINE : BackupSender.BringSiteOnlineResponse.ALREADY_ONLINE;
    }

    @Override
    public BackupSender.TakeSiteOfflineResponse takeSiteOffline(String siteName) {
        if (!this.config.sites().hasInUseBackup(siteName)) {
            return BackupSender.TakeSiteOfflineResponse.NO_SUCH_SITE;
        }
        OfflineStatus offline = (OfflineStatus)this.offlineStatus.get(siteName);
        return offline.forceOffline() ? BackupSender.TakeSiteOfflineResponse.TAKEN_OFFLINE : BackupSender.TakeSiteOfflineResponse.ALREADY_OFFLINE;
    }

    private BackupResponse backupCommand(ReplicableCommand command, List<XSiteBackup> xSiteBackups) throws Exception {
        return this.transport.backupRemotely(xSiteBackups, new SingleRpcCommand(this.cacheName, command));
    }

    private BackupResponse sendTo1PCBackups(CommitCommand command) throws Exception {
        List<XSiteBackup> backups = this.calculateBackupInfo(BackupFilter.KEEP_1PC_ONLY);
        LocalTransaction localTx = this.txTable.getLocalTransaction(command.getGlobalTransaction());
        PrepareCommand prepare = new PrepareCommand(this.cacheName, localTx.getGlobalTransaction(), localTx.getModifications(), true);
        return this.backupCommand(prepare, backups);
    }

    private void processFailedResponses(BackupResponse backupResponse, VisitableCommand command, Transaction transaction) throws Throwable {
        SitesConfiguration sitesConfiguration = this.config.sites();
        Map<String, Throwable> failures = backupResponse.getFailedBackups();
        BackupFailureException backupException = null;
        for (Map.Entry<String, Throwable> failure : failures.entrySet()) {
            BackupFailurePolicy policy = sitesConfiguration.getFailurePolicy(failure.getKey());
            if (policy == BackupFailurePolicy.CUSTOM) {
                CustomFailurePolicy customFailurePolicy = this.siteFailurePolicy.get(failure.getKey());
                command.acceptVisitor(null, new CustomBackupPolicyInvoker(failure.getKey(), customFailurePolicy, transaction));
            }
            if (policy == BackupFailurePolicy.WARN) {
                log.warnXsiteBackupFailed(this.cacheName, failure.getKey(), failure.getValue());
                continue;
            }
            if (policy != BackupFailurePolicy.FAIL) continue;
            if (backupException == null) {
                backupException = new BackupFailureException(this.cacheName);
            }
            backupException.addFailure(failure.getKey(), failure.getValue());
        }
        if (backupException != null) {
            throw backupException;
        }
    }

    private List<XSiteBackup> calculateBackupInfo(BackupFilter backupFilter) {
        ArrayList<XSiteBackup> backupInfo = new ArrayList<XSiteBackup>(2);
        SitesConfiguration sites = this.config.sites();
        for (BackupConfiguration bc : sites.enabledBackups()) {
            boolean isSync;
            if (bc.site().equals(this.localSiteName)) {
                log.cacheBackupsDataToSameSite(this.localSiteName);
                continue;
            }
            boolean bl = isSync = bc.strategy() == BackupConfiguration.BackupStrategy.SYNC;
            if (backupFilter == BackupFilter.KEEP_1PC_ONLY && isSync && bc.isTwoPhaseCommit() || backupFilter == BackupFilter.KEEP_2PC_ONLY && (!isSync || isSync && !bc.isTwoPhaseCommit())) continue;
            if (this.isOffline(bc.site())) {
                log.tracef("The site '%s' is offline, not backing up information to it", bc.site());
                continue;
            }
            XSiteBackup bi = new XSiteBackup(bc.site(), isSync, bc.replicationTimeout());
            backupInfo.add(bi);
        }
        return backupInfo;
    }

    private boolean isOffline(String site) {
        OfflineStatus offline = (OfflineStatus)this.offlineStatus.get(site);
        return offline != null && offline.isOffline();
    }

    @Override
    public OfflineStatus getOfflineStatus(String site) {
        return (OfflineStatus)this.offlineStatus.get(site);
    }

    @Override
    public Map<String, Boolean> status() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(this.offlineStatus.size());
        for (Map.Entry os : this.offlineStatus.entrySet()) {
            result.put((String)os.getKey(), !((OfflineStatus)os.getValue()).isOffline());
        }
        return result;
    }

    public static final class CustomBackupPolicyInvoker
    extends AbstractVisitor {
        private final String site;
        private final CustomFailurePolicy failurePolicy;
        private final Transaction tx;

        public CustomBackupPolicyInvoker(String site, CustomFailurePolicy failurePolicy, Transaction tx) {
            this.site = site;
            this.failurePolicy = failurePolicy;
            this.tx = tx;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.failurePolicy.handlePutFailure(this.site, command.getKey(), command.getValue(), command.isPutIfAbsent());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.failurePolicy.handleRemoveFailure(this.site, command.getKey(), command.getValue());
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            this.failurePolicy.handleReplaceFailure(this.site, command.getKey(), command.getOldValue(), command.getNewValue());
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.failurePolicy.handleClearFailure(this.site);
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.failurePolicy.handlePutAllFailure(this.site, command.getMap());
            return null;
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            this.failurePolicy.handlePrepareFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            this.failurePolicy.handleRollbackFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.failurePolicy.handleCommitFailure(this.site, this.tx);
            return null;
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            super.handleDefault(ctx, command);
            throw new IllegalStateException("Unknown command: " + command);
        }
    }

    private static enum BackupFilter {
        KEEP_1PC_ONLY,
        KEEP_2PC_ONLY,
        KEEP_ALL;

    }
}

