/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.ReferenceValueFactory;

public class NodeIdentifierReferenceFactory
extends ReferenceValueFactory {
    private final NodeKey rootKey;

    public NodeIdentifierReferenceFactory(NodeKey rootKey, TextDecoder decoder, ValueFactories factories, boolean weak) {
        super(decoder, factories, weak);
        this.rootKey = rootKey;
    }

    @Override
    public Reference create(String value) {
        if (value == null) {
            return null;
        }
        NodeKey key = JcrSession.createNodeKeyFromIdentifier(value, this.rootKey);
        boolean isForeign = !key.getSourceKey().equals(this.rootKey.getSourceKey()) || !key.getWorkspaceKey().equals(this.rootKey.getWorkspaceKey());
        return new NodeKeyReference(key, this.weak, isForeign);
    }

    @Override
    public ReferenceFactory with(ValueFactories valueFactories) {
        return new NodeIdentifierReferenceFactory(this.rootKey, this.decoder, valueFactories, this.weak);
    }
}

