/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.federation.FederationManager;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.value.Path;

public class ModeShapeFederationManager
implements FederationManager {
    private final JcrSession session;

    protected ModeShapeFederationManager(JcrSession session) {
        this.session = session;
    }

    public void createProjection(String absNodePath, String sourceName, String externalPath, String alias) throws RepositoryException {
        NodeKey key = this.session.getNode(absNodePath).key();
        SessionCache writer = this.session.spawnSessionCache(false);
        ((WritableSessionCache)writer.unwrap()).createProjection(key, sourceName, externalPath, alias);
        writer.save();
    }

    public void removeProjection(String projectionPath) throws RepositoryException {
        CheckArg.isNotNull((Object)projectionPath, (String)"projectionPath");
        Path path = (Path)this.session.pathFactory().create(projectionPath);
        if (path.isRoot()) {
            throw new IllegalArgumentException(JcrI18n.invalidProjectionPath.text(new Object[]{projectionPath}));
        }
        NodeKey federatedNodeKey = this.session.getNode(path.getParent().getString()).key();
        NodeKey externalNodeKey = this.session.getNode(path.getString()).key();
        SessionCache writer = this.session.spawnSessionCache(false);
        ((WritableSessionCache)writer.unwrap()).removeProjection(federatedNodeKey, externalNodeKey);
        writer.save();
    }
}

