/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.security.SimplePrincipal;
import org.modeshape.jcr.security.acl.AccessControlPolicyIteratorImpl;
import org.modeshape.jcr.security.acl.JcrAccessControlList;
import org.modeshape.jcr.security.acl.PrivilegeImpl;
import org.modeshape.jcr.security.acl.Privileges;
import org.modeshape.jcr.value.Path;

public class AccessControlManagerImpl
implements AccessControlManager {
    private static final String MODE_ACCESS_CONTROLLABLE = "mode:accessControllable";
    private static final String ACCESS_LIST_NODE = "mode:acl";
    private static final String MODE_ACCESS_LIST_NODE = "mode:Acl";
    private static final String MODE_ACCESS_LIST_ENTRY_NODE = "mode:Permission";
    private static final String PRINCIPAL_NAME = "name";
    private static final String PRIVILEGES = "privileges";
    private final JcrSession session;
    private final Privileges privileges;
    private final JcrAccessControlList defaultACL;

    protected AccessControlManagerImpl(JcrSession session) {
        this.session = session;
        this.privileges = new Privileges(session);
        this.defaultACL = JcrAccessControlList.defaultAcl(this);
    }

    public Privilege[] privileges() {
        return this.privileges.listOfSupported();
    }

    public Privilege[] getSupportedPrivileges(String path) {
        return this.privileges.listOfSupported();
    }

    public Privilege privilegeFromName(String name) throws AccessControlException, RepositoryException {
        PrivilegeImpl p = this.privileges.forName(name);
        if (p == null) {
            throw new AccessControlException(name + " is not a valid name for privilege");
        }
        return p;
    }

    public boolean hasPrivileges(String path, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        JcrAccessControlList acl = this.findAccessList(path);
        if (!this.found(acl)) {
            return this.defaultACL.hasPrivileges(this.session.getUserID(), privileges);
        }
        return acl.isEmpty() || acl.hasPrivileges(this.session.getUserID(), privileges);
    }

    public Privilege[] getPrivileges(String path) throws PathNotFoundException, RepositoryException {
        JcrAccessControlList acl = this.findAccessList(path);
        if (!this.found(acl)) {
            return this.defaultACL.getPrivileges(this.session.getUserID());
        }
        Privilege[] pp = acl.getPrivileges(this.session.getUserID());
        return pp;
    }

    public AccessControlPolicy[] getPolicies(String path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{path, "read access control content"}));
        }
        if (!this.hasPrivileges(path, new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}readAccessControl")})) {
            throw new AccessDeniedException();
        }
        AbstractJcrNode node = this.session.getNode(path, true);
        if (node.hasNode(ACCESS_LIST_NODE)) {
            JcrAccessControlList policy = new JcrAccessControlList(this, path);
            Node aclNode = node.getNode(ACCESS_LIST_NODE);
            NodeIterator it = aclNode.getNodes();
            while (it.hasNext()) {
                Node entryNode = it.nextNode();
                String principalName = entryNode.getProperty(PRINCIPAL_NAME).getString();
                Value[] values = entryNode.getProperty(PRIVILEGES).getValues();
                Privilege[] privileges = new Privilege[values.length];
                for (int i = 0; i < privileges.length; ++i) {
                    privileges[i] = this.privilegeFromName(values[i].getString());
                }
                policy.addAccessControlEntry(this.principal(principalName), privileges);
            }
            return new AccessControlPolicy[]{policy};
        }
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicy[] getEffectivePolicies(String path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        AccessControlPolicy[] policies = this.getPolicies(path);
        if (policies.length == 0) {
            return new AccessControlPolicy[]{(AccessControlPolicy)this.getApplicablePolicies(path).next()};
        }
        return policies;
    }

    public AccessControlPolicyIterator getApplicablePolicies(String path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{path, "read access control content"}));
        }
        AbstractJcrNode node = this.session.getNode(path, true);
        if (node.hasNode(ACCESS_LIST_NODE)) {
            return AccessControlPolicyIteratorImpl.EMPTY;
        }
        return new AccessControlPolicyIteratorImpl(new AccessControlPolicy[]{new JcrAccessControlList(this, path)});
    }

    public void setPolicy(String path, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{path, "read access control content"}));
        }
        if (!this.hasPrivileges(path, new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")})) {
            throw new AccessDeniedException();
        }
        if (!(policy instanceof AccessControlList)) {
            throw new AccessControlException("");
        }
        JcrAccessControlList acl = (JcrAccessControlList)policy;
        AbstractJcrNode node = this.session.getNode(path, true);
        node.addMixin(MODE_ACCESS_CONTROLLABLE, false);
        AbstractJcrNode aclNode = node.hasNode(ACCESS_LIST_NODE) ? node.getNode(ACCESS_LIST_NODE) : node.addAclNode(ACCESS_LIST_NODE, MODE_ACCESS_LIST_NODE);
        for (AccessControlEntry ace : acl.getAccessControlEntries()) {
            assert (ace.getPrincipal() != null);
            String name = ace.getPrincipal().getName();
            AbstractJcrNode entryNode = aclNode.hasNode(name) ? aclNode.getNode(name) : aclNode.addAclNode(name, MODE_ACCESS_LIST_ENTRY_NODE);
            entryNode.setPropertyInAccessControlScope(PRINCIPAL_NAME, ace.getPrincipal().getName());
            entryNode.setPropertyInAccessControlScope(PRIVILEGES, this.privileges(ace.getPrivileges()));
        }
        NodeIterator it = aclNode.getNodes();
        while (it.hasNext()) {
            Node entryNode = it.nextNode();
            String name = entryNode.getProperty(PRINCIPAL_NAME).getString();
            if (acl.hasEntry(name)) continue;
            entryNode.remove();
        }
        this.session.repository.repositoryCache().setAccessControlEnabled(true);
    }

    public void removePolicy(String path, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{path, "read access control content"}));
        }
        try {
            if (!this.hasPrivileges(path, new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")})) {
                throw new AccessDeniedException();
            }
            AbstractJcrNode node = this.session.getNode(path);
            if (node.hasNode(ACCESS_LIST_NODE)) {
                Node aclNode = node.getNode(ACCESS_LIST_NODE);
                aclNode.remove();
                node.removeMixin(MODE_ACCESS_CONTROLLABLE);
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public JcrAccessControlList findAccessList(String absPath) throws PathNotFoundException, RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath, true);
        while (!node.hasNode(ACCESS_LIST_NODE)) {
            try {
                node = node.getParent();
            }
            catch (ItemNotFoundException e) {
                // empty catch block
                break;
            }
        }
        if (node.hasNode(ACCESS_LIST_NODE)) {
            return this.acl(node.getNode(ACCESS_LIST_NODE));
        }
        return null;
    }

    private JcrAccessControlList acl(Node node) throws RepositoryException {
        JcrAccessControlList acl = new JcrAccessControlList(this, node.getPath());
        NodeIterator entryNodes = node.getNodes();
        while (entryNodes.hasNext()) {
            Node entry = entryNodes.nextNode();
            String name = entry.getProperty(PRINCIPAL_NAME).getString();
            Value[] privileges = entry.getProperty(PRIVILEGES).getValues();
            acl.addAccessControlEntry(this.principal(name), this.privileges(privileges));
        }
        return acl;
    }

    private String[] privileges(Privilege[] privileges) {
        String[] names = new String[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            names[i] = privileges[i].getName();
        }
        return names;
    }

    private Privilege[] privileges(Value[] names) throws ValueFormatException, AccessControlException, RepositoryException {
        Privilege[] privileges = new Privilege[names.length];
        for (int i = 0; i < names.length; ++i) {
            privileges[i] = this.privilegeFromName(names[i].getString());
        }
        return privileges;
    }

    private boolean found(Object o) {
        return o != null;
    }

    public boolean hasPermission(Path absPath, String ... actions) {
        Privilege[] permissions = new Privilege[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            permissions[i] = this.privileges.forAction(actions[i]);
        }
        try {
            return this.hasPrivileges(absPath.toString(), permissions);
        }
        catch (Exception e) {
            return true;
        }
    }

    private Principal principal(String name) {
        return SimplePrincipal.newInstance(name);
    }
}

