/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.collection.ListMultimap;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.UnionIterator;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;

public class ImmutableChildReferences {
    protected static final ChildReferences EMPTY_CHILD_REFERENCES = EmptyChildReferences.INSTANCE;
    protected static final Iterator<ChildReference> EMPTY_ITERATOR = new EmptyIterator();
    protected static final Iterator<NodeKey> EMPTY_KEY_ITERATOR = new EmptyIterator();

    public static ChildReferences create(List<ChildReference> references) {
        int size = references.size();
        if (size == 0) {
            return EMPTY_CHILD_REFERENCES;
        }
        return new Medium(references);
    }

    public static ChildReferences create(ChildReferences first, DocumentTranslator.ChildReferencesInfo segmentingInfo, WorkspaceCache cache) {
        return new Segmented(cache, first, segmentingInfo);
    }

    public static ChildReferences create(ChildReferences first, DocumentTranslator.ChildReferencesInfo segmentingInfo, ChildReferences externalReferences, WorkspaceCache cache) {
        Segmented segmentedReferences = new Segmented(cache, first, segmentingInfo);
        return !externalReferences.isEmpty() ? new FederatedReferences(segmentedReferences, externalReferences) : segmentedReferences;
    }

    protected static class Segment {
        private final ChildReferences references;
        private final String nextKey;
        private Segment next;

        protected Segment(ChildReferences references, String nextKey) {
            this.nextKey = nextKey;
            this.references = references;
        }

        public ChildReferences getReferences() {
            return this.references;
        }

        public Segment next(WorkspaceCache cache) {
            if (this.next == null && this.nextKey != null) {
                Document blockDoc = cache.blockFor(this.nextKey);
                if (blockDoc == null) {
                    throw new DocumentNotFoundException(this.nextKey);
                }
                ChildReferences refs = cache.translator().getChildReferencesFromBlock(blockDoc);
                DocumentTranslator.ChildReferencesInfo nextNextKey = cache.translator().getChildReferencesInfo(blockDoc);
                this.next = new Segment(refs, nextNextKey != null ? nextNextKey.nextKey : null);
            }
            return this.next;
        }

        public Iterator<NodeKey> keys() {
            return this.references.getAllKeys();
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            Iterator<ChildReference> iter = this.references.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
            return sb;
        }
    }

    public static class FederatedReferences
    extends AbstractChildReferences {
        private final ChildReferences internalReferences;
        private final ChildReferences externalReferences;

        FederatedReferences(ChildReferences externalReferences, ChildReferences internalReferences) {
            this.externalReferences = externalReferences;
            this.internalReferences = internalReferences;
        }

        @Override
        public long size() {
            return this.externalReferences.size() + this.internalReferences.size();
        }

        @Override
        public int getChildCount(Name name) {
            return this.externalReferences.getChildCount(name) + this.internalReferences.getChildCount(name);
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            ChildReference nonFederatedRef = this.internalReferences.getChild(name, snsIndex, context);
            if (nonFederatedRef != null) {
                return nonFederatedRef;
            }
            return this.externalReferences.getChild(name, snsIndex, context);
        }

        @Override
        public boolean hasChild(NodeKey key) {
            return this.externalReferences.hasChild(key) || this.internalReferences.hasChild(key);
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return this.getChild(key, new ChildReferences.BasicContext());
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            ChildReference nonFederatedRef = this.internalReferences.getChild(key, context);
            if (nonFederatedRef != null) {
                return nonFederatedRef;
            }
            return this.externalReferences.getChild(key, context);
        }

        @Override
        public Iterator<ChildReference> iterator() {
            return new UnionIterator<ChildReference>(this.internalReferences.iterator(), this.externalReferences);
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            HashSet<NodeKey> externalKeys = new HashSet<NodeKey>();
            Iterator<NodeKey> externalKeysIterator = this.externalReferences.getAllKeys();
            while (externalKeysIterator.hasNext()) {
                externalKeys.add(externalKeysIterator.next());
            }
            return new UnionIterator<NodeKey>(this.internalReferences.getAllKeys(), externalKeys);
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            sb.append("<external references=").append(this.externalReferences.toString());
            sb.append(">, <internal references=").append(this.internalReferences.toString()).append(">");
            return sb;
        }
    }

    @Immutable
    public static class Segmented
    extends AbstractChildReferences {
        protected final WorkspaceCache cache;
        protected final long totalSize;
        private Segment firstSegment;

        public Segmented(WorkspaceCache cache, ChildReferences firstSegment, DocumentTranslator.ChildReferencesInfo info) {
            this.cache = cache;
            this.totalSize = info.totalSize;
            this.firstSegment = new Segment(firstSegment, info.nextKey);
        }

        @Override
        public long size() {
            return this.totalSize;
        }

        @Override
        public boolean supportsGetChildReferenceByKey() {
            return this.size() != -1L;
        }

        @Override
        public int getChildCount(Name name) {
            int result = 0;
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                result += segment.getReferences().getChildCount(name);
            }
            return result;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            ChildReference result = null;
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                result = segment.getReferences().getChild(name, snsIndex, context);
                if (result == null) continue;
                return result;
            }
            return result;
        }

        @Override
        public boolean hasChild(NodeKey key) {
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                if (!segment.getReferences().hasChild(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return this.getChild(key, new ChildReferences.BasicContext());
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            ChildReference result = null;
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                result = segment.getReferences().getChild(key, context);
                if (result == null) continue;
                return result;
            }
            return result;
        }

        @Override
        public Iterator<ChildReference> iterator(final Name name) {
            final Segment firstSegment = this.firstSegment;
            return new Iterator<ChildReference>(){
                private Segment segment;
                private Iterator<ChildReference> iter;
                private ChildReference next;
                {
                    this.segment = firstSegment;
                    this.iter = this.segment != null ? this.segment.getReferences().iterator(name) : EMPTY_ITERATOR;
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (!this.iter.hasNext()) {
                        while (this.segment != null) {
                            this.segment = this.segment.next(Segmented.this.cache);
                            if (this.segment == null) continue;
                            this.iter = this.segment.getReferences().iterator(name);
                            if (!this.iter.hasNext()) continue;
                            this.next = this.iter.next();
                            return true;
                        }
                        return false;
                    }
                    this.next = this.iter.next();
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ChildReference next() {
                    try {
                        if (this.next == null) {
                            if (this.hasNext()) {
                                ChildReference childReference = this.next;
                                return childReference;
                            }
                            throw new NoSuchElementException();
                        }
                        ChildReference childReference = this.next;
                        return childReference;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<ChildReference> iterator() {
            final Segment firstSegment = this.firstSegment;
            return new Iterator<ChildReference>(){
                private Segment segment;
                private Iterator<ChildReference> iter;
                private ChildReference next;
                {
                    this.segment = firstSegment;
                    this.iter = this.segment != null ? this.segment.getReferences().iterator() : EMPTY_ITERATOR;
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (!this.iter.hasNext()) {
                        while (this.segment != null) {
                            this.segment = this.segment.next(Segmented.this.cache);
                            if (this.segment == null) continue;
                            this.iter = this.segment.getReferences().iterator();
                            if (!this.iter.hasNext()) continue;
                            this.next = this.iter.next();
                            return true;
                        }
                        return false;
                    }
                    this.next = this.iter.next();
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ChildReference next() {
                    try {
                        if (this.next == null) {
                            if (this.hasNext()) {
                                ChildReference childReference = this.next;
                                return childReference;
                            }
                            throw new NoSuchElementException();
                        }
                        ChildReference childReference = this.next;
                        return childReference;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            final Segment firstSegment = this.firstSegment;
            return new Iterator<NodeKey>(){
                private Segment segment;
                private Iterator<NodeKey> iter;
                private NodeKey next;
                {
                    this.segment = firstSegment;
                    this.iter = this.segment != null ? this.segment.keys() : EMPTY_KEY_ITERATOR;
                }

                @Override
                public boolean hasNext() {
                    if (!this.iter.hasNext()) {
                        while (this.segment != null) {
                            this.segment = this.segment.next(Segmented.this.cache);
                            if (this.segment == null) continue;
                            this.iter = this.segment.keys();
                            if (!this.iter.hasNext()) continue;
                            this.next = this.iter.next();
                            return true;
                        }
                        return false;
                    }
                    this.next = this.iter.next();
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public NodeKey next() {
                    try {
                        if (this.next == null) {
                            if (this.hasNext()) {
                                NodeKey nodeKey = this.next;
                                return nodeKey;
                            }
                            throw new NoSuchElementException();
                        }
                        NodeKey nodeKey = this.next;
                        return nodeKey;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            Segment segment = this.firstSegment;
            while (segment != null) {
                segment.toString(sb);
                if (segment.next != null) {
                    sb.append(", ");
                } else if (segment.nextKey != null) {
                    sb.append(", <segment=").append(segment.nextKey).append('>');
                }
                segment = segment.next;
            }
            return sb;
        }
    }

    @Immutable
    protected static final class Medium
    extends AbstractChildReferences {
        private final ListMultimap<Name, ChildReference> childReferences = LinkedListMultimap.create();
        private final Map<NodeKey, ChildReference> childReferencesByKey = new HashMap<NodeKey, ChildReference>();

        protected Medium(Iterable<ChildReference> children) {
            for (ChildReference ref : children) {
                this.childReferences.put((Object)ref.getName(), (Object)ref);
                this.childReferencesByKey.put(ref.getKey(), ref);
            }
        }

        @Override
        public long size() {
            return this.childReferencesByKey.size();
        }

        @Override
        public int getChildCount(Name name) {
            return this.childReferences.get((Object)name).size();
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            ChildReferences.Changes changes = null;
            Iterator<ChildReferences.ChildInsertions> insertions = null;
            boolean includeRenames = false;
            if (context == null) {
                context = new ChildReferences.SingleNameContext();
            } else {
                changes = context.changes();
                if (changes != null) {
                    insertions = changes.insertions(name);
                    includeRenames = changes.isRenamed(name);
                }
            }
            List childrenWithSameName = this.childReferences.get((Object)name);
            if (childrenWithSameName.isEmpty() && !includeRenames) {
                if (insertions == null) {
                    return null;
                }
                while (insertions.hasNext()) {
                    ChildReferences.ChildInsertions inserted = insertions.next();
                    for (ChildReference result : inserted.inserted()) {
                        int index = context.consume(result.getName(), result.getKey());
                        if (index != snsIndex) continue;
                        return result.with(index);
                    }
                }
                return null;
            }
            if (insertions != null || includeRenames) {
                Iterator<ChildReference> iter = this.iterator(context, name);
                while (iter.hasNext()) {
                    ChildReference ref = iter.next();
                    if (ref.getSnsIndex() != snsIndex) continue;
                    return ref;
                }
                return null;
            }
            for (ChildReference childWithSameName : childrenWithSameName) {
                int index;
                if (changes != null && (changes.isRemoved(childWithSameName) || changes.isRenamed(childWithSameName)) || (index = context.consume(childWithSameName.getName(), childWithSameName.getKey())) != snsIndex) continue;
                return childWithSameName.with(index);
            }
            return null;
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            ChildReference ref;
            block12: {
                block11: {
                    ChildReferences.Changes changes;
                    ref = this.childReferencesByKey.get(key);
                    if (ref != null) break block11;
                    if (context == null || (changes = context.changes()) == null || (ref = changes.inserted(key)) == null) break block12;
                    Iterator<ChildReference> iter = this.iterator(context, ref.getName());
                    while (iter.hasNext()) {
                        ChildReference child = iter.next();
                        if (!child.getKey().equals(key)) continue;
                        return child;
                    }
                    break block12;
                }
                if (context != null) {
                    ChildReferences.Changes changes = context.changes();
                    if (changes != null) {
                        Iterator<ChildReferences.ChildInsertions> insertions;
                        boolean renamed = false;
                        if (changes.isRenamed(ref)) {
                            Name newName = changes.renamed(key);
                            ref = ref.with(newName, 1);
                            renamed = true;
                        }
                        if ((insertions = changes.insertions(ref.getName())) != null || renamed) {
                            Iterator<ChildReference> iter = this.iterator(context, ref.getName());
                            while (iter.hasNext()) {
                                ChildReference child = iter.next();
                                if (!child.getKey().equals(key)) continue;
                                return child;
                            }
                        }
                        if (changes.isRemoved(ref)) {
                            return null;
                        }
                    } else {
                        List childrenWithSameName = this.childReferences.get((Object)ref.getName());
                        assert (childrenWithSameName != null);
                        assert (childrenWithSameName.size() != 0);
                        for (ChildReference child : childrenWithSameName) {
                            int index = context.consume(child.getName(), child.getKey());
                            if (!key.equals(child.getKey())) continue;
                            return child.with(index);
                        }
                    }
                }
            }
            return ref;
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return this.getChild(key, new ChildReferences.BasicContext());
        }

        @Override
        public boolean hasChild(NodeKey key) {
            return this.childReferencesByKey.containsKey(key);
        }

        @Override
        public Iterator<ChildReference> iterator(Name name) {
            return this.childReferences.get((Object)name).iterator();
        }

        @Override
        public Iterator<ChildReference> iterator() {
            return this.childReferences.values().iterator();
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            return this.childReferencesByKey.keySet().iterator();
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            Iterator iter = this.childReferences.values().iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
            return sb;
        }
    }

    @Immutable
    protected static final class EmptyChildReferences
    implements ChildReferences {
        public static final ChildReferences INSTANCE = new EmptyChildReferences();

        private EmptyChildReferences() {
        }

        @Override
        public boolean supportsGetChildReferenceByKey() {
            return true;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getChildCount(Name name) {
            return 0;
        }

        @Override
        public ChildReference getChild(Name name) {
            return null;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex) {
            return null;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            return null;
        }

        @Override
        public ChildReference getChild(Path.Segment segment) {
            return null;
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return null;
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            return null;
        }

        @Override
        public boolean hasChild(NodeKey key) {
            return false;
        }

        @Override
        public Iterator<ChildReference> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(Name name) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(ChildReferences.Context context) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(Collection<?> namePatterns, NamespaceRegistry registry) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(ChildReferences.Context context, Collection<?> namePatterns, NamespaceRegistry registry) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            return EMPTY_KEY_ITERATOR;
        }
    }
}

