/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.parse.FullTextSearchParser;

@Immutable
public class FullTextSearch
implements Constraint,
javax.jcr.query.qom.FullTextSearch {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String propertyName;
    private final String fullTextSearchExpression;
    private Term term;
    private final int hc;
    private transient StaticOperand expression;

    protected static String toString(StaticOperand operand) throws RepositoryException {
        if (operand instanceof javax.jcr.query.qom.Literal) {
            return ((javax.jcr.query.qom.Literal)operand).getLiteralValue().getString();
        }
        return operand.toString();
    }

    public FullTextSearch(SelectorName selectorName, String propertyName, StaticOperand fullTextSearchExpression, Term term) throws RepositoryException {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)fullTextSearchExpression, (String)"fullTextSearchExpression");
        String expressionString = FullTextSearch.toString(fullTextSearchExpression);
        CheckArg.isNotEmpty((String)expressionString, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.term = term;
        this.fullTextSearchExpression = expressionString;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
        this.expression = fullTextSearchExpression;
    }

    public FullTextSearch(SelectorName selectorName, String propertyName, String expressionString, StaticOperand fullTextSearchExpression) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)fullTextSearchExpression, (String)"fullTextSearchExpression");
        CheckArg.isNotEmpty((String)expressionString, (String)"expressionString");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.fullTextSearchExpression = expressionString;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
        this.expression = fullTextSearchExpression;
    }

    public FullTextSearch(SelectorName selectorName, String propertyName, String fullTextSearchExpression, Term term) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotEmpty((String)fullTextSearchExpression, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.term = term;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
    }

    public FullTextSearch(SelectorName selectorName, String propertyName, String fullTextSearchExpression) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotEmpty((String)fullTextSearchExpression, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.term = null;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
    }

    public FullTextSearch(SelectorName selectorName, String fullTextSearchExpression) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotEmpty((String)fullTextSearchExpression, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = null;
        this.term = null;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public String getSelectorName() {
        return this.selectorName.getString();
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String fullTextSearchExpression() {
        return this.fullTextSearchExpression;
    }

    public StaticOperand getFullTextSearchExpression() {
        if (this.expression == null) {
            this.expression = new Literal(new Value(){

                public int getType() {
                    return 1;
                }

                public String getString() {
                    return FullTextSearch.this.fullTextSearchExpression();
                }

                public InputStream getStream() throws RepositoryException {
                    throw new ValueFormatException();
                }

                public long getLong() throws ValueFormatException, RepositoryException {
                    throw new ValueFormatException();
                }

                public double getDouble() throws ValueFormatException, RepositoryException {
                    throw new ValueFormatException();
                }

                public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
                    throw new ValueFormatException();
                }

                public Calendar getDate() throws ValueFormatException, RepositoryException {
                    throw new ValueFormatException();
                }

                public boolean getBoolean() throws ValueFormatException, RepositoryException {
                    throw new ValueFormatException();
                }

                public Binary getBinary() throws RepositoryException {
                    throw new ValueFormatException();
                }
            });
        }
        return this.expression;
    }

    public Term getTerm() {
        if (this.term == null) {
            this.term = new FullTextSearchParser().parse(this.fullTextSearchExpression);
        }
        return this.term;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FullTextSearch) {
            FullTextSearch that = (FullTextSearch)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.propertyName, (Object)that.propertyName)) {
                return false;
            }
            return this.fullTextSearchExpression.equals(that.fullTextSearchExpression);
        }
        return false;
    }

    public FullTextSearch withFullTextExpression(String expression) {
        return new FullTextSearch(this.selectorName, this.propertyName, expression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public static class Conjunction
    extends CompoundTerm {
        public Conjunction(List<Term> terms) {
            super(terms);
        }

        public String toString() {
            return this.toString("AND");
        }
    }

    public static class Disjunction
    extends CompoundTerm {
        public Disjunction(List<Term> terms) {
            super(terms);
        }

        public String toString() {
            return this.toString("OR");
        }
    }

    public static abstract class CompoundTerm
    implements Term,
    Iterable<Term> {
        private final List<Term> terms;

        protected CompoundTerm(List<Term> terms) {
            this.terms = terms;
        }

        public List<Term> getTerms() {
            return this.terms;
        }

        @Override
        public Iterator<Term> iterator() {
            return this.terms.iterator();
        }

        public int hashCode() {
            return ((Object)this.terms).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.getClass().isInstance(obj)) {
                CompoundTerm that = (CompoundTerm)obj;
                return ((Object)this.getTerms()).equals(that.getTerms());
            }
            return false;
        }

        protected String toString(String delimiter) {
            if (this.terms.size() == 1) {
                return this.terms.iterator().next().toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("( ");
            boolean first = true;
            for (Term term : this.terms) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ').append(delimiter).append(' ');
                }
                sb.append(term);
            }
            sb.append(" )");
            return sb.toString();
        }
    }

    public static class SimpleTerm
    implements Term {
        private final String value;
        private final boolean quoted;

        public SimpleTerm(String value) {
            assert (value != null);
            assert (value.trim().length() > 0);
            this.value = value;
            this.quoted = this.value.indexOf(32) != -1;
        }

        public String getValue() {
            return this.value;
        }

        public String[] getValues() {
            return this.value.split("/w");
        }

        public boolean isQuotingRequired() {
            return this.quoted;
        }

        public boolean containsWildcards() {
            if (this.value.length() == 0) {
                return false;
            }
            StringCharacterIterator iter = new StringCharacterIterator(this.value);
            boolean skipNext = false;
            char c = iter.first();
            while (c != '\uffff') {
                if (skipNext) {
                    skipNext = false;
                } else {
                    if (c == '*' || c == '?' || c == '%' || c == '_') {
                        return true;
                    }
                    if (c == '\\') {
                        skipNext = true;
                    }
                }
                c = iter.next();
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SimpleTerm) {
                SimpleTerm that = (SimpleTerm)obj;
                return this.getValue().equals(that.getValue());
            }
            return false;
        }

        public String toString() {
            return this.quoted ? "\"" + this.value + "\"" : this.value;
        }
    }

    public static class NegationTerm
    implements Term {
        private final Term negated;

        public NegationTerm(Term negatedTerm) {
            assert (negatedTerm != null);
            this.negated = negatedTerm;
        }

        public Term getNegatedTerm() {
            return this.negated;
        }

        public int hashCode() {
            return this.negated.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NegationTerm) {
                NegationTerm that = (NegationTerm)obj;
                return this.getNegatedTerm().equals(that.getNegatedTerm());
            }
            return false;
        }

        public String toString() {
            return "-" + this.negated.toString();
        }
    }

    public static interface Term {
    }
}

