/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.util.concurrent.TimeoutException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.AllPathsCache;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentAlreadyExistsException;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.ReferentialIntegrityException;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.document.AbstractSessionCache;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@ThreadSafe
public class WritableSessionCache
extends AbstractSessionCache {
    private static final AtomicInteger SAVE_NUMBER = new AtomicInteger(1);
    private static final int MAX_SAVE_NUMBER = 100;
    private static final Logger SAVE_LOGGER = Logger.getLogger((String)"org.modeshape.jcr.txn");
    private static final Logger LOGGER = Logger.getLogger(WritableSessionCache.class);
    private static final NodeKey REMOVED_KEY = new NodeKey("REMOVED_NODE_SHOULD_NEVER_BE_PERSISTED");
    private static final SessionNode REMOVED = new SessionNode(REMOVED_KEY, false);
    private static final int MAX_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 4;
    private static final long PAUSE_TIME_BEFORE_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 50L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<NodeKey, SessionNode> changedNodes = new HashMap<NodeKey, SessionNode>();
    private Set<NodeKey> replacedNodes;
    private LinkedHashSet<NodeKey> changedNodesInOrder = new LinkedHashSet();
    private Map<NodeKey, SessionNode.ReferrerChanges> referrerChangesForRemovedNodes = new HashMap<NodeKey, SessionNode.ReferrerChanges>();
    private final Transactions txns;

    public WritableSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, SessionEnvironment sessionContext) {
        super(context, workspaceCache, sessionContext);
        this.txns = sessionContext.getTransactions();
    }

    protected final void assertInSession(SessionNode node) {
        assert (this.changedNodes.get(node.getKey()) == node) : "Node " + node.getKey() + " is not in this session";
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedNode getNode(NodeKey key) {
        CachedNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == REMOVED) {
            return null;
        }
        return sessionNode != null ? sessionNode : super.getNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SessionNode mutable(NodeKey key) {
        SessionNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == null || sessionNode == REMOVED) {
            sessionNode = new SessionNode(key, false);
            lock = this.lock.writeLock();
            try {
                lock.lock();
                sessionNode = this.changedNodes.get(key);
                if (sessionNode != null) return sessionNode;
                sessionNode = new SessionNode(key, false);
                this.changedNodes.put(key, sessionNode);
                this.changedNodesInOrder.add(key);
                return sessionNode;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (this.changedNodesInOrder.contains(key)) return sessionNode;
            this.changedNodesInOrder.add(key);
        }
        return sessionNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear() {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.changedNodes.clear();
            this.changedNodesInOrder.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear(CachedNode node) {
        Path nodePath = node.getPath(this);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            List<SessionNode> nodesToRemoveInOrder = this.getChangedNodesAtOrBelowChildrenFirst(nodePath);
            for (SessionNode nodeToRemove : nodesToRemoveInOrder) {
                NodeKey key = nodeToRemove.getKey();
                this.changedNodes.remove(key);
                this.changedNodesInOrder.remove(key);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private List<SessionNode> getChangedNodesAtOrBelowChildrenFirst(Path nodePath) {
        ArrayList<SessionNode> changedNodesChildrenFirst = new ArrayList<SessionNode>();
        for (NodeKey key : this.changedNodes.keySet()) {
            SessionNode changedNode = this.changedNodes.get(key);
            boolean isAtOrBelow = false;
            try {
                isAtOrBelow = changedNode.isAtOrBelow(this, nodePath);
            }
            catch (NodeNotFoundException e) {
                isAtOrBelow = false;
            }
            if (!isAtOrBelow) continue;
            int insertIndex = changedNodesChildrenFirst.size();
            Path changedNodePath = changedNode.getPath(this);
            for (int i = 0; i < changedNodesChildrenFirst.size(); ++i) {
                if (!((SessionNode)changedNodesChildrenFirst.get(i)).getPath(this).isAncestorOf(changedNodePath)) continue;
                insertIndex = i;
                break;
            }
            changedNodesChildrenFirst.add(insertIndex, changedNode);
        }
        return changedNodesChildrenFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeys() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet<NodeKey> hashSet = new HashSet<NodeKey>(this.changedNodes.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeysAtOrBelow(CachedNode srcNode) {
        CheckArg.isNotNull((Object)srcNode, (String)"srcNode");
        Path sourcePath = srcNode.getPath(this);
        WorkspaceCache workspaceCache = this.workspaceCache();
        AllPathsCache allPathsCache = new AllPathsCache(this, workspaceCache, this.context()){

            @Override
            protected Set<NodeKey> getAdditionalParentKeys(CachedNode node, NodeCache cache) {
                SessionNode sessionNode;
                SessionNode.ChangedAdditionalParents changed;
                Set<NodeKey> keys = super.getAdditionalParentKeys(node, cache);
                if (node instanceof SessionNode && (changed = (sessionNode = (SessionNode)node).additionalParents()) != null) {
                    keys = new HashSet<NodeKey>(keys);
                    keys.addAll(sessionNode.additionalParents().getRemovals());
                }
                return keys;
            }
        };
        Lock readLock = this.lock.readLock();
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        try {
            readLock.lock();
            block3: for (Map.Entry<NodeKey, SessionNode> entry : this.changedNodes.entrySet()) {
                SessionNode changedNodeThisSession = entry.getValue();
                NodeKey changedNodeKey = entry.getKey();
                CachedNode changedNode = null;
                if (changedNodeThisSession == REMOVED) {
                    CachedNode persistentRemovedNode = workspaceCache.getNode(changedNodeKey);
                    if (persistentRemovedNode == null) {
                        result.add(changedNodeKey);
                        continue;
                    }
                    changedNode = persistentRemovedNode;
                } else {
                    changedNode = changedNodeThisSession;
                }
                for (Path validPath : allPathsCache.getPaths(changedNode)) {
                    if (!validPath.isAtOrBelow(sourcePath)) continue;
                    result.add(changedNodeKey);
                    continue block3;
                }
            }
            HashSet<NodeKey> hashSet = result;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanges() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            boolean bl = !this.changedNodesInOrder.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected final void logChangesBeingSaved(Iterable<NodeKey> firstNodesInOrder, Map<NodeKey, SessionNode> firstNodes, Iterable<NodeKey> secondNodesInOrder, Map<NodeKey, SessionNode> secondNodes) {
        if (SAVE_LOGGER.isTraceEnabled()) {
            SessionNode node;
            String txn = this.txns.currentTransactionId();
            int s = SAVE_NUMBER.getAndIncrement();
            if (s == 100) {
                SAVE_NUMBER.set(1);
            }
            int changes = 0;
            ExecutionContext context = this.getContext();
            String id = context.getId();
            String username = context.getSecurityContext().getUserName();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            if (username == null) {
                username = "<anonymous>";
            }
            SAVE_LOGGER.trace("Save #{0} (part of transaction '{1}') by session {2}({3}) is persisting the following changes:", new Object[]{s, txn, username, id});
            for (NodeKey key : firstNodesInOrder) {
                node = this.changedNodes.get(key);
                if (node == null || !node.hasChanges()) continue;
                SAVE_LOGGER.trace(" #{0} {1}", new Object[]{s, node.getString(registry)});
                ++changes;
            }
            if (secondNodesInOrder != null) {
                for (NodeKey key : secondNodesInOrder) {
                    node = this.changedNodes.get(key);
                    if (node == null || !node.hasChanges()) continue;
                    SAVE_LOGGER.trace(" #{0} {1}", new Object[]{s, node.getString(registry)});
                    ++changes;
                }
            }
            SAVE_LOGGER.trace("Save #{0} (part of transaction '{1}') by session {2}({3}) completed persisting changes to {4} nodes", new Object[]{s, txn, username, id, changes});
        }
    }

    @Override
    public void save() {
        this.save(null);
    }

    /*
     * Exception decompiling
     */
    protected void save(SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runPreSaveBeforeTransaction(SessionCache.PreSave preSaveOperation) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (SessionNode node : this.changedNodes.values()) {
                if (node == REMOVED) continue;
                this.checkNodeNotRemovedByAnotherTransaction(node);
                preSaveOperation.process(node, saveContext);
            }
        }
    }

    private void runPreSaveAfterLocking(SessionCache.PreSave preSaveOperation) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (SessionNode node : this.changedNodes.values()) {
                if (node == REMOVED || node.isNew()) continue;
                preSaveOperation.processAfterLocking(node, saveContext, this.workspaceCache());
            }
        }
    }

    protected void clearState() {
        this.changedNodes = new HashMap<NodeKey, SessionNode>();
        this.referrerChangesForRemovedNodes.clear();
        this.changedNodesInOrder.clear();
        this.replacedNodes = null;
        this.checkForTransaction();
    }

    protected void clearState(Iterable<NodeKey> savedNodesInOrder) {
        for (NodeKey savedNode : savedNodesInOrder) {
            this.changedNodes.remove(savedNode);
            this.changedNodesInOrder.remove(savedNode);
            if (this.replacedNodes == null) continue;
            this.replacedNodes.remove(savedNode);
        }
        this.checkForTransaction();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void save(SessionCache other, SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkNodeNotRemovedByAnotherTransaction(MutableCachedNode node) {
        String keyString = node.getKey().toString();
        if (!node.isNew() && !this.workspaceCache().documentStore().containsKey(keyString)) {
            throw new DocumentNotFoundException(keyString);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void save(Set<NodeKey> toBeSaved, SessionCache other, SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Could not resolve type clashes
     */
    protected ChangeSet persistChanges(Iterable<NodeKey> changedNodesInOrder, SessionEnvironment.Monitor monitor) {
        ExecutionContext context = this.context();
        String userId = context.getSecurityContext().getUserName();
        Map<String, String> userData = context.getData();
        DateTime timestamp = context.getValueFactories().getDateFactory().create();
        String workspaceName = this.workspaceCache().getWorkspaceName();
        String repositoryKey = this.workspaceCache().getRepositoryKey();
        String processKey = this.workspaceCache().getProcessKey();
        RecordingChanges changes = new RecordingChanges(processKey, repositoryKey, workspaceName);
        WorkspaceCache workspaceCache = this.workspaceCache();
        DocumentStore documentStore = workspaceCache.documentStore();
        DocumentTranslator translator = workspaceCache.translator();
        PathCache sessionPaths = new PathCache(this);
        PathCache workspacePaths = new PathCache(workspaceCache);
        HashSet<NodeKey> removedNodes = null;
        HashSet<BinaryKey> unusedBinaryKeys = new HashSet<BinaryKey>();
        HashSet<NodeKey> renamedExternalNodes = new HashSet<NodeKey>();
        for (Comparable<NodeKey> key : changedNodesInOrder) {
            ChildReference ref;
            EditableDocument doc;
            CachedNode persisted;
            boolean isExternal;
            SessionNode node = this.changedNodes.get(key);
            String keyStr = key.toString();
            boolean bl = isExternal = !node.getKey().getSourceKey().equalsIgnoreCase(this.workspaceCache().getRootKey().getSourceKey());
            if (node == REMOVED) {
                persisted = workspaceCache.getNode((NodeKey)key);
                if (persisted == null) continue;
                if (removedNodes == null) {
                    removedNodes = new HashSet<NodeKey>();
                }
                Path path = workspacePaths.getPath(persisted);
                changes.nodeRemoved((NodeKey)key, persisted.getParentKey(workspaceCache), path);
                removedNodes.add((NodeKey)key);
                SessionNode.ReferrerChanges referrerChanges = this.referrerChangesForRemovedNodes.get(key);
                if (referrerChanges == null) continue;
                doc = documentStore.get(keyStr).editDocumentContent();
                translator.changeReferrers(doc, referrerChanges);
                continue;
            }
            persisted = null;
            Path newPath = sessionPaths.getPath(node);
            NodeKey newParent = node.newParent();
            doc = null;
            SessionNode.ChangedAdditionalParents additionalParents = node.additionalParents();
            if (node.isNew()) {
                doc = Schematic.newDocument();
                translator.setKey(doc, (NodeKey)key);
                translator.setParents(doc, newParent, null, additionalParents);
                changes.nodeCreated((NodeKey)key, newParent, newPath, (Map<Name, Property>)node.changedProperties());
            } else {
                SchematicEntry nodeEntry = documentStore.get(keyStr);
                if (nodeEntry == null) {
                    if (isExternal && renamedExternalNodes.contains(key)) continue;
                    throw new DocumentNotFoundException(keyStr);
                }
                doc = nodeEntry.editDocumentContent();
                if (newParent != null) {
                    persisted = workspaceCache.getNode((NodeKey)key);
                    Path oldPath = workspacePaths.getPath(persisted);
                    NodeKey oldParentKey = persisted.getParentKey(workspaceCache);
                    if (!oldParentKey.equals(newParent) || additionalParents != null && !additionalParents.isEmpty()) {
                        translator.setParents(doc, node.newParent(), oldParentKey, additionalParents);
                    }
                    changes.nodeMoved((NodeKey)key, newParent, oldParentKey, newPath, oldPath);
                } else if (additionalParents != null) {
                    translator.setParents(doc, null, null, additionalParents);
                }
                SessionNode.MixinChanges mixinChanges = node.mixinChanges(false);
                if (mixinChanges != null && !mixinChanges.isEmpty()) {
                    Property oldProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    translator.addPropertyValues(doc, JcrLexicon.MIXIN_TYPES, true, mixinChanges.getAdded(), unusedBinaryKeys);
                    translator.removePropertyValues(doc, JcrLexicon.MIXIN_TYPES, mixinChanges.getRemoved(), unusedBinaryKeys);
                    Property newProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    if (oldProperty == null) {
                        changes.propertyAdded((NodeKey)key, newPath, newProperty);
                    } else if (newProperty == null) {
                        changes.propertyRemoved((NodeKey)key, newPath, oldProperty);
                    } else {
                        changes.propertyChanged((NodeKey)key, newPath, newProperty, oldProperty);
                    }
                }
            }
            SessionNode.LockChange lockChange = node.getLockChange();
            if (lockChange != null) {
                switch (lockChange) {
                    case LOCK_FOR_SESSION: 
                    case LOCK_FOR_NON_SESSION: {
                        if (!translator.isLocked(doc)) break;
                        throw new LockFailureException((NodeKey)key);
                    }
                }
            }
            boolean hasPropertyChanges = false;
            Set<Name> removedProperties = node.removedProperties();
            if (!removedProperties.isEmpty()) {
                assert (!node.isNew());
                if (persisted == null) {
                    persisted = workspaceCache.getNode((NodeKey)key);
                }
                for (Name name : removedProperties) {
                    Property oldProperty = translator.removeProperty(doc, name, unusedBinaryKeys);
                    if (oldProperty == null) continue;
                    changes.propertyRemoved((NodeKey)key, newPath, oldProperty);
                    hasPropertyChanges = true;
                }
            }
            if (!node.changedProperties().isEmpty()) {
                if (!node.isNew() && persisted == null) {
                    persisted = workspaceCache.getNode((NodeKey)key);
                }
                for (Map.Entry propEntry : node.changedProperties().entrySet()) {
                    Name name = (Name)propEntry.getKey();
                    Property prop = (Property)propEntry.getValue();
                    Property oldProperty = persisted != null ? persisted.getProperty(name, workspaceCache) : null;
                    translator.setProperty(doc, prop, unusedBinaryKeys);
                    if (oldProperty == null) {
                        changes.propertyAdded((NodeKey)key, newPath, prop);
                        hasPropertyChanges = true;
                        continue;
                    }
                    if (!hasPropertyChanges && oldProperty.equals(prop)) continue;
                    changes.propertyChanged((NodeKey)key, newPath, prop, oldProperty);
                    hasPropertyChanges = true;
                }
            }
            SessionNode.ChangedChildren changedChildren = node.changedChildren();
            MutableChildReferences appended = node.appended(false);
            if ((changedChildren == null || changedChildren.isEmpty()) && appended != null && !appended.isEmpty()) {
                translator.changeChildren(doc, changedChildren, appended);
            } else if (changedChildren != null && !changedChildren.isEmpty()) {
                if (!changedChildren.getRemovals().isEmpty()) {
                    for (NodeKey removed : changedChildren.getRemovals()) {
                        CachedNode persistent = workspaceCache.getNode(removed);
                        if (persistent == null) continue;
                        Path oldPath = workspacePaths.getPath(persistent);
                        if (appended == null || !appended.hasChild(persistent.getKey())) continue;
                        ChildReference appendedChildRef = node.getChildReferences(this).getChild(persistent.getKey());
                        newPath = this.pathFactory().create(sessionPaths.getPath(node), appendedChildRef.getSegment());
                        changes.nodeReordered(persistent.getKey(), node.getKey(), newPath, oldPath, null);
                    }
                }
                translator.changeChildren(doc, changedChildren, appended);
                Map<NodeKey, Name> newNames = changedChildren.getNewNames();
                if (!newNames.isEmpty()) {
                    for (Map.Entry<Object, Object> renameEntry : newNames.entrySet()) {
                        NodeKey renamedKey = (NodeKey)renameEntry.getKey();
                        CachedNode oldRenamedNode = workspaceCache.getNode(renamedKey);
                        if (oldRenamedNode == null) continue;
                        Path renamedFromPath = workspacePaths.getPath(oldRenamedNode);
                        Path renamedToPath = this.pathFactory().create(renamedFromPath.getParent(), (Name)renameEntry.getValue());
                        changes.nodeRenamed(renamedKey, renamedToPath, renamedFromPath.getLastSegment());
                        if (!isExternal) continue;
                        renamedExternalNodes.add(renamedKey);
                    }
                }
                Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
                for (SessionNode.Insertions insertion : insertionsByBeforeKey.values()) {
                    for (ChildReference insertedRef : insertion.inserted()) {
                        boolean isSnsReordering;
                        CachedNode insertedNodePersistent = workspaceCache.getNode(insertedRef);
                        Path nodeOldPath = insertedNodePersistent != null ? workspacePaths.getPath(insertedNodePersistent) : null;
                        CachedNode insertedBeforeNode = workspaceCache.getNode(insertion.insertedBefore());
                        Path insertedBeforePath = workspacePaths.getPath(insertedBeforeNode);
                        Path nodeNewPath = null;
                        nodeNewPath = nodeOldPath != null ? ((isSnsReordering = nodeOldPath.getLastSegment().getName().equals(insertedBeforePath.getLastSegment().getName())) ? insertedBeforePath : nodeOldPath) : sessionPaths.getPath(this.changedNodes.get(insertedRef.getKey()));
                        changes.nodeReordered(insertedRef.getKey(), node.getKey(), nodeNewPath, nodeOldPath, insertedBeforePath);
                    }
                }
            }
            SessionNode.ReferrerChanges referrerChanges = node.getReferrerChanges();
            if (referrerChanges != null && !referrerChanges.isEmpty()) {
                translator.changeReferrers(doc, referrerChanges);
                changes.nodeChanged((NodeKey)key, newPath);
            }
            for (Map.Entry<String, String> federatedSegment : node.getAddedFederatedSegments().entrySet()) {
                translator.addFederatedSegment(doc, federatedSegment.getKey(), federatedSegment.getValue());
            }
            translator.removeFederatedSegments(doc, node.getRemovedFederatedSegments());
            boolean queryable = node.isQueryable(this);
            if (!queryable) {
                translator.setQueryable(doc, false);
            }
            if (node.isNew()) {
                if (documentStore.storeDocument(keyStr, (Document)doc) != null) {
                    if (this.replacedNodes != null && this.replacedNodes.contains(key)) {
                        documentStore.localStore().put(keyStr, (Document)doc);
                    } else if (removedNodes != null && removedNodes.contains(key)) {
                        documentStore.localStore().put(keyStr, (Document)doc);
                        removedNodes.remove(key);
                    } else {
                        throw new DocumentAlreadyExistsException(keyStr);
                    }
                }
                if (monitor != null && queryable) {
                    Name primaryType = node.getPrimaryType(this);
                    Set<Name> mixinTypes = node.getMixinTypes(this);
                    monitor.recordAdd(workspaceName, (NodeKey)key, newPath, primaryType, mixinTypes, node.changedProperties().values().iterator());
                }
            } else {
                boolean shouldUpdateIndexes;
                boolean externalNodeChanged = isExternal && (hasPropertyChanges || node.hasNonPropertyChanges() || node.changedChildren().renameCount() > 0);
                boolean isSameWorkspace = this.workspaceCache().getWorkspaceKey().equalsIgnoreCase(node.getKey().getWorkspaceKey());
                Path oldNodePath = workspacePaths.getPath(workspaceCache.getNode(node.getKey()));
                Path newNodePath = sessionPaths.getPath(node);
                boolean pathChanged = !oldNodePath.equals(newNodePath);
                boolean bl2 = shouldUpdateIndexes = isSameWorkspace && (hasPropertyChanges || node.hasIndexRelatedChanges() || pathChanged) || externalNodeChanged;
                if (monitor != null && queryable && shouldUpdateIndexes) {
                    ChildReference persistedNodeAtNewPath;
                    CachedNode persistedParent;
                    Name primaryType = node.getPrimaryType(this);
                    Set<Name> mixinTypes = node.getMixinTypes(this);
                    monitor.recordUpdate(workspaceName, (NodeKey)key, newNodePath, primaryType, mixinTypes, node.getProperties(this));
                    if (pathChanged && (persistedParent = workspaceCache.getNode(node.getParentKey(this))) != null && (persistedNodeAtNewPath = persistedParent.getChildReferences(workspaceCache).getChild(newNodePath.getLastSegment().getName(), newNodePath.getLastSegment().getIndex())) != null) {
                        monitor.recordRemove(workspaceName, Arrays.asList(persistedNodeAtNewPath.getKey()));
                    }
                    this.updateIndexesForAllChildren(node, sessionPaths, workspaceName, monitor);
                }
                if (externalNodeChanged) {
                    documentStore.updateDocument(keyStr, (Document)doc, node);
                }
            }
            if (additionalParents == null) continue;
            for (NodeKey parentKey : additionalParents.getAdditions()) {
                SessionNode parent = this.changedNodes.get(parentKey);
                if (parent == null) continue;
                ref = parent.getChildReferences(this).getChild((NodeKey)key);
                Path parentPath = sessionPaths.getPath(parent);
                Path childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeCreated((NodeKey)key, parentKey, childPath, null);
            }
            for (NodeKey parentKey : additionalParents.getRemovals()) {
                CachedNode persistedParent = workspaceCache.getNode(parentKey);
                if (persistedParent == null || (ref = persistedParent.getChildReferences(this).getChild((NodeKey)key)) == null) continue;
                Path parentPath = workspacePaths.getPath(persistedParent);
                Path childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeRemoved((NodeKey)key, parentKey, childPath);
            }
        }
        if (removedNodes != null) {
            assert (!removedNodes.isEmpty());
            HashSet<NodeKey> referrers = new HashSet<NodeKey>();
            for (NodeKey removedKey : removedNodes) {
                SchematicEntry entry = documentStore.get(removedKey.toString());
                if (entry == null) continue;
                Document doc = documentStore.get(removedKey.toString()).getContentAsDocument();
                referrers.addAll(translator.getReferrers(doc, CachedNode.ReferenceType.STRONG));
            }
            referrers.removeAll(removedNodes);
            if (!referrers.isEmpty()) {
                throw new ReferentialIntegrityException((Set<NodeKey>)removedNodes, referrers);
            }
            for (NodeKey removedKey : removedNodes) {
                documentStore.remove(removedKey.toString());
            }
            if (monitor != null) {
                monitor.recordRemove(workspaceName, (Iterable<NodeKey>)removedNodes);
            }
        }
        if (!unusedBinaryKeys.isEmpty()) {
            for (Comparable<NodeKey> key : unusedBinaryKeys) {
                changes.binaryValueNoLongerUsed((BinaryKey)key);
            }
        }
        changes.setChangedNodes(this.changedNodes.keySet());
        changes.freeze(userId, userData, timestamp);
        return changes;
    }

    private void updateIndexesForAllChildren(CachedNode parentNode, PathCache sessionPaths, String workspaceName, SessionEnvironment.Monitor indexingMonitor) {
        for (ChildReference childReference : parentNode.getChildReferences(this)) {
            Path parentNodePath = sessionPaths.getPath(parentNode);
            Path newChildPath = this.pathFactory().create(parentNodePath, childReference.getSegment());
            NodeKey childKey = childReference.getKey();
            CachedNode child = this.getNode(childKey);
            if (child == null || child instanceof SessionNode && ((SessionNode)child).hasIndexRelatedChanges()) continue;
            indexingMonitor.recordUpdate(workspaceName, childKey, newChildPath, child.getPrimaryType(this), child.getMixinTypes(this), child.getProperties(this));
            this.updateIndexesForAllChildren(child, sessionPaths, workspaceName, indexingMonitor);
        }
    }

    private void lockAndPurgeCache(Iterable<NodeKey> changedNodesInOrder) {
        DocumentStore documentStore = this.workspaceCache().documentStore();
        if (documentStore.updatesRequirePreparing()) {
            LOGGER.debug("Locking nodes in Infinispan", new Object[0]);
            HashSet<String> keysToLock = new HashSet<String>();
            for (NodeKey key : changedNodesInOrder) {
                SessionNode node = this.changedNodes.get(key);
                if (node == REMOVED || node.isNew()) continue;
                String keyStr = key.toString();
                keysToLock.add(keyStr);
            }
            if (!documentStore.prepareDocumentsForUpdate(keysToLock) && !documentStore.prepareDocumentsForUpdate(keysToLock)) {
                throw new TimeoutException("Unable to acquire storage locks: " + keysToLock);
            }
            this.workspaceCache().purge(changedNodesInOrder);
        } else {
            LOGGER.debug("Infinispan is not configured with pessimistic locks, no nodes will be locked", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionNode add(SessionNode newNode) {
        assert (newNode != REMOVED);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            NodeKey key = newNode.getKey();
            SessionNode node = this.changedNodes.put(key, newNode);
            if (node != null) {
                if (node != REMOVED) {
                    this.changedNodes.put(key, node);
                    SessionNode sessionNode = node;
                    return sessionNode;
                }
                if (this.replacedNodes == null) {
                    this.replacedNodes = new HashSet<NodeKey>();
                }
                this.replacedNodes.add(key);
            }
            this.changedNodesInOrder.add(key);
            SessionNode sessionNode = newNode;
            return sessionNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(NodeKey key) {
        assert (key != null);
        WorkspaceCache workspace = this.workspaceCache();
        CachedNode topNode = this.getNode(key);
        if (topNode == null) {
            throw new NodeNotFoundException(key);
        }
        HashMap<NodeKey, SessionNode> removed = new HashMap<NodeKey, SessionNode>();
        LinkedHashSet<NodeKey> addToChangedNodes = new LinkedHashSet<NodeKey>();
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            LinkedList<NodeKey> keys = new LinkedList<NodeKey>();
            keys.add(key);
            while (!keys.isEmpty()) {
                NodeKey nodeKey = (NodeKey)keys.remove();
                SessionNode node = this.changedNodes.put(nodeKey, REMOVED);
                boolean cleanupReferences = false;
                ChildReferences children = null;
                if (node != null) {
                    if (node == REMOVED) continue;
                    children = node.getChildReferences(this);
                    removed.put(nodeKey, node);
                    this.referrerChangesForRemovedNodes.put(nodeKey, node.getReferrerChanges());
                    cleanupReferences = true;
                } else {
                    addToChangedNodes.add(nodeKey);
                    CachedNode persisted = workspace.getNode(nodeKey);
                    if (persisted == null) continue;
                    children = persisted.getChildReferences(workspace);
                    Iterator<Property> it = persisted.getProperties(workspace);
                    while (it.hasNext()) {
                        Property property = it.next();
                        if (property == null || !property.isReference()) continue;
                        this.changedNodes.remove(nodeKey);
                        node = this.mutable(nodeKey);
                        if (node != null) {
                            cleanupReferences = true;
                        }
                        this.changedNodes.put(nodeKey, REMOVED);
                    }
                }
                if (cleanupReferences) {
                    assert (node != null);
                    node.removeAllReferences(this);
                }
                assert (children != null);
                for (ChildReference child : children) {
                    NodeKey childKey = child.getKey();
                    if (!childKey.getSourceKey().equalsIgnoreCase(key.getSourceKey())) continue;
                    keys.add(childKey);
                }
            }
            this.changedNodesInOrder.addAll(addToChangedNodes);
        }
        catch (RuntimeException e) {
            try {
                this.changedNodes.putAll(removed);
            }
            catch (RuntimeException e2) {
                I18n msg = JcrI18n.failedWhileRollingBackDestroyToRuntimeError;
                LOGGER.error((Throwable)e2, (I18nResource)msg, new Object[]{e2.getMessage(), e.getMessage()});
            }
            finally {
                throw e;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isDestroyed(NodeKey key) {
        return this.changedNodes.get(key) == REMOVED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NamespaceRegistry reg = this.context().getNamespaceRegistry();
        sb.append("Session ").append(this.context().getId()).append(" to workspace '").append(this.workspaceName());
        for (NodeKey key : this.changedNodesInOrder) {
            SessionNode changes = this.changedNodes.get(key);
            if (changes == null) continue;
            sb.append("\n ");
            sb.append(changes.getString(reg));
        }
        return sb.toString();
    }
}

