/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.basic.BasicProperty;
import org.modeshape.jcr.value.basic.NodeKeyReference;

@Immutable
public class BasicSingleValueProperty
extends BasicProperty {
    private static final long serialVersionUID = 1L;
    protected final Object value;

    public BasicSingleValueProperty(Name name, Object value) {
        super(name);
        this.value = value;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean isReference() {
        Object firstValue = this.getFirstValue();
        if (firstValue instanceof NodeKeyReference) {
            return !((NodeKeyReference)firstValue).isSimple();
        }
        return firstValue instanceof Reference;
    }

    @Override
    public boolean isSimpleReference() {
        Object firstValue = this.getFirstValue();
        return firstValue instanceof Reference && ((Reference)firstValue).isSimple();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object getFirstValue() {
        return this.value;
    }

    @Override
    public Iterator<Object> iterator() {
        return new ValueIterator();
    }

    protected class ValueIterator
    implements Iterator<Object> {
        private boolean done = false;

        protected ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Object next() {
            if (!this.done) {
                this.done = true;
                return BasicSingleValueProperty.this.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

