/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.List;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.process.DelegatingComponent;
import org.modeshape.jcr.query.process.ProcessingComponent;

public class LimitComponent
extends DelegatingComponent {
    private final Limit limit;

    public LimitComponent(ProcessingComponent delegate, Limit limit) {
        super(delegate);
        this.limit = limit;
        assert (this.limit != null);
    }

    @Override
    public List<Object[]> execute() {
        if (this.limit.getRowLimit() == 0) {
            return this.emptyTuples();
        }
        List<Object[]> tuples = this.delegate().execute();
        if (this.limit.isOffset()) {
            if (this.limit.getOffset() >= tuples.size()) {
                return this.emptyTuples();
            }
            if (this.limit.hasRowLimited()) {
                int toIndex = Math.min(tuples.size(), Math.max(0, this.limit.getOffset() + this.limit.getRowLimit()));
                tuples = tuples.subList(this.limit.getOffset(), toIndex);
            } else {
                tuples = tuples.subList(this.limit.getOffset(), tuples.size());
            }
        } else if (this.limit.hasRowLimited()) {
            int toIndex = Math.min(this.limit.getRowLimit(), tuples.size());
            tuples = tuples.subList(0, toIndex);
        }
        return tuples;
    }
}

