/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.SearchFactory;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.query.qom.Between;
import org.modeshape.jcr.api.query.qom.NodeDepth;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.lucene.CaseOperations;
import org.modeshape.jcr.query.lucene.HasValueQuery;
import org.modeshape.jcr.query.lucene.LuceneException;
import org.modeshape.jcr.query.lucene.RelikeQuery;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

@NotThreadSafe
public abstract class LuceneQueryFactory {
    private static final PhraseQuery EMPTY_PHRASE_QUERY = new PhraseQuery();
    protected final QueryContext context;
    protected final SearchFactory searchFactory;
    protected final ValueFactories factories;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final ValueFactory<String> stringFactory;
    protected final Version version;
    private Schemata schemata;

    protected LuceneQueryFactory(QueryContext context, SearchFactory searchFactory, Version version) {
        this.context = context;
        this.searchFactory = searchFactory;
        this.version = version;
        this.factories = this.context.getExecutionContext().getValueFactories();
        this.pathFactory = this.factories.getPathFactory();
        this.nameFactory = this.factories.getNameFactory();
        this.stringFactory = this.factories.getStringFactory();
    }

    /*
     * WARNING - void declaration
     */
    public Query createQuery(SelectorName selectorName, Constraint constraint) throws IOException {
        if (constraint instanceof And) {
            And and = (And)constraint;
            Query leftQuery = this.createQuery(selectorName, and.left());
            Query rightQuery = this.createQuery(selectorName, and.right());
            if (leftQuery == null || rightQuery == null) {
                return null;
            }
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(leftQuery, BooleanClause.Occur.MUST);
            booleanQuery.add(rightQuery, BooleanClause.Occur.MUST);
            return booleanQuery;
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            Query leftQuery = this.createQuery(selectorName, or.left());
            Query rightQuery = this.createQuery(selectorName, or.right());
            if (leftQuery == null) {
                return rightQuery != null ? rightQuery : null;
            }
            if (rightQuery == null) {
                return leftQuery;
            }
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(leftQuery, BooleanClause.Occur.SHOULD);
            booleanQuery.add(rightQuery, BooleanClause.Occur.SHOULD);
            return booleanQuery;
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            return this.not(this.createQuery(selectorName, not.getConstraint()));
        }
        if (constraint instanceof SetCriteria) {
            StaticOperand rightOperand;
            SetCriteria setCriteria = (SetCriteria)constraint;
            org.modeshape.jcr.query.model.DynamicOperand left = setCriteria.leftOperand();
            int numRightOperands = setCriteria.rightOperands().size();
            assert (numRightOperands > 0);
            if (numRightOperands == 1 && (rightOperand = (StaticOperand)setCriteria.rightOperands().iterator().next()) instanceof Literal) {
                return this.createQuery(selectorName, left, Operator.EQUAL_TO, setCriteria.rightOperands().iterator().next());
            }
            BooleanQuery setQuery = new BooleanQuery();
            for (StaticOperand staticOperand : setCriteria.rightOperands()) {
                if (staticOperand instanceof BindVariableName) {
                    BindVariableName var = (BindVariableName)staticOperand;
                    Object value = this.context.getVariables().get(var.getBindVariableName());
                    if (value instanceof Iterable) {
                        for (Object resolvedValue : (Iterable)value) {
                            if (resolvedValue == null) continue;
                            if (resolvedValue instanceof Object[]) {
                                for (Object val : (Object[])resolvedValue) {
                                    this.addQueryForValue(setQuery, selectorName, left, val);
                                }
                                continue;
                            }
                            this.addQueryForValue(setQuery, selectorName, left, resolvedValue);
                        }
                    }
                    if (value != null) continue;
                    throw new LuceneException(JcrI18n.missingVariableValue.text(new Object[]{var.getBindVariableName()}));
                }
                Query rightQuery = this.createQuery(selectorName, left, Operator.EQUAL_TO, staticOperand);
                if (rightQuery == null) {
                    return null;
                }
                setQuery.add(rightQuery, BooleanClause.Occur.SHOULD);
            }
            return setQuery;
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence existence = (PropertyExistence)constraint;
            return this.createQuery(selectorName, existence);
        }
        if (constraint instanceof Between) {
            Between between = (Between)constraint;
            DynamicOperand operand = between.getOperand();
            StaticOperand lower = between.getLowerBound();
            StaticOperand upper = between.getUpperBound();
            return this.createQuery(selectorName, operand, lower, upper, between.isLowerBoundIncluded(), between.isUpperBoundIncluded(), null);
        }
        if (constraint instanceof Relike) {
            Relike relike = (Relike)constraint;
            org.modeshape.jcr.query.model.StaticOperand op1 = relike.getOperand1();
            PropertyValue op2 = relike.getOperand2();
            Object relikeValue = this.createOperand(selectorName, op1, null);
            assert (relikeValue != null);
            String filedName = op2.getPropertyName();
            return new RelikeQuery(filedName, relikeValue.toString());
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            return this.createQuery(selectorName, comparison.getOperand1(), comparison.operator(), comparison.getOperand2());
        }
        if (constraint instanceof FullTextSearch) {
            FullTextSearch search = (FullTextSearch)constraint;
            String propertyName = search.getPropertyName();
            if (propertyName != null) {
                propertyName = this.fieldNameFor(propertyName);
            }
            String fieldName = this.fullTextFieldName(propertyName);
            org.modeshape.jcr.query.model.StaticOperand expression = search.getFullTextSearchExpression();
            if (expression instanceof BindVariableName) {
                void var8_42;
                BindVariableName bindVariable = (BindVariableName)expression;
                Object object = this.context.getVariables().get(bindVariable.getBindVariableName());
                if (object == null) {
                    throw new LuceneException(JcrI18n.missingVariableValue.text(new Object[]{bindVariable.getBindVariableName()}));
                }
                if (object instanceof Literal) {
                    Object object2 = ((Literal)object).value();
                }
                search = search.withFullTextExpression(var8_42.toString());
            }
            return this.createQuery(selectorName, fieldName, search.getTerm());
        }
        if (constraint instanceof SameNode) {
            SameNode sameNode = (SameNode)constraint;
            Path path = (Path)this.pathFactory.create(sameNode.getPath());
            return this.findNodeAt(path);
        }
        if (constraint instanceof ChildNode) {
            ChildNode childNode = (ChildNode)constraint;
            Path path = (Path)this.pathFactory.create(childNode.getParentPath());
            return this.findChildNodes(path);
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            Path path = (Path)this.pathFactory.create(descendantNode.getAncestorPath());
            return this.findAllNodesBelow(path);
        }
        assert (false) : "Unexpected Constraint instance: class=" + (constraint != null ? constraint.getClass() : "null") + " and instance=" + constraint;
        return null;
    }

    private Object convertBindVariableValue(Object value) {
        if (value instanceof Path || value instanceof Name || value instanceof Binary) {
            return this.stringFactory.create(value);
        }
        return value;
    }

    private void addQueryForValue(BooleanQuery setQuery, SelectorName selectorName, DynamicOperand left, Object resolvedValue) throws IOException {
        Literal elementInRight = null;
        if (resolvedValue instanceof Literal) {
            elementInRight = (Literal)resolvedValue;
        } else {
            resolvedValue = this.convertBindVariableValue(resolvedValue);
            elementInRight = new Literal(resolvedValue);
        }
        Query rightQuery = this.createQuery(selectorName, left, Operator.EQUAL_TO, elementInRight);
        if (rightQuery != null) {
            setQuery.add(rightQuery, BooleanClause.Occur.SHOULD);
        }
    }

    public Query createQuery(SelectorName selectorName, DynamicOperand left, Operator operator, StaticOperand right) throws IOException {
        return this.createQuery(selectorName, left, operator, right, null);
    }

    protected Query createQuery(SelectorName selectorName, DynamicOperand left, Operator operator, StaticOperand right, CaseOperations.CaseOperation caseOperation) throws IOException {
        Object value = this.createOperand(selectorName, right, caseOperation);
        assert (value != null);
        if (left instanceof FullTextSearchScore) {
            return null;
        }
        if (left instanceof javax.jcr.query.qom.PropertyValue) {
            return this.findNodesWith(selectorName, (javax.jcr.query.qom.PropertyValue)left, operator, value, caseOperation);
        }
        if (left instanceof ReferenceValue) {
            return this.findNodesWith(selectorName, (ReferenceValue)left, operator, value);
        }
        if (left instanceof Length) {
            return this.findNodesWith(selectorName, (Length)left, operator, value);
        }
        if (left instanceof LowerCase) {
            LowerCase lowercase = (LowerCase)left;
            if (caseOperation == null) {
                caseOperation = CaseOperations.LOWERCASE;
            }
            return this.createQuery(selectorName, lowercase.getOperand(), operator, right, caseOperation);
        }
        if (left instanceof UpperCase) {
            UpperCase uppercase = (UpperCase)left;
            if (caseOperation == null) {
                caseOperation = CaseOperations.UPPERCASE;
            }
            return this.createQuery(selectorName, uppercase.getOperand(), operator, right, caseOperation);
        }
        if (left instanceof NodeDepth) {
            assert (operator != Operator.LIKE);
            return this.findNodesWith(selectorName, (NodeDepth)left, operator, value);
        }
        if (left instanceof NodePath) {
            return this.findNodesWith(selectorName, (NodePath)left, operator, value, caseOperation);
        }
        if (left instanceof NodeName) {
            return this.findNodesWith(selectorName, (NodeName)left, operator, value, caseOperation);
        }
        if (left instanceof NodeLocalName) {
            return this.findNodesWith(selectorName, (NodeLocalName)left, operator, value, caseOperation);
        }
        assert (false) : "Unexpected DynamicOperand instance: class=" + (left != null ? left.getClass() : "null") + " and instance=" + left;
        return null;
    }

    public Object createOperand(SelectorName selectorName, StaticOperand operand, CaseOperations.CaseOperation caseOperation) {
        Object value = null;
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        if (operand instanceof Literal) {
            Literal literal = (Literal)operand;
            value = literal.value();
        } else if (operand instanceof BindVariableName) {
            BindVariableName variable = (BindVariableName)operand;
            String variableName = variable.getBindVariableName();
            value = this.context.getVariables().get(variableName);
            if (value instanceof Iterable) {
                Iterator iter = ((Iterable)value).iterator();
                if (iter.hasNext()) {
                    return iter.next();
                }
                value = null;
            }
            if (value == null) {
                throw new LuceneException(JcrI18n.missingVariableValue.text(new Object[]{variableName}));
            }
            value = this.convertBindVariableValue(value);
        } else assert (false);
        return value;
    }

    public Query createQuery(SelectorName selectorName, DynamicOperand left, StaticOperand lower, StaticOperand upper, boolean includesLower, boolean includesUpper, CaseOperations.CaseOperation caseOperation) throws IOException {
        Object lowerValue = this.createOperand(selectorName, lower, caseOperation);
        Object upperValue = this.createOperand(selectorName, upper, caseOperation);
        assert (lowerValue != null);
        assert (upperValue != null);
        if (left instanceof NodeDepth) {
            return this.findNodesWithNumericRange(selectorName, (NodeDepth)left, lowerValue, upperValue, includesLower, includesUpper);
        }
        if (left instanceof javax.jcr.query.qom.PropertyValue) {
            PropertyType lowerType = PropertyType.discoverType(lowerValue);
            PropertyType upperType = PropertyType.discoverType(upperValue);
            if (upperType == lowerType) {
                switch (upperType) {
                    case DATE: 
                    case LONG: 
                    case DOUBLE: 
                    case DECIMAL: {
                        return this.findNodesWithNumericRange(selectorName, (javax.jcr.query.qom.PropertyValue)left, lowerValue, upperValue, includesLower, includesUpper);
                    }
                }
            }
        }
        BooleanQuery query = new BooleanQuery();
        Operator lowerOp = includesLower ? Operator.GREATER_THAN_OR_EQUAL_TO : Operator.GREATER_THAN;
        Operator upperOp = includesUpper ? Operator.LESS_THAN_OR_EQUAL_TO : Operator.LESS_THAN;
        Query lowerQuery = this.createQuery(selectorName, left, lowerOp, lower, caseOperation);
        Query upperQuery = this.createQuery(selectorName, left, upperOp, upper, caseOperation);
        if (lowerQuery == null || upperQuery == null) {
            return null;
        }
        query.add(lowerQuery, BooleanClause.Occur.MUST);
        query.add(upperQuery, BooleanClause.Occur.MUST);
        return query;
    }

    protected String stringValueFrom(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return this.stringFactory.create(value);
    }

    public Query createQuery(SelectorName selectorName, PropertyExistence existence) {
        String propertyName = existence.getPropertyName();
        if ("jcr:primaryType".equals(propertyName)) {
            return new MatchAllDocsQuery();
        }
        return new HasValueQuery(this.fieldNameFor(propertyName));
    }

    public Query createQuery(final SelectorName selectorName, String fieldName, FullTextSearch.Term term) throws IOException {
        assert (fieldName != null);
        if (term instanceof FullTextSearch.Conjunction) {
            FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)term;
            BooleanQuery query = new BooleanQuery();
            for (FullTextSearch.Term nested : conjunction) {
                Query subQuery;
                if (nested instanceof FullTextSearch.NegationTerm) {
                    subQuery = this.createQuery(selectorName, fieldName, ((FullTextSearch.NegationTerm)nested).getNegatedTerm());
                    if (EMPTY_PHRASE_QUERY.equals((Object)subQuery)) continue;
                    query.add(subQuery, BooleanClause.Occur.MUST_NOT);
                    continue;
                }
                subQuery = this.createQuery(selectorName, fieldName, nested);
                if (EMPTY_PHRASE_QUERY.equals((Object)subQuery)) continue;
                query.add(subQuery, BooleanClause.Occur.MUST);
            }
            return query;
        }
        if (term instanceof FullTextSearch.Disjunction) {
            FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)term;
            BooleanQuery query = new BooleanQuery();
            for (FullTextSearch.Term nested : disjunction) {
                Query subQuery;
                if (nested instanceof FullTextSearch.NegationTerm) {
                    subQuery = this.createQuery(selectorName, fieldName, ((FullTextSearch.NegationTerm)nested).getNegatedTerm());
                    if (EMPTY_PHRASE_QUERY.equals((Object)subQuery)) continue;
                    query.add(subQuery, BooleanClause.Occur.MUST_NOT);
                    continue;
                }
                subQuery = this.createQuery(selectorName, fieldName, nested);
                if (EMPTY_PHRASE_QUERY.equals((Object)subQuery)) continue;
                query.add(subQuery, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (term instanceof FullTextSearch.SimpleTerm) {
            FullTextSearch.SimpleTerm simple = (FullTextSearch.SimpleTerm)term;
            Analyzer analyzer = this.getFullTextSearchAnalyzer();
            if (simple.containsWildcards()) {
                QueryParser parser = new QueryParser(this.version, fieldName, analyzer){

                    protected Query getWildcardQuery(String field, String termStr) {
                        return LuceneQueryFactory.this.findNodesLike(selectorName, field, termStr.toLowerCase(), CaseOperations.LOWERCASE);
                    }
                };
                try {
                    String expression = simple.getValue();
                    expression = expression.replaceAll("(?<![\\\\])_", "?");
                    expression = expression.replaceAll("(?<![\\\\])%", "*");
                    expression = expression.replaceAll("((?<![\\d*?]))[-]((?![\\d*?]))", "$1 $2");
                    return parser.parse(expression);
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
            PhraseQuery query = new PhraseQuery();
            query.setSlop(0);
            String expression = simple.getValue();
            TokenStream stream = analyzer.tokenStream(fieldName, (Reader)new StringReader(expression));
            CharTermAttribute termAttribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            while (stream.incrementToken()) {
                String analyzedTerm = termAttribute.toString();
                query.add(new Term(fieldName, analyzedTerm));
            }
            return query;
        }
        assert (false);
        return null;
    }

    protected Query not(Query notted) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        query.add(notted, BooleanClause.Occur.MUST_NOT);
        return query;
    }

    protected String fieldNameFor(String name) {
        return this.stringFactory.create((Name)this.nameFactory.create(name));
    }

    protected abstract String fullTextFieldName(String var1);

    protected abstract Analyzer getFullTextSearchAnalyzer();

    protected abstract Query findAllNodesBelow(Path var1) throws IOException;

    protected abstract Query findAllNodesAtOrBelow(Path var1) throws IOException;

    protected abstract Query findChildNodes(Path var1) throws IOException;

    protected abstract Query findNodeAt(Path var1) throws IOException;

    protected abstract Query findNodesLike(SelectorName var1, String var2, String var3, CaseOperations.CaseOperation var4);

    protected abstract Query findNodesWith(SelectorName var1, Length var2, Operator var3, Object var4) throws IOException;

    protected abstract Query findNodesWith(SelectorName var1, javax.jcr.query.qom.PropertyValue var2, Operator var3, Object var4, CaseOperations.CaseOperation var5) throws IOException;

    protected abstract Query findNodesWith(SelectorName var1, ReferenceValue var2, Operator var3, Object var4) throws IOException;

    protected abstract Query findNodesWithNumericRange(SelectorName var1, javax.jcr.query.qom.PropertyValue var2, Object var3, Object var4, boolean var5, boolean var6) throws IOException;

    protected abstract Query findNodesWithNumericRange(SelectorName var1, NodeDepth var2, Object var3, Object var4, boolean var5, boolean var6) throws IOException;

    protected abstract Query findNodesWith(SelectorName var1, NodePath var2, Operator var3, Object var4, CaseOperations.CaseOperation var5) throws IOException;

    protected abstract Query findNodesWith(SelectorName var1, NodeName var2, Operator var3, Object var4, CaseOperations.CaseOperation var5) throws IOException;

    protected abstract Query findNodesWith(SelectorName var1, NodeLocalName var2, Operator var3, Object var4, CaseOperations.CaseOperation var5) throws IOException;

    protected abstract Query findNodesWith(SelectorName var1, NodeDepth var2, Operator var3, Object var4) throws IOException;

    protected Schemata schemata() {
        if (this.schemata == null) {
            this.schemata = this.context.getSchemata();
        }
        return this.schemata;
    }

    protected Schemata.Column getMetadataFor(SelectorName selectorName, String propertyName) {
        return this.schemata().getTable(selectorName).getColumn(propertyName);
    }
}

