/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.OperationNotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.search.backend.TransactionContext;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.Editor;
import org.infinispan.schematic.internal.document.Paths;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.BackupService;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.InitialContentImporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrXaSession;
import org.modeshape.jcr.ModeShape;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.NodeTypesImporter;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryDisabledQueryManager;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.Sequencers;
import org.modeshape.jcr.SystemContentInitializer;
import org.modeshape.jcr.SystemNamespaceRegistry;
import org.modeshape.jcr.TextExtractors;
import org.modeshape.jcr.Upgrades;
import org.modeshape.jcr.api.AnonymousCredentials;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.bus.ClusteredRepositoryChangeBus;
import org.modeshape.jcr.bus.RepositoryChangeBus;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCaches;
import org.modeshape.jcr.federation.FederatedDocumentStore;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.MimeTypeDetectors;
import org.modeshape.jcr.query.QueryIndexing;
import org.modeshape.jcr.query.parse.FullTextSearchParser;
import org.modeshape.jcr.query.parse.JcrQomQueryParser;
import org.modeshape.jcr.query.parse.JcrSql2QueryParser;
import org.modeshape.jcr.query.parse.JcrSqlQueryParser;
import org.modeshape.jcr.query.parse.QueryParsers;
import org.modeshape.jcr.query.xpath.XPathQueryParser;
import org.modeshape.jcr.security.AnonymousProvider;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.AuthenticationProviders;
import org.modeshape.jcr.security.JaasProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.txn.NoClientTransactions;
import org.modeshape.jcr.txn.SynchronizedTransactions;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryUsageChangeSetListener;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.modeshape.jmx.RepositoryStatisticsBean;

public class JcrRepository
implements Repository {
    protected static final Set<String> MISSING_JAAS_POLICIES = new CopyOnWriteArraySet<String>();
    private static final boolean AUTO_START_REPO_UPON_LOGIN = true;
    private static final String INTERNAL_WORKER_USERNAME = "<modeshape-worker>";
    protected final Logger logger;
    private final AtomicReference<RepositoryConfiguration> config = new AtomicReference();
    private final AtomicReference<String> repositoryName = new AtomicReference();
    private final Map<String, Object> descriptors;
    private final AtomicReference<RunningState> runningState = new AtomicReference();
    private final AtomicReference<ModeShapeEngine.State> state = new AtomicReference<ModeShapeEngine.State>(ModeShapeEngine.State.NOT_RUNNING);
    private final Lock stateLock = new ReentrantLock();
    private final AtomicBoolean allowAutoStartDuringLogin = new AtomicBoolean(true);
    private Problems configurationProblems = null;

    protected JcrRepository(RepositoryConfiguration configuration) throws ConfigurationException {
        ModeShape.getName();
        this.config.set(configuration);
        RepositoryConfiguration config = this.config.get();
        Problems results = configuration.validate();
        this.setConfigurationProblems(results);
        if (results.hasErrors()) {
            String msg = JcrI18n.errorsInRepositoryConfiguration.text(new Object[]{this.repositoryName, results.errorCount(), results.toString()});
            throw new ConfigurationException(results, msg);
        }
        this.repositoryName.set(config.getName());
        this.logger = Logger.getLogger(this.getClass());
        this.logger.debug("Activating '{0}' repository", new Object[]{this.repositoryName});
        this.descriptors = new HashMap<String, Object>();
        this.initializeDescriptors();
    }

    void setConfigurationProblems(Problems configurationProblems) {
        this.configurationProblems = configurationProblems;
    }

    RepositoryConfiguration repositoryConfiguration() {
        return this.config.get();
    }

    public ModeShapeEngine.State getState() {
        return this.state.get();
    }

    public String getName() {
        return this.repositoryName.get();
    }

    public int getActiveSessionsCount() {
        RunningState state = this.runningState.get();
        return state == null ? 0 : state.activeSessionCount();
    }

    public RepositoryStatistics getRepositoryStatistics() {
        return this.statistics();
    }

    public Problems getStartupProblems() throws Exception {
        this.doStart();
        SimpleProblems result = new SimpleProblems();
        result.addAll((Iterable)this.configurationProblems);
        result.addAll((Iterable)this.runningState().problems());
        return result;
    }

    void start() throws Exception {
        this.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Boolean> shutdown() {
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("modeshape-repository-shutdown"));
        try {
            Future<Boolean> future;
            Future<Boolean> future2 = future = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return JcrRepository.this.doShutdown();
                }
            });
            return future2;
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(Changes changes) throws Exception {
        try {
            this.stateLock.lock();
            this.logger.debug("Applying changes to '{0}' repository configuration: {1} --> {2}", new Object[]{this.repositoryName, changes, this.config});
            RepositoryConfiguration oldConfiguration = this.config.get();
            Editor copy = oldConfiguration.edit();
            ConfigurationChange configChanges = new ConfigurationChange();
            copy.apply(changes, (Editor.Observer)configChanges);
            RunningState oldState = this.runningState.get();
            this.config.set(new RepositoryConfiguration(copy.unwrap(), copy.getString("name"), oldConfiguration.environment()));
            if (oldState != null) {
                assert (this.state.get() == ModeShapeEngine.State.RUNNING);
                this.runningState.set(new RunningState(oldState, configChanges));
                if (!configChanges.storageChanged && configChanges.predefinedWorkspacesChanged) {
                    this.refreshWorkspaces();
                }
                if (configChanges.nameChanged) {
                    this.repositoryNameChanged();
                }
            }
            this.logger.debug("Applied changes to '{0}' repository configuration: {1} --> {2}", new Object[]{this.repositoryName, changes, this.config});
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected final RunningState doStart() throws Exception {
        try {
            this.stateLock.lock();
            if (this.state.get() == ModeShapeEngine.State.RESTORING) {
                throw new IllegalStateException(JcrI18n.repositoryIsBeingRestoredAndCannotBeStarted.text(new Object[]{this.getName()}));
            }
            RunningState state = this.runningState.get();
            if (state == null) {
                this.state.set(ModeShapeEngine.State.STARTING);
                state = new RunningState();
                this.runningState.compareAndSet(null, state);
                state.completeInitialization();
                this.state.set(ModeShapeEngine.State.RUNNING);
                state.postInitialize();
            }
            RunningState runningState = state;
            return runningState;
        }
        catch (Exception e) {
            this.state.set(ModeShapeEngine.State.NOT_RUNNING);
            throw e;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doShutdown() {
        if (this.state.get() == ModeShapeEngine.State.NOT_RUNNING) {
            return true;
        }
        try {
            this.stateLock.lock();
            RunningState running = this.runningState.get();
            if (running != null) {
                this.allowAutoStartDuringLogin.set(false);
                this.state.set(ModeShapeEngine.State.STOPPING);
                running.terminateSessions();
                running.shutdown();
                this.runningState.set(null);
            }
            this.state.set(ModeShapeEngine.State.NOT_RUNNING);
        }
        finally {
            this.stateLock.unlock();
        }
        return true;
    }

    protected final DocumentStore documentStore() {
        return this.runningState().documentStore();
    }

    protected final String repositoryName() {
        return this.repositoryName.get();
    }

    protected final RepositoryCache repositoryCache() {
        return this.runningState().repositoryCache();
    }

    protected final RepositoryStatistics statistics() {
        return this.runningState().statistics();
    }

    protected final RepositoryNodeTypeManager nodeTypeManager() {
        return this.runningState().nodeTypeManager();
    }

    protected final RepositoryQueryManager queryManager() {
        return this.runningState().queryManager();
    }

    protected final RepositoryLockManager lockManager() {
        return this.runningState().lockManager();
    }

    protected final NamespaceRegistry persistentRegistry() {
        return this.runningState().persistentRegistry();
    }

    protected final String systemWorkspaceName() {
        return this.runningState().systemWorkspaceName();
    }

    protected final String systemWorkspaceKey() {
        return this.runningState().systemWorkspaceKey();
    }

    protected final ChangeBus changeBus() {
        return this.runningState().changeBus();
    }

    protected final String repositoryKey() {
        return this.runningState().repositoryKey();
    }

    protected final RunningState runningState() {
        RunningState running = this.runningState.get();
        if (running == null) {
            throw new IllegalStateException(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown.text(new Object[]{this.repositoryName()}));
        }
        return running;
    }

    protected final boolean hasWorkspace(String workspaceName) {
        return this.repositoryCache().getWorkspaceNames().contains(workspaceName);
    }

    protected final NodeCache workspaceCache(String workspaceName) {
        return this.repositoryCache().getWorkspaceCache(workspaceName);
    }

    final SessionCache createSystemSession(ExecutionContext context, boolean readOnly) {
        return this.repositoryCache().createSession(context, this.systemWorkspaceName(), readOnly);
    }

    protected final TransactionManager transactionManager() {
        return this.runningState().txnManager();
    }

    protected final void prepareToRestore() throws RepositoryException {
        this.logger.debug("Preparing to restore '{0}' repository; setting state to RESTORING", new Object[]{this.getName()});
        if (this.getState() == ModeShapeEngine.State.RESTORING) {
            throw new RepositoryException(JcrI18n.repositoryIsCurrentlyBeingRestored.text(new Object[]{this.getName()}));
        }
        this.state.set(ModeShapeEngine.State.RESTORING);
    }

    protected final void completeRestore() throws ExecutionException, Exception {
        if (this.getState() == ModeShapeEngine.State.RESTORING) {
            this.logger.debug("Shutting down '{0}' after content has been restored", new Object[]{this.getName()});
            Future<Boolean> future = this.shutdown();
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            this.logger.debug("Starting '{0}' after content has been restored", new Object[]{this.getName()});
            this.start();
            this.logger.debug("Started '{0}' after content has been restored; beginning indexing of content", new Object[]{this.getName()});
            this.queryManager().reindexContent(true, false, false);
            this.logger.debug("Completed reindexing all content in '{0}' after restore.", new Object[]{this.getName()});
        }
    }

    public RepositoryConfiguration getConfiguration() {
        return this.config.get();
    }

    public String getDescriptor(String key) {
        if (key == null) {
            return null;
        }
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        JcrValue value = (JcrValue)this.descriptors.get(key);
        try {
            return value.getString();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public JcrValue getDescriptorValue(String key) {
        if (key == null) {
            return null;
        }
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        return (JcrValue)this.descriptors.get(key);
    }

    public JcrValue[] getDescriptorValues(String key) {
        Object value = this.descriptors.get(key);
        if (value instanceof JcrValue[]) {
            JcrValue[] values = (JcrValue[])value;
            JcrValue[] newValues = new JcrValue[values.length];
            System.arraycopy(values, 0, newValues, 0, values.length);
            return newValues;
        }
        if (value instanceof JcrValue) {
            return new JcrValue[]{(JcrValue)value};
        }
        return null;
    }

    public boolean isSingleValueDescriptor(String key) {
        if (key == null) {
            return true;
        }
        return this.descriptors.get(key) instanceof JcrValue;
    }

    public boolean isStandardDescriptor(String key) {
        return STANDARD_DESCRIPTORS.contains(key);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public synchronized JcrSession login() throws RepositoryException {
        return this.login(null, null);
    }

    public synchronized JcrSession login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public synchronized JcrSession login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized JcrSession login(Credentials credentials, String workspaceName) throws RepositoryException {
        String repoName = this.repositoryName();
        RunningState running = this.runningState.get();
        if (running == null) {
            if (!this.allowAutoStartDuringLogin.get()) throw new RepositoryException(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown.text(new Object[]{repoName}));
            try {
                running = this.doStart();
            }
            catch (Throwable t) {
                throw new RepositoryException(JcrI18n.errorStartingRepository.text(new Object[]{repoName, t.getMessage()}), t);
            }
            if (running == null) {
                throw new RepositoryException(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown.text(new Object[]{repoName}));
            }
        } else if (this.state.get() == ModeShapeEngine.State.RESTORING) {
            throw new RepositoryException(JcrI18n.repositoryIsBeingRestoredAndCannotBeStarted.text(new Object[]{this.getName()}));
        }
        workspaceName = this.validateWorkspaceName(running, workspaceName);
        AuthenticationProviders authenticators = running.authenticators();
        Credentials anonCredentials = running.anonymousCredentials();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ExecutionContext context = running.context();
        ExecutionContext sessionContext = authenticators.authenticate(credentials, repoName, workspaceName, context, attributes);
        if (sessionContext == null && credentials != null && anonCredentials != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(JcrI18n.usingAnonymousUser.text(new Object[0]), new Object[0]);
            }
            attributes.clear();
            sessionContext = authenticators.authenticate(anonCredentials, repoName, workspaceName, context, attributes);
        }
        if (sessionContext == null) {
            throw new LoginException(JcrI18n.loginFailed.text(new Object[]{repoName, workspaceName}));
        }
        try {
            SecurityContext securityContext = sessionContext.getSecurityContext();
            boolean writable = JcrSession.hasRole(securityContext, "readwrite", repoName, workspaceName) || JcrSession.hasRole(securityContext, "admin", repoName, workspaceName);
            JcrSession session = null;
            session = running.useXaSessions() ? new JcrXaSession(this, workspaceName, sessionContext, attributes, !writable) : new JcrSession(this, workspaceName, sessionContext, attributes, !writable);
            session.checkWorkspacePermission(workspaceName, "read");
            running.addSession(session, false);
            return session;
        }
        catch (AccessDeniedException ace) {
            throw new LoginException(JcrI18n.loginFailed.text(new Object[]{repoName, workspaceName}), (Throwable)ace);
        }
        catch (WorkspaceNotFoundException e) {
            throw new NoSuchWorkspaceException(e.getMessage(), (Throwable)e);
        }
    }

    private String validateWorkspaceName(RunningState runningState, String workspaceName) throws RepositoryException {
        if (workspaceName == null) {
            return runningState.defaultWorkspaceName();
        }
        if (runningState.systemWorkspaceName().equals(workspaceName)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.repositoryName(), workspaceName}));
        }
        return workspaceName;
    }

    private void initializeDescriptors() {
        ValueFactories factories = new ExecutionContext().getValueFactories();
        this.descriptors.put("level.1.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("level.2.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.locking.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.observation.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.query.sql.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.transactions.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.versioning.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.xpath.doc.order", JcrRepository.valueFor(factories, false));
        this.descriptors.put("query.xpath.pos.index", JcrRepository.valueFor(factories, false));
        this.descriptors.put("write.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("identifier.stability", JcrRepository.valueFor(factories, "identifier.stability.indefinite.duration"));
        this.descriptors.put("option.xml.import.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.xml.export.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.unfiled.content.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.simple.versioning.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.activities.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.baselines.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.access.control.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.journaled.observation.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.retention.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.lifecycle.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.node.and.property.with.same.name.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.update.primary.node.type.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.update.mixin.node.types.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.shareable.nodes.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.node.type.management.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.inheritance", JcrRepository.valueFor(factories, "node.type.management.inheritance.multiple"));
        this.descriptors.put("node.type.management.primary.item.name.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.orderable.child.nodes.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.residual.definitions.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.autocreated.definitions.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.same.name.siblings.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.property.types", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.overrides.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.multivalued.properties.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.multiple.binary.properties.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.value.constraints.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.update.in.use.suported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.languages", new JcrValue[]{JcrRepository.valueFor(factories, "xpath"), JcrRepository.valueFor(factories, "JCR-SQL2"), JcrRepository.valueFor(factories, "sql"), JcrRepository.valueFor(factories, "JCR-JQOM")});
        this.descriptors.put("query.stored.queries.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.full.text.search.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.joins", JcrRepository.valueFor(factories, "query.joins.inner.outer"));
        this.descriptors.put("jcr.specification.name", JcrRepository.valueFor(factories, JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        this.descriptors.put("jcr.specification.version", JcrRepository.valueFor(factories, "2.0"));
        this.descriptors.put("jcr.repository.name", JcrRepository.valueFor(factories, ModeShape.getName()));
        this.descriptors.put("jcr.repository.vendor", JcrRepository.valueFor(factories, ModeShape.getVendor()));
        this.descriptors.put("jcr.repository.vendor.url", JcrRepository.valueFor(factories, ModeShape.getUrl()));
        this.descriptors.put("jcr.repository.version", JcrRepository.valueFor(factories, ModeShape.getVersion()));
        this.descriptors.put("option.workspace.management.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("custom.rep.name", JcrRepository.valueFor(factories, this.repositoryName()));
    }

    private static JcrValue valueFor(ValueFactories valueFactories, int type, Object value) {
        return new JcrValue(valueFactories, type, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, String value) {
        return JcrRepository.valueFor(valueFactories, 1, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, boolean value) {
        return JcrRepository.valueFor(valueFactories, 6, value);
    }

    protected void refreshWorkspaces() {
        RunningState running = this.runningState();
        if (running != null) {
            Set<String> workspaceNames = running.repositoryCache().getWorkspaceNames();
            ValueFactories factories = running.context().getValueFactories();
            JcrValue[] values = new JcrValue[workspaceNames.size()];
            int i = 0;
            for (String workspaceName : workspaceNames) {
                values[i++] = JcrRepository.valueFor(factories, workspaceName);
            }
            this.descriptors.put("custom.rep.workspace.names", values);
        }
    }

    private void repositoryNameChanged() {
        this.descriptors.put("custom.rep.name", this.repositoryName());
    }

    Collection<Cache<?, ?>> caches() {
        RunningState running = this.runningState.get();
        if (running == null) {
            return Collections.emptyList();
        }
        ArrayList caches = new ArrayList();
        LocalDocumentStore localDocumentStore = running.documentStore().localStore();
        caches.add(localDocumentStore.localCache());
        BinaryStore store = running.binaryStore();
        if (store instanceof InfinispanBinaryStore) {
            InfinispanBinaryStore ispnStore = (InfinispanBinaryStore)store;
            caches.addAll(ispnStore.getCaches());
        }
        return caches;
    }

    protected long determineInitialDelay(String initialTimeExpression) {
        Matcher matcher = RepositoryConfiguration.INITIAL_TIME_PATTERN.matcher(initialTimeExpression);
        if (matcher.matches()) {
            DateTime now;
            int hours = Integer.decode(matcher.group(1));
            int mins = Integer.decode(matcher.group(2));
            DateTimeFactory factory = this.runningState().context().getValueFactories().getDateFactory();
            DateTime initialTime = factory.create((now = factory.create()).getYear(), now.getMonthOfYear(), now.getDayOfMonth(), hours, mins, 0, 0);
            long delay = initialTime.getMilliseconds() - System.currentTimeMillis();
            if (delay <= 0L) {
                initialTime = initialTime.plusDays(1);
                delay = initialTime.getMilliseconds() - System.currentTimeMillis();
            }
            if (delay < 10000L) {
                delay += 10000L;
            }
            assert (delay >= 0L);
            return delay;
        }
        String msg = JcrI18n.invalidGarbageCollectionInitialTime.text(new Object[]{this.repositoryName(), initialTimeExpression});
        throw new IllegalArgumentException(msg);
    }

    protected static class OptimizationTask
    extends BackgroundRepositoryTask {
        private final int targetCount;
        private final int tolerance;

        protected OptimizationTask(JcrRepository repository, int targetCount, int tolerance) {
            super(repository);
            this.targetCount = targetCount;
            this.tolerance = tolerance;
        }

        @Override
        protected void doRun(JcrRepository repository) {
            repository.runningState().repositoryCache().optimizeChildren(this.targetCount, this.tolerance);
        }
    }

    protected static class LockGarbageCollectionTask
    extends BackgroundRepositoryTask {
        protected LockGarbageCollectionTask(JcrRepository repository) {
            super(repository);
        }

        @Override
        protected void doRun(JcrRepository repository) {
            repository.runningState().cleanUpLocks();
        }
    }

    protected static class BinaryValueGarbageCollectionTask
    extends BackgroundRepositoryTask {
        protected BinaryValueGarbageCollectionTask(JcrRepository repository) {
            super(repository);
        }

        @Override
        protected void doRun(JcrRepository repository) {
            repository.runningState().cleanUpBinaryValues();
        }
    }

    protected static abstract class BackgroundRepositoryTask
    implements Runnable {
        private WeakReference<JcrRepository> repositoryRef;

        protected BackgroundRepositoryTask(JcrRepository repository) {
            assert (repository != null);
            this.repositoryRef = new WeakReference<JcrRepository>(repository);
        }

        @Override
        public final void run() {
            JcrRepository repository = (JcrRepository)this.repositoryRef.get();
            if (repository != null && repository.getState() == ModeShapeEngine.State.RUNNING) {
                this.doRun(repository);
            }
        }

        protected abstract void doRun(JcrRepository var1);
    }

    private final class InternalSecurityContext
    implements SecurityContext {
        private final String username;

        protected InternalSecurityContext(String username) {
            this.username = username;
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public String getUserName() {
            return this.username;
        }

        @Override
        public boolean hasRole(String roleName) {
            return true;
        }

        @Override
        public void logout() {
        }
    }

    protected static class RepositoryMonitorFactory
    implements SessionEnvironment.MonitorFactory {
        private final RunningState runningState;

        protected RepositoryMonitorFactory(RunningState runningState) {
            this.runningState = runningState;
        }

        protected Transaction currentTransaction() {
            try {
                Transaction txn = this.runningState.txnManager().getTransaction();
                return txn != null && txn.getStatus() == 0 ? txn : null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SessionEnvironment.Monitor createMonitor() {
            RepositoryNodeTypeManager nodeTypeManager = this.runningState.nodeTypeManager();
            RepositoryQueryManager queryManager = this.runningState.queryManager();
            if (nodeTypeManager == null || queryManager == null) {
                return this.statisticsMonitor();
            }
            return this.indexingMonitor(nodeTypeManager, queryManager);
        }

        private SessionEnvironment.Monitor indexingMonitor(RepositoryNodeTypeManager nodeTypeManager, RepositoryQueryManager queryManager) {
            final NodeTypeSchemata schemata = nodeTypeManager.getRepositorySchemata();
            final QueryIndexing indexes = queryManager.getIndexes();
            final Transaction txn = this.currentTransaction();
            final TransactionContext txnCtx = new TransactionContext(){

                public Object getTransactionIdentifier() {
                    return txn;
                }

                public boolean isTransactionInProgress() {
                    return txn != null;
                }

                public void registerSynchronization(Synchronization synchronization) {
                    CheckArg.isNotNull((Object)synchronization, (String)"synchronization");
                    try {
                        if (txn != null && txn.getStatus() == 0) {
                            txn.registerSynchronization(synchronization);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            final RunningState runningState = this.runningState;
            return new SessionEnvironment.Monitor(){

                @Override
                public void recordChanged(long changedNodesCount) {
                    runningState.statistics().increment(ValueMetric.NODE_CHANGES, changedNodesCount);
                }

                @Override
                public void recordAdd(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertiesIterator) {
                    indexes.addToIndex(workspace, key, path, primaryType, mixinTypes, propertiesIterator, schemata, txnCtx);
                }

                @Override
                public void recordUpdate(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties) {
                    indexes.updateIndex(workspace, key, path, primaryType, mixinTypes, properties, schemata, txnCtx);
                }

                @Override
                public void recordRemove(String workspace, Iterable<NodeKey> keys) {
                    indexes.removeFromIndex(workspace, keys, txnCtx);
                }
            };
        }

        private SessionEnvironment.Monitor statisticsMonitor() {
            final RunningState runningState = this.runningState;
            return new SessionEnvironment.Monitor(){

                @Override
                public void recordChanged(long changedNodesCount) {
                    runningState.statistics().increment(ValueMetric.NODE_CHANGES, changedNodesCount);
                }

                @Override
                public void recordAdd(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertiesIterator) {
                }

                @Override
                public void recordRemove(String workspace, Iterable<NodeKey> keys) {
                }

                @Override
                public void recordUpdate(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties) {
                }
            };
        }
    }

    protected static class RepositorySessionEnvironment
    implements SessionEnvironment {
        private final Transactions transactions;
        private final TransactionalWorkspaceCaches transactionalWorkspaceCacheFactory;
        private final boolean indexingClustered;

        protected RepositorySessionEnvironment(Transactions transactions, boolean indexingClustered) {
            this.transactions = transactions;
            this.transactionalWorkspaceCacheFactory = new TransactionalWorkspaceCaches(transactions);
            this.indexingClustered = indexingClustered;
        }

        @Override
        public Transactions getTransactions() {
            return this.transactions;
        }

        @Override
        public TransactionalWorkspaceCaches getTransactionalWorkspaceCacheFactory() {
            return this.transactionalWorkspaceCacheFactory;
        }

        @Override
        public boolean indexingClustered() {
            return this.indexingClustered;
        }
    }

    @Immutable
    protected class RunningState {
        private final RepositoryConfiguration config;
        private final DocumentStore documentStore;
        private final AuthenticationProviders authenticators;
        private final Credentials anonymousCredentialsIfSuppliedCredentialsFail;
        private final String defaultWorkspaceName;
        private final String systemWorkspaceName;
        private final String systemWorkspaceKey;
        private final RepositoryNodeTypeManager nodeTypes;
        private final RepositoryLockManager lockManager;
        private final TransactionManager txnMgr;
        private final Transactions transactions;
        private final String jndiName;
        private final SystemNamespaceRegistry persistentRegistry;
        private final ExecutionContext context;
        private final ExecutionContext internalWorkerContext;
        private final ReadWriteLock activeSessionLock = new ReentrantReadWriteLock();
        private final WeakHashMap<JcrSession, Object> activeSessions = new WeakHashMap();
        private final WeakHashMap<JcrSession, Object> internalSessions = new WeakHashMap();
        private final RepositoryStatistics statistics;
        private final RepositoryStatisticsBean mbean;
        private final BinaryStore binaryStore;
        private final ScheduledExecutorService statsRollupService;
        private final Sequencers sequencers;
        private final QueryParsers queryParsers;
        private final RepositoryQueryManager repositoryQueryManager;
        private final ExecutorService indexingExecutor;
        private final TextExtractors extractors;
        private final ChangeBus changeBus;
        private final ExecutorService changeDispatchingQueue;
        private final boolean useXaSessions;
        private final MimeTypeDetectors mimeTypeDetector;
        private final BackupService backupService;
        private final InitialContentImporter initialContentImporter;
        private final SystemContentInitializer systemContentInitializer;
        private final NodeTypesImporter nodeTypesImporter;
        private final Connectors connectors;
        private final RepositoryConfiguration.IndexRebuildOptions indexRebuildOptions;
        private final List<ScheduledFuture<?>> backgroundProcesses = new ArrayList();
        private final Problems problems;
        private Transaction existingUserTransaction;
        private RepositoryCache cache;

        protected RunningState() throws Exception {
            this(null, null);
        }

        protected RunningState(RunningState other, ConfigurationChange change) throws Exception {
            this.config = JcrRepository.this.repositoryConfiguration();
            this.systemContentInitializer = new SystemContentInitializer();
            if (other == null) {
                JcrRepository.this.logger.debug("Starting '{0}' repository with configuration: \n{1}", new Object[]{JcrRepository.this.repositoryName(), this.config});
                this.problems = new SimpleProblems();
            } else {
                JcrRepository.this.logger.debug("Updating '{0}' repository with configuration: \n{1}", new Object[]{JcrRepository.this.repositoryName(), this.config});
                this.problems = other.problems;
            }
            ExecutionContext tempContext = new ExecutionContext();
            if (other != null && !change.monitoringChanged) {
                this.statistics = other.statistics;
                this.statsRollupService = other.statsRollupService;
                this.mbean = other.mbean;
            } else {
                RepositoryStatistics repositoryStatistics = this.statistics = other != null ? other.statistics : new RepositoryStatistics(tempContext);
                if (this.config.getMonitoring().enabled()) {
                    this.statsRollupService = tempContext.getScheduledThreadPool("modeshape-stats");
                    this.statistics.start(this.statsRollupService);
                    this.mbean = new RepositoryStatisticsBean(this.statistics, JcrRepository.this.getName());
                    this.mbean.start();
                } else {
                    this.statsRollupService = null;
                    this.mbean = null;
                }
            }
            this.systemWorkspaceName = "system";
            this.systemWorkspaceKey = NodeKey.keyForWorkspaceName(this.systemWorkspaceName);
            this.defaultWorkspaceName = other != null && !change.workspacesChanged ? other.defaultWorkspaceName : this.config.getDefaultWorkspaceName();
            try {
                if (other != null) {
                    if (change.storageChanged) {
                        this.warn(JcrI18n.storageRelatedConfigurationChangesWillTakeEffectAfterShutdown, JcrRepository.this.getName());
                    }
                    if (change.binaryStorageChanged) {
                        this.warn(JcrI18n.storageRelatedConfigurationChangesWillTakeEffectAfterShutdown, JcrRepository.this.getName());
                    }
                    this.cache = other.cache;
                    this.context = other.context;
                    this.connectors = other.connectors;
                    this.documentStore = other.documentStore;
                    this.txnMgr = this.documentStore.transactionManager();
                    RepositoryMonitorFactory monitorFactory = new RepositoryMonitorFactory(this);
                    this.transactions = this.createTransactions(this.config.getTransactionMode(), monitorFactory, this.txnMgr);
                    this.suspendExistingUserTransaction();
                    if (change.largeValueChanged) {
                        RepositoryConfiguration.BinaryStorage binaryStorage = this.config.getBinaryStorage();
                        this.cache.setLargeStringLength(binaryStorage.getMinimumBinarySizeInBytes());
                        this.context.getBinaryStore().setMinimumBinarySizeInBytes(binaryStorage.getMinimumBinarySizeInBytes());
                    }
                    if (change.predefinedWorkspacesChanged) {
                        for (String workspaceName : this.config.getPredefinedWorkspaceNames()) {
                            this.cache.createWorkspace(workspaceName);
                        }
                    }
                    this.mimeTypeDetector = new MimeTypeDetectors(other.config.environment(), this.problems);
                    this.binaryStore = other.binaryStore;
                    this.internalWorkerContext = other.internalWorkerContext;
                    this.nodeTypes = other.nodeTypes.with(this, true, true);
                    this.lockManager = other.lockManager.with(this);
                    this.cache.register(this.lockManager);
                    other.cache.unregister(other.lockManager);
                    this.persistentRegistry = other.persistentRegistry;
                    this.changeDispatchingQueue = other.changeDispatchingQueue;
                    this.changeBus = other.changeBus;
                } else {
                    CacheContainer container = this.config.getContentCacheContainer();
                    String cacheName = this.config.getCacheName();
                    List<RepositoryConfiguration.Component> connectorComponents = this.config.getFederation().getConnectors(this.problems);
                    Map<String, List<RepositoryConfiguration.ProjectionConfiguration>> preconfiguredProjectionsByWorkspace = this.config.getFederation().getProjectionsByWorkspace();
                    this.connectors = new Connectors(this, connectorComponents, preconfiguredProjectionsByWorkspace);
                    JcrRepository.this.logger.debug("Loading cache '{0}' from cache container {1}", new Object[]{cacheName, container});
                    SchematicDb database = Schematic.get((CacheContainer)container, (String)cacheName);
                    this.documentStore = this.connectors.hasConnectors() ? new FederatedDocumentStore(this.connectors, database) : new LocalDocumentStore(database);
                    this.txnMgr = this.documentStore.transactionManager();
                    RepositoryMonitorFactory monitorFactory = new RepositoryMonitorFactory(this);
                    this.transactions = this.createTransactions(this.config.getTransactionMode(), monitorFactory, this.txnMgr);
                    this.suspendExistingUserTransaction();
                    RepositoryConfiguration.BinaryStorage binaryStorageConfig = this.config.getBinaryStorage();
                    this.binaryStore = binaryStorageConfig.getBinaryStore();
                    this.binaryStore.start();
                    tempContext = tempContext.with(this.binaryStore);
                    this.persistentRegistry = new SystemNamespaceRegistry(this);
                    this.mimeTypeDetector = new MimeTypeDetectors(this.config.environment(), this.problems);
                    this.context = tempContext.with(this.persistentRegistry);
                    this.persistentRegistry.setContext(this.context);
                    this.internalWorkerContext = this.context.with(new InternalSecurityContext(JcrRepository.INTERNAL_WORKER_USERNAME));
                    this.changeDispatchingQueue = this.context().getCachedTreadPool("modeshape-event-dispatcher");
                    this.changeBus = this.createBus(this.config.getClustering(), this.changeDispatchingQueue, this.systemWorkspaceName(), this.context.getProcessId());
                    this.changeBus.start();
                    RepositoryConfiguration.QuerySystem query = this.config.getQuery();
                    boolean indexingClustered = query.queriesEnabled() && query.indexingClustered();
                    RepositorySessionEnvironment sessionEnv = new RepositorySessionEnvironment(this.transactions, indexingClustered);
                    CacheContainer workspaceCacheContainer = this.config.getWorkspaceContentCacheContainer();
                    this.cache = new RepositoryCache(this.context, this.documentStore, this.config, this.systemContentInitializer, sessionEnv, this.changeBus, workspaceCacheContainer, Upgrades.STANDARD_UPGRADES);
                    this.nodeTypes = new RepositoryNodeTypeManager(this, true, true);
                    this.cache.register(this.nodeTypes);
                    this.lockManager = new RepositoryLockManager(this);
                    this.cache.register(this.lockManager);
                    this.cache.register(new BinaryUsageChangeSetListener(this.binaryStore));
                    this.persistentRegistry.refreshFromSystem();
                    this.lockManager.refreshFromSystem();
                    if (!this.nodeTypes.refreshFromSystem()) {
                        try {
                            CndImporter importer = new CndImporter(this.context, true);
                            importer.importBuiltIns(this.problems);
                            this.nodeTypes.registerNodeTypes(importer.getNodeTypeDefinitions(), false, true, true);
                        }
                        catch (RepositoryException re) {
                            throw new IllegalStateException("Could not load node type definition files", re);
                        }
                        catch (IOException ioe) {
                            throw new IllegalStateException("Could not access node type definition files", ioe);
                        }
                    }
                    this.persistentRegistry.register(JcrNamespaceRegistry.STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX);
                    this.statistics.set(ValueMetric.WORKSPACE_COUNT, this.cache.getWorkspaceNames().size());
                }
                this.useXaSessions = this.transactions instanceof SynchronizedTransactions;
                if (other != null && !change.securityChanged) {
                    this.authenticators = other.authenticators;
                    this.anonymousCredentialsIfSuppliedCredentialsFail = other.anonymousCredentialsIfSuppliedCredentialsFail;
                } else {
                    AtomicBoolean useAnonymouOnFailedLogins = new AtomicBoolean();
                    this.authenticators = this.createAuthenticationProviders(useAnonymouOnFailedLogins);
                    this.anonymousCredentialsIfSuppliedCredentialsFail = useAnonymouOnFailedLogins.get() ? new AnonymousCredentials() : null;
                }
                this.extractors = other != null && !change.extractorsChanged ? new TextExtractors(this, other.config.getQuery().getTextExtracting()) : new TextExtractors(this, this.config.getQuery().getTextExtracting());
                this.binaryStore.setMimeTypeDetector(this.mimeTypeDetector);
                this.binaryStore.setTextExtractors(this.extractors);
                if (other != null && !change.sequencingChanged) {
                    this.sequencers = other.sequencers.with(this);
                    if (!this.sequencers.isEmpty()) {
                        this.cache.register(this.sequencers);
                    }
                    this.cache.unregister(other.sequencers);
                } else {
                    this.sequencers = new Sequencers(this, this.config, this.cache.getWorkspaceNames());
                }
                if (other != null && !change.indexingChanged) {
                    this.indexingExecutor = other.indexingExecutor;
                    this.queryParsers = other.queryParsers;
                } else {
                    String indexThreadPoolName = this.config.getQuery().getThreadPoolName();
                    this.indexingExecutor = this.context.getThreadPool(indexThreadPoolName);
                    this.queryParsers = new QueryParsers(new JcrSql2QueryParser(), new XPathQueryParser(), new FullTextSearchParser(), new JcrSqlQueryParser(), new JcrQomQueryParser());
                }
                RepositoryConfiguration.QuerySystem query = this.config.getQuery();
                if (query.queriesEnabled()) {
                    Properties backendProps = query.getIndexingBackendProperties();
                    Properties indexingProps = query.getIndexingProperties();
                    Properties indexStorageProps = query.getIndexStorageProperties();
                    this.repositoryQueryManager = new RepositoryQueryManager(this, this.indexingExecutor, backendProps, indexingProps, indexStorageProps);
                    this.indexRebuildOptions = query.getIndexRebuildOptions();
                } else {
                    this.repositoryQueryManager = new RepositoryDisabledQueryManager(this, this.config.getQuery());
                    this.indexRebuildOptions = null;
                    JcrRepository.this.logger.debug("Queries have been DISABLED for the '{0}' repository. Nothing will be indexed, and all queries will return empty results.", new Object[]{JcrRepository.this.repositoryName()});
                }
                assert (this.queryParsers.getParserFor("xpath") != null);
                assert (this.queryParsers.getParserFor("sql") != null);
                assert (this.queryParsers.getParserFor("JCR-SQL2") != null);
                assert (this.queryParsers.getParserFor("JCR-JQOM") != null);
                assert (this.queryParsers.getParserFor("search") != null);
                if (other != null && !change.jndiChanged) {
                    this.jndiName = other.jndiName;
                } else {
                    this.jndiName = this.config.getJndiName();
                    this.bindIntoJndi();
                    if (other != null) {
                        other.unbindFromJndi();
                    }
                }
                this.backupService = new BackupService(this);
                this.initialContentImporter = new InitialContentImporter(this.config.getInitialContent(), this);
                this.nodeTypesImporter = new NodeTypesImporter(this.config.getNodeTypes(), this);
            }
            catch (Throwable t) {
                if (this.cache != null) {
                    this.cache.rollbackRepositoryInfo();
                }
                this.resumeExistingUserTransaction();
                throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
            }
        }

        protected Transactions createTransactions(RepositoryConfiguration.TransactionMode mode, SessionEnvironment.MonitorFactory monitorFactory, TransactionManager txnMgr) {
            if (txnMgr == null) {
                throw new ConfigurationException(JcrI18n.repositoryCannotBeStartedWithoutTransactionalSupport.text(new Object[]{JcrRepository.this.getName()}));
            }
            switch (mode) {
                case NONE: {
                    return new NoClientTransactions(monitorFactory, txnMgr);
                }
            }
            return new SynchronizedTransactions(monitorFactory, txnMgr);
        }

        protected final void completeInitialization() throws Exception {
            try {
                JcrRepository.this.refreshWorkspaces();
                this.sequencers.initialize();
                this.nodeTypesImporter.importNodeTypes();
                if (this.repositoryCache().isInitializingRepository()) {
                    this.cache.runOneTimeSystemInitializationOperation(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            for (String workspaceName : RunningState.this.repositoryCache().getWorkspaceNames()) {
                                RunningState.this.initialContentImporter().importInitialContent(workspaceName);
                            }
                            return null;
                        }
                    });
                }
                this.connectors.initialize();
                this.repositoryCache().completeInitialization();
                this.repositoryCache().completeUpgrade(new Upgrades.Context(){

                    @Override
                    public RunningState getRepository() {
                        return RunningState.this;
                    }

                    @Override
                    public Problems getProblems() {
                        return RunningState.this.problems();
                    }
                });
            }
            catch (Throwable t) {
                this.repositoryCache().rollbackRepositoryInfo();
                this.resumeExistingUserTransaction();
                throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void postInitialize() throws Exception {
            try {
                if (this.indexRebuildOptions != null) {
                    RepositoryConfiguration.QueryRebuild when = this.indexRebuildOptions.getWhen();
                    boolean includeSystemContent = this.indexRebuildOptions.includeSystemContent();
                    boolean async = this.indexRebuildOptions.getMode() == RepositoryConfiguration.IndexingMode.ASYNC;
                    switch (when) {
                        case ALWAYS: {
                            this.repositoryQueryManager.reindexContent(includeSystemContent, async, false);
                            break;
                        }
                        case IF_MISSING: {
                            this.repositoryQueryManager.reindexContent(includeSystemContent, async, true);
                            break;
                        }
                        case NEVER: {
                            JcrRepository.this.logger.debug(JcrI18n.noReindex.text(new Object[]{JcrRepository.this.getName()}), new Object[0]);
                            break;
                        }
                        case FAIL_IF_MISSING: {
                            if (this.repositoryQueryManager.indexesEmpty()) {
                                throw new RepositoryException(JcrI18n.noIndexesExist.text(new Object[]{JcrRepository.this.getName(), RepositoryConfiguration.QueryRebuild.FAIL_IF_MISSING.name()}));
                            }
                            JcrRepository.this.logger.debug("Index rebuild mode is '{0}' and there are some indexes present. Nothing will be reindexed.", new Object[]{RepositoryConfiguration.QueryRebuild.FAIL_IF_MISSING.name()});
                        }
                    }
                }
                RepositoryConfiguration.GarbageCollection gcConfig = this.config.getGarbageCollection();
                String threadPoolName = gcConfig.getThreadPoolName();
                long binaryGcInitialTimeInMillis = JcrRepository.this.determineInitialDelay(gcConfig.getInitialTimeExpression());
                long binaryGcIntervalInHours = gcConfig.getIntervalInHours();
                int lockSweepIntervalInMinutes = gcConfig.getLockSweepIntervalInMinutes();
                assert (binaryGcInitialTimeInMillis >= 0L);
                long binaryGcIntervalInMillis = TimeUnit.MILLISECONDS.convert(binaryGcIntervalInHours, TimeUnit.HOURS);
                ScheduledExecutorService garbageCollectionService = this.context.getScheduledThreadPool(threadPoolName);
                this.backgroundProcesses.add(garbageCollectionService.scheduleAtFixedRate(new LockGarbageCollectionTask(JcrRepository.this), lockSweepIntervalInMinutes, lockSweepIntervalInMinutes, TimeUnit.MINUTES));
                this.backgroundProcesses.add(garbageCollectionService.scheduleAtFixedRate(new BinaryValueGarbageCollectionTask(JcrRepository.this), binaryGcInitialTimeInMillis, binaryGcIntervalInMillis, TimeUnit.MILLISECONDS));
                RepositoryConfiguration.DocumentOptimization optConfig = this.config.getDocumentOptimization();
                if (optConfig.isEnabled()) {
                    this.warn(JcrI18n.enablingDocumentOptimization, this.name());
                    threadPoolName = optConfig.getThreadPoolName();
                    long optInitialTimeInMillis = JcrRepository.this.determineInitialDelay(optConfig.getInitialTimeExpression());
                    long optIntervalInHours = optConfig.getIntervalInHours();
                    int targetCount = optConfig.getChildCountTarget();
                    int tolerance = optConfig.getChildCountTolerance();
                    assert (optInitialTimeInMillis >= 0L);
                    long optIntervalInMillis = TimeUnit.MILLISECONDS.convert(optIntervalInHours, TimeUnit.HOURS);
                    ScheduledExecutorService optService = this.context.getScheduledThreadPool(threadPoolName);
                    OptimizationTask optTask = new OptimizationTask(JcrRepository.this, targetCount, tolerance);
                    this.backgroundProcesses.add(optService.scheduleAtFixedRate(optTask, optInitialTimeInMillis, optIntervalInMillis, TimeUnit.MILLISECONDS));
                }
            }
            finally {
                this.resumeExistingUserTransaction();
            }
        }

        protected final Sequencers sequencers() {
            return this.sequencers;
        }

        protected final boolean useXaSessions() {
            return this.useXaSessions;
        }

        final String name() {
            return JcrRepository.this.repositoryName();
        }

        final ExecutionContext context() {
            return this.context;
        }

        final ExecutionContext internalWorkerContext() {
            return this.internalWorkerContext;
        }

        final RepositoryCache repositoryCache() {
            return this.cache;
        }

        final QueryParsers queryParsers() {
            return this.queryParsers;
        }

        final RepositoryQueryManager queryManager() {
            return this.repositoryQueryManager;
        }

        protected final DocumentStore documentStore() {
            return this.documentStore;
        }

        protected final BinaryStore binaryStore() {
            return this.binaryStore;
        }

        protected final MimeTypeDetector mimeTypeDetector() {
            return this.mimeTypeDetector;
        }

        protected final TextExtractors textExtractors() {
            return this.extractors;
        }

        protected final Environment environment() {
            return this.config.environment();
        }

        protected final TransactionManager txnManager() {
            TransactionManager mgr = this.documentStore().transactionManager();
            assert (mgr != null);
            return mgr;
        }

        protected final RepositoryNodeTypeManager nodeTypeManager() {
            return this.nodeTypes;
        }

        protected final RepositoryLockManager lockManager() {
            return this.lockManager;
        }

        protected final String systemWorkspaceName() {
            return this.systemWorkspaceName;
        }

        protected final String systemWorkspaceKey() {
            return this.systemWorkspaceKey;
        }

        protected final String defaultWorkspaceName() {
            return this.defaultWorkspaceName;
        }

        protected final NamespaceRegistry persistentRegistry() {
            return this.persistentRegistry;
        }

        protected final AuthenticationProviders authenticators() {
            return this.authenticators;
        }

        protected final RepositoryStatistics statistics() {
            return this.statistics;
        }

        protected final Credentials anonymousCredentials() {
            return this.anonymousCredentialsIfSuppliedCredentialsFail;
        }

        protected final ChangeBus changeBus() {
            return this.changeBus;
        }

        final Connectors connectors() {
            return this.connectors;
        }

        protected final String repositoryKey() {
            return this.cache.getKey();
        }

        protected final boolean isFullTextSearchEnabled() {
            return this.config.getQuery().fullTextSearchEnabled();
        }

        protected final BackupService backupService() {
            return this.backupService;
        }

        protected final void warn(I18n message, Object ... params) {
            JcrRepository.this.logger.warn((I18nResource)message, params);
            this.problems.addWarning(message, params);
        }

        protected final void error(I18n message, Object ... params) {
            JcrRepository.this.logger.error((I18nResource)message, params);
            this.problems.addError(message, params);
        }

        protected final void error(Throwable t, I18n message, Object ... params) {
            JcrRepository.this.logger.error(t, (I18nResource)message, params);
            this.problems.addError(t, message, params);
        }

        protected final Problems problems() {
            return this.problems;
        }

        final InitialContentImporter initialContentImporter() {
            return this.initialContentImporter;
        }

        private AuthenticationProviders createAuthenticationProviders(AtomicBoolean useAnonymouOnFailedLogins) {
            RepositoryConfiguration.Security securityConfig;
            AuthenticationProviders authenticators;
            block11: {
                String policyName;
                authenticators = new AuthenticationProviders();
                securityConfig = this.config.getSecurity();
                RepositoryConfiguration.JaasSecurity jaasSecurity = securityConfig.getJaas();
                if (jaasSecurity != null && (policyName = jaasSecurity.getPolicyName()) != null && policyName.trim().length() != 0) {
                    try {
                        JaasProvider jaasProvider = new JaasProvider(policyName);
                        authenticators = authenticators.with(jaasProvider);
                    }
                    catch (SecurityException e) {
                        if (MISSING_JAAS_POLICIES.add(policyName)) {
                            this.warn(JcrI18n.loginConfigNotFound, policyName, "security/policyName", JcrRepository.this.repositoryName());
                        }
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        if (!MISSING_JAAS_POLICIES.add(policyName)) break block11;
                        this.warn(JcrI18n.loginConfigNotFound, policyName, "security/policyName", JcrRepository.this.repositoryName());
                    }
                }
            }
            for (RepositoryConfiguration.Component component : securityConfig.getCustomProviders(this.problems())) {
                try {
                    Object value;
                    AuthenticationProvider provider = (AuthenticationProvider)component.createInstance(this.getClass().getClassLoader());
                    authenticators = authenticators.with(provider);
                    if (!(provider instanceof AnonymousProvider) || !Boolean.TRUE.equals(value = component.getDocument().get("useOnFailedLogin"))) continue;
                    useAnonymouOnFailedLogins.set(true);
                }
                catch (Throwable t) {
                    JcrRepository.this.logger.error(t, (I18nResource)JcrI18n.unableToInitializeAuthenticationProvider, new Object[]{component, JcrRepository.this.repositoryName(), t.getMessage()});
                }
            }
            RepositoryConfiguration.AnonymousSecurity anonSecurity = securityConfig.getAnonymous();
            if (anonSecurity != null) {
                Set<String> anonRoles = anonSecurity.getAnonymousRoles();
                if (!anonRoles.isEmpty()) {
                    String anonUsername = anonSecurity.getAnonymousUsername();
                    AnonymousProvider anonProvider = new AnonymousProvider(anonUsername, anonRoles);
                    authenticators = authenticators.with(anonProvider);
                    JcrRepository.this.logger.debug("Enabling anonymous authentication and authorization.", new Object[0]);
                }
                if (anonSecurity.useAnonymousOnFailedLogings()) {
                    useAnonymouOnFailedLogins.set(true);
                }
            }
            return authenticators;
        }

        final SessionCache createSystemSession(ExecutionContext context, boolean readOnly) {
            return this.cache.createSession(context, this.systemWorkspaceName(), readOnly);
        }

        protected void shutdown() {
            if (this.repositoryQueryManager != null) {
                this.repositoryQueryManager.stopReindexing();
            }
            this.connectors.shutdown();
            for (ScheduledFuture<?> future : this.backgroundProcesses) {
                future.cancel(true);
            }
            this.unbindFromJndi();
            this.sequencers().shutdown();
            if (!this.internalSessions.isEmpty()) {
                try {
                    for (int counter = 200; counter > 0 && !this.internalSessions.isEmpty(); --counter) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cache.startShutdown();
            if (this.changeBus != null) {
                this.changeBus.shutdown();
            }
            if (this.repositoryQueryManager != null) {
                this.repositoryQueryManager.shutdown();
            }
            if (this.extractors != null) {
                this.extractors.shutdown();
            }
            if (this.backupService != null) {
                this.backupService.shutdown();
            }
            this.binaryStore.shutdown();
            this.cache.completeShutdown();
            if (this.statistics != null) {
                this.statistics.stop();
            }
            if (this.mbean != null) {
                this.mbean.stop();
            }
            this.context().terminateAllPools(30L, TimeUnit.SECONDS);
            this.environment().shutdown();
        }

        protected void bindIntoJndi() {
            if (this.jndiName != null && this.jndiName.trim().length() != 0) {
                try {
                    InitialContext ic = new InitialContext();
                    ic.bind(this.jndiName, (Object)JcrRepository.this);
                }
                catch (NoInitialContextException e) {
                    JcrRepository.this.logger.debug("No JNDI found, so not registering '{0}' repository", new Object[]{JcrRepository.this.getName()});
                }
                catch (OperationNotSupportedException e) {
                    this.warn(JcrI18n.jndiReadOnly, this.config.getName(), this.jndiName);
                }
                catch (NamingException e) {
                    JcrRepository.this.logger.error((Throwable)e, (I18nResource)JcrI18n.unableToBindToJndi, new Object[]{this.config.getName(), this.jndiName, e.getMessage()});
                }
                catch (Exception e) {
                    JcrRepository.this.logger.debug((Throwable)e, "Error while registering the '{0}' repository from the '{1}' name in JNDI", new Object[]{this.config.getName(), this.jndiName});
                }
            }
        }

        protected void unbindFromJndi() {
            if (this.jndiName != null && this.jndiName.trim().length() != 0) {
                try {
                    InitialContext ic = new InitialContext();
                    ic.unbind(this.jndiName);
                }
                catch (NoInitialContextException e) {
                    JcrRepository.this.logger.debug("No JNDI found, so not registering '{0}' repository", new Object[]{JcrRepository.this.getName()});
                }
                catch (OperationNotSupportedException e) {
                    this.warn(JcrI18n.jndiReadOnly, this.config.getName(), this.jndiName);
                }
                catch (Exception e) {
                    JcrRepository.this.logger.debug((Throwable)e, "Error while unregistering the '{0}' repository from the '{1}' name in JNDI", new Object[]{this.config.getName(), this.jndiName});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSession(JcrSession session, boolean internal) {
            WeakHashMap<JcrSession, Object> sessions = internal ? this.internalSessions : this.activeSessions;
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                sessions.put(session, null);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int activeSessionCount() {
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                int n = this.activeSessions.size();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSession(JcrSession session) {
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                if (this.activeSessions.remove(session) == null) {
                    this.internalSessions.remove(session);
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminateSessions() {
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                for (JcrSession session : this.activeSessions.keySet()) {
                    session.terminate(false);
                }
                this.activeSessions.clear();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUpLocks() {
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Starting lock cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
            try {
                HashSet<String> activeSessionIds = new HashSet<String>();
                Lock lock = this.activeSessionLock.writeLock();
                try {
                    lock.lock();
                    Iterator<Map.Entry<JcrSession, Object>> iter = this.activeSessions.entrySet().iterator();
                    while (iter.hasNext()) {
                        JcrSession session = iter.next().getKey();
                        if (!session.isLive()) continue;
                        activeSessionIds.add(session.sessionId());
                    }
                }
                finally {
                    lock.unlock();
                }
                this.lockManager().cleanupLocks(activeSessionIds);
            }
            catch (Throwable e) {
                JcrRepository.this.logger.error(e, (I18nResource)JcrI18n.errorDuringGarbageCollection, new Object[]{e.getMessage()});
            }
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Finishing lock cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
        }

        void cleanUpBinaryValues() {
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Starting binary value cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
            try {
                this.binaryStore.removeValuesUnusedLongerThan(RepositoryConfiguration.UNUSED_BINARY_VALUE_AGE_IN_MILLIS, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                JcrRepository.this.logger.error(e, (I18nResource)JcrI18n.errorDuringGarbageCollection, new Object[]{e.getMessage()});
            }
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Finishing binary value cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
        }

        protected Session loginInternalSession() throws RepositoryException {
            return this.loginInternalSession(this.defaultWorkspaceName());
        }

        protected JcrSession loginInternalSession(String workspaceName) throws RepositoryException {
            try {
                boolean readOnly = false;
                RunningState running = JcrRepository.this.runningState();
                ExecutionContext sessionContext = running.internalWorkerContext();
                Map<String, Object> attributes = Collections.emptyMap();
                JcrSession session = new JcrSession(JcrRepository.this, workspaceName, sessionContext, attributes, readOnly);
                running.addSession(session, true);
                return session;
            }
            catch (WorkspaceNotFoundException e) {
                throw new NoSuchWorkspaceException(e.getMessage(), (Throwable)e);
            }
        }

        protected ChangeBus createBus(RepositoryConfiguration.Clustering clusteringConfiguration, ExecutorService executor, String systemWorkspaceName, String processId) {
            RepositoryChangeBus standaloneBus = new RepositoryChangeBus(executor, systemWorkspaceName);
            return clusteringConfiguration.isEnabled() ? new ClusteredRepositoryChangeBus(clusteringConfiguration, standaloneBus, processId) : standaloneBus;
        }

        void suspendExistingUserTransaction() throws SystemException {
            this.existingUserTransaction = this.transactions.suspend();
        }

        void resumeExistingUserTransaction() throws SystemException {
            if (this.transactions != null && this.existingUserTransaction != null) {
                this.transactions.resume(this.existingUserTransaction);
                this.existingUserTransaction = null;
            }
        }
    }

    protected static class ConfigurationChange
    implements Editor.Observer {
        private final org.infinispan.schematic.document.Path SECURITY_PATH = Paths.path((String)"security");
        private final org.infinispan.schematic.document.Path QUERY_PATH = Paths.path((String)"query");
        private final org.infinispan.schematic.document.Path SEQUENCING_PATH = Paths.path((String)"sequencing");
        private final org.infinispan.schematic.document.Path EXTRACTORS_PATH = Paths.path((String[])new String[]{"query", "extractors"});
        private final org.infinispan.schematic.document.Path STORAGE_PATH = Paths.path((String)"storage");
        private final org.infinispan.schematic.document.Path BINARY_STORAGE_PATH = Paths.path((String[])new String[]{"storage", "binaryStorage"});
        private final org.infinispan.schematic.document.Path WORKSPACES_PATH = Paths.path((String)"workspaces");
        private final org.infinispan.schematic.document.Path PREDEFINED_PATH = Paths.path((String[])new String[]{"workspaces", "predefined"});
        private final org.infinispan.schematic.document.Path JNDI_PATH = Paths.path((String)"jndiName");
        private final org.infinispan.schematic.document.Path TRANSACTION_MODE_PATH = Paths.path((String)"transactionMode");
        private final org.infinispan.schematic.document.Path MINIMUM_BINARY_SIZE_IN_BYTES_PATH = Paths.path((String[])new String[]{"storage", "binaryStorage", "minimumBinarySizeInBytes"});
        private final org.infinispan.schematic.document.Path NAME_PATH = Paths.path((String)"name");
        private final org.infinispan.schematic.document.Path MONITORING_PATH = Paths.path((String)"monitoring");
        private final org.infinispan.schematic.document.Path[] IGNORE_PATHS = new org.infinispan.schematic.document.Path[]{this.STORAGE_PATH, this.BINARY_STORAGE_PATH};
        protected boolean securityChanged = false;
        protected boolean sequencingChanged = false;
        protected boolean extractorsChanged = false;
        protected boolean storageChanged = false;
        protected boolean binaryStorageChanged = false;
        protected boolean indexingChanged = false;
        protected boolean workspacesChanged = false;
        protected boolean predefinedWorkspacesChanged = false;
        protected boolean jndiChanged = false;
        protected boolean transactionMode = false;
        protected boolean largeValueChanged = false;
        protected boolean nameChanged = false;
        protected boolean monitoringChanged = false;

        protected ConfigurationChange() {
        }

        public void setArrayValue(org.infinispan.schematic.document.Path path, Array.Entry entry) {
            this.checkForChanges(path);
        }

        public void addArrayValue(org.infinispan.schematic.document.Path path, Array.Entry entry) {
            this.checkForChanges(path);
        }

        public void removeArrayValue(org.infinispan.schematic.document.Path path, Array.Entry entry) {
            this.checkForChanges(path);
        }

        public void clear(org.infinispan.schematic.document.Path path) {
            this.checkForChanges(path);
        }

        public void put(org.infinispan.schematic.document.Path parentPath, String field, Object newValue) {
            this.checkForChanges(parentPath.with(field));
        }

        public void remove(org.infinispan.schematic.document.Path path, String field) {
            this.checkForChanges(path.with(field));
        }

        private void checkForChanges(org.infinispan.schematic.document.Path path) {
            for (org.infinispan.schematic.document.Path ignorePath : this.IGNORE_PATHS) {
                if (!path.equals(ignorePath)) continue;
                return;
            }
            if (!this.largeValueChanged && path.equals(this.MINIMUM_BINARY_SIZE_IN_BYTES_PATH)) {
                this.largeValueChanged = true;
            } else if (!this.binaryStorageChanged && path.startsWith(this.BINARY_STORAGE_PATH)) {
                this.binaryStorageChanged = true;
            } else if (!this.storageChanged && path.startsWith(this.STORAGE_PATH)) {
                this.storageChanged = true;
            }
            if (!this.sequencingChanged && path.startsWith(this.SEQUENCING_PATH)) {
                this.sequencingChanged = true;
            }
            if (!this.extractorsChanged && path.startsWith(this.EXTRACTORS_PATH)) {
                this.extractorsChanged = true;
            }
            if (!this.securityChanged && path.startsWith(this.SECURITY_PATH)) {
                this.securityChanged = true;
            }
            if (!this.workspacesChanged && path.startsWith(this.WORKSPACES_PATH) && !path.startsWith(this.PREDEFINED_PATH)) {
                this.workspacesChanged = true;
            }
            if (!this.predefinedWorkspacesChanged && path.startsWith(this.PREDEFINED_PATH)) {
                this.predefinedWorkspacesChanged = true;
            }
            if (!this.indexingChanged && path.startsWith(this.QUERY_PATH) && !path.startsWith(this.EXTRACTORS_PATH)) {
                this.indexingChanged = true;
            }
            if (!this.jndiChanged && path.equals(this.JNDI_PATH)) {
                this.jndiChanged = true;
            }
            if (!this.transactionMode && path.equals(this.TRANSACTION_MODE_PATH)) {
                this.transactionMode = true;
            }
            if (!this.nameChanged && path.equals(this.NAME_PATH)) {
                this.nameChanged = true;
            }
            if (!this.monitoringChanged && path.equals(this.MONITORING_PATH)) {
                this.monitoringChanged = true;
            }
        }
    }

    public static final class QueryLanguage {
        public static final String XPATH = "xpath";
        public static final String JCR_SQL = "sql";
        public static final String JCR_SQL2 = "JCR-SQL2";
        public static final String JCR_JQOM = "JCR-JQOM";
        public static final String SEARCH = "search";
    }
}

