/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.math.BigDecimal;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.PropertyValue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexQuery;
import org.apache.lucene.util.Version;
import org.hibernate.search.SearchFactory;
import org.modeshape.jcr.api.query.qom.NodeDepth;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.lucene.CaseOperations;
import org.modeshape.jcr.query.lucene.CompareLengthQuery;
import org.modeshape.jcr.query.lucene.CompareNameQuery;
import org.modeshape.jcr.query.lucene.ComparePathQuery;
import org.modeshape.jcr.query.lucene.CompareStringQuery;
import org.modeshape.jcr.query.lucene.FieldUtil;
import org.modeshape.jcr.query.lucene.LuceneQueryFactory;
import org.modeshape.jcr.query.lucene.MatchNoneQuery;
import org.modeshape.jcr.query.lucene.basic.NodeInfo;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFormatException;

public class BasicLuceneQueryFactory
extends LuceneQueryFactory {
    protected static final int MIN_DEPTH = 0;
    protected static final int MAX_DEPTH = 1000;
    protected static final int MIN_SNS_INDEX = 1;
    protected static final int MAX_SNS_INDEX = 10000000;

    public BasicLuceneQueryFactory(QueryContext context, SearchFactory searchFactory, Version version) {
        super(context, searchFactory, version);
    }

    protected final String pathAsString(Path path) {
        assert (path != null);
        if (path.isRoot()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (Path.Segment segment : path) {
            sb.append('/');
            sb.append((String)this.stringFactory.create(segment.getName()));
            sb.append('[');
            sb.append(segment.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    protected Analyzer getFullTextSearchAnalyzer() {
        return this.searchFactory.getAnalyzer(NodeInfo.class);
    }

    @Override
    protected String fullTextFieldName(String propertyName) {
        return propertyName == null ? "::fts" : ":ft:" + propertyName;
    }

    @Override
    protected Query findAllNodesBelow(Path ancestorPath) {
        String stringifiedPath = this.pathAsString(ancestorPath);
        if (!ancestorPath.isRoot()) {
            stringifiedPath = stringifiedPath + '/';
        }
        return new PrefixQuery(new Term("::pth", stringifiedPath));
    }

    @Override
    protected Query findAllNodesAtOrBelow(Path ancestorPath) {
        if (ancestorPath.isRoot()) {
            return new MatchAllDocsQuery();
        }
        String stringifiedPath = this.pathAsString(ancestorPath);
        return new PrefixQuery(new Term("::pth", stringifiedPath));
    }

    @Override
    protected Query findChildNodes(Path parentPath) {
        Query descendants = this.findAllNodesBelow(parentPath);
        int childrenDepth = parentPath.size() + 1;
        NumericRangeQuery depthQuery = NumericRangeQuery.newIntRange((String)"::dep", (Integer)childrenDepth, (Integer)childrenDepth, (boolean)true, (boolean)true);
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add(descendants, BooleanClause.Occur.MUST);
        combinedQuery.add((Query)depthQuery, BooleanClause.Occur.MUST);
        return combinedQuery;
    }

    @Override
    protected Query findNodeAt(Path path) {
        if (path.isRoot()) {
            return NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        }
        String stringifiedPath = this.pathAsString(path);
        return new TermQuery(new Term("::pth", stringifiedPath));
    }

    @Override
    protected Query findNodesLike(SelectorName selectorName, String fieldName, String likeExpression, CaseOperations.CaseOperation caseOperation) {
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        return CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, fieldName, this.factories, caseOperation);
    }

    protected Query findNodesLike(String fieldName, String likeExpression, CaseOperations.CaseOperation caseOperation) {
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        return CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, fieldName, this.factories, caseOperation);
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, Length propertyLength, Operator operator, Object value) {
        assert (propertyLength != null);
        assert (value != null);
        PropertyValue propertyValue = propertyLength.getPropertyValue();
        String field = (String)this.stringFactory.create(propertyValue.getPropertyName());
        long length = this.factories.getLongFactory().create(value);
        if (length <= 0L) {
            return new MatchNoneQuery();
        }
        if ("jcr:name".equals(field) || "jcr:path".equals(field) || "mode:localName".equals(field)) {
            switch (operator) {
                case EQUAL_TO: {
                    return CompareLengthQuery.createQueryForNodesWithFieldEqualTo(length, field, this.factories);
                }
                case NOT_EQUAL_TO: {
                    return CompareLengthQuery.createQueryForNodesWithFieldNotEqualTo(length, field, this.factories);
                }
                case GREATER_THAN: {
                    return CompareLengthQuery.createQueryForNodesWithFieldGreaterThan(length, field, this.factories);
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    return CompareLengthQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(length, field, this.factories);
                }
                case LESS_THAN: {
                    return CompareLengthQuery.createQueryForNodesWithFieldLessThan(length, field, this.factories);
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    return CompareLengthQuery.createQueryForNodesWithFieldLessThanOrEqualTo(length, field, this.factories);
                }
                case LIKE: {
                    assert (false);
                    break;
                }
            }
        } else {
            field = ":len:" + field;
            switch (operator) {
                case EQUAL_TO: {
                    return NumericRangeQuery.newLongRange((String)field, (Long)length, (Long)length, (boolean)true, (boolean)true);
                }
                case NOT_EQUAL_TO: {
                    NumericRangeQuery upper = NumericRangeQuery.newLongRange((String)field, (Long)length, (Long)Long.MAX_VALUE, (boolean)false, (boolean)false);
                    NumericRangeQuery lower = NumericRangeQuery.newLongRange((String)field, (Long)0L, (Long)length, (boolean)true, (boolean)false);
                    BooleanQuery query = new BooleanQuery();
                    query.add(new BooleanClause((Query)upper, BooleanClause.Occur.SHOULD));
                    query.add(new BooleanClause((Query)lower, BooleanClause.Occur.SHOULD));
                    return query;
                }
                case GREATER_THAN: {
                    return NumericRangeQuery.newLongRange((String)field, (Long)length, (Long)Long.MAX_VALUE, (boolean)false, (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    return NumericRangeQuery.newLongRange((String)field, (Long)length, (Long)Long.MAX_VALUE, (boolean)true, (boolean)false);
                }
                case LESS_THAN: {
                    return NumericRangeQuery.newLongRange((String)field, (Long)0L, (Long)length, (boolean)true, (boolean)false);
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    return NumericRangeQuery.newLongRange((String)field, (Long)0L, (Long)length, (boolean)true, (boolean)true);
                }
                case LIKE: {
                    assert (false);
                    break;
                }
            }
        }
        return null;
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, PropertyValue propertyValue, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        Query query;
        String field;
        Schemata.Column metadata;
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        if ((metadata = this.getMetadataFor(selectorName, field = propertyValue.getPropertyName())) != null) {
            PropertyType requiredType = metadata.getRequiredType();
            PropertyType valueType = PropertyType.discoverType(value);
            Query query1 = this.findNodesWith(selectorName, propertyValue, operator, value, caseOperation, requiredType, metadata);
            if (requiredType == valueType) {
                return query1;
            }
            Query query2 = this.findNodesWith(selectorName, propertyValue, operator, value, caseOperation, valueType, metadata);
            if (query1.equals((Object)query2)) {
                return query1;
            }
            if (operator == Operator.NOT_EQUAL_TO) {
                BooleanQuery result = new BooleanQuery();
                result.add(new BooleanClause(query1, BooleanClause.Occur.MUST));
                result.add(new BooleanClause(query2, BooleanClause.Occur.MUST));
                return result;
            }
            BooleanQuery result = new BooleanQuery();
            result.add(new BooleanClause(query1, BooleanClause.Occur.SHOULD));
            result.add(new BooleanClause(query2, BooleanClause.Occur.SHOULD));
            return result;
        }
        assert (metadata == null);
        if (!(value instanceof String)) {
            PropertyType type = PropertyType.discoverType(value);
            return this.findNodesWith(selectorName, propertyValue, operator, value, caseOperation, type, metadata);
        }
        if ("::wks".equals(field)) {
            String strValue = (String)this.stringFactory.create(value);
            return this.findNodesWith(selectorName, propertyValue, operator, strValue, caseOperation, PropertyType.STRING, null);
        }
        BooleanQuery orOfValues = new BooleanQuery();
        boolean checkBoolean = false;
        boolean checkDate = true;
        try {
            Long lValue = this.factories.getLongFactory().create(value);
            query = this.findNodesWith(selectorName, propertyValue, operator, lValue, caseOperation, PropertyType.LONG, null);
            if (query != null) {
                orOfValues.add(query, BooleanClause.Occur.SHOULD);
            }
            checkBoolean = lValue == 1L || lValue == 0L;
            checkDate = false;
        }
        catch (ValueFormatException e) {
            // empty catch block
        }
        try {
            Double dValue = this.factories.getDoubleFactory().create(value);
            query = this.findNodesWith(selectorName, propertyValue, operator, dValue, caseOperation, PropertyType.DOUBLE, null);
            if (query != null) {
                orOfValues.add(query, BooleanClause.Occur.SHOULD);
            }
        }
        catch (ValueFormatException e) {
            // empty catch block
        }
        if (checkBoolean) {
            try {
                Boolean b = this.factories.getBooleanFactory().create(value);
                query = this.findNodesWith(selectorName, propertyValue, operator, b, caseOperation, PropertyType.BOOLEAN, null);
                if (query != null) {
                    orOfValues.add(query, BooleanClause.Occur.SHOULD);
                }
            }
            catch (ValueFormatException e) {
                // empty catch block
            }
        }
        if (checkDate) {
            try {
                DateTime date = (DateTime)this.factories.getDateFactory().create(value);
                query = this.findNodesWith(selectorName, propertyValue, operator, date, caseOperation, PropertyType.DATE, null);
                if (query != null) {
                    orOfValues.add(query, BooleanClause.Occur.SHOULD);
                }
            }
            catch (ValueFormatException e) {
                // empty catch block
            }
        }
        String strValue = (String)this.stringFactory.create(value);
        Query strQuery = this.findNodesWith(selectorName, propertyValue, operator, strValue, caseOperation, PropertyType.STRING, null);
        if (orOfValues.clauses().isEmpty()) {
            return strQuery;
        }
        orOfValues.add(strQuery, BooleanClause.Occur.SHOULD);
        return orOfValues;
    }

    protected Query findNodesWith(SelectorName selectorName, PropertyValue propertyValue, Operator operator, Object value, CaseOperations.CaseOperation caseOperation, PropertyType valueType, Schemata.Column metadata) {
        String stringValue;
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        String field = propertyValue.getPropertyName();
        if (valueType == PropertyType.OBJECT) {
            valueType = PropertyType.discoverType(value);
        }
        if (operator == Operator.LIKE) {
            stringValue = (String)this.stringFactory.create(value);
            if (stringValue.indexOf(37) != -1 || stringValue.indexOf(95) != -1 || stringValue.indexOf(92) != -1) {
                valueType = PropertyType.STRING;
            } else {
                operator = Operator.EQUAL_TO;
            }
        }
        switch (valueType) {
            case REFERENCE: 
            case WEAKREFERENCE: 
            case SIMPLEREFERENCE: 
            case UUID: 
            case PATH: 
            case NAME: 
            case URI: 
            case STRING: {
                stringValue = (String)this.stringFactory.create(value);
                if (value instanceof Path) {
                    stringValue = this.pathAsString((Path)value);
                }
                switch (operator) {
                    case EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, this.factories, caseOperation);
                    }
                    case NOT_EQUAL_TO: {
                        Query query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, this.factories, caseOperation);
                        return this.not(query);
                    }
                    case GREATER_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, this.factories, caseOperation);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, this.factories, caseOperation);
                    }
                    case LESS_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, this.factories, caseOperation);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, this.factories, caseOperation);
                    }
                    case LIKE: {
                        return this.findNodesLike(selectorName, field, stringValue, caseOperation);
                    }
                }
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = this.factories.getDecimalFactory().create(value);
                stringValue = FieldUtil.decimalToString(decimalValue);
                switch (operator) {
                    case EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, this.factories, caseOperation);
                    }
                    case NOT_EQUAL_TO: {
                        Query query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, this.factories, caseOperation);
                        return this.not(query);
                    }
                    case GREATER_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, this.factories, caseOperation);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, this.factories, caseOperation);
                    }
                    case LESS_THAN: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, this.factories, caseOperation);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, this.factories, caseOperation);
                    }
                    case LIKE: {
                        return this.findNodesLike(selectorName, field, stringValue, caseOperation);
                    }
                }
                break;
            }
            case DATE: {
                Long longMinimum = Long.MIN_VALUE;
                Long longMaximum = Long.MAX_VALUE;
                if (metadata != null) {
                    longMinimum = (Long)metadata.getMinimum();
                    longMaximum = (Long)metadata.getMaximum();
                    if (longMinimum == null) {
                        longMinimum = Long.MIN_VALUE;
                    }
                    if (longMaximum == null) {
                        longMaximum = Long.MAX_VALUE;
                    }
                }
                long date = this.factories.getLongFactory().create(value);
                switch (operator) {
                    case EQUAL_TO: {
                        if (date < longMinimum || date > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)date, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (date < longMinimum || date > longMaximum) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery lowerRange = NumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)date, (boolean)true, (boolean)false);
                        NumericRangeQuery upperRange = NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)longMaximum, (boolean)false, (boolean)true);
                        BooleanQuery query = new BooleanQuery();
                        query.add((Query)lowerRange, BooleanClause.Occur.SHOULD);
                        query.add((Query)upperRange, BooleanClause.Occur.SHOULD);
                        return query;
                    }
                    case GREATER_THAN: {
                        if (date > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)longMaximum, (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (date > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)date, (Long)longMaximum, (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (date < longMinimum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)date, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (date < longMinimum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)date, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case LONG: {
                Long longMaximum;
                Long longMinimum;
                if (metadata != null) {
                    longMinimum = (Long)metadata.getMinimum();
                    longMaximum = (Long)metadata.getMaximum();
                    if (longMinimum == null) {
                        longMinimum = Long.MIN_VALUE;
                    }
                    if (longMaximum == null) {
                        longMaximum = Long.MAX_VALUE;
                    }
                } else {
                    longMinimum = Long.MIN_VALUE;
                    longMaximum = Long.MAX_VALUE;
                }
                long longValue = this.factories.getLongFactory().create(value);
                switch (operator) {
                    case EQUAL_TO: {
                        if (longValue < longMinimum || longValue > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longValue, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (longValue < longMinimum || longValue > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        NumericRangeQuery lowerRange = NumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)longValue, (boolean)true, (boolean)false);
                        NumericRangeQuery upperRange = NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longMaximum, (boolean)false, (boolean)true);
                        BooleanQuery query = new BooleanQuery();
                        query.add((Query)lowerRange, BooleanClause.Occur.SHOULD);
                        query.add((Query)upperRange, BooleanClause.Occur.SHOULD);
                        return query;
                    }
                    case GREATER_THAN: {
                        if (longValue > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longMaximum, (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (longValue > longMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longMaximum, (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (longValue < longMinimum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)longValue, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (longValue < longMinimum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)longValue, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case BOOLEAN: {
                boolean booleanValue = this.factories.getBooleanFactory().create(value);
                if (booleanValue) {
                    switch (operator) {
                        case EQUAL_TO: {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)false, (boolean)true);
                        }
                        case NOT_EQUAL_TO: {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)false);
                        }
                        case GREATER_THAN_OR_EQUAL_TO: {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)1, (Integer)1, (boolean)true, (boolean)true);
                        }
                        case LESS_THAN_OR_EQUAL_TO: {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)true);
                        }
                        case GREATER_THAN: {
                            return new MatchNoneQuery();
                        }
                        case LESS_THAN: {
                            return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)0, (boolean)true, (boolean)true);
                        }
                        case LIKE: {
                            assert (false);
                            return null;
                        }
                    }
                    break;
                }
                switch (operator) {
                    case EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)false);
                    }
                    case NOT_EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)true);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)0, (boolean)true, (boolean)true);
                    }
                    case GREATER_THAN: {
                        return NumericRangeQuery.newIntRange((String)field, (Integer)1, (Integer)1, (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        return new MatchNoneQuery();
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case DOUBLE: {
                double doubleValue = this.factories.getDoubleFactory().create(value);
                Double doubleMinimum = Double.MIN_VALUE;
                Double doubleMaximum = Double.MAX_VALUE;
                if (metadata != null) {
                    doubleMinimum = (Double)metadata.getMinimum();
                    doubleMaximum = (Double)metadata.getMaximum();
                    if (doubleMinimum == null) {
                        doubleMinimum = Double.MIN_VALUE;
                    }
                    if (doubleMaximum == null) {
                        doubleMaximum = Double.MAX_VALUE;
                    }
                }
                switch (operator) {
                    case EQUAL_TO: {
                        if (doubleValue < doubleMinimum || doubleValue > doubleMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleValue, (boolean)true, (boolean)true);
                    }
                    case NOT_EQUAL_TO: {
                        if (doubleValue < doubleMinimum || doubleValue > doubleMaximum) {
                            return new MatchAllDocsQuery();
                        }
                        NumericRangeQuery lowerRange = NumericRangeQuery.newDoubleRange((String)field, (Double)doubleMinimum, (Double)doubleValue, (boolean)true, (boolean)false);
                        NumericRangeQuery upperRange = NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleMaximum, (boolean)false, (boolean)true);
                        BooleanQuery query = new BooleanQuery();
                        query.add((Query)lowerRange, BooleanClause.Occur.SHOULD);
                        query.add((Query)upperRange, BooleanClause.Occur.SHOULD);
                        return query;
                    }
                    case GREATER_THAN: {
                        if (doubleValue > doubleMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleMaximum, (boolean)false, (boolean)true);
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        if (doubleValue > doubleMaximum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleMaximum, (boolean)true, (boolean)true);
                    }
                    case LESS_THAN: {
                        if (doubleValue < doubleMinimum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleMinimum, (Double)doubleValue, (boolean)true, (boolean)false);
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        if (doubleValue < doubleMinimum) {
                            return new MatchNoneQuery();
                        }
                        return NumericRangeQuery.newDoubleRange((String)field, (Double)doubleMinimum, (Double)doubleValue, (boolean)true, (boolean)true);
                    }
                    case LIKE: {
                        assert (false);
                        return null;
                    }
                }
                break;
            }
            case BINARY: 
            case OBJECT: {
                assert (false);
                return null;
            }
        }
        return null;
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, ReferenceValue referenceValue, Operator operator, Object value) {
        String field = referenceValue.getPropertyName();
        if (field == null) {
            field = referenceValue.includesWeakReferences() || referenceValue.includeSimpleReferences() ? "::ref" : "::sref";
        }
        String stringValue = (String)this.stringFactory.create(value);
        CaseOperations.CaseOperation caseOperation = CaseOperations.AS_IS;
        switch (operator) {
            case EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, this.factories, caseOperation);
            }
            case NOT_EQUAL_TO: {
                return this.not(CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, this.factories, caseOperation));
            }
            case GREATER_THAN: {
                return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, this.factories, caseOperation);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, this.factories, caseOperation);
            }
            case LESS_THAN: {
                return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, this.factories, caseOperation);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, this.factories, caseOperation);
            }
            case LIKE: {
                return this.findNodesLike(selectorName, field, stringValue, caseOperation);
            }
        }
        return null;
    }

    @Override
    protected Query findNodesWithNumericRange(SelectorName selectorName, PropertyValue propertyValue, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        String field = (String)this.stringFactory.create(propertyValue.getPropertyName());
        return this.findNodesWithNumericRange(selectorName, field, lowerValue, upperValue, includesLower, includesUpper);
    }

    @Override
    protected Query findNodesWithNumericRange(SelectorName selectorName, NodeDepth depth, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        return this.findNodesWithNumericRange(selectorName, "::dep", lowerValue, upperValue, includesLower, includesUpper);
    }

    protected Query findNodesWithNumericRange(SelectorName selectorName, String field, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        Schemata.Column metadata = this.getMetadataFor(selectorName, field);
        PropertyType type = null;
        if (metadata != null) {
            type = metadata.getRequiredType();
        } else {
            PropertyType upperType;
            PropertyType lowerType = PropertyType.discoverType(lowerValue);
            if (lowerType != (upperType = PropertyType.discoverType(upperValue))) {
                return new MatchNoneQuery();
            }
            type = lowerType;
        }
        switch (type) {
            case DATE: {
                long lowerDate = this.factories.getLongFactory().create(lowerValue);
                long upperDate = this.factories.getLongFactory().create(upperValue);
                return NumericRangeQuery.newLongRange((String)field, (Long)lowerDate, (Long)upperDate, (boolean)includesLower, (boolean)includesUpper);
            }
            case LONG: {
                long lowerLong = this.factories.getLongFactory().create(lowerValue);
                long upperLong = this.factories.getLongFactory().create(upperValue);
                return NumericRangeQuery.newLongRange((String)field, (Long)lowerLong, (Long)upperLong, (boolean)includesLower, (boolean)includesUpper);
            }
            case DOUBLE: {
                double lowerDouble = this.factories.getDoubleFactory().create(lowerValue);
                double upperDouble = this.factories.getDoubleFactory().create(upperValue);
                return NumericRangeQuery.newDoubleRange((String)field, (Double)lowerDouble, (Double)upperDouble, (boolean)includesLower, (boolean)includesUpper);
            }
            case BOOLEAN: {
                int lowerInt = this.factories.getBooleanFactory().create(lowerValue) != false ? 1 : 0;
                int upperInt = this.factories.getBooleanFactory().create(upperValue) != false ? 1 : 0;
                return NumericRangeQuery.newIntRange((String)field, (Integer)lowerInt, (Integer)upperInt, (boolean)includesLower, (boolean)includesUpper);
            }
            case DECIMAL: {
                BigDecimal lowerDecimal = this.factories.getDecimalFactory().create(lowerValue);
                BigDecimal upperDecimal = this.factories.getDecimalFactory().create(upperValue);
                CaseOperations.CaseOperation caseOp = CaseOperations.AS_IS;
                String lsv = FieldUtil.decimalToString(lowerDecimal);
                String usv = FieldUtil.decimalToString(upperDecimal);
                CompareStringQuery lower = null;
                lower = includesLower ? CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(lsv, field, this.factories, caseOp) : CompareStringQuery.createQueryForNodesWithFieldGreaterThan(lsv, field, this.factories, caseOp);
                CompareStringQuery upper = null;
                upper = includesUpper ? CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(usv, field, this.factories, caseOp) : CompareStringQuery.createQueryForNodesWithFieldLessThan(usv, field, this.factories, caseOp);
                BooleanQuery query = new BooleanQuery();
                query.add((Query)lower, BooleanClause.Occur.MUST);
                query.add((Query)upper, BooleanClause.Occur.MUST);
                return query;
            }
            case REFERENCE: 
            case WEAKREFERENCE: 
            case SIMPLEREFERENCE: 
            case UUID: 
            case PATH: 
            case NAME: 
            case URI: 
            case STRING: 
            case BINARY: 
            case OBJECT: {
                assert (false);
                break;
            }
        }
        return new MatchNoneQuery();
    }

    protected String likeExpresionForWildcardPath(String path) {
        if (path.equals("/") || path.equals("%")) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        if ((path = path.replaceAll("%+", "%")).startsWith("%/")) {
            sb.append("%");
            if (path.length() == 2) {
                return sb.toString();
            }
            path = path.substring(2);
        }
        for (String segment : path.split("/")) {
            if (segment.length() == 0) continue;
            sb.append("/");
            sb.append(segment);
            if (segment.equals("%") || segment.equals("_") || segment.endsWith("]") || segment.endsWith("]%") || segment.endsWith("]_")) continue;
            sb.append("[1]");
        }
        if (path.endsWith("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, NodePath nodePath, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        Path pathValue = operator != Operator.LIKE ? (Path)this.pathFactory.create(value) : null;
        ComparePathQuery query = null;
        switch (operator) {
            case EQUAL_TO: {
                return this.findNodeAt(pathValue);
            }
            case NOT_EQUAL_TO: {
                return this.not(this.findNodeAt(pathValue));
            }
            case LIKE: {
                String likeExpression = (String)this.stringFactory.create(value);
                likeExpression = this.likeExpresionForWildcardPath(likeExpression);
                if (likeExpression.indexOf("[%]") != -1) {
                    String regex = likeExpression;
                    regex = regex.replace("[%]", "[\\d+]");
                    regex = regex.replace("[", "\\[");
                    regex = regex.replace("*", ".*").replace("?", ".");
                    regex = regex.replace("%", ".*").replace("_", ".");
                    RegexQuery regexQuery = new RegexQuery(new Term("::pth", regex));
                    int flags = caseOperation == CaseOperations.AS_IS ? 0 : 2;
                    regexQuery.setRegexImplementation((RegexCapabilities)new JavaUtilRegexCapabilities(flags));
                    query = regexQuery;
                    break;
                }
                query = this.findNodesLike(selectorName, "::pth", likeExpression, caseOperation);
                break;
            }
            case GREATER_THAN: {
                query = ComparePathQuery.createQueryForNodesWithPathGreaterThan(pathValue, "::pth", this.factories, caseOperation);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query = ComparePathQuery.createQueryForNodesWithPathGreaterThanOrEqualTo(pathValue, "::pth", this.factories, caseOperation);
                break;
            }
            case LESS_THAN: {
                query = ComparePathQuery.createQueryForNodesWithPathLessThan(pathValue, "::pth", this.factories, caseOperation);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query = ComparePathQuery.createQueryForNodesWithPathLessThanOrEqualTo(pathValue, "::pth", this.factories, caseOperation);
            }
        }
        return query;
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, NodeName nodeName, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        String stringValue = (String)this.stringFactory.create(value);
        if (stringValue.startsWith("./") && stringValue.length() > 2) {
            stringValue = stringValue.substring(2);
        }
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        Path.Segment segment = operator != Operator.LIKE ? this.pathFactory.createSegment(stringValue) : null;
        boolean includeSns = stringValue.indexOf(91) != -1;
        Query query = null;
        switch (operator) {
            case EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameEqualTo(segment, "::nam", "::sns", this.factories, caseOperation, includeSns);
                break;
            }
            case NOT_EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameEqualTo(segment, "::nam", "::sns", this.factories, caseOperation, includeSns);
                query = this.not(query);
                break;
            }
            case GREATER_THAN: {
                query = CompareNameQuery.createQueryForNodesWithNameGreaterThan(segment, "::nam", "::sns", this.factories, caseOperation, includeSns);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameGreaterThanOrEqualTo(segment, "::nam", "::sns", this.factories, caseOperation, includeSns);
                break;
            }
            case LESS_THAN: {
                query = CompareNameQuery.createQueryForNodesWithNameLessThan(segment, "::nam", "::sns", this.factories, caseOperation, includeSns);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query = CompareNameQuery.createQueryForNodesWithNameLessThanOrEqualTo(segment, "::nam", "::sns", this.factories, caseOperation, includeSns);
                break;
            }
            case LIKE: {
                String likeExpression = stringValue;
                int openBracketIndex = likeExpression.indexOf(91);
                if (openBracketIndex != -1) {
                    String localNameExpression = likeExpression.substring(0, openBracketIndex);
                    String snsIndexExpression = likeExpression.substring(openBracketIndex);
                    Query localNameQuery = CompareStringQuery.createQueryForNodesWithFieldLike(localNameExpression, "::nam", this.factories, caseOperation);
                    Query snsQuery = this.createSnsIndexQuery(snsIndexExpression);
                    if (localNameQuery == null) {
                        query = snsQuery == null ? new MatchNoneQuery() : snsQuery;
                    } else if (snsQuery == null) {
                        query = localNameQuery;
                    } else {
                        BooleanQuery booleanQuery = new BooleanQuery();
                        booleanQuery.add(localNameQuery, BooleanClause.Occur.MUST);
                        booleanQuery.add(snsQuery, BooleanClause.Occur.MUST);
                        query = booleanQuery;
                    }
                } else {
                    query = CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, "::nam", this.factories, caseOperation);
                }
                assert (query != null);
                break;
            }
        }
        return query;
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, NodeLocalName nodeName, Operator operator, Object value, CaseOperations.CaseOperation caseOperation) {
        String nameValue = (String)this.stringFactory.create(value);
        if (caseOperation == null) {
            caseOperation = CaseOperations.AS_IS;
        }
        Query query = null;
        switch (operator) {
            case LIKE: {
                String likeExpression = nameValue;
                query = this.findNodesLike("::loc", likeExpression, caseOperation);
                break;
            }
            case EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(nameValue, "::loc", this.factories, caseOperation);
                break;
            }
            case NOT_EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(nameValue, "::loc", this.factories, caseOperation);
                query = this.not(query);
                break;
            }
            case GREATER_THAN: {
                query = CompareStringQuery.createQueryForNodesWithFieldGreaterThan(nameValue, "::loc", this.factories, caseOperation);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(nameValue, "::loc", this.factories, caseOperation);
                break;
            }
            case LESS_THAN: {
                query = CompareStringQuery.createQueryForNodesWithFieldLessThan(nameValue, "::loc", this.factories, caseOperation);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                query = CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(nameValue, "::loc", this.factories, caseOperation);
            }
        }
        return query;
    }

    @Override
    protected Query findNodesWith(SelectorName selectorName, NodeDepth depthConstraint, Operator operator, Object value) {
        int depth = this.factories.getLongFactory().create(value).intValue();
        switch (operator) {
            case EQUAL_TO: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)depth, (boolean)true, (boolean)true);
            }
            case NOT_EQUAL_TO: {
                NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)depth, (boolean)true, (boolean)true);
                return this.not((Query)query);
            }
            case GREATER_THAN: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)1000, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)depth, (Integer)1000, (boolean)true, (boolean)true);
            }
            case LESS_THAN: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)depth, (boolean)true, (boolean)false);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return NumericRangeQuery.newIntRange((String)"::dep", (Integer)0, (Integer)depth, (boolean)true, (boolean)true);
            }
            case LIKE: {
                return null;
            }
        }
        return null;
    }

    protected Query createSnsIndexQuery(String likeExpression) {
        if (likeExpression == null) {
            return null;
        }
        if ((likeExpression = likeExpression.trim()).length() == 0) {
            return null;
        }
        assert (likeExpression.charAt(0) == '[');
        int closeBracketIndex = (likeExpression = likeExpression.substring(1)).indexOf(93);
        if (closeBracketIndex != -1) {
            likeExpression = likeExpression.substring(0, closeBracketIndex);
        }
        if (likeExpression.equals("_")) {
            return NumericRangeQuery.newIntRange((String)"::sns", (Integer)1, (Integer)9, (boolean)true, (boolean)true);
        }
        if (likeExpression.equals("%")) {
            return NumericRangeQuery.newIntRange((String)"::sns", (Integer)1, (Integer)10000000, (boolean)true, (boolean)true);
        }
        if (likeExpression.indexOf(95) != -1) {
            int secondWildcardChar;
            if (likeExpression.indexOf(37) != -1) {
                return this.findNodesLike("::sns", likeExpression, null);
            }
            int firstWildcardChar = likeExpression.indexOf(95);
            if (firstWildcardChar + 1 < likeExpression.length() && (secondWildcardChar = likeExpression.indexOf(95, firstWildcardChar + 1)) != -1) {
                return this.findNodesLike("::sns", likeExpression, null);
            }
            String lowerExpression = likeExpression.replace('_', '0');
            String upperExpression = likeExpression.replace('_', '9');
            try {
                int lowerSns = Integer.parseInt(lowerExpression);
                int upperSns = Integer.parseInt(upperExpression);
                return NumericRangeQuery.newIntRange((String)"::sns", (Integer)lowerSns, (Integer)upperSns, (boolean)true, (boolean)true);
            }
            catch (NumberFormatException e) {
                return new MatchNoneQuery();
            }
        }
        if (likeExpression.indexOf(37) != -1) {
            return this.findNodesLike("::sns", likeExpression, null);
        }
        try {
            int sns = Integer.parseInt(likeExpression);
            return NumericRangeQuery.newIntRange((String)"::sns", (Integer)sns, (Integer)sns, (boolean)true, (boolean)true);
        }
        catch (NumberFormatException e) {
            return new MatchNoneQuery();
        }
    }
}

