/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.TextExtractors;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.NullMimeTypeDetector;
import org.modeshape.jcr.text.TextExtractorContext;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;

public class CompositeBinaryStore
implements BinaryStore {
    private static final String DEFAULT_STRATEGY_HINT = "default";
    private volatile TextExtractors extractors;
    private volatile MimeTypeDetector detector = NullMimeTypeDetector.INSTANCE;
    protected Logger logger = Logger.getLogger(this.getClass());
    private Map<String, BinaryStore> namedStores;
    private BinaryStore defaultBinaryStore;

    public CompositeBinaryStore(Map<String, BinaryStore> namedStores) {
        this.namedStores = namedStores;
        this.defaultBinaryStore = null;
    }

    @Override
    public void start() {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            bs.start();
        }
    }

    @Override
    public void shutdown() {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            bs.shutdown();
        }
    }

    @Override
    public long getMinimumBinarySizeInBytes() {
        long minimumBinarySize = Long.MAX_VALUE;
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            if (minimumBinarySize <= bs.getMinimumBinarySizeInBytes()) continue;
            minimumBinarySize = bs.getMinimumBinarySizeInBytes();
        }
        return minimumBinarySize;
    }

    @Override
    public void setMinimumBinarySizeInBytes(long minSizeInBytes) {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            bs.setMinimumBinarySizeInBytes(minSizeInBytes);
        }
    }

    @Override
    public void setTextExtractors(TextExtractors textExtractors) {
        CheckArg.isNotNull((Object)textExtractors, (String)"textExtractors");
        this.extractors = textExtractors;
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            bs.setTextExtractors(textExtractors);
        }
    }

    @Override
    public void setMimeTypeDetector(MimeTypeDetector mimeTypeDetector) {
        this.detector = mimeTypeDetector != null ? mimeTypeDetector : NullMimeTypeDetector.INSTANCE;
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            bs.setMimeTypeDetector(mimeTypeDetector);
        }
    }

    @Override
    public BinaryValue storeValue(InputStream stream) throws BinaryStoreException {
        return this.storeValue(stream, DEFAULT_STRATEGY_HINT);
    }

    @Override
    public BinaryValue storeValue(InputStream stream, String hint) throws BinaryStoreException {
        BinaryStore binaryStore = this.selectBinaryStore(hint);
        BinaryValue bv = binaryStore.storeValue(stream);
        this.logger.debug("Stored binary " + bv.getKey() + " into binary store " + binaryStore, new Object[0]);
        return bv;
    }

    public BinaryKey moveValue(BinaryKey key, String source, String destination) throws BinaryStoreException {
        BinaryStore sourceStore = source == null ? this.findBinaryStoreContainingKey(key) : this.selectBinaryStore(source);
        if (sourceStore == null || !sourceStore.hasBinary(key)) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, sourceStore}));
        }
        BinaryStore destinationStore = this.selectBinaryStore(destination);
        if (sourceStore.equals(destinationStore)) {
            return key;
        }
        BinaryValue binaryValue = this.storeValue(sourceStore.getInputStream(key), destination);
        sourceStore.markAsUnused(Collections.singleton(key));
        return binaryValue.getKey();
    }

    public void moveValue(BinaryKey key, String destination) throws BinaryStoreException {
        this.moveValue(key, null, destination);
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            Map.Entry<String, BinaryStore> entry = it.next();
            String binaryStoreKey = entry.getKey();
            BinaryStore binaryStore = entry.getValue();
            this.logger.trace("Checking binary store " + binaryStoreKey + " for key " + key, new Object[0]);
            try {
                return binaryStore.getInputStream(key);
            }
            catch (BinaryStoreException e) {
                this.logger.trace((Throwable)((Object)e), "The named store " + binaryStoreKey + " raised exception", new Object[0]);
            }
        }
        throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.toString()}));
    }

    @Override
    public boolean hasBinary(BinaryKey key) {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            BinaryStore bs = it.next().getValue();
            if (!bs.hasBinary(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            Map.Entry<String, BinaryStore> entry = it.next();
            String binaryStoreKey = entry.getKey();
            BinaryStore bs = entry.getValue();
            try {
                bs.markAsUnused(keys);
            }
            catch (BinaryStoreException e) {
                this.logger.debug((Throwable)((Object)e), "The named store " + binaryStoreKey + " raised exception", new Object[0]);
            }
        }
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            Map.Entry<String, BinaryStore> entry = it.next();
            String binaryStoreKey = entry.getKey();
            BinaryStore bs = entry.getValue();
            try {
                bs.removeValuesUnusedLongerThan(minimumAge, unit);
            }
            catch (BinaryStoreException e) {
                this.logger.debug((Throwable)((Object)e), "The named store " + binaryStoreKey + " raised exception", new Object[0]);
            }
        }
    }

    @Override
    public String getText(BinaryValue binary) throws BinaryStoreException {
        if (binary instanceof InMemoryBinaryValue) {
            if (this.extractors == null || !this.extractors.extractionEnabled()) {
                return null;
            }
            return this.extractors.extract((InMemoryBinaryValue)binary, new TextExtractorContext(this.detector));
        }
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            Map.Entry<String, BinaryStore> entry = it.next();
            String binaryStoreKey = entry.getKey();
            BinaryStore bs = entry.getValue();
            try {
                if (!bs.hasBinary(binary.getKey())) continue;
                return bs.getText(binary);
            }
            catch (BinaryStoreException e) {
                this.logger.debug((Throwable)((Object)e), "The named store " + binaryStoreKey + " raised exception", new Object[0]);
                if (it.hasNext()) continue;
                throw e;
            }
        }
        throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{binary.getKey(), this}));
    }

    @Override
    public String getMimeType(BinaryValue binary, String name) throws IOException, RepositoryException {
        if (this.detector == null) {
            return null;
        }
        String detectedMimeType = this.detector.mimeTypeOf(name, (Binary)binary);
        if (binary instanceof InMemoryBinaryValue) {
            return detectedMimeType;
        }
        Iterator<Map.Entry<String, BinaryStore>> it = this.getNamedStoreIterator();
        while (it.hasNext()) {
            Map.Entry<String, BinaryStore> entry = it.next();
            String binaryStoreKey = entry.getKey();
            BinaryStore bs = entry.getValue();
            try {
                if (!bs.hasBinary(binary.getKey())) continue;
                return bs.getMimeType(binary, name);
            }
            catch (BinaryStoreException e) {
                this.logger.debug((Throwable)((Object)e), "The named store " + binaryStoreKey + " raised exception", new Object[0]);
                if (it.hasNext()) continue;
                throw e;
            }
        }
        throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{binary.getKey(), this}));
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        Iterable<BinaryKey> generatedIterable = new HashSet<BinaryKey>();
        Iterator<Map.Entry<String, BinaryStore>> binaryStoreIterator = this.getNamedStoreIterator();
        while (binaryStoreIterator.hasNext()) {
            BinaryStore bs = binaryStoreIterator.next().getValue();
            generatedIterable = org.modeshape.common.collection.Collections.concat(generatedIterable, bs.getAllBinaryKeys());
        }
        return generatedIterable;
    }

    public Iterator<Map.Entry<String, BinaryStore>> getNamedStoreIterator() {
        return this.namedStores.entrySet().iterator();
    }

    public BinaryStore findBinaryStoreContainingKey(BinaryKey key) {
        Iterator<Map.Entry<String, BinaryStore>> binaryStoreIterator = this.getNamedStoreIterator();
        while (binaryStoreIterator.hasNext()) {
            BinaryStore bs = binaryStoreIterator.next().getValue();
            if (!bs.hasBinary(key)) continue;
            return bs;
        }
        return null;
    }

    private BinaryStore selectBinaryStore(String hint) {
        BinaryStore namedBinaryStore = null;
        if (hint != null) {
            this.logger.trace("Selecting named binary store for hint: " + hint, new Object[0]);
            namedBinaryStore = this.namedStores.get(hint);
        }
        if (namedBinaryStore == null) {
            namedBinaryStore = this.getDefaultBinaryStore();
        }
        this.logger.trace("Selected binary store: " + namedBinaryStore.toString(), new Object[0]);
        return namedBinaryStore;
    }

    private BinaryStore getDefaultBinaryStore() {
        if (this.defaultBinaryStore == null) {
            if (this.namedStores.containsKey(DEFAULT_STRATEGY_HINT)) {
                this.defaultBinaryStore = this.namedStores.get(DEFAULT_STRATEGY_HINT);
            } else {
                this.logger.trace("Did not find a named binary store with the key 'default', picking the first binary store in the list", new Object[0]);
                Iterator<BinaryStore> iterator = this.namedStores.values().iterator();
                if (iterator.hasNext()) {
                    this.defaultBinaryStore = iterator.next();
                }
            }
        }
        return this.defaultBinaryStore;
    }
}

