/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Credentials;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.security.AuthenticationProvider;

public class AuthenticationProviders
implements AuthenticationProvider {
    private final List<AuthenticationProvider> providers;

    public AuthenticationProviders() {
        this.providers = new CopyOnWriteArrayList<AuthenticationProvider>();
    }

    public AuthenticationProviders(List<AuthenticationProvider> providers) {
        this.providers = new CopyOnWriteArrayList<AuthenticationProvider>(providers);
    }

    public AuthenticationProviders(AuthenticationProvider ... providers) {
        this.providers = new CopyOnWriteArrayList<AuthenticationProvider>(providers);
    }

    @Override
    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        ExecutionContext result = null;
        for (AuthenticationProvider provider : this.providers) {
            try {
                sessionAttributes.clear();
                result = provider.authenticate(credentials, repositoryName, workspaceName, repositoryContext, sessionAttributes);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                Logger.getLogger(AuthenticationProviders.class).error((Throwable)e, (I18nResource)JcrI18n.errorInAuthenticationProvider, new Object[]{provider.getClass().getName(), repositoryName, e.getMessage()});
            }
        }
        return null;
    }

    public AuthenticationProviders with(AuthenticationProvider provider) {
        CopyOnWriteArrayList<AuthenticationProvider> providers = new CopyOnWriteArrayList<AuthenticationProvider>(this.providers);
        providers.add(provider);
        return new AuthenticationProviders(providers);
    }

    public static AuthenticationProviders with(AuthenticationProvider ... providers) {
        CopyOnWriteArrayList<AuthenticationProvider> providerList = new CopyOnWriteArrayList<AuthenticationProvider>();
        for (AuthenticationProvider provider : providers) {
            if (provider == null) continue;
            providerList.add(provider);
        }
        return new AuthenticationProviders(providerList);
    }
}

