/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class Database {
    private static final Logger LOGGER = Logger.getLogger(Database.class);
    public static final String TABLE_NAME = "CONTENT_STORE";
    public static final String STATEMENTS_FILE_PATH = "org/modeshape/jcr/database/";
    protected static final String STATEMENTS_FILE_PREFIX = "binary_store_";
    protected static final String STATEMENTS_FILENAME_SUFFIX = "_database.properties";
    protected static final String DEFAULT_STATEMENTS_FILE_PATH = "org/modeshape/jcr/database/binary_store_default_database.properties";
    private final Connection connection;
    private final Type databaseType;
    private final String prefix;
    private final String tableName;
    private final Properties statements;
    private PreparedStatement addContentSql;
    private PreparedStatement getUsedContentSql;
    private PreparedStatement getUnusedContentSql;
    private PreparedStatement markUnusedSql;
    private PreparedStatement markUsedSql;
    private PreparedStatement removedExpiredSql;
    private PreparedStatement getMimeType;
    private PreparedStatement setMimeType;
    private PreparedStatement getExtractedTextSql;
    private PreparedStatement setExtractedTextSql;
    private PreparedStatement getBinaryKeysSql;

    public Database(Connection connection) throws BinaryStoreException {
        this(connection, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(Connection connection, Type type, String prefix) throws BinaryStoreException {
        block11: {
            assert (connection != null);
            this.connection = connection;
            this.databaseType = type != null ? type : this.determineType();
            this.prefix = prefix == null ? null : prefix.trim();
            this.tableName = this.prefix != null && this.prefix.length() != 0 ? this.prefix + TABLE_NAME : TABLE_NAME;
            LOGGER.debug("Discovered DBMS type for binary store as '{0}' on {1}", new Object[]{this.databaseType, connection});
            try {
                String statementsFilename = DEFAULT_STATEMENTS_FILE_PATH;
                Properties defaultStatements = new Properties();
                try (InputStream statementStream = this.getClass().getClassLoader().getResourceAsStream(statementsFilename);){
                    LOGGER.trace("Loading default statement from '{0}'", new Object[]{statementsFilename});
                    defaultStatements.load(statementStream);
                }
                statementsFilename = "org/modeshape/jcr/database/binary_store_" + this.databaseType.name().toLowerCase() + STATEMENTS_FILENAME_SUFFIX;
                statementStream = this.getClass().getClassLoader().getResourceAsStream(statementsFilename);
                if (statementStream != null) {
                    try {
                        LOGGER.trace("Loading DBMS-specific statement from '{0}'", new Object[]{statementsFilename});
                        this.statements = new Properties(defaultStatements);
                        this.statements.load(statementStream);
                        break block11;
                    }
                    finally {
                        statementStream.close();
                    }
                }
                this.statements = defaultStatements;
                LOGGER.trace("No DBMS-specific statement found in '{0}'", new Object[]{statementsFilename});
            }
            catch (IOException e) {
                throw new BinaryStoreException(e);
            }
        }
    }

    public void initialize() throws BinaryStoreException {
        try {
            boolean createTable = true;
            try {
                PreparedStatement exists = this.prepareStatement("table_exists_query");
                LOGGER.trace("Running statement: {0}", new Object[]{exists});
                exists.execute();
                exists.close();
                createTable = false;
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (createTable) {
                LOGGER.debug("Unable to find existing table. Attempting to create '{0}' table in {1}", new Object[]{this.tableName, this.connection});
                try {
                    PreparedStatement create = this.prepareStatement("create_table");
                    LOGGER.trace("Running statement: {0}", new Object[]{create});
                    create.execute();
                    create.close();
                }
                catch (SQLException e) {
                    String msg = JcrI18n.errorCreatingDatabaseTable.text(new Object[]{this.tableName, this.databaseType, this.connection, e.getMessage()});
                    throw new BinaryStoreException(msg);
                }
            }
            this.addContentSql = this.prepareStatement("add_content");
            this.getUsedContentSql = this.prepareStatement("get_used_content");
            this.getUnusedContentSql = this.prepareStatement("get_unused_content");
            this.markUnusedSql = this.prepareStatement("mark_unused");
            this.markUsedSql = this.prepareStatement("mark_used");
            this.removedExpiredSql = this.prepareStatement("remove_expired");
            this.getMimeType = this.prepareStatement("get_mimetype");
            this.setMimeType = this.prepareStatement("set_mimetype");
            this.getExtractedTextSql = this.prepareStatement("get_extracted_text");
            this.setExtractedTextSql = this.prepareStatement("set_extracted_text");
            this.getBinaryKeysSql = this.prepareStatement("get_binary_keys");
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected PreparedStatement prepareStatement(String statementKey) throws SQLException {
        String statementString = this.statements.getProperty(statementKey);
        statementString = StringUtil.createString((String)statementString, (Object[])new Object[]{this.tableName});
        LOGGER.trace("Preparing statement: {0}", new Object[]{statementString});
        return this.connection.prepareStatement(statementString);
    }

    protected Type determineType() throws BinaryStoreException {
        try {
            String name = this.connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (name.toLowerCase().contains("mysql")) {
                return Type.MYSQL;
            }
            if (name.contains("postgres")) {
                return Type.POSTGRES;
            }
            if (name.contains("derby")) {
                return Type.DERBY;
            }
            if (name.contains("hsql") || name.toLowerCase().contains("hypersonic")) {
                return Type.HSQL;
            }
            if (name.contains("h2")) {
                return Type.H2;
            }
            if (name.contains("sqlite")) {
                return Type.SQLITE;
            }
            if (name.contains("db2")) {
                return Type.DB2;
            }
            if (name.contains("informix")) {
                return Type.INFORMIX;
            }
            if (name.contains("interbase")) {
                return Type.INTERBASE;
            }
            if (name.contains("firebird")) {
                return Type.FIREBIRD;
            }
            if (name.contains("sqlserver") || name.toLowerCase().contains("microsoft")) {
                return Type.SQLSERVER;
            }
            if (name.contains("access")) {
                return Type.ACCESS;
            }
            if (name.contains("oracle")) {
                return Type.ORACLE;
            }
            if (name.contains("adaptive")) {
                return Type.SYBASE;
            }
            if (name.contains("Cassandra")) {
                return Type.CASSANDRA;
            }
            return Type.UNKNOWN;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        if (this.connection == null) return;
        boolean failed = false;
        try {
            if (this.addContentSql != null) {
                this.addContentSql.close();
            }
            if (this.getUsedContentSql != null) {
                this.getUsedContentSql.close();
            }
            if (this.getUnusedContentSql != null) {
                this.getUnusedContentSql.close();
            }
            if (this.markUnusedSql != null) {
                this.markUnusedSql.close();
            }
            if (this.markUsedSql != null) {
                this.markUsedSql.close();
            }
            if (this.removedExpiredSql != null) {
                this.removedExpiredSql.close();
            }
            if (this.getMimeType != null) {
                this.getMimeType.close();
            }
            if (this.setMimeType != null) {
                this.setMimeType.close();
            }
            if (this.getExtractedTextSql != null) {
                this.getExtractedTextSql.close();
            }
            if (this.setExtractedTextSql != null) {
                this.setExtractedTextSql.close();
            }
            if (this.getBinaryKeysSql == null) return;
            this.getBinaryKeysSql.close();
            return;
        }
        catch (SQLException e) {
            failed = true;
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                if (!failed) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.addContentSql = null;
                this.getUsedContentSql = null;
                this.getUnusedContentSql = null;
                this.markUnusedSql = null;
                this.markUsedSql = null;
                this.removedExpiredSql = null;
                this.getMimeType = null;
                this.setMimeType = null;
                this.getExtractedTextSql = null;
                this.setExtractedTextSql = null;
                this.getBinaryKeysSql = null;
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Type getDatabaseType() {
        return this.databaseType;
    }

    private long now() {
        return new Date().getTime();
    }

    public PreparedStatement insertContentSQL(BinaryKey key, InputStream stream) throws BinaryStoreException {
        try {
            this.addContentSql.setString(1, key.toString());
            this.addContentSql.setTimestamp(2, new Timestamp(this.now()));
            this.addContentSql.setBinaryStream(3, stream);
            return this.addContentSql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveContentSQL(BinaryKey key, boolean inUse) throws BinaryStoreException {
        try {
            PreparedStatement sql = inUse ? this.getUsedContentSql : this.getUnusedContentSql;
            sql.setString(1, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement markUnusedSQL(BinaryKey key) throws BinaryStoreException {
        try {
            this.markUnusedSql.setTimestamp(1, new Timestamp(this.now()));
            this.markUnusedSql.setString(2, key.toString());
            return this.markUnusedSql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement restoreContentSQL(BinaryKey key) throws BinaryStoreException {
        try {
            this.markUsedSql.setString(1, key.toString());
            return this.markUsedSql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement removeExpiredContentSQL(long deadline) throws BinaryStoreException {
        try {
            this.removedExpiredSql.setTimestamp(1, new Timestamp(deadline));
            return this.removedExpiredSql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveMimeTypeSQL(BinaryKey key) throws BinaryStoreException {
        try {
            this.getMimeType.setString(1, key.toString());
            return this.getMimeType;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement updateMimeTypeSQL(BinaryKey key, String mimeType) throws BinaryStoreException {
        try {
            this.setMimeType.setString(1, mimeType);
            this.setMimeType.setString(2, key.toString());
            return this.setMimeType;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveExtTextSQL(BinaryKey key) throws BinaryStoreException {
        try {
            this.getExtractedTextSql.setString(1, key.toString());
            return this.getExtractedTextSql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement updateExtTextSQL(BinaryKey key, String text) throws BinaryStoreException {
        try {
            this.setExtractedTextSql.setString(1, text);
            this.setExtractedTextSql.setString(2, key.toString());
            return this.setExtractedTextSql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveBinaryKeys(Set<BinaryKey> keys) throws BinaryStoreException {
        return this.getBinaryKeysSql;
    }

    public static void execute(PreparedStatement sql) throws BinaryStoreException {
        try {
            LOGGER.trace("Running statement: {0}", new Object[]{sql});
            sql.execute();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static ResultSet executeQuery(PreparedStatement sql) throws BinaryStoreException {
        try {
            LOGGER.trace("Running statement: {0}", new Object[]{sql});
            return sql.executeQuery();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static void executeUpdate(PreparedStatement sql) throws BinaryStoreException {
        try {
            LOGGER.trace("Running statement: {0}", new Object[]{sql});
            sql.executeUpdate();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected InputStream readStream(ResultSet rs) throws BinaryStoreException {
        boolean error = false;
        try {
            if (!rs.next()) {
                InputStream inputStream = null;
                return inputStream;
            }
            switch (this.databaseType) {
                case SQLSERVER: {
                    InputStream inputStream = rs.getBlob(1).getBinaryStream();
                    return inputStream;
                }
            }
            InputStream inputStream = rs.getBinaryStream(1);
            return inputStream;
        }
        catch (SQLException e) {
            error = true;
            throw new BinaryStoreException(e);
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block20: {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    if (error) break block20;
                    throw new BinaryStoreException(e);
                }
            }
        }
    }

    public static String asString(ResultSet rs) throws BinaryStoreException {
        boolean error = false;
        try {
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException e) {
            error = true;
            throw new BinaryStoreException(e);
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block14: {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    if (error) break block14;
                    throw new BinaryStoreException(e);
                }
            }
        }
    }

    public static List<String> asStringList(ResultSet rs) throws BinaryStoreException {
        boolean error = false;
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            error = true;
            throw new BinaryStoreException(e);
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block12: {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    if (error) break block12;
                    throw new BinaryStoreException(e);
                }
            }
        }
        return result;
    }

    public static enum Type {
        MYSQL,
        POSTGRES,
        DERBY,
        HSQL,
        H2,
        SQLITE,
        DB2,
        DB2_390,
        INFORMIX,
        INTERBASE,
        FIREBIRD,
        SQLSERVER,
        ACCESS,
        ORACLE,
        SYBASE,
        CASSANDRA,
        UNKNOWN;

    }
}

