/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.LinkedHashMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.basic.LocalNamespaceRegistry;
import org.modeshape.jcr.xml.NodeImportDestination;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

@NotThreadSafe
public class NodeImportXmlHandler
extends DefaultHandler2 {
    private static final TextDecoder XML_DECODER = new XmlNameEncoder();
    private static final AttributeScoping DEFAULT_ATTRIBUTE_SCOPING = AttributeScoping.USE_DEFAULT_NAMESPACE;
    private static final String DEFAULT_MULTI_VALUE_SEPARATOR = ",";
    private static final String ROOT_ELEMENT_NAME = "jcr:root";
    private static final String MULTI_VALUE_SEPARATOR_ATTRIBUTE = "multi-value-separator";
    private final String nameAttribute;
    private final String typeAttribute;
    private final String typeAttributeValue;
    private final NameFactory nameFactory;
    protected final PathFactory pathFactory;
    private final NamespaceRegistry namespaceRegistry;
    private final AttributeScoping attributeScoping;
    private final Map<String, LinkedList<String>> prefixStackByUri = new HashMap<String, LinkedList<String>>();
    private final NodeImportDestination destination;
    private final StringBuilder characterDataBuffer = new StringBuilder();
    protected String multiValueSeparator;
    private final Stack<ImportElement> elementsStack = new Stack();
    private final List<ImportElement> parsedElements = new ArrayList<ImportElement>();
    private boolean validateRootElement;

    public NodeImportXmlHandler(NodeImportDestination destination) {
        this(destination, "jcr:name", "jcr:primaryType", "nt:unstructured", DEFAULT_MULTI_VALUE_SEPARATOR, DEFAULT_ATTRIBUTE_SCOPING);
    }

    public NodeImportXmlHandler(NodeImportDestination destination, String nameAttribute, String typeAttribute, String typeAttributeValue, String multiValueSeparator, AttributeScoping scoping) {
        this.nameAttribute = nameAttribute;
        this.typeAttribute = typeAttribute;
        this.typeAttributeValue = typeAttributeValue;
        this.attributeScoping = scoping != null ? scoping : DEFAULT_ATTRIBUTE_SCOPING;
        this.destination = destination;
        this.multiValueSeparator = !StringUtil.isBlank((String)multiValueSeparator) ? multiValueSeparator : DEFAULT_MULTI_VALUE_SEPARATOR;
        ExecutionContext context = destination.getExecutionContext();
        LocalNamespaceRegistry namespaceRegistry = new LocalNamespaceRegistry(context.getNamespaceRegistry());
        ExecutionContext localContext = context.with(namespaceRegistry);
        this.nameFactory = localContext.getValueFactories().getNameFactory();
        this.pathFactory = localContext.getValueFactories().getPathFactory();
        this.namespaceRegistry = localContext.getNamespaceRegistry();
        assert (this.nameFactory != null);
        assert (this.namespaceRegistry != null);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        if (prefixStack == null) {
            prefixStack = new LinkedList();
            this.prefixStackByUri.put(uri, prefixStack);
        }
        prefixStack.addFirst(prefix);
        if (!this.namespaceRegistry.isRegisteredNamespaceUri(uri)) {
            ExecutionContext destinationContext = this.destination.getExecutionContext();
            NamespaceRegistry contextRegistry = destinationContext.getNamespaceRegistry();
            if (contextRegistry.getNamespaceForPrefix(prefix) != null) {
                destinationContext.getNamespaceRegistry().getPrefixForNamespaceUri(uri, true);
                this.namespaceRegistry.register(prefix, uri);
            } else {
                destinationContext.getNamespaceRegistry().register(prefix, uri);
            }
        } else {
            this.namespaceRegistry.register(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        assert (prefix != null);
        String uri = this.namespaceRegistry.getNamespaceForPrefix(prefix);
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        assert (prefixStack != null);
        assert (!prefixStack.isEmpty());
        String existingPrefix = prefixStack.removeFirst();
        assert (prefix.equals(existingPrefix));
        if (prefixStack.isEmpty()) {
            this.namespaceRegistry.unregister(uri);
            this.prefixStackByUri.remove(uri);
        } else {
            String previous = prefixStack.getFirst();
            this.namespaceRegistry.register(previous, uri);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.validateRootElement) {
            if (!name.equalsIgnoreCase(ROOT_ELEMENT_NAME)) {
                throw new SAXException(JcrI18n.errorDuringInitialImport.text(new Object[]{"Root xml element must be jcr:root"}));
            }
            this.parseCustomSettings(attributes);
            this.validateRootElement = false;
            return;
        }
        assert (localName != null);
        String nodeName = null;
        ImportElement parent = this.elementsStack.isEmpty() ? null : this.elementsStack.peek();
        ImportElement element = new ImportElement(parent);
        this.elementsStack.push(element);
        String typePropertyValue = null;
        int len = attributes.getLength();
        for (int i = 0; i != len; ++i) {
            String attributeLocalName = attributes.getLocalName(i);
            String attributeUri = attributes.getURI(i);
            String attributeName = null;
            if ((attributeUri == null || attributeUri.length() == 0) && attributes.getQName(i).indexOf(58) == -1) {
                switch (this.attributeScoping) {
                    case INHERIT_ELEMENT_NAMESPACE: {
                        attributeName = this.createName(uri, attributeLocalName);
                        break;
                    }
                    case USE_DEFAULT_NAMESPACE: {
                        attributeName = this.createName(null, attributeLocalName);
                    }
                }
            } else {
                attributeName = this.createName(attributeUri, attributeLocalName);
            }
            assert (attributeName != null);
            if (nodeName == null && attributeName.equalsIgnoreCase(this.nameAttribute)) {
                nodeName = this.createName(null, attributes.getValue(i));
                element.setName(nodeName);
                continue;
            }
            if (typePropertyValue == null && attributeName.equalsIgnoreCase(this.typeAttribute)) {
                typePropertyValue = this.createName(null, attributes.getValue(i));
                element.setType(typePropertyValue);
                continue;
            }
            element.addProperty(attributeName, attributes.getValue(i));
        }
        if (nodeName == null) {
            nodeName = this.createName(uri, localName);
            element.setName(nodeName);
        }
        if (typePropertyValue == null) {
            if (this.typeAttributeValue != null) {
                element.setType(this.typeAttributeValue);
            } else {
                element.setType("nt:unstructured");
            }
        }
    }

    private void parseCustomSettings(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeLocalName = attributes.getLocalName(i);
            if (!attributeLocalName.equalsIgnoreCase(MULTI_VALUE_SEPARATOR_ATTRIBUTE)) continue;
            this.multiValueSeparator = attributes.getValue(i);
        }
    }

    protected String createName(String uri, String localName) {
        return !StringUtil.isBlank((String)uri) ? this.nameFactory.create(uri, localName, XML_DECODER).getString((TextEncoder)NoOpEncoder.getInstance()) : ((Name)this.nameFactory.create(localName, XML_DECODER)).getString((TextEncoder)NoOpEncoder.getInstance());
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if (name.equalsIgnoreCase(ROOT_ELEMENT_NAME)) {
            return;
        }
        ImportElement entry = this.elementsStack.pop();
        String s = this.characterDataBuffer.toString().trim();
        if (s.length() > 0) {
            if (entry.looksLikeProperty()) {
                entry.addAsPropertyValue(s);
            } else {
                entry.addProperty(JcrLexicon.XMLCHARACTERS.toString(), s);
                this.parsedElements.add(entry);
            }
        } else {
            this.parsedElements.add(entry);
        }
        this.characterDataBuffer.delete(0, this.characterDataBuffer.length());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.validateRootElement) {
            return;
        }
        this.characterDataBuffer.append(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
        this.validateRootElement = true;
    }

    @Override
    public void endDocument() throws SAXException {
        this.validateRootElement = false;
        try {
            this.destination.submit(this.getParsedElementByPath());
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        this.parsedElements.clear();
    }

    private TreeMap<Path, ImportElement> getParsedElementByPath() {
        TreeMap<Path, ImportElement> result = new TreeMap<Path, ImportElement>();
        for (ImportElement element : this.parsedElements) {
            result.put(element.getPath(), element);
        }
        return result;
    }

    public class ImportElement {
        private final Multimap<String, String> properties = LinkedHashMultimap.create();
        private final List<String> mixins = new ArrayList<String>();
        private final Map<String, AtomicInteger> childSnsIndexes = new HashMap<String, AtomicInteger>();
        private String name;
        private String type;
        private Path path;
        private ImportElement parent;

        protected ImportElement(ImportElement parent) {
            this.parent = parent;
        }

        protected final boolean looksLikeProperty() {
            return this.properties.size() == 0;
        }

        private int getNextSnsForChildNamed(String childName) {
            AtomicInteger snsIndex = this.childSnsIndexes.get(childName);
            if (snsIndex == null) {
                this.childSnsIndexes.put(childName, new AtomicInteger(0));
            }
            return this.childSnsIndexes.get(childName).incrementAndGet();
        }

        protected void setName(String name) {
            this.name = name;
            int snsIndex = 1;
            if (this.parent != null) {
                snsIndex = this.parent.getNextSnsForChildNamed(name);
                this.path = NodeImportXmlHandler.this.pathFactory.create(this.parent.getPath(), name, snsIndex);
            } else {
                this.path = (Path)NodeImportXmlHandler.this.pathFactory.create("/" + name);
            }
        }

        protected void setType(String type) {
            this.type = type;
        }

        protected void addProperty(String propertyName, String propertyValue) {
            String[] values;
            for (String value : values = propertyValue.split(NodeImportXmlHandler.this.multiValueSeparator)) {
                if (propertyName.equals("jcr:mixinTypes")) {
                    this.mixins.add(NodeImportXmlHandler.this.createName(null, value.trim()));
                    continue;
                }
                this.properties.put((Object)propertyName, (Object)value);
            }
        }

        protected void addAsPropertyValue(String value) {
            this.parent.addProperty(this.name, value);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getMixins() {
            return this.mixins;
        }

        public Multimap<String, String> getProperties() {
            return this.properties;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ImportElement");
            sb.append("{name='").append(this.name).append('\'');
            sb.append(", path=").append(this.path);
            sb.append(", type='").append(this.type).append('\'');
            sb.append(", properties=").append(this.properties);
            sb.append(", mixins=").append(this.mixins);
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum AttributeScoping {
        USE_DEFAULT_NAMESPACE,
        INHERIT_ELEMENT_NAMESPACE;

    }
}

