/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.query.Query;
import org.modeshape.jcr.api.query.QueryManager;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.JcrQuery;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrTypeSystem;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.QueryObjectModel;
import org.modeshape.jcr.query.model.QueryObjectModelFactory;
import org.modeshape.jcr.query.model.SelectQuery;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.model.SetQueryObjectModel;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.parse.InvalidQueryException;
import org.modeshape.jcr.query.parse.QueryParser;
import org.modeshape.jcr.query.parse.QueryParsers;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;

@Immutable
class JcrQueryManager
implements QueryManager {
    private static final Logger LOGGER = Logger.getLogger(JcrQueryManager.class);
    private final JcrSession session;
    private final JcrQueryContext context;
    private final JcrTypeSystem typeSystem;
    private final QueryObjectModelFactory factory;

    JcrQueryManager(JcrSession session) {
        this.session = session;
        this.context = new SessionQueryContext(this.session);
        this.typeSystem = new SessionTypeSystem(this.session);
        this.factory = new QueryObjectModelFactory(this.context);
    }

    public org.modeshape.jcr.api.query.qom.QueryObjectModelFactory getQOMFactory() {
        return this.factory;
    }

    public javax.jcr.query.Query createQuery(String statement, String language) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        CheckArg.isNotNull((Object)statement, (String)"statement");
        CheckArg.isNotNull((Object)language, (String)"language");
        return this.createQuery(statement, language, null);
    }

    public Query createQuery(String expression, String language, Path storedAtPath) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        this.session.checkLive();
        QueryParsers queryParsers = this.session.repository().runningState().queryParsers();
        QueryParser parser = queryParsers.getParserFor(language);
        if (parser == null) {
            Set<String> languages = queryParsers.getLanguages();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.invalidQueryLanguage.text(new Object[]{language, languages}));
        }
        try {
            QueryCommand command = parser.parseQuery(expression, this.typeSystem);
            if (command == null) {
                throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(new Object[]{language, expression}));
            }
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            hints.hasFullTextSearch = true;
            hints.validateColumnExistance = false;
            if (parser.getLanguage().equals("JCR-SQL2")) {
                hints.qualifyExpandedColumnNames = true;
            }
            return this.resultWith(expression, parser.getLanguage(), command, hints, storedAtPath);
        }
        catch (ParsingException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(new Object[]{language, expression, reason}));
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{language, expression, reason}));
        }
    }

    public javax.jcr.query.Query createQuery(QueryCommand command) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        this.session.checkLive();
        if (command == null) {
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{"JCR-SQL2", command}));
        }
        String expression = Visitors.readable(command);
        try {
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            hints.hasFullTextSearch = true;
            hints.qualifyExpandedColumnNames = true;
            return this.resultWith(expression, "JCR-SQL2", command, hints, null);
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{"JCR-SQL2", expression, reason}));
        }
    }

    public Query getQuery(Node node) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        AbstractJcrNode jcrNode = (AbstractJcrNode)CheckArg.getInstanceOf((Object)node, AbstractJcrNode.class, (String)"node");
        JcrNodeType nodeType = jcrNode.getPrimaryNodeType();
        if (!nodeType.getInternalName().equals(JcrNtLexicon.QUERY)) {
            NamespaceRegistry registry = this.session.context().getNamespaceRegistry();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.notStoredQuery.text(new Object[]{jcrNode.path().getString(registry)}));
        }
        String statement = jcrNode.getProperty(JcrLexicon.STATEMENT).getString();
        String language = jcrNode.getProperty(JcrLexicon.LANGUAGE).getString();
        return this.createQuery(statement, language, jcrNode.path());
    }

    public String[] getSupportedQueryLanguages() {
        Set<String> languages = this.session.repository().runningState().queryParsers().getLanguages();
        return languages.toArray(new String[languages.size()]);
    }

    protected Query resultWith(String expression, String language, QueryCommand command, PlanHints hints, Path storedAtPath) {
        if (command instanceof SelectQuery) {
            SelectQuery query = (SelectQuery)command;
            return new QueryObjectModel(this.context, expression, language, query, hints, storedAtPath);
        }
        if (command instanceof SetQuery) {
            SetQuery query = (SetQuery)command;
            return new SetQueryObjectModel(this.context, expression, language, query, hints, storedAtPath);
        }
        SessionQueryContext context = new SessionQueryContext(this.session);
        return new JcrQuery(context, expression, language, command, hints, storedAtPath);
    }

    protected static class SessionTypeSystem
    extends JcrTypeSystem {
        protected final JcrSession session;
        protected final TypeSystem delegate;

        protected SessionTypeSystem(JcrSession session) {
            this.session = session;
            this.delegate = session.context().getValueFactories().getTypeSystem();
        }

        @Override
        public Set<String> getTypeNames() {
            return this.delegate.getTypeNames();
        }

        @Override
        public TypeSystem.TypeFactory<?> getTypeFactory(Object prototype) {
            return this.delegate.getTypeFactory(prototype);
        }

        @Override
        public TypeSystem.TypeFactory<?> getTypeFactory(String typeName) {
            return this.delegate.getTypeFactory(typeName);
        }

        @Override
        public TypeSystem.TypeFactory<String> getStringFactory() {
            return this.delegate.getStringFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Reference> getReferenceFactory() {
            return this.delegate.getReferenceFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Path> getPathFactory() {
            return this.delegate.getPathFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Name> getNameFactory() {
            return this.delegate.getNameFactory();
        }

        @Override
        public TypeSystem.TypeFactory<NodeKey> getNodeKeyFactory() {
            return this.delegate.getNodeKeyFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Long> getLongFactory() {
            return this.delegate.getLongFactory();
        }

        @Override
        public TypeSystem.TypeFactory<Double> getDoubleFactory() {
            return this.delegate.getDoubleFactory();
        }

        @Override
        public String getDefaultType() {
            return this.delegate.getDefaultType();
        }

        @Override
        public Comparator<Object> getDefaultComparator() {
            return this.delegate.getDefaultComparator();
        }

        @Override
        public TypeSystem.TypeFactory<BigDecimal> getDecimalFactory() {
            return this.delegate.getDecimalFactory();
        }

        @Override
        public TypeSystem.TypeFactory<?> getDateTimeFactory() {
            return this.delegate.getDateTimeFactory();
        }

        @Override
        public String getCompatibleType(String type1, String type2) {
            return this.delegate.getCompatibleType(type1, type2);
        }

        @Override
        public TypeSystem.TypeFactory<?> getCompatibleType(TypeSystem.TypeFactory<?> type1, TypeSystem.TypeFactory<?> type2) {
            return this.delegate.getCompatibleType(type1, type2);
        }

        @Override
        public TypeSystem.TypeFactory<Boolean> getBooleanFactory() {
            return this.delegate.getBooleanFactory();
        }

        @Override
        public TypeSystem.TypeFactory<BinaryValue> getBinaryFactory() {
            return this.delegate.getBinaryFactory();
        }

        @Override
        public String asString(Object value) {
            return this.delegate.asString(value);
        }

        @Override
        public JcrValueFactory getValueFactory() {
            return this.session.valueFactory();
        }
    }

    protected static class SessionQueryContext
    implements JcrQueryContext {
        private final JcrSession session;
        private final ValueFactories factories;

        protected SessionQueryContext(JcrSession session) {
            this.session = session;
            this.factories = session.context().getValueFactories();
        }

        @Override
        public BufferManager getBufferManager() {
            return this.session.bufferManager();
        }

        @Override
        public String getWorkspaceName() {
            return this.session.workspaceName();
        }

        @Override
        public Value createValue(int propertyType, Object value) {
            return value == null ? null : new JcrValue(this.factories, propertyType, value);
        }

        @Override
        public CancellableQuery createExecutableQuery(QueryCommand query, PlanHints hints, Map<String, Object> variables) throws RepositoryException {
            this.session.checkLive();
            Schemata schemata = this.session.workspace().nodeTypeManager().schemata();
            NodeTypes nodeTypes = this.session.repository().nodeTypeManager().getNodeTypes();
            RepositoryIndexes indexDefns = this.session.repository().queryManager().getIndexes();
            ExecutionContext context = this.session.context();
            String workspaceName = this.session.workspaceName();
            JcrRepository.RunningState state = this.session.repository().runningState();
            RepositoryQueryManager queryManager = state.queryManager();
            RepositoryCache repoCache = state.repositoryCache();
            NodeCache nodeCache = hints.useSessionContent ? this.session.cache() : this.session.cache().getWorkspace();
            HashMap<String, NodeCache> overriddenNodeCaches = new HashMap<String, NodeCache>();
            overriddenNodeCaches.put(workspaceName, nodeCache);
            Set<String> workspaceNames = null;
            if (hints.includeSystemContent) {
                workspaceNames = new LinkedHashSet<String>();
                workspaceNames.add(workspaceName);
                workspaceNames.add(repoCache.getSystemWorkspaceName());
            } else {
                workspaceNames = Collections.singleton(workspaceName);
            }
            return queryManager.query(context, repoCache, workspaceNames, overriddenNodeCaches, query, schemata, indexDefns, nodeTypes, hints, variables);
        }

        @Override
        public ExecutionContext getExecutionContext() {
            return this.session.context();
        }

        @Override
        public void checkValid() throws RepositoryException {
            this.session.checkLive();
        }

        @Override
        public Node getNode(CachedNode node) {
            if (node == null) {
                return null;
            }
            Path path = this.getPath(node);
            try {
                this.session.checkPermission(path, "read");
                return this.session.node(node, (AbstractJcrNode.Type)null);
            }
            catch (AccessDeniedException ade) {
                LOGGER.debug("READ access denied on '{0}'", new Object[]{path});
                return null;
            }
        }

        @Override
        public String getUuid(CachedNode node) {
            Node jcrNode = this.getNode(node);
            if (jcrNode != null) {
                try {
                    return jcrNode.getUUID();
                }
                catch (UnsupportedRepositoryOperationException e) {
                    return null;
                }
                catch (RepositoryException e) {
                    Logger.getLogger(this.getClass()).debug((Throwable)e, "Error obtaining UUID from node", new Object[0]);
                }
            }
            return null;
        }

        @Override
        public Path getPath(CachedNode node) {
            return node.getPath(this.session.cache());
        }

        @Override
        public Name getName(CachedNode node) {
            return node.getName(this.session.cache());
        }

        @Override
        public long getDepth(CachedNode node) {
            assert (node != null);
            return node.getDepth(this.session.cache());
        }

        @Override
        public Node storeQuery(String absolutePath, Name nodeType, String language, String statement) throws RepositoryException {
            Path path;
            this.session.checkLive();
            NamespaceRegistry namespaces = this.session.namespaces();
            try {
                path = (Path)this.session.pathFactory().create(absolutePath);
            }
            catch (IllegalArgumentException iae) {
                throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{"absolutePath", absolutePath}));
            }
            Path parentPath = path.getParent();
            AbstractJcrNode parentNode = this.session.node(parentPath);
            if (!parentNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parentNode.getPath()}));
            }
            Node queryNode = parentNode.addNode(path.relativeTo(parentPath).getString(namespaces), JcrNtLexicon.QUERY.getString(namespaces));
            queryNode.setProperty(JcrLexicon.LANGUAGE.getString(namespaces), language);
            queryNode.setProperty(JcrLexicon.STATEMENT.getString(namespaces), statement);
            return queryNode;
        }

        @Override
        public void recordDuration(long nanos, TimeUnit unit, String query, String language) {
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("query", query);
            payload.put("language", language);
            this.session.repository().statistics().recordDuration(DurationMetric.QUERY_EXECUTION_TIME, nanos, unit, payload);
        }
    }
}

