/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.ObservationManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryManager;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNodeCache;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.ModeShapeFederationManager;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.jcr.api.federation.FederationManager;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.value.InvalidPathException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@ThreadSafe
class JcrWorkspace
implements Workspace {
    private final JcrSession session;
    private final String workspaceName;
    private final Lock lock = new ReentrantLock();
    private JcrNodeTypeManager nodeTypeManager;
    private JcrLockManager lockManager;
    private JcrNamespaceRegistry workspaceRegistry;
    private JcrVersionManager versionManager;
    private JcrQueryManager queryManager;
    private JcrObservationManager observationManager;
    private JcrRepositoryManager repositoryManager;
    private ModeShapeFederationManager federationManager;

    JcrWorkspace(JcrSession session, String workspaceName) {
        this.session = session;
        this.workspaceName = workspaceName;
    }

    final JcrRepository repository() {
        return this.session.repository();
    }

    final ExecutionContext context() {
        return this.session.context();
    }

    public final JcrSession getSession() {
        return this.session;
    }

    public final String getName() {
        return this.workspaceName;
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        this.session.checkLive();
        this.copy(this.workspaceName, srcAbsPath, destAbsPath);
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        this.validateCrossWorkspaceAction(srcWorkspace);
        PathFactory pathFactory = this.session.pathFactory();
        Path srcPath = null;
        try {
            srcPath = (Path)pathFactory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
        }
        Path destPath = null;
        try {
            destPath = (Path)pathFactory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
        }
        if (!destPath.isIdentifier() && destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        if (destPath.isRoot() && !srcPath.isRoot()) {
            throw new RepositoryException(JcrI18n.cannotCopySubgraphIntoRoot.text(new Object[]{srcAbsPath, srcWorkspace, this.getName()}));
        }
        try {
            JcrSession copySession = this.session.spawnSession(false);
            AbstractJcrNode parentNode = null;
            Name newNodeName = null;
            if (destPath.isIdentifier()) {
                AbstractJcrNode existingDestNode = copySession.node(destPath);
                if (!existingDestNode.isRoot()) {
                    parentNode = existingDestNode.getParent();
                    newNodeName = existingDestNode.segment().getName();
                } else {
                    parentNode = existingDestNode;
                }
            } else if (!destPath.isRoot()) {
                parentNode = copySession.node(destPath.getParent());
                newNodeName = destPath.getLastSegment().getName();
            } else {
                parentNode = copySession.getRootNode();
            }
            JcrSession sourceSession = this.session.spawnSession(srcWorkspace, true);
            AbstractJcrNode sourceNode = sourceSession.node(srcPath);
            if (this.session.lockManager().isLocked(sourceNode) && !this.session.lockManager().hasLockToken(sourceNode.getLock().getLockToken())) {
                throw new LockException(srcAbsPath);
            }
            this.validateCopyForExternalNode(sourceNode, parentNode);
            AbstractJcrNode copy = newNodeName == null ? parentNode : parentNode.addChildNode(newNodeName, sourceNode.getPrimaryTypeName(), null, false, false);
            Map<NodeKey, NodeKey> nodeKeyCorrespondence = copy.mutable().deepCopy(copySession.cache(), sourceNode.node(), sourceSession.cache(), this.repository().systemWorkspaceKey(), this.repository().runningState().connectors());
            copySession.initOriginalVersionKeys();
            Set<NodeKey> srcNodeKeys = nodeKeyCorrespondence.keySet();
            for (NodeKey sourceKey : srcNodeKeys) {
                AbstractJcrNode srcNode = sourceSession.node(sourceKey, null);
                if (!srcNode.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
                NodeKey dstNodeKey = nodeKeyCorrespondence.get(sourceKey);
                copySession.setOriginalVersionKey(dstNodeKey, srcNode.getBaseVersion().key());
            }
            copySession.save();
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        catch (InvalidPathException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validateCopyForExternalNode(AbstractJcrNode sourceNode, AbstractJcrNode destParentNode) throws RepositoryException {
        String rootSourceKey = this.session.getRootNode().key().getSourceKey();
        NodeKey parentKey = destParentNode.key();
        if (parentKey.getSourceKey().equalsIgnoreCase(rootSourceKey)) {
            return;
        }
        String destExternalKey = parentKey.getSourceKey();
        Connectors connectors = this.repository().runningState().connectors();
        String destSourceName = connectors.getSourceNameAtKey(destExternalKey);
        Set<NodeKey> sourceKeys = this.session.cache().getNodeKeysAtAndBelow(sourceNode.key());
        boolean sourceContainsExternalNodes = false;
        for (NodeKey sourceKey : sourceKeys) {
            String sourceNodeSourceKey = sourceKey.getSourceKey();
            if (rootSourceKey.equalsIgnoreCase(sourceNodeSourceKey)) continue;
            sourceContainsExternalNodes = true;
            if (sourceNodeSourceKey.equalsIgnoreCase(destExternalKey)) continue;
            String sourceExternalSourceName = connectors.getSourceNameAtKey(sourceNodeSourceKey);
            throw new RepositoryException(JcrI18n.unableToCopySourceTargetMismatch.text(new Object[]{sourceExternalSourceName, destSourceName}));
        }
        String sourceNodeSourceKey = sourceNode.key().getSourceKey();
        if (sourceContainsExternalNodes && !sourceNodeSourceKey.equalsIgnoreCase(destExternalKey)) {
            throw new RepositoryException(JcrI18n.unableToCopySourceNotExternal.text(new Object[]{sourceNode.path()}));
        }
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.internalClone(srcWorkspace, srcAbsPath, destAbsPath, removeExisting, false);
    }

    void internalClone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting, boolean skipVersioningValidation) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        block34: {
            CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
            CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
            this.validateCrossWorkspaceAction(srcWorkspace);
            boolean sameWorkspace = this.getName().equals(srcWorkspace);
            if (sameWorkspace && removeExisting) {
                this.move(srcAbsPath, destAbsPath);
                return;
            }
            PathFactory pathFactory = this.session.pathFactory();
            Path srcPath = null;
            try {
                srcPath = (Path)pathFactory.create(srcAbsPath);
            }
            catch (ValueFormatException e) {
                throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
            }
            Path destPath = null;
            try {
                destPath = (Path)pathFactory.create(destAbsPath);
            }
            catch (ValueFormatException e) {
                throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
            }
            if (!sameWorkspace && !destPath.isIdentifier() && destAbsPath.endsWith("]")) {
                throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
            }
            if (destPath.isRoot() && !srcPath.isRoot()) {
                throw new RepositoryException(JcrI18n.cannotCloneSubgraphIntoRoot.text(new Object[]{srcAbsPath, srcWorkspace, this.getName()}));
            }
            try {
                JcrSession cloneSession = this.session.spawnSession(false);
                AbstractJcrNode parentNode = null;
                Name newNodeName = null;
                if (destPath.isIdentifier()) {
                    AbstractJcrNode existingDestNode = cloneSession.node(destPath);
                    if (!existingDestNode.isRoot()) {
                        parentNode = existingDestNode.getParent();
                        newNodeName = existingDestNode.segment().getName();
                    } else {
                        parentNode = existingDestNode;
                    }
                } else if (!destPath.isRoot()) {
                    parentNode = cloneSession.node(destPath.getParent());
                    newNodeName = destPath.getLastSegment().getName();
                } else {
                    parentNode = cloneSession.getRootNode();
                }
                JcrSession sourceSession = null;
                sourceSession = sameWorkspace ? cloneSession : this.session.spawnSession(srcWorkspace, true);
                AbstractJcrNode sourceNode = sourceSession.node(srcPath);
                if (this.session.lockManager().isLocked(sourceNode) && !this.session.lockManager().hasLockToken(sourceNode.getLock().getLockToken())) {
                    throw new LockException(srcAbsPath);
                }
                this.validateCloneForExternalNodes(sameWorkspace, sourceSession, sourceNode, parentNode);
                if (sameWorkspace && sourceNode.isShareable()) {
                    assert (!removeExisting);
                    if (destPath.isAtOrBelow(srcPath)) {
                        throw new RepositoryException(JcrI18n.unableToShareNodeWithinSubgraph.text(new Object[]{srcAbsPath, destAbsPath}));
                    }
                    Path destParent = destPath.getParent();
                    if (destParent.isSameAs(srcPath.getParent())) {
                        String msg = JcrI18n.unableToShareNodeWithinSameParent.text(new Object[]{srcAbsPath, destAbsPath, destParent});
                        throw new UnsupportedRepositoryOperationException(msg);
                    }
                    JcrSharedNodeCache.SharedSet sharedSet = sourceNode.sharedSet();
                    AbstractJcrNode existingShare = sharedSet.getSharedNodeAtOrBelow(destParent);
                    if (existingShare != null) {
                        String msg = JcrI18n.shareAlreadyExistsWithinParent.text(new Object[]{destAbsPath, existingShare.getPath()});
                        throw new RepositoryException(msg);
                    }
                    parentNode.addSharedNode(sourceNode, newNodeName);
                    cloneSession.save();
                    break block34;
                }
                SessionCache sourceCache = sourceSession.cache();
                Set<NodeKey> sourceKeys = sourceCache.getNodeKeysAtAndBelow(sourceNode.key());
                sourceKeys = this.filterNodeKeysForClone(sourceKeys, sourceCache);
                for (NodeKey srcKey : sourceKeys) {
                    try {
                        boolean hasAnyPendingChanges;
                        boolean isExternal;
                        AbstractJcrNode srcNode = sourceSession.node(srcKey, null);
                        boolean bl = isExternal = !srcKey.getSourceKey().equalsIgnoreCase(sourceCache.getRootKey().getSourceKey());
                        if (isExternal && this.session.nodeExists(srcKey) && !removeExisting) {
                            throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{srcKey, this.workspaceName, srcNode.getPath()}));
                        }
                        NodeKey cloneKey = parentNode.key().withId(srcNode.key().getIdentifier());
                        AbstractJcrNode cloneSessionNode = null;
                        try {
                            cloneSessionNode = cloneSession.node(cloneKey, null);
                        }
                        catch (ItemNotFoundException e) {
                            continue;
                        }
                        if (cloneSessionNode.nodeDefinition().isMandatory()) {
                            throw new ConstraintViolationException(JcrI18n.cannotRemoveNodeFromClone.text(new Object[]{cloneSessionNode.getPath(), cloneSessionNode.getIdentifier()}));
                        }
                        boolean bl2 = hasAnyPendingChanges = !this.session.cache().getChangedNodeKeysAtOrBelow(cloneSessionNode.node()).isEmpty();
                        if (hasAnyPendingChanges) {
                            throw new RepositoryException(JcrI18n.cannotRemoveNodeFromCloneDueToChangesInSession.text(new Object[]{cloneSessionNode.getPath(), cloneSessionNode.getIdentifier()}));
                        }
                        if (!removeExisting) {
                            throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{srcKey, this.workspaceName, cloneSessionNode.getPath()}));
                        }
                        cloneSessionNode.remove();
                    }
                    catch (PathNotFoundException e) {}
                }
                NodeKey cloneKey = null;
                if (!destPath.isRoot()) {
                    cloneKey = parentNode.key().withId(sourceNode.key().getIdentifier());
                    parentNode.addChildNode(newNodeName, sourceNode.getPrimaryTypeName(), cloneKey, skipVersioningValidation, false);
                } else {
                    cloneKey = parentNode.key();
                }
                this.deepClone(sourceSession, sourceNode.key(), cloneSession, cloneKey);
            }
            catch (ItemNotFoundException e) {
                throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (AccessControlException ace) {
                throw new AccessDeniedException((Throwable)ace);
            }
            catch (InvalidPathException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void validateCloneForExternalNodes(boolean sameWorkspace, JcrSession sourceSession, AbstractJcrNode sourceNode, AbstractJcrNode parentNode) throws RepositoryException {
        String rootSourceKey = sourceSession.getRootNode().key().getSourceKey();
        Connectors connectors = this.repository().runningState().connectors();
        Set<NodeKey> sourceKeys = sourceSession.cache().getNodeKeysAtAndBelow(sourceNode.key());
        for (NodeKey sourceKey : sourceKeys) {
            String sourceNodeSourceKey = sourceKey.getSourceKey();
            if (sourceNodeSourceKey.equalsIgnoreCase(rootSourceKey)) continue;
            String sourceNameAtKey = connectors.getSourceNameAtKey(sourceNodeSourceKey);
            if (sameWorkspace) {
                throw new RepositoryException(JcrI18n.unableToCloneSameWsContainsExternalNode.text(new Object[]{sourceNameAtKey}));
            }
            if (sourceNode.isRoot() && parentNode.isRoot()) continue;
            throw new RepositoryException(JcrI18n.unableToCloneExternalNodesRequireRoot.text(new Object[]{sourceNameAtKey}));
        }
    }

    private Set<NodeKey> filterNodeKeysForClone(Set<NodeKey> sourceKeys, SessionCache sourceCache) {
        HashSet<NodeKey> filteredSet = new HashSet<NodeKey>();
        for (NodeKey sourceKey : sourceKeys) {
            if (sourceKey.equals(sourceCache.getRootKey()) || sourceKey.getWorkspaceKey().equalsIgnoreCase(this.repository().systemWorkspaceKey())) continue;
            filteredSet.add(sourceKey);
        }
        return filteredSet;
    }

    protected void validateCrossWorkspaceAction(String srcWorkspace) throws RepositoryException {
        CheckArg.isNotEmpty((String)srcWorkspace, (String)"srcWorkspace");
        this.session.checkLive();
        this.session.checkWorkspacePermission(srcWorkspace, "read");
        this.session.checkWorkspacePermission(this.getName(), "read");
        JcrRepository repository = this.repository();
        if (!repository.hasWorkspace(srcWorkspace)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{repository.getName(), srcWorkspace}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkLive();
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        JcrSession session = this.session.spawnSession(false);
        try {
            session.move(srcAbsPath, destAbsPath);
            session.save();
        }
        finally {
            session.logout();
        }
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkLive();
        this.versionManager().restore(versions, removeExisting);
    }

    public JcrLockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.lockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrLockManager lockManager() {
        if (this.lockManager == null) {
            try {
                this.lock.lock();
                if (this.lockManager == null) {
                    this.lockManager = new JcrLockManager(this.session, this.repository().lockManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrQueryManager getQueryManager() throws RepositoryException {
        this.session.checkLive();
        if (this.queryManager == null) {
            try {
                this.lock.lock();
                if (this.queryManager == null) {
                    this.queryManager = new JcrQueryManager(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.queryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        this.session.checkLive();
        if (this.workspaceRegistry == null) {
            try {
                this.lock.lock();
                if (this.workspaceRegistry == null) {
                    this.workspaceRegistry = new JcrNamespaceRegistry(this.repository().persistentRegistry(), this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.workspaceRegistry;
    }

    public JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.session.checkLive();
        return this.nodeTypeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrNodeTypeManager nodeTypeManager() {
        if (this.nodeTypeManager == null) {
            try {
                this.lock.lock();
                if (this.nodeTypeManager == null) {
                    this.nodeTypeManager = new JcrNodeTypeManager(this.session, this.repository().nodeTypeManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.nodeTypeManager;
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.observationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrObservationManager observationManager() {
        if (this.observationManager == null && this.session.isLive()) {
            try {
                this.lock.lock();
                if (this.observationManager == null) {
                    this.observationManager = new JcrObservationManager(this.session, this.repository().changeBus(), this.repository().getRepositoryStatistics());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.observationManager;
    }

    public JcrVersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.versionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrVersionManager versionManager() {
        if (this.versionManager == null) {
            try {
                this.lock.lock();
                if (this.versionManager == null) {
                    this.versionManager = new JcrVersionManager(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.versionManager;
    }

    public JcrRepositoryManager getRepositoryManager() throws AccessDeniedException, RepositoryException {
        this.session.checkLive();
        return this.repositoryManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrRepositoryManager repositoryManager() {
        if (this.repositoryManager == null) {
            try {
                this.lock.lock();
                if (this.repositoryManager == null) {
                    this.repositoryManager = new JcrRepositoryManager(this);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.repositoryManager;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        this.session.checkLive();
        JcrSession session = this.session.spawnSession(false);
        boolean saveWhenFinished = true;
        AbstractJcrNode parent = session.getNode(parentAbsPath);
        if (!parent.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parent.getPath()}));
        }
        JcrRepository repo = this.getSession().getRepository();
        boolean retainLifecycleInfo = repo.getDescriptorValue("option.lifecycle.supported").getBoolean();
        boolean retainRetentionInfo = repo.getDescriptorValue("option.retention.supported").getBoolean();
        return new JcrContentHandler(session, parent, uuidBehavior, saveWhenFinished, retainRetentionInfo, retainLifecycleInfo);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        CheckArg.isNotNull((Object)in, (String)"in");
        this.session.checkLive();
        boolean error = false;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)((Object)cause);
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            error = true;
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            error = true;
            throw new RepositoryException((Throwable)se);
        }
        finally {
            block16: {
                try {
                    in.close();
                }
                catch (IOException t) {
                    if (!error) {
                        throw t;
                    }
                }
                catch (RuntimeException re) {
                    if (error) break block16;
                    throw re;
                }
            }
        }
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.session.checkLive();
        HashSet<String> names = new HashSet<String>(this.session.repository().repositoryCache().getWorkspaceNames());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            try {
                this.session.checkWorkspacePermission((String)iter.next(), "read");
            }
            catch (AccessDeniedException ace) {
                iter.remove();
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        try {
            this.session.checkWorkspacePermission(name, "create_workspace");
            JcrRepository repository = this.session.repository();
            if (repository.hasWorkspace(name)) {
                String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{name, this.getName()});
                throw new RepositoryException(msg);
            }
            repository.repositoryCache().createWorkspace(name);
            repository.statistics().increment(ValueMetric.WORKSPACE_COUNT);
            repository.runningState().initialContentImporter().importInitialContent(name);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedRepositoryOperationException(e.getMessage());
        }
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        this.validateCrossWorkspaceAction(srcWorkspace);
        this.createWorkspace(name);
        JcrSession newWorkspaceSession = this.session.spawnSession(name, false);
        JcrSession srcWorkspaceSession = this.session.spawnSession(srcWorkspace, true);
        this.deepClone(srcWorkspaceSession, srcWorkspaceSession.getRootNode().key(), newWorkspaceSession, newWorkspaceSession.getRootNode().key());
    }

    protected void deepClone(JcrSession sourceSession, NodeKey sourceNodeKey, JcrSession cloneSession, NodeKey cloneNodeKey) throws RepositoryException {
        assert (!cloneSession.cache().isReadOnly());
        SessionCache sourceCache = sourceSession.cache();
        CachedNode sourceNode = sourceCache.getNode(sourceNodeKey);
        SessionCache cloneCache = cloneSession.cache();
        MutableCachedNode mutableCloneNode = cloneSession.node(cloneNodeKey, null).mutable();
        mutableCloneNode.deepClone(cloneCache, sourceNode, sourceCache, this.repository().systemWorkspaceKey(), this.repository().runningState().connectors());
        cloneSession.initBaseVersionKeys();
        Set<NodeKey> sourceKeys = sourceCache.getNodeKeysAtAndBelow(sourceNodeKey);
        for (NodeKey sourceKey : sourceKeys) {
            AbstractJcrNode srcNode = sourceSession.node(sourceKey, null);
            if (!srcNode.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
            cloneSession.setDesiredBaseVersionKey(sourceKey, srcNode.getBaseVersion().key());
        }
        cloneSession.save();
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        this.session.checkLive();
        this.session.checkWorkspacePermission(name, "delete_workspace");
        JcrSession removeSession = this.session.spawnSession(name, false);
        JcrRepository repository = this.session.repository();
        RepositoryCache repositoryCache = repository.repositoryCache();
        NodeKey systemKey = repositoryCache.getSystemKey();
        try {
            JcrRootNode rootNode = removeSession.getRootNode();
            NodeIterator nodeIterator = rootNode.getNodesInternal();
            while (nodeIterator.hasNext()) {
                AbstractJcrNode child = (AbstractJcrNode)nodeIterator.nextNode();
                if (child.key().equals(systemKey)) continue;
                child.remove();
            }
            if (!repositoryCache.destroyWorkspace(name, (WritableSessionCache)removeSession.cache())) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNotFound.text(new Object[]{name, this.getName()}));
            }
            repository.statistics().decrement(ValueMetric.WORKSPACE_COUNT);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedRepositoryOperationException(e.getMessage());
        }
        finally {
            removeSession.logout();
        }
    }

    public void reindex() throws RepositoryException {
        this.session.checkPermission(this.workspaceName, Path.ROOT_PATH, "index_workspace");
        this.repository().runningState().queryManager().reindexContent(this);
    }

    public void reindex(String pathStr) throws RepositoryException {
        try {
            Path path = (Path)this.session.pathFactory().create(pathStr);
            this.session.checkPermission(this.workspaceName, path, "index_workspace");
            this.repository().runningState().queryManager().reindexContent(this, path, Integer.MAX_VALUE);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public Future<Boolean> reindexAsync() throws RepositoryException {
        this.session.checkPermission(this.workspaceName, Path.ROOT_PATH, "index_workspace");
        return this.repository().runningState().queryManager().reindexContentAsync(this);
    }

    public Future<Boolean> reindexAsync(String pathStr) throws RepositoryException {
        try {
            Path path = (Path)this.session.pathFactory().create(pathStr);
            this.session.checkPermission(this.workspaceName, path, "index_workspace");
            return this.repository().runningState().queryManager().reindexContentAsync(this, path, Integer.MAX_VALUE);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public FederationManager getFederationManager() throws RepositoryException {
        this.session.checkLive();
        return this.federationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ModeShapeFederationManager federationManager() {
        if (this.federationManager == null) {
            try {
                this.lock.lock();
                if (this.federationManager == null) {
                    this.federationManager = new ModeShapeFederationManager(this.session, this.session.repository().runningState().documentStore());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.federationManager;
    }
}

