/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.spi.index.IndexColumnDefinition;
import org.modeshape.jcr.spi.index.IndexDefinition;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

@Immutable
class RepositoryIndexDefinition
implements IndexDefinition {
    private final String name;
    private final String providerName;
    private final IndexDefinition.IndexKind kind;
    private final Name nodeTypeName;
    private final String description;
    private final boolean enabled;
    private final List<IndexColumnDefinition> columnDefns;
    private final Map<Name, Property> extendedProperties;

    public static IndexDefinition createFrom(IndexDefinition other) {
        return new RepositoryIndexDefinition(other.getName(), other.getProviderName(), other.getKind(), other.getNodeTypeName(), other, other.getProperties(), other.getDescription(), other.isEnabled());
    }

    public static IndexDefinition createFrom(IndexDefinition other, boolean isEnabled) {
        return new RepositoryIndexDefinition(other.getName(), other.getProviderName(), other.getKind(), other.getNodeTypeName(), other, other.getProperties(), other.getDescription(), isEnabled);
    }

    RepositoryIndexDefinition(String name, String providerName, IndexDefinition.IndexKind kind, Name nodeTypeName, Iterable<IndexColumnDefinition> columnDefns, Map<Name, Property> extendedProperties, String description, boolean enabled) {
        assert (name != null);
        assert (providerName != null);
        assert (columnDefns != null);
        assert (extendedProperties != null);
        this.name = name;
        this.providerName = providerName;
        this.kind = kind;
        this.nodeTypeName = nodeTypeName != null ? nodeTypeName : JcrNtLexicon.BASE;
        this.columnDefns = new ArrayList<IndexColumnDefinition>();
        this.extendedProperties = extendedProperties;
        this.description = description != null ? description : "";
        this.enabled = enabled;
        for (IndexColumnDefinition columnDefn : columnDefns) {
            assert (columnDefn != null);
            this.columnDefns.add(columnDefn);
        }
        assert (!this.columnDefns.isEmpty());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public IndexDefinition.IndexKind getKind() {
        return this.kind;
    }

    @Override
    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean hasSingleColumn() {
        return this.columnDefns.size() == 1;
    }

    @Override
    public Property getProperty(Name propertyName) {
        return this.extendedProperties.get(propertyName);
    }

    @Override
    public Map<Name, Property> getProperties() {
        return Collections.unmodifiableMap(this.extendedProperties);
    }

    @Override
    public Iterator<IndexColumnDefinition> iterator() {
        return new ReadOnlyIterator(this.columnDefns.iterator());
    }
}

