/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.function.Predicate;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.Observable;
import org.modeshape.jcr.spi.index.Index;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.IndexDefinitionChanges;
import org.modeshape.jcr.spi.index.IndexFeedback;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.spi.index.WorkspaceChanges;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueFactories;

public abstract class IndexProvider {
    private Logger logger;
    private String name;
    private ExecutionContext context;
    private String repositoryName;
    private boolean initialized = false;
    private final Map<String, Map<String, ProvidedIndex>> providedIndexesByWorkspaceNameByIndexName = new HashMap<String, Map<String, ProvidedIndex>>();

    protected final Logger logger() {
        return this.logger;
    }

    public final String getName() {
        return this.name;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    public final synchronized void initialize() throws RepositoryException {
        if (!this.initialized) {
            try {
                this.doInitialize();
                this.initialized = true;
            }
            catch (RuntimeException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    protected abstract void doInitialize() throws RepositoryException;

    public final synchronized void shutdown() throws RepositoryException {
        this.preShutdown();
        for (Map<String, ProvidedIndex> byWorkspaceName : this.providedIndexesByWorkspaceNameByIndexName.values()) {
            for (ProvidedIndex provided : byWorkspaceName.values()) {
                provided.shutdown(false);
            }
        }
        this.providedIndexesByWorkspaceNameByIndexName.clear();
        this.postShutdown();
    }

    protected void preShutdown() throws RepositoryException {
    }

    protected void postShutdown() throws RepositoryException {
    }

    public final IndexWriter getIndexWriter() {
        final ArrayList<ProvidedIndex> indexes = new ArrayList<ProvidedIndex>(this.providedIndexesByWorkspaceNameByIndexName.size());
        for (Map<String, ProvidedIndex> byWorkspaceNames : this.providedIndexesByWorkspaceNameByIndexName.values()) {
            for (ProvidedIndex index : byWorkspaceNames.values()) {
                indexes.add(index);
            }
        }
        return new IndexWriter(){

            @Override
            public boolean canBeSkipped() {
                return indexes.isEmpty();
            }

            @Override
            public void clearAllIndexes() {
                for (ProvidedIndex index : indexes) {
                    index.managed().removeAll();
                }
            }

            @Override
            public void add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
                for (ProvidedIndex index : indexes) {
                    if (!index.workspaceName().equals(workspace)) continue;
                    index.managed().getIndexChangeAdapter().index(workspace, key, path, primaryType, mixinTypes, properties, true);
                }
            }
        };
    }

    public final Index getIndex(String indexName, String workspaceName) {
        Map<String, ProvidedIndex> byWorkspaceNames = this.providedIndexesByWorkspaceNameByIndexName.get(indexName);
        return byWorkspaceNames == null ? null : byWorkspaceNames.get(workspaceName);
    }

    public abstract IndexPlanner getIndexPlanner();

    protected final NamespaceRegistry namespaces() {
        return this.context.getNamespaceRegistry();
    }

    protected final ValueFactories valueFactories() {
        return this.context.getValueFactories();
    }

    protected final NameFactory names() {
        return this.valueFactories().getNameFactory();
    }

    public final synchronized void notify(final WorkspaceChanges changes, Observable observable, NodeTypes.Supplier nodeTypesSupplier, Set<String> workspaceNames, IndexFeedback feedback) {
        for (IndexDefinition defn : changes.getIndexDefinitions()) {
            for (String workspaceName : changes.getAddedWorkspaces()) {
                if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) continue;
                try {
                    ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, feedback);
                    Map<String, ProvidedIndex> managedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(defn.getName());
                    if (managedIndexesByWorkspaceName == null) {
                        managedIndexesByWorkspaceName = new HashMap<String, ProvidedIndex>();
                        this.providedIndexesByWorkspaceNameByIndexName.put(defn.getName(), managedIndexesByWorkspaceName);
                    }
                    ProvidedIndex index = new ProvidedIndex(defn, managedIndex, workspaceName);
                    managedIndexesByWorkspaceName.put(workspaceName, index);
                    observable.register(index);
                }
                catch (RuntimeException e) {
                    String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                    this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                }
            }
            Map<String, ProvidedIndex> managedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(defn.getName());
            if (managedIndexesByWorkspaceName.isEmpty()) continue;
            this.removeProvidedIndexes(managedIndexesByWorkspaceName, observable, new Predicate<ProvidedIndex>(){

                public boolean test(ProvidedIndex index) {
                    return !changes.getRemovedWorkspaces().contains(index.workspaceName());
                }
            });
        }
    }

    public final synchronized void notify(IndexDefinitionChanges changes, Observable observable, NodeTypes.Supplier nodeTypesSupplier, final Set<String> workspaceNames, IndexFeedback feedback) {
        for (IndexDefinition defn : changes.getUpdatedIndexDefinitions().values()) {
            Map<String, ProvidedIndex> providedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(defn.getName());
            if (providedIndexesByWorkspaceName == null || providedIndexesByWorkspaceName.isEmpty()) {
                providedIndexesByWorkspaceName = new HashMap<String, ProvidedIndex>();
                for (String workspaceName : workspaceNames) {
                    if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) continue;
                    try {
                        ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, feedback);
                        ProvidedIndex index = new ProvidedIndex(defn, managedIndex, workspaceName);
                        providedIndexesByWorkspaceName.put(workspaceName, index);
                        observable.register(index);
                    }
                    catch (RuntimeException e) {
                        String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                        this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                    }
                }
                if (providedIndexesByWorkspaceName.isEmpty()) continue;
                Map<String, ProvidedIndex> existing = this.providedIndexesByWorkspaceNameByIndexName.put(defn.getName(), providedIndexesByWorkspaceName);
                assert (existing == null);
                continue;
            }
            assert (providedIndexesByWorkspaceName != null && !providedIndexesByWorkspaceName.isEmpty());
            for (String workspaceName : workspaceNames) {
                String msg;
                ManagedIndex managedIndex;
                ProvidedIndex provided = providedIndexesByWorkspaceName.get(workspaceName);
                if (provided != null) {
                    if (defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) {
                        try {
                            managedIndex = this.updateIndex(provided.indexDefinition(), defn, provided.managed(), workspaceName, nodeTypesSupplier, feedback);
                            provided.update(managedIndex, defn);
                        }
                        catch (RuntimeException e) {
                            msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                            this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                        }
                        continue;
                    }
                    this.removeProvidedIndex(provided, observable);
                    continue;
                }
                try {
                    managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, feedback);
                    ProvidedIndex index = new ProvidedIndex(defn, managedIndex, workspaceName);
                    providedIndexesByWorkspaceName.put(workspaceName, index);
                    observable.register(index);
                }
                catch (RuntimeException e) {
                    msg = "Error adding index '{0}' in workspace '{1}' with definition: {2}";
                    this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                }
            }
            this.removeProvidedIndexes(providedIndexesByWorkspaceName, observable, new Predicate<ProvidedIndex>(){

                public boolean test(ProvidedIndex index) {
                    return !workspaceNames.contains(index.workspaceName());
                }
            });
        }
        Predicate predicate = Predicate.always();
        for (String indexName : changes.getRemovedIndexDefinitions()) {
            this.removeProvidedIndexes(this.providedIndexesByWorkspaceNameByIndexName.get(indexName), observable, (Predicate<ProvidedIndex>)predicate);
        }
    }

    protected abstract ManagedIndex createIndex(IndexDefinition var1, String var2, NodeTypes.Supplier var3, IndexFeedback var4);

    protected abstract ManagedIndex updateIndex(IndexDefinition var1, IndexDefinition var2, ManagedIndex var3, String var4, NodeTypes.Supplier var5, IndexFeedback var6);

    protected abstract void removeIndex(IndexDefinition var1, ManagedIndex var2, String var3);

    private void removeProvidedIndexes(Map<String, ProvidedIndex> managedIndexesByWorkspaceName, Observable observable, Predicate<ProvidedIndex> predicate) {
        Iterator<Map.Entry<String, ProvidedIndex>> iter = managedIndexesByWorkspaceName.entrySet().iterator();
        while (iter.hasNext()) {
            ProvidedIndex index = iter.next().getValue();
            if (!predicate.test((Object)index)) continue;
            this.removeProvidedIndex(index, observable);
            iter.remove();
        }
    }

    private void removeProvidedIndex(ProvidedIndex index, Observable observable) {
        try {
            observable.unregister(index);
            this.removeIndex(index.indexDefinition(), index.managed(), index.workspaceName());
        }
        catch (RuntimeException e) {
            String msg = "Error removing index '{0}' in workspace '{1}' with definition: {2}";
            this.logger().error((Throwable)e, msg, new Object[]{index.getName(), index.workspaceName(), index.indexDefinition()});
        }
    }

    @ThreadSafe
    private class ProvidedIndex
    implements Index,
    ChangeSetListener {
        private final String workspaceName;
        private volatile ManagedIndex managedIndex;
        private volatile IndexDefinition defn;

        protected ProvidedIndex(IndexDefinition defn, ManagedIndex managedIndex, String workspaceName) {
            this.defn = defn;
            this.managedIndex = managedIndex;
            this.workspaceName = workspaceName;
        }

        protected final IndexDefinition indexDefinition() {
            return this.defn;
        }

        protected final String workspaceName() {
            return this.workspaceName;
        }

        @Override
        public final String getProviderName() {
            return IndexProvider.this.getName();
        }

        @Override
        public final String getName() {
            return this.defn.getName();
        }

        @Override
        public boolean supportsFullTextConstraints() {
            return this.defn.getKind() == IndexDefinition.IndexKind.FULLTEXTSEARCH;
        }

        @Override
        public final Filter.Results filter(IndexConstraints constraints) {
            return this.managedIndex.filter(constraints);
        }

        @Override
        public final void notify(ChangeSet changeSet) {
            if (changeSet.getWorkspaceName() != null) {
                this.managedIndex.getIndexChangeAdapter().notify(changeSet);
            }
        }

        protected ManagedIndex managed() {
            return this.managedIndex;
        }

        public void shutdown(boolean destroyed) {
            this.managedIndex.shutdown(destroyed);
        }

        protected final void update(ManagedIndex managedIndex, IndexDefinition newDefinition) {
            this.managedIndex = managedIndex;
            this.defn = this.defn;
        }
    }
}

