/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.DelegateIterable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.function.Function;
import org.modeshape.common.function.Predicate;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.Observable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.engine.NoOpQueryIndexWriter;
import org.modeshape.jcr.spi.index.Index;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.IndexDefinitionChanges;
import org.modeshape.jcr.spi.index.IndexFeedback;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.spi.index.WorkspaceChanges;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueFactories;

public abstract class IndexProvider {
    private static final IndexWriter EMPTY_WRITER = NoOpQueryIndexWriter.INSTANCE;
    private Logger logger;
    private String name;
    private ExecutionContext context;
    private String repositoryName;
    private boolean initialized = false;
    private final IndexPlanner planner;
    private final Map<String, Map<String, ProvidedIndex>> providedIndexesByWorkspaceNameByIndexName = new HashMap<String, Map<String, ProvidedIndex>>();
    private final Map<String, Map<String, ProvidedIndex>> providedIndexesByIndexNameByWorkspaceName = new HashMap<String, Map<String, ProvidedIndex>>();
    private volatile IndexWriter delegateWriter = EMPTY_WRITER;
    private final IndexWriter publicWriter = new IndexWriter(){

        @Override
        public boolean canBeSkipped() {
            return IndexProvider.this.delegateWriter.canBeSkipped();
        }

        @Override
        public void clearAllIndexes() {
            IndexProvider.this.delegateWriter.clearAllIndexes();
        }

        @Override
        public void add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
            IndexProvider.this.delegateWriter.add(workspace, key, path, primaryType, mixinTypes, properties);
        }
    };

    protected IndexProvider() {
        this.planner = new BasicPlanner();
    }

    protected IndexProvider(IndexPlanner planner) {
        assert (planner != null);
        this.planner = planner;
    }

    protected final Logger logger() {
        return this.logger;
    }

    public final String getName() {
        return this.name;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    public final synchronized void initialize() throws RepositoryException {
        if (!this.initialized) {
            try {
                this.doInitialize();
                this.initialized = true;
            }
            catch (RuntimeException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void postInitialize() {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    protected abstract void doInitialize() throws RepositoryException;

    public final synchronized void shutdown() throws RepositoryException {
        this.preShutdown();
        this.delegateWriter = NoOpQueryIndexWriter.INSTANCE;
        for (Map<String, ProvidedIndex> byWorkspaceName : this.providedIndexesByWorkspaceNameByIndexName.values()) {
            for (ProvidedIndex provided : byWorkspaceName.values()) {
                provided.shutdown(false);
            }
        }
        this.providedIndexesByWorkspaceNameByIndexName.clear();
        this.providedIndexesByIndexNameByWorkspaceName.clear();
        this.postShutdown();
    }

    protected void preShutdown() throws RepositoryException {
    }

    protected void postShutdown() throws RepositoryException {
    }

    public abstract void validateProposedIndex(ExecutionContext var1, IndexDefinition var2, NodeTypes.Supplier var3, Problems var4);

    public final IndexWriter getIndexWriter() {
        return this.publicWriter;
    }

    public final Index getIndex(String indexName, String workspaceName) {
        this.logger().trace("Looking for index '{0}' in '{1}' provider for query in workspace '{2}'", new Object[]{indexName, this.getName(), workspaceName});
        Map<String, ProvidedIndex> byWorkspaceNames = this.providedIndexesByWorkspaceNameByIndexName.get(indexName);
        return byWorkspaceNames == null ? null : byWorkspaceNames.get(workspaceName);
    }

    protected final Iterable<ManagedIndex> getIndexes(String workspaceName) {
        Map<String, ProvidedIndex> byIndexName = this.providedIndexesByIndexNameByWorkspaceName.get(workspaceName);
        if (byIndexName == null) {
            return Collections.emptySet();
        }
        return DelegateIterable.around(byIndexName.values(), (Function)new Function<ProvidedIndex, ManagedIndex>(){

            public ManagedIndex apply(ProvidedIndex input) {
                return input.managed();
            }
        });
    }

    protected final void onEachIndex(ManagedIndexOperation op) {
        for (Map.Entry<String, Map<String, ProvidedIndex>> entry : this.providedIndexesByIndexNameByWorkspaceName.entrySet()) {
            this.onEachIndexInWorkspace(entry.getKey(), op);
        }
    }

    protected final void onEachIndexInWorkspace(String workspaceName, ManagedIndexOperation op) {
        assert (workspaceName != null);
        Map<String, ProvidedIndex> byIndexName = this.providedIndexesByIndexNameByWorkspaceName.get(workspaceName);
        if (byIndexName != null) {
            for (ProvidedIndex providedIndex : byIndexName.values()) {
                assert (providedIndex.managed() != null);
                assert (providedIndex.indexDefinition() != null);
                op.apply(workspaceName, providedIndex.managed(), providedIndex.indexDefinition());
            }
        }
    }

    protected abstract void planUseOfIndex(QueryContext var1, IndexCostCalculator var2, String var3, ManagedIndex var4, IndexDefinition var5);

    public final IndexPlanner getIndexPlanner() {
        return this.planner;
    }

    protected final NamespaceRegistry namespaces() {
        return this.context.getNamespaceRegistry();
    }

    protected final ValueFactories valueFactories() {
        return this.context.getValueFactories();
    }

    protected final NameFactory names() {
        return this.valueFactories().getNameFactory();
    }

    public final synchronized void notify(final WorkspaceChanges changes, Observable observable, NodeTypes.Supplier nodeTypesSupplier, Set<String> workspaceNames, IndexFeedback feedback) {
        for (IndexDefinition defn : changes.getIndexDefinitions()) {
            for (String workspaceName : changes.getAddedWorkspaces()) {
                if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) continue;
                try {
                    ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, feedback);
                    ProvidedIndex index = new ProvidedIndex(defn, managedIndex, workspaceName);
                    this.addProvidedIndex(index);
                    observable.register(index);
                }
                catch (RuntimeException e) {
                    String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                    this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                }
            }
        }
        this.removeProvidedIndexes(observable, new Predicate<ProvidedIndex>(){

            public boolean test(ProvidedIndex index) {
                return !changes.getRemovedWorkspaces().contains(index.workspaceName());
            }
        });
        this.refreshDelegateIndexWriter();
    }

    public final synchronized void notify(final IndexDefinitionChanges changes, Observable observable, NodeTypes.Supplier nodeTypesSupplier, final Set<String> workspaceNames, IndexFeedback feedback) {
        for (IndexDefinition defn : changes.getUpdatedIndexDefinitions().values()) {
            Map<String, ProvidedIndex> providedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(defn.getName());
            if (providedIndexesByWorkspaceName == null || providedIndexesByWorkspaceName.isEmpty()) {
                for (String workspaceName : workspaceNames) {
                    if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) continue;
                    try {
                        ManagedIndex managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, feedback);
                        ProvidedIndex index = new ProvidedIndex(defn, managedIndex, workspaceName);
                        this.addProvidedIndex(index);
                        observable.register(index);
                    }
                    catch (RuntimeException e) {
                        String msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                        this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                    }
                }
                continue;
            }
            assert (providedIndexesByWorkspaceName != null && !providedIndexesByWorkspaceName.isEmpty());
            for (String workspaceName : workspaceNames) {
                String msg;
                ManagedIndex managedIndex;
                ProvidedIndex provided = providedIndexesByWorkspaceName.get(workspaceName);
                if (provided != null) {
                    if (defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) {
                        try {
                            managedIndex = this.updateIndex(provided.indexDefinition(), defn, provided.managed(), workspaceName, nodeTypesSupplier, feedback);
                            provided.update(managedIndex, defn);
                        }
                        catch (RuntimeException e) {
                            msg = "Error updating index '{0}' in workspace '{1}' with definition: {2}";
                            this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                        }
                        continue;
                    }
                    this.removeProvidedIndex(provided, observable);
                    continue;
                }
                try {
                    managedIndex = this.createIndex(defn, workspaceName, nodeTypesSupplier, feedback);
                    ProvidedIndex index = new ProvidedIndex(defn, managedIndex, workspaceName);
                    this.addProvidedIndex(index);
                    observable.register(index);
                }
                catch (RuntimeException e) {
                    msg = "Error adding index '{0}' in workspace '{1}' with definition: {2}";
                    this.logger().error((Throwable)e, msg, new Object[]{defn.getName(), workspaceName, defn});
                }
            }
            this.removeProvidedIndexes(observable, new Predicate<ProvidedIndex>(){

                public boolean test(ProvidedIndex index) {
                    return !workspaceNames.contains(index.workspaceName());
                }
            });
        }
        this.removeProvidedIndexes(observable, new Predicate<ProvidedIndex>(){

            public boolean test(ProvidedIndex index) {
                return changes.getRemovedIndexDefinitions().contains(index.getName());
            }
        });
        this.refreshDelegateIndexWriter();
    }

    private void addProvidedIndex(ProvidedIndex index) {
        String indexName = index.getName();
        String workspaceName = index.workspaceName();
        Map<String, ProvidedIndex> managedIndexesByWorkspaceName = this.providedIndexesByWorkspaceNameByIndexName.get(indexName);
        if (managedIndexesByWorkspaceName == null) {
            managedIndexesByWorkspaceName = new HashMap<String, ProvidedIndex>();
            this.providedIndexesByWorkspaceNameByIndexName.put(indexName, managedIndexesByWorkspaceName);
        }
        managedIndexesByWorkspaceName.put(workspaceName, index);
        Map<String, ProvidedIndex> byName = this.providedIndexesByIndexNameByWorkspaceName.get(workspaceName);
        if (byName == null) {
            byName = new HashMap<String, ProvidedIndex>();
            this.providedIndexesByIndexNameByWorkspaceName.put(workspaceName, byName);
        }
        byName.put(indexName, index);
    }

    private void refreshDelegateIndexWriter() {
        final HashMap<String, ArrayList<IndexChangeAdapter>> adaptersByWorkspaceName = new HashMap<String, ArrayList<IndexChangeAdapter>>();
        final ArrayList<ManagedIndex> managedIndexes = new ArrayList<ManagedIndex>();
        for (Map<String, ProvidedIndex> providedIndexesByWorkspaceName : this.providedIndexesByWorkspaceNameByIndexName.values()) {
            for (Map.Entry<String, ProvidedIndex> entry : providedIndexesByWorkspaceName.entrySet()) {
                String workspaceName = entry.getKey();
                ProvidedIndex index = entry.getValue();
                ArrayList<IndexChangeAdapter> adaptersForWorkspace = (ArrayList<IndexChangeAdapter>)adaptersByWorkspaceName.get(workspaceName);
                if (adaptersForWorkspace == null) {
                    adaptersForWorkspace = new ArrayList<IndexChangeAdapter>();
                    adaptersByWorkspaceName.put(workspaceName, adaptersForWorkspace);
                }
                adaptersForWorkspace.add(index.managed().getIndexChangeAdapter());
                managedIndexes.add(index.managed());
            }
        }
        final boolean canBeSkipped = managedIndexes.isEmpty();
        this.delegateWriter = new IndexWriter(){

            @Override
            public boolean canBeSkipped() {
                return canBeSkipped;
            }

            @Override
            public void clearAllIndexes() {
                for (ManagedIndex index : managedIndexes) {
                    index.removeAll();
                }
            }

            @Override
            public void add(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties) {
                for (IndexChangeAdapter adapter : (Collection)adaptersByWorkspaceName.get(workspace)) {
                    adapter.index(workspace, key, path, primaryType, mixinTypes, properties, true);
                }
            }
        };
    }

    protected abstract ManagedIndex createIndex(IndexDefinition var1, String var2, NodeTypes.Supplier var3, IndexFeedback var4);

    protected abstract ManagedIndex updateIndex(IndexDefinition var1, IndexDefinition var2, ManagedIndex var3, String var4, NodeTypes.Supplier var5, IndexFeedback var6);

    protected abstract void removeIndex(IndexDefinition var1, ManagedIndex var2, String var3);

    private void removeProvidedIndexes(Observable observable, Predicate<ProvidedIndex> predicate) {
        Iterator<Map.Entry<String, Map<String, ProvidedIndex>>> iter = this.providedIndexesByWorkspaceNameByIndexName.entrySet().iterator();
        while (iter.hasNext()) {
            Map<String, ProvidedIndex> byWorkspaceName = iter.next().getValue();
            if (byWorkspaceName.isEmpty()) continue;
            Iterator<Map.Entry<String, ProvidedIndex>> providedIter = byWorkspaceName.entrySet().iterator();
            while (providedIter.hasNext()) {
                ProvidedIndex index = providedIter.next().getValue();
                if (!predicate.test((Object)index)) continue;
                this.removeProvidedIndex(index, observable);
                iter.remove();
                Map<String, ProvidedIndex> byIndexName = this.providedIndexesByIndexNameByWorkspaceName.get(index.workspaceName());
                byIndexName.remove(index.getName());
            }
        }
    }

    private void removeProvidedIndex(ProvidedIndex index, Observable observable) {
        try {
            observable.unregister(index);
            this.removeIndex(index.indexDefinition(), index.managed(), index.workspaceName());
        }
        catch (RuntimeException e) {
            String msg = "Error removing index '{0}' in workspace '{1}' with definition: {2}";
            this.logger().error((Throwable)e, msg, new Object[]{index.getName(), index.workspaceName(), index.indexDefinition()});
        }
    }

    @ThreadSafe
    private class ProvidedIndex
    implements Index,
    ChangeSetListener {
        private final String workspaceName;
        private volatile ManagedIndex managedIndex;
        private volatile IndexDefinition defn;

        protected ProvidedIndex(IndexDefinition defn, ManagedIndex managedIndex, String workspaceName) {
            this.defn = defn;
            this.managedIndex = managedIndex;
            this.workspaceName = workspaceName;
        }

        protected final IndexDefinition indexDefinition() {
            return this.defn;
        }

        protected final String workspaceName() {
            return this.workspaceName;
        }

        @Override
        public final String getProviderName() {
            return IndexProvider.this.getName();
        }

        @Override
        public final String getName() {
            return this.defn.getName();
        }

        @Override
        public boolean supportsFullTextConstraints() {
            return this.defn.getKind() == IndexDefinition.IndexKind.TEXT;
        }

        @Override
        public final Filter.Results filter(IndexConstraints constraints) {
            return this.managedIndex.filter(constraints);
        }

        @Override
        public final void notify(ChangeSet changeSet) {
            if (changeSet.getWorkspaceName() != null) {
                this.managedIndex.getIndexChangeAdapter().notify(changeSet);
            }
        }

        protected ManagedIndex managed() {
            return this.managedIndex;
        }

        public void shutdown(boolean destroyed) {
            this.managedIndex.shutdown(destroyed);
        }

        protected final void update(ManagedIndex managedIndex, IndexDefinition newDefinition) {
            this.managedIndex = managedIndex;
            this.defn = this.defn;
        }
    }

    private final class BasicPlanner
    extends IndexPlanner {
        protected BasicPlanner() {
        }

        @Override
        public void applyIndexes(final QueryContext context, final IndexCostCalculator calculator) {
            ManagedIndexOperation planningOp = new ManagedIndexOperation(){

                @Override
                public void apply(String workspaceName, ManagedIndex index, IndexDefinition defn) {
                    if (!defn.getWorkspaceMatchRule().usedInWorkspace(workspaceName)) {
                        return;
                    }
                    IndexProvider.this.logger().trace("Considering index '{0}' in '{1}' provider for query in workspace '{2}'", new Object[]{defn.getName(), IndexProvider.this.getName(), workspaceName});
                    IndexProvider.this.planUseOfIndex(context, calculator, workspaceName, index, defn);
                }
            };
            for (String workspaceName : context.getWorkspaceNames()) {
                IndexProvider.this.onEachIndexInWorkspace(workspaceName, planningOp);
            }
        }
    }

    protected static interface ManagedIndexOperation {
        public void apply(String var1, ManagedIndex var2, IndexDefinition var3);
    }
}

