/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

class InclusionExclusionFilenameFilter
implements FilenameFilter {
    private String inclusionPattern = null;
    private String exclusionPattern = null;
    private Pattern inclusion;
    private Pattern exclusion;
    private Pattern extraPropertiesExclusion;

    InclusionExclusionFilenameFilter() {
    }

    public void setExclusionPattern(String exclusionPattern) {
        this.exclusionPattern = exclusionPattern;
        this.exclusion = exclusionPattern == null ? null : Pattern.compile(exclusionPattern);
    }

    public void setExtraPropertiesExclusionPattern(String exclusionPattern) {
        this.extraPropertiesExclusion = exclusionPattern == null ? null : Pattern.compile(exclusionPattern);
    }

    public void setInclusionPattern(String inclusionPattern) {
        this.inclusionPattern = inclusionPattern;
        this.inclusion = inclusionPattern == null ? null : Pattern.compile(inclusionPattern);
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    public String getInclusionPattern() {
        return this.inclusionPattern;
    }

    @Override
    public boolean accept(File file, String name) {
        if (this.inclusionPattern == null) {
            if (this.exclusionPattern != null && this.exclusion.matcher(name).matches()) {
                return false;
            }
            return this.extraPropertiesExclusion == null || !this.extraPropertiesExclusion.matcher(name).matches();
        }
        if (!this.inclusion.matcher(name).matches()) {
            return false;
        }
        if (this.exclusionPattern != null && this.exclusion.matcher(name).matches()) {
            return false;
        }
        return this.extraPropertiesExclusion == null || !this.extraPropertiesExclusion.matcher(name).matches();
    }
}

